/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Test;
import org.ojai.Document;
import org.ojai.DocumentListener;
import org.ojai.DocumentStream;
import org.ojai.store.Connection;
import org.ojai.store.DocumentStore;
import org.ojai.store.Driver;
import org.ojai.store.DriverManager;
import org.ojai.store.Query;
import org.ojai.store.QueryCondition;

public class DemoOjaiFragments {
    private static Driver ojaiDriver;
    private static final String TABLE_NAME = "/user/cwestin/demo_table";

    private static synchronized Driver getDriver() {
        if (ojaiDriver == null) {
            ojaiDriver = DriverManager.getDriver((String)"ojai:mapr:");
        }
        return ojaiDriver;
    }

    private static Connection getConnection() {
        Driver ojaiDriver = DemoOjaiFragments.getDriver();
        Document connectionOptions = ojaiDriver.newDocument();
        String maprHome = System.getenv("MAPR_HOME");
        if (maprHome == null) {
            maprHome = "/opt/mapr";
        }
        connectionOptions.set("mapr.client.conf_file", maprHome + "/conf/mapr-clusters.conf");
        Connection connection = ojaiDriver.connect("ojai:mapr:", connectionOptions);
        return connection;
    }

    @Test
    public void demoInsert() {
        try (Connection connection = DemoOjaiFragments.getConnection();
             DocumentStore docStore = connection.getStore(TABLE_NAME);){
            Document doc = connection.newDocument();
            doc.setId("1");
            doc.set("a", 17);
            doc.set("b", "foo");
            docStore.insert(doc);
        }
    }

    @Test
    public void demoQuery_iterate() {
        try (Connection connection = DemoOjaiFragments.getConnection();
             DocumentStore docStore = connection.getStore(TABLE_NAME);){
            Query query = connection.newQuery().select(new String[]{"b"}).where(connection.newCondition().is("a", QueryCondition.Op.GREATER_OR_EQUAL, 5).build()).build();
            try (DocumentStream docStream = docStore.findQuery(query);){
                for (Document doc : docStream) {
                    System.err.println("got doc: " + doc);
                }
            }
        }
    }

    @Test
    public void demoQuery_streamTo() throws InterruptedException {
        try (Connection connection = DemoOjaiFragments.getConnection();
             DocumentStore docStore = connection.getStore(TABLE_NAME);){
            Query query = connection.newQuery().select(new String[]{"b"}).where(connection.newCondition().is("a", QueryCondition.Op.GREATER_OR_EQUAL, 5).build()).build();
            final CountDownLatch latch = new CountDownLatch(1);
            try (DocumentStream docStream = docStore.findQuery(query);){
                docStream.streamTo(new DocumentListener(){

                    public boolean documentArrived(Document doc) {
                        System.err.println("got doc: " + doc);
                        return true;
                    }

                    public void eos() {
                        latch.countDown();
                    }

                    public void failed(Exception ex) {
                        System.err.println("got exception: " + ex);
                    }
                });
                latch.await(60L, TimeUnit.SECONDS);
            }
        }
    }
}

