/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.google.common.base.Preconditions;
import com.mapr.db.tests.utils.DBTests;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.ojai.store.Connection;

public abstract class SharedTestTable {
    private boolean isInitialized;
    private String tableName;
    private static final List<String> tables = new LinkedList<String>();
    private final String tableNameRoot;
    private String tableNameId;
    private static final AtomicInteger tableId = new AtomicInteger(0);
    private static final int NUM_RETRIES = 3;

    public SharedTestTable(String tableNameRoot) {
        this.tableNameRoot = tableNameRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String prepare(Connection connection) {
        if (this.isInitialized) {
            return this.tableName;
        }
        for (int retry = 0; retry < 3; ++retry) {
            try {
                this.tableNameId = this.tableNameRoot + "_" + tableId.incrementAndGet();
                this.tableName = this.initialize(connection, this.tableNameId);
                DBTests.waitForRowCount((String)this.tableNameId, (long)this.getNumRows());
                DBTests.waitForIndexFlush((String)this.tableNameId);
                List<String> list = tables;
                synchronized (list) {
                    tables.add(this.tableNameId);
                }
                this.isInitialized = true;
                break;
            }
            catch (Exception ex) {
                System.err.println("SharedTestTable " + this.tableNameRoot + " setup failure " + ex);
                continue;
            }
        }
        if (!this.isInitialized) {
            Assert.fail((String)("SharedTestTable " + this.tableNameRoot + " not set up after 3"));
        }
        return this.tableName;
    }

    public String getRawTableName() {
        Preconditions.checkState((boolean)this.isInitialized);
        return this.tableNameId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanup() throws IOException {
        List<String> list = tables;
        synchronized (list) {
            for (String tableName : tables) {
                DBTests.deleteTables((String[])new String[]{tableName});
            }
        }
    }

    protected abstract String initialize(Connection var1, String var2) throws Exception;

    public abstract long getNumRows();

    public static String removeTrialSuffix(String rawTableName) {
        int underPos = rawTableName.lastIndexOf("_");
        String tableName = rawTableName.substring(0, underPos);
        return tableName;
    }
}

