/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.mapr.ojai.store.impl.RunnableQueue;
import java.util.concurrent.ExecutorService;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.proto.helper.QueryIdHelper;
import org.apache.drill.exec.rpc.ConnectionThrottle;
import org.apache.drill.exec.rpc.user.QueryDataBatch;
import org.apache.drill.exec.rpc.user.UserResultsListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingResultsListener
implements UserResultsListener {
    private static final Logger logger = LoggerFactory.getLogger(DelegatingResultsListener.class);
    private final RunnableQueue runnableQueue;
    private final UserResultsListener delegateListener;
    private final int id;

    public DelegatingResultsListener(ExecutorService executorService, int id, final UserResultsListener delegateListener) {
        this.delegateListener = delegateListener;
        this.id = id;
        this.runnableQueue = new RunnableQueue(executorService, id){

            @Override
            protected void handleException(Exception ex) {
                UserException uex = UserException.systemError((Throwable)ex).message("Internal error processing Drill response", (Object[])null).build();
                delegateListener.submissionFailed(uex);
            }
        };
    }

    public void queryIdArrived(final UserBitShared.QueryId queryId) {
        String qid = QueryIdHelper.getQueryId((UserBitShared.QueryId)queryId);
        logger.debug("DelegatingResultsListener[{}].queryIdArrived(queryId = {})", (Object)this.id, (Object)qid);
        this.runnableQueue.execute(new Runnable(){

            @Override
            public void run() {
                DelegatingResultsListener.this.delegateListener.queryIdArrived(queryId);
            }
        });
        logger.debug("DelegatingResultsListener[{}].queryIdArrived(...) submitted", (Object)this.id);
    }

    public void submissionFailed(final UserException ex) {
        logger.debug("DelegatingResultsListener[{}].submissionFailed(ex = {})", (Object)this.id, (Object)ex);
        this.runnableQueue.execute(new Runnable(){

            @Override
            public void run() {
                DelegatingResultsListener.this.delegateListener.submissionFailed(ex);
            }
        });
        logger.debug("DelegatingResultsListener[{}].submissionFailed(...) submitted", (Object)this.id);
    }

    public void dataArrived(final QueryDataBatch result, final ConnectionThrottle throttle) {
        logger.debug("DelegatingResultsListener[{}].dataArrived(...)", (Object)this.id);
        this.runnableQueue.execute(new Runnable(){

            @Override
            public void run() {
                DelegatingResultsListener.this.delegateListener.dataArrived(result, throttle);
            }
        });
        logger.debug("DelegatingResultsListener[{}].dataArrived(...) submitted", (Object)this.id);
    }

    public void queryCompleted(final UserBitShared.QueryResult.QueryState state) {
        logger.debug("DelegatingResultsListener[{}].queryCompleted({})", (Object)this.id, (Object)state);
        this.runnableQueue.execute(new Runnable(){

            @Override
            public void run() {
                DelegatingResultsListener.this.delegateListener.queryCompleted(state);
            }
        });
        logger.debug("DelegatingResultsListener[{}].queryCompleted(...) submitted", (Object)this.id);
    }

    public void terminate() {
        this.runnableQueue.terminate();
    }
}

