/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.google.common.collect.ImmutableList;
import com.mapr.db.impl.ClonedCondition;
import com.mapr.db.impl.ConditionLeaf;
import com.mapr.ojai.store.impl.Expression;
import com.mapr.ojai.store.impl.ExpressionVisitor;
import com.mapr.ojai.store.impl.FieldExpression;
import com.mapr.ojai.store.impl.LiteralExpression;
import com.mapr.ojai.store.impl.NaryOperator;
import com.mapr.ojai.store.impl.OperatorExpression;
import com.mapr.ojai.store.impl.RelationalOperator;
import com.mapr.ojai.store.impl.UnaryOperator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.ojai.FieldPath;

public class ExpressionPruner
extends ExpressionVisitor {
    private final Set<FieldPath> fieldSet;
    private final Set<ClonedCondition> conditionSet;
    private Expression resultExpr;
    private PartialElementAndMatch pElmentAndMatchHolder;
    private final Stack<StackEntry> keepStack = new Stack();

    public ExpressionPruner(Set<FieldPath> fieldSet, Set<ClonedCondition> conditionSet, PartialElementAndMatch partialElmentAndMatch) {
        this.fieldSet = Collections.unmodifiableSet(fieldSet);
        this.conditionSet = Collections.unmodifiableSet(conditionSet);
        this.pElmentAndMatchHolder = partialElmentAndMatch;
        if (this.pElmentAndMatchHolder != null) {
            this.pElmentAndMatchHolder.partialElmentAndMatch = false;
        }
    }

    public Expression getPrunedExpression() {
        return this.resultExpr;
    }

    private boolean keepSubtree() {
        if (this.keepStack.isEmpty()) {
            return false;
        }
        StackEntry stackEntry = this.keepStack.peek();
        return stackEntry.keep;
    }

    private void pushExpression(OperatorExpression opExpr) {
        ConditionLeaf conditionLeaf;
        ClonedCondition clonedCondition;
        boolean keep = false;
        if (this.keepSubtree()) {
            keep = true;
        } else if (opExpr.originalNode instanceof ConditionLeaf && this.conditionSet.contains(clonedCondition = (conditionLeaf = (ConditionLeaf)opExpr.originalNode).getClonedCondition())) {
            keep = true;
        }
        StackEntry stackEntry = new StackEntry(opExpr, keep);
        this.keepStack.push(stackEntry);
    }

    private void popExpression(OperatorExpression opExpr) {
        StackEntry stackEntry = this.keepStack.pop();
        if (stackEntry.opExpr != opExpr) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void visitField(FieldExpression fieldExpr) {
        FieldPath fieldPath = this.getPath(fieldExpr.getFieldPath());
        if (this.fieldSet.contains(fieldPath) || this.keepSubtree()) {
            this.resultExpr = fieldExpr;
        } else {
            FieldPath leafPath = fieldExpr.getFieldPath();
            if (!fieldPath.equals((Object)leafPath) && this.pElmentAndMatchHolder != null) {
                this.pElmentAndMatchHolder.partialElmentAndMatch = true;
            }
            this.resultExpr = null;
        }
    }

    @Override
    public void visitLiteral(LiteralExpression literalExpr) {
        this.resultExpr = literalExpr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitNary(NaryOperator naryOp) {
        this.pushExpression(naryOp);
        boolean oldPartialElementAndMatch = this.pElmentAndMatchHolder != null ? this.pElmentAndMatchHolder.partialElmentAndMatch : false;
        try {
            int nonNull = 0;
            int nonLiterals = 0;
            Expression[] args = new Expression[naryOp.arg.length];
            for (int i = naryOp.skipVisitArgs; i < args.length; ++i) {
                naryOp.arg[i].visit(this);
                if (this.resultExpr == null) continue;
                ++nonNull;
                args[i] = this.resultExpr;
                if (this.resultExpr instanceof LiteralExpression) continue;
                ++nonLiterals;
            }
            if (nonNull > 0 && nonLiterals > 0) {
                ArrayList<Expression> newArgs = new ArrayList<Expression>(nonNull);
                for (int i = 0; i < args.length; ++i) {
                    if (args[i] == null) continue;
                    newArgs.add(args[i]);
                }
                if (newArgs.size() == 1 && RelationalOperator.isLogicalOperator(naryOp.opName)) {
                    this.resultExpr = newArgs.get(0);
                    return;
                }
                this.resultExpr = naryOp.recreateWithNewArgs(newArgs);
                return;
            }
            this.resultExpr = null;
        }
        finally {
            if (naryOp.opName.equals("elementAnd") && this.resultExpr == null && this.pElmentAndMatchHolder != null) {
                this.pElmentAndMatchHolder.partialElmentAndMatch = oldPartialElementAndMatch;
            }
            this.popExpression(naryOp);
        }
    }

    @Override
    public void visitRelational(RelationalOperator relOp) {
        Expression leftArg = relOp.arg[0];
        this.pushExpression(relOp);
        leftArg.visit(this);
        this.popExpression(relOp);
        if (this.resultExpr != null) {
            this.resultExpr = new RelationalOperator(relOp.opName, (List<Expression>)ImmutableList.of((Object)leftArg, (Object)relOp.getRightLiteral()), relOp.originalNode);
        }
    }

    @Override
    public void visitUnary(UnaryOperator unaryOp) {
        Expression operand = unaryOp.getOperand();
        this.pushExpression(unaryOp);
        operand.visit(this);
        this.popExpression(unaryOp);
        if (this.resultExpr != null) {
            this.resultExpr = unaryOp;
        }
    }

    private static class StackEntry {
        public final OperatorExpression opExpr;
        public final boolean keep;

        public StackEntry(OperatorExpression opExpr, boolean keep) {
            this.opExpr = opExpr;
            this.keep = keep;
        }
    }

    public static class PartialElementAndMatch {
        public boolean partialElmentAndMatch;
    }
}

