/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.mapr.db.JsonTable;
import com.mapr.db.impl.OjaiQueryProperties;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.ojai.store.impl.OjaiConnection;
import com.mapr.ojai.store.impl.OjaiTest;
import com.mapr.tests.annotations.ClusterTest;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.store.DocumentStore;
import org.ojai.store.Query;
import org.ojai.store.QueryCondition;
import org.ojai.store.QueryResult;

@Category(value={ClusterTest.class})
public class TestOjaiPipeline_bug28510
extends OjaiTest {
    private static void bug28510_query(DocumentStore docStore, int nRows, Query query, int aKey, String indexName) {
        try (QueryResult docStream = docStore.find(query);){
            int docCount = 0;
            for (Document doc : docStream) {
                String id = doc.getIdString();
                Assert.assertTrue((Integer.parseInt(id) > 0 ? 1 : 0) != 0);
                int a = doc.getInt("a");
                Assert.assertEquals((long)aKey, (long)a);
                if (++docCount < nRows / 2) continue;
                break;
            }
            OjaiTest.assertQueryPath((DocumentStream)docStream, OjaiQueryProperties.QueryPath.DIRECT);
            Assert.assertEquals((Object)indexName, (Object)OjaiTest.getIndexUsed((DocumentStream)docStream));
        }
    }

    @Test
    public void testQuery_bug28510() throws Exception {
        String rawTableName = "bug28510";
        this.addCleanupTable("bug28510");
        try (JsonTable table = DBTests.createOrGetTable((String)"bug28510");){
            String tableName = DBTests.getFullPath((String)"bug28510");
            String indexName = "bug28510_idx";
            DBTests.createIndex((JsonTable)table, (String)"bug28510_idx", (boolean)false, (int)0, (String[])new String[]{"a"}, null, null);
            try (OjaiConnection connection = TestOjaiPipeline_bug28510.getConnection();
                 DocumentStore docStore = connection.getStore(tableName);){
                ExecutorService executorService = connection.getExecutorService();
                ThreadPoolExecutor tpe = (ThreadPoolExecutor)executorService;
                int nRows = 29;
                int aKey = 10;
                for (int i = 1; i <= 29; ++i) {
                    Document doc = connection.newDocument();
                    doc.setId(Integer.toString(i));
                    doc.set("a", 10);
                    doc.set("b", i);
                    docStore.insert(doc);
                }
                DBTests.waitForRowCount((String)"bug28510", (long)29L);
                DBTests.waitForIndexFlush((String)"bug28510");
                Query query = connection.newQuery().select(new String[]{"a", "b"}).where(connection.newCondition().is("a", QueryCondition.Op.EQUAL, 10).build()).build();
                Query queryIndex = connection.newQuery().setOption("ojai.mapr.query.hint-using-index", (Object)"bug28510_idx").select(new String[]{"a", "b"}).where(connection.newCondition().is("a", QueryCondition.Op.EQUAL, 10).build()).build();
                int nQueries = tpe.getCorePoolSize() * 2;
                for (int iQuery = 0; iQuery < nQueries; ++iQuery) {
                    TestOjaiPipeline_bug28510.bug28510_query(docStore, 29, queryIndex, 10, "bug28510_idx");
                }
                Thread.sleep(tpe.getKeepAliveTime(TimeUnit.MILLISECONDS) + 5000L);
                int poolSize = tpe.getPoolSize();
                int corePoolSize = tpe.getCorePoolSize();
                if (poolSize > corePoolSize) {
                    Assert.fail((String)("poolSize " + poolSize + " exceeds corePoolSize " + corePoolSize));
                }
            }
        }
    }
}

