/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.google.common.base.Preconditions;
import com.mapr.db.impl.OjaiQueryProperties;
import com.mapr.ojai.store.impl.AbstractDocumentFilter;
import com.mapr.ojai.store.impl.LongValue;
import com.mapr.ojai.store.impl.PipelineControl;
import com.mapr.ojai.store.impl.RowkeyLookup;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ojai.Document;
import org.ojai.DocumentStream;

public class OffsetStream
extends AbstractDocumentFilter {
    private final long offset;
    private long docCount;
    private LongValue desiredRows = LongValue.MAX_VALUE;

    public OffsetStream(DocumentStream upstreamStream, long offset) {
        super(upstreamStream);
        this.offset = offset;
        if (upstreamStream instanceof PipelineControl) {
            PipelineControl pc = (PipelineControl)upstreamStream;
            pc.setDesiredRows(new RemainingRows());
        }
    }

    @Override
    public Iterator<Document> iterator() {
        this.checkState();
        super.iterator();
        while (this.docCount < this.offset && this.docIter.hasNext()) {
            this.docIter.next();
            ++this.docCount;
        }
        return this.docIter;
    }

    public void getQueryPlan(List<Map<String, Object>> planList) {
        if (this.upstreamStream == null) {
            return;
        }
        ((OjaiQueryProperties)this.upstreamStream).getQueryPlan(planList);
        HashMap<String, Object> myMap = new HashMap<String, Object>();
        myMap.put("streamName", this.getClass().getSimpleName());
        HashMap<String, Long> valueMap = new HashMap<String, Long>();
        valueMap.put("offset", this.offset);
        myMap.put("parameters", valueMap);
        planList.add(myMap);
    }

    @Override
    public void setDesiredRows(LongValue longValue) {
        Preconditions.checkNotNull((Object)longValue);
        this.desiredRows = longValue;
    }

    private class RemainingRows
    implements LongValue {
        private RemainingRows() {
        }

        @Override
        public long getLongValue() {
            long dr = OffsetStream.this.offset - OffsetStream.this.docCount + OffsetStream.this.desiredRows.getLongValue();
            if (dr > 0L) {
                return dr;
            }
            return RowkeyLookup.MAX_BATCH_SIZE;
        }
    }
}

