/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.mapr.ojai.store.impl.CollectingDocumentListener;
import com.mapr.ojai.store.impl.DrillDocumentStream;
import com.mapr.ojai.store.impl.OjaiConnection;
import com.mapr.ojai.store.impl.OjaiDriver;
import com.mapr.ojai.store.impl.OjaiTest;
import com.mapr.ojai.store.impl.QueryContext;
import com.mapr.tests.annotations.ClusterTest;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.DocumentListener;
import org.ojai.DocumentStream;
import org.ojai.store.DocumentStore;
import org.ojai.store.Query;
import org.ojai.store.QueryCondition;

@Ignore
@Category(value={ClusterTest.class})
public class TestOjaiMilestones
extends OjaiTest {
    private final OjaiDriver driver = TestOjaiMilestones.getDriver();
    private static final int TIMEOUT_SECONDS = 15;
    private static final String REVIEWS_TABLE = "/tables/review";

    private List<Document> getDocuments(DocumentStream docStream) {
        LinkedList<Document> docList = new LinkedList<Document>();
        Semaphore doneSem = new Semaphore(0);
        docStream.streamTo((DocumentListener)new CollectingDocumentListener(docList, doneSem));
        try {
            doneSem.tryAcquire(1, 15L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException("timed out waiting for result", ex);
        }
        return docList;
    }

    private long countRecords(String tableName) {
        String countName = "theCount";
        String countDocumentsSql = "select count(*) theCount from dfs.`" + tableName + "`";
        ArrayList docList = new ArrayList(1);
        Semaphore doneSem = new Semaphore(0);
        try (OjaiConnection ojaiConnection = TestOjaiMilestones.getConnection();
             DrillDocumentStream ods = new DrillDocumentStream(ojaiConnection, QueryContext.newBuilder((String)countDocumentsSql).build());){
            ods.streamTo((DocumentListener)new CollectingDocumentListener(docList, doneSem){

                public void failed(Exception ex) {
                    Assert.fail((String)("Caught exception " + ex));
                    super.failed(ex);
                }
            });
            try {
                doneSem.tryAcquire(1, 15L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ex) {
                Assert.fail((String)("interrupted " + ex.toString()));
            }
        }
        Assert.assertEquals((long)1L, (long)docList.size());
        Document doc = (Document)docList.get(0);
        Assert.assertEquals((long)1L, (long)doc.size());
        long count = doc.getLong("theCount");
        System.out.println(tableName + " has " + count + " documents");
        return count;
    }

    @Test
    public void testM2Queries() {
        this.countRecords(REVIEWS_TABLE);
        OjaiConnection connection = TestOjaiMilestones.getConnection();
        DocumentStore docStore = connection.getStore(REVIEWS_TABLE);
        Query query1 = this.driver.newQuery().select(new String[]{"user_id"}).select(new String[]{"business_id"}).where(this.driver.newCondition().and().is("stars", QueryCondition.Op.EQUAL, 5.0).is("business_id", QueryCondition.Op.GREATER_OR_EQUAL, "zoQBXHsDQYc7HDy5oJutvQ").is("business_id", QueryCondition.Op.LESS_OR_EQUAL, "zofs5Ig8kgvtFyp3ySoSBA").close().build()).build();
        DocumentStream docStream = docStore.findQuery(query1);
        List<Document> docList = this.getDocuments(docStream);
        Assert.assertTrue((docList.size() > 0 ? 1 : 0) != 0);
        System.out.println("docList.size() => " + docList.size());
        Query query2 = this.driver.newQuery().select(new String[]{"user_id"}).select(new String[]{"review_id"}).where(this.driver.newCondition().and().is("business_id", QueryCondition.Op.GREATER_OR_EQUAL, "zzUUj9BUNn0_0F5hwy7RRw").is("business_id", QueryCondition.Op.LESS_OR_EQUAL, "zzucnDH33KlmbkI4rLyQTA").close().build()).build();
        docStream = docStore.findQuery(query2);
        docList = this.getDocuments(docStream);
        Assert.assertTrue((docList.size() > 0 ? 1 : 0) != 0);
        System.out.println("docList.size() => " + docList.size());
    }
}

