/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl.results;

import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.ojai.store.impl.ValueExtractor;
import com.mapr.ojai.store.impl.ValueExtractors;
import com.mapr.ojai.store.impl.results.QueryResultProcessor;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.drill.exec.record.RecordBatchLoader;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.vector.ValueVector;
import org.ojai.Document;

public class SqlResultProcessor
implements QueryResultProcessor {
    private final List<ValueExtractor> extractors = new LinkedList<ValueExtractor>();
    private final boolean excludeId;

    public SqlResultProcessor(boolean excludeId) {
        this.excludeId = excludeId;
    }

    @Override
    public Document extractFirst(RecordBatchLoader loader) {
        DBDocumentImpl firstDocument = new DBDocumentImpl();
        for (VectorWrapper vw : loader) {
            ValueVector vv = vw.getValueVector();
            ValueExtractor ve = ValueExtractors.fromValueVector(vv, this.excludeId);
            if (ve.valueCount <= 0) continue;
            this.extractors.add(ve);
            ve.extract(firstDocument, 0);
        }
        return firstDocument;
    }

    @Override
    public Document extractNext(int rowNum) {
        DBDocumentImpl dbDoc = new DBDocumentImpl();
        Iterator<ValueExtractor> iter = this.extractors.iterator();
        while (iter.hasNext()) {
            ValueExtractor ve = iter.next();
            if (rowNum >= ve.valueCount) {
                iter.remove();
                continue;
            }
            ve.extract(dbDoc, rowNum);
        }
        return dbDoc;
    }
}

