/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.ojai.store.impl.ValueExtractor;
import com.mapr.ojai.store.impl.Values;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.util.Text;
import org.apache.drill.exec.vector.BigIntVector;
import org.apache.drill.exec.vector.BitVector;
import org.apache.drill.exec.vector.DateVector;
import org.apache.drill.exec.vector.Float4Vector;
import org.apache.drill.exec.vector.Float8Vector;
import org.apache.drill.exec.vector.IntVector;
import org.apache.drill.exec.vector.NullableBigIntVector;
import org.apache.drill.exec.vector.NullableBitVector;
import org.apache.drill.exec.vector.NullableDateVector;
import org.apache.drill.exec.vector.NullableFloat4Vector;
import org.apache.drill.exec.vector.NullableFloat8Vector;
import org.apache.drill.exec.vector.NullableIntVector;
import org.apache.drill.exec.vector.NullableSmallIntVector;
import org.apache.drill.exec.vector.NullableTimeStampVector;
import org.apache.drill.exec.vector.NullableTimeVector;
import org.apache.drill.exec.vector.NullableTinyIntVector;
import org.apache.drill.exec.vector.NullableVar16CharVector;
import org.apache.drill.exec.vector.NullableVarBinaryVector;
import org.apache.drill.exec.vector.NullableVarCharVector;
import org.apache.drill.exec.vector.SmallIntVector;
import org.apache.drill.exec.vector.TimeStampVector;
import org.apache.drill.exec.vector.TimeVector;
import org.apache.drill.exec.vector.TinyIntVector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.Var16CharVector;
import org.apache.drill.exec.vector.VarBinaryVector;
import org.apache.drill.exec.vector.VarCharVector;
import org.apache.drill.exec.vector.complex.MapVector;
import org.apache.drill.exec.vector.complex.RepeatedValueVector;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;
import org.ojai.Value;
import org.ojai.exceptions.OjaiException;
import org.ojai.types.ODate;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;

public class ValueExtractors {
    private static final DateTimeZone TIME_ZONE_UTC = DateTimeZone.forID((String)"UTC");

    private static Object drillObjectToOjaiObject(Object drillObject) {
        if (drillObject instanceof Text) {
            return ((Text)drillObject).toString();
        }
        if (drillObject instanceof Map) {
            return ValueExtractors.drillMapToOjaiMap((Map)drillObject);
        }
        if (drillObject instanceof List) {
            return ValueExtractors.drillListToOjaiList((List)drillObject);
        }
        return drillObject;
    }

    private static List<?> drillListToOjaiList(List<?> drillList) {
        ArrayList<Object> ojaiList = new ArrayList<Object>(drillList.size());
        for (Object drillObject : drillList) {
            ojaiList.add(ValueExtractors.drillObjectToOjaiObject(drillObject));
        }
        return ojaiList;
    }

    private static Map<String, Object> drillMapToOjaiMap(Map<String, Object> drillMap) {
        HashMap<String, Object> ojaiMap = new HashMap<String, Object>();
        Set<Map.Entry<String, Object>> drillEntries = drillMap.entrySet();
        for (Map.Entry<String, Object> drillEntry : drillEntries) {
            Object drillValue = drillEntry.getValue();
            ojaiMap.put(drillEntry.getKey(), ValueExtractors.drillObjectToOjaiObject(drillValue));
        }
        return ojaiMap;
    }

    public static ValueExtractor fromValueVector(ValueVector vv, boolean excludeId) {
        UserBitShared.SerializedField serializedField = vv.getMetadata();
        String fieldName = serializedField.getNamePart().getName();
        TypeProtos.MajorType majorType = serializedField.getMajorType();
        TypeProtos.MinorType minorType = majorType.getMinorType();
        ValueVector.Accessor accessor = vv.getAccessor();
        if (fieldName.equals("_id")) {
            switch (minorType) {
                case VARBINARY: {
                    return new VarBinaryIdValueExtractor((NullableVarBinaryVector.Accessor)accessor, excludeId);
                }
                case VARCHAR: {
                    return new VarCharIdValueExtractor((NullableVarCharVector.Accessor)accessor, excludeId);
                }
            }
            throw new IllegalStateException();
        }
        TypeProtos.DataMode dataMode = majorType.getMode();
        if (dataMode == TypeProtos.DataMode.REPEATED) {
            return new RepeatedScalarValueExtractor(fieldName, (ValueVector.Accessor)((RepeatedValueVector.RepeatedAccessor)accessor));
        }
        block4 : switch (minorType) {
            case BIGINT: {
                switch (dataMode) {
                    case OPTIONAL: {
                        return new NullableBigIntValueExtractor(fieldName, (NullableBigIntVector.Accessor)accessor);
                    }
                    case REQUIRED: {
                        return new BigIntValueExtractor(fieldName, (BigIntVector.Accessor)accessor);
                    }
                }
                break;
            }
            case BIT: {
                switch (dataMode) {
                    case OPTIONAL: {
                        return new NullableBooleanValueExtractor(fieldName, (NullableBitVector.Accessor)accessor);
                    }
                    case REQUIRED: {
                        return new BooleanValueExtractor(fieldName, (BitVector.Accessor)accessor);
                    }
                }
                break;
            }
            case DATE: {
                switch (dataMode) {
                    case OPTIONAL: {
                        return new NullableDateValueExtractor(fieldName, (NullableDateVector.Accessor)accessor);
                    }
                    case REQUIRED: {
                        return new DateValueExtractor(fieldName, (DateVector.Accessor)accessor);
                    }
                }
                break;
            }
            case FLOAT4: {
                switch (dataMode) {
                    case OPTIONAL: {
                        return new NullableFloatValueExtractor(fieldName, (NullableFloat4Vector.Accessor)accessor);
                    }
                    case REQUIRED: {
                        return new FloatValueExtractor(fieldName, (Float4Vector.Accessor)accessor);
                    }
                }
                break;
            }
            case FLOAT8: {
                switch (dataMode) {
                    case OPTIONAL: {
                        return new NullableDoubleValueExtractor(fieldName, (NullableFloat8Vector.Accessor)accessor);
                    }
                    case REQUIRED: {
                        return new DoubleValueExtractor(fieldName, (Float8Vector.Accessor)accessor);
                    }
                }
                break;
            }
            case INT: {
                switch (dataMode) {
                    case OPTIONAL: {
                        return new NullableIntValueExtractor(fieldName, (NullableIntVector.Accessor)accessor);
                    }
                    case REQUIRED: {
                        return new IntValueExtractor(fieldName, (IntVector.Accessor)accessor);
                    }
                }
                break;
            }
            case MAP: {
                switch (dataMode) {
                    case OPTIONAL: {
                        break block4;
                    }
                    case REQUIRED: {
                        return new MapValueExtractor(fieldName, (MapVector.Accessor)accessor);
                    }
                }
                break;
            }
            case SMALLINT: {
                switch (dataMode) {
                    case OPTIONAL: {
                        return new NullableShortValueExtractor(fieldName, (NullableSmallIntVector.Accessor)accessor);
                    }
                    case REQUIRED: {
                        return new ShortValueExtractor(fieldName, (SmallIntVector.Accessor)accessor);
                    }
                }
                break;
            }
            case TIME: {
                switch (dataMode) {
                    case OPTIONAL: {
                        return new NullableTimeValueExtractor(fieldName, (NullableTimeVector.Accessor)accessor);
                    }
                    case REQUIRED: {
                        return new TimeValueExtractor(fieldName, (TimeVector.Accessor)accessor);
                    }
                }
                break;
            }
            case TIMESTAMP: {
                switch (dataMode) {
                    case OPTIONAL: {
                        return new NullableTimestampValueExtractor(fieldName, (NullableTimeStampVector.Accessor)accessor);
                    }
                    case REQUIRED: {
                        return new TimestampValueExtractor(fieldName, (TimeStampVector.Accessor)accessor);
                    }
                }
                break;
            }
            case TINYINT: {
                switch (dataMode) {
                    case OPTIONAL: {
                        return new NullableByteValueExtractor(fieldName, (NullableTinyIntVector.Accessor)accessor);
                    }
                    case REQUIRED: {
                        return new ByteValueExtractor(fieldName, (TinyIntVector.Accessor)accessor);
                    }
                }
                break;
            }
            case VAR16CHAR: {
                switch (dataMode) {
                    case OPTIONAL: {
                        return new NullableVar16CharValueExtractor(fieldName, (NullableVar16CharVector.Accessor)accessor);
                    }
                    case REQUIRED: {
                        return new Var16CharValueExtractor(fieldName, (Var16CharVector.Accessor)accessor);
                    }
                }
                break;
            }
            case VARBINARY: {
                switch (dataMode) {
                    case OPTIONAL: {
                        return new NullableVarBinaryValueExtractor(fieldName, (NullableVarBinaryVector.Accessor)accessor);
                    }
                    case REQUIRED: {
                        return new VarBinaryValueExtractor(fieldName, (VarBinaryVector.Accessor)accessor);
                    }
                }
                break;
            }
            case VARCHAR: {
                switch (dataMode) {
                    case OPTIONAL: {
                        return new NullableVarCharValueExtractor(fieldName, (NullableVarCharVector.Accessor)accessor);
                    }
                    case REQUIRED: {
                        return new VarCharValueExtractor(fieldName, (VarCharVector.Accessor)accessor);
                    }
                }
                break;
            }
            default: {
                throw new OjaiException("unrecognized ValueVector minorType " + minorType + " majorType " + majorType + " (needs a " + vv.getClass().getName() + " accessor)");
            }
        }
        throw new OjaiException("not reached");
    }

    public static class VarCharIdValueExtractor
    extends NullableVarCharValueExtractor {
        private final boolean excludeId;

        public VarCharIdValueExtractor(NullableVarCharVector.Accessor accessor, boolean excludeId) {
            super("_id", accessor);
            this.excludeId = excludeId;
        }

        @Override
        public void extract(DBDocumentImpl doc, int iRow) {
            final Text v = this.accessor.getObject(iRow);
            Values.BaseValue value = new Values.BaseValue(Value.Type.STRING){

                @Override
                public String getString() {
                    return v.toString();
                }

                @Override
                public Object getObject() {
                    return v.toString();
                }
            };
            doc.setId((Value)value, this.excludeId);
        }
    }

    public static class NullableVarCharValueExtractor
    extends ValueExtractor {
        protected final NullableVarCharVector.Accessor accessor;

        public NullableVarCharValueExtractor(String fieldName, NullableVarCharVector.Accessor accessor) {
            super(fieldName, accessor.getValueCount());
            this.accessor = accessor;
        }

        @Override
        public void extract(DBDocumentImpl doc, int iRow) {
            if (!this.accessor.isNull(iRow)) {
                Text v = this.accessor.getObject(iRow);
                doc.set(this.fieldPath, v.toString());
            }
        }
    }

    public static class VarCharValueExtractor
    extends ValueExtractor {
        private final VarCharVector.Accessor accessor;

        public VarCharValueExtractor(String fieldName, VarCharVector.Accessor accessor) {
            super(fieldName, accessor.getValueCount());
            this.accessor = accessor;
        }

        @Override
        public void extract(DBDocumentImpl doc, int iRow) {
            Text v = this.accessor.getObject(iRow);
            doc.set(this.fieldPath, v.toString());
        }
    }

    public static class VarBinaryIdValueExtractor
    extends NullableVarBinaryValueExtractor {
        private final boolean excludeId;

        public VarBinaryIdValueExtractor(NullableVarBinaryVector.Accessor accessor, boolean excludeId) {
            super("_id", accessor);
            this.excludeId = excludeId;
        }

        @Override
        public void extract(DBDocumentImpl doc, int iRow) {
            final byte[] v = this.accessor.getObject(iRow);
            Values.BaseValue value = new Values.BaseValue(Value.Type.BINARY){

                @Override
                public ByteBuffer getBinary() {
                    return ByteBuffer.wrap(v);
                }

                @Override
                public Object getObject() {
                    return ByteBuffer.wrap(v);
                }
            };
            doc.setId((Value)value, this.excludeId);
        }
    }

    public static class NullableVarBinaryValueExtractor
    extends ValueExtractor {
        protected final NullableVarBinaryVector.Accessor accessor;

        public NullableVarBinaryValueExtractor(String fieldName, NullableVarBinaryVector.Accessor accessor) {
            super(fieldName, accessor.getValueCount());
            this.accessor = accessor;
        }

        @Override
        public void extract(DBDocumentImpl doc, int iRow) {
            if (!this.accessor.isNull(iRow)) {
                byte[] v = this.accessor.getObject(iRow);
                doc.set(this.fieldPath, v);
            }
        }
    }

    public static class VarBinaryValueExtractor
    extends ValueExtractor {
        private final VarBinaryVector.Accessor accessor;

        public VarBinaryValueExtractor(String fieldName, VarBinaryVector.Accessor accessor) {
            super(fieldName, accessor.getValueCount());
            this.accessor = accessor;
        }

        @Override
        public void extract(DBDocumentImpl doc, int iRow) {
            byte[] v = this.accessor.getObject(iRow);
            doc.set(this.fieldPath, v);
        }
    }

    public static class NullableVar16CharValueExtractor
    extends ValueExtractor {
        private final NullableVar16CharVector.Accessor accessor;

        public NullableVar16CharValueExtractor(String fieldName, NullableVar16CharVector.Accessor accessor) {
            super(fieldName, accessor.getValueCount());
            this.accessor = accessor;
        }

        @Override
        public void extract(DBDocumentImpl doc, int iRow) {
            if (!this.accessor.isNull(iRow)) {
                String v = this.accessor.getObject(iRow);
                doc.set(this.fieldPath, v);
            }
        }
    }

    public static class Var16CharValueExtractor
    extends ValueExtractor {
        private final Var16CharVector.Accessor accessor;

        public Var16CharValueExtractor(String fieldName, Var16CharVector.Accessor accessor) {
            super(fieldName, accessor.getValueCount());
            this.accessor = accessor;
        }

        @Override
        public void extract(DBDocumentImpl doc, int iRow) {
            String v = this.accessor.getObject(iRow);
            doc.set(this.fieldPath, v);
        }
    }

    public static class MapValueExtractor
    extends ValueExtractor {
        private final MapVector.Accessor accessor;

        public MapValueExtractor(String fieldName, MapVector.Accessor accessor) {
            super(fieldName, accessor.getValueCount());
            this.accessor = accessor;
        }

        @Override
        public void extract(DBDocumentImpl doc, int iRow) {
            Map v = (Map)this.accessor.getObject(iRow);
            if (v.size() > 0) {
                doc.set(this.fieldPath, ValueExtractors.drillMapToOjaiMap(v));
            }
        }
    }

    public static class NullableTimestampValueExtractor
    extends ValueExtractor {
        private final NullableTimeStampVector.Accessor accessor;

        public NullableTimestampValueExtractor(String fieldName, NullableTimeStampVector.Accessor accessor) {
            super(fieldName, accessor.getValueCount());
            this.accessor = accessor;
        }

        @Override
        public void extract(DBDocumentImpl doc, int iRow) {
            if (!this.accessor.isNull(iRow)) {
                OTimestamp v = new OTimestamp(this.accessor.get(iRow));
                doc.set(this.fieldPath, v);
            }
        }
    }

    public static class TimestampValueExtractor
    extends ValueExtractor {
        private final TimeStampVector.Accessor accessor;

        public TimestampValueExtractor(String fieldName, TimeStampVector.Accessor accessor) {
            super(fieldName, accessor.getValueCount());
            this.accessor = accessor;
        }

        @Override
        public void extract(DBDocumentImpl doc, int iRow) {
            OTimestamp v = new OTimestamp(this.accessor.get(iRow));
            doc.set(this.fieldPath, v);
        }
    }

    public static class NullableTimeValueExtractor
    extends ValueExtractor {
        private final NullableTimeVector.Accessor accessor;

        public NullableTimeValueExtractor(String fieldName, NullableTimeVector.Accessor accessor) {
            super(fieldName, accessor.getValueCount());
            this.accessor = accessor;
        }

        @Override
        public void extract(DBDocumentImpl doc, int iRow) {
            if (!this.accessor.isNull(iRow)) {
                LocalTime localTime = new LocalTime((long)this.accessor.get(iRow), TIME_ZONE_UTC);
                OTime v = new OTime(localTime.getHourOfDay(), localTime.getMinuteOfHour(), localTime.getSecondOfMinute(), localTime.getMillisOfSecond());
                doc.set(this.fieldPath, v);
            }
        }
    }

    public static class TimeValueExtractor
    extends ValueExtractor {
        private final TimeVector.Accessor accessor;

        public TimeValueExtractor(String fieldName, TimeVector.Accessor accessor) {
            super(fieldName, accessor.getValueCount());
            this.accessor = accessor;
        }

        @Override
        public void extract(DBDocumentImpl doc, int iRow) {
            LocalTime localTime = new LocalTime((long)this.accessor.get(iRow), TIME_ZONE_UTC);
            OTime v = new OTime(localTime.getHourOfDay(), localTime.getMinuteOfHour(), localTime.getSecondOfMinute(), localTime.getMillisOfSecond());
            doc.set(this.fieldPath, v);
        }
    }

    public static class NullableByteValueExtractor
    extends ValueExtractor {
        private final NullableTinyIntVector.Accessor accessor;

        public NullableByteValueExtractor(String fieldName, NullableTinyIntVector.Accessor accessor) {
            super(fieldName, accessor.getValueCount());
            this.accessor = accessor;
        }

        @Override
        public void extract(DBDocumentImpl doc, int iRow) {
            if (!this.accessor.isNull(iRow)) {
                byte v = this.accessor.get(iRow);
                doc.set(this.fieldPath, v);
            }
        }
    }

    public static class ByteValueExtractor
    extends ValueExtractor {
        private final TinyIntVector.Accessor accessor;

        public ByteValueExtractor(String fieldName, TinyIntVector.Accessor accessor) {
            super(fieldName, accessor.getValueCount());
            this.accessor = accessor;
        }

        @Override
        public void extract(DBDocumentImpl doc, int iRow) {
            byte v = this.accessor.get(iRow);
            doc.set(this.fieldPath, v);
        }
    }

    public static class NullableShortValueExtractor
    extends ValueExtractor {
        private final NullableSmallIntVector.Accessor accessor;

        public NullableShortValueExtractor(String fieldName, NullableSmallIntVector.Accessor accessor) {
            super(fieldName, accessor.getValueCount());
            this.accessor = accessor;
        }

        @Override
        public void extract(DBDocumentImpl doc, int iRow) {
            if (!this.accessor.isNull(iRow)) {
                short v = this.accessor.get(iRow);
                doc.set(this.fieldPath, v);
            }
        }
    }

    public static class ShortValueExtractor
    extends ValueExtractor {
        private final SmallIntVector.Accessor accessor;

        public ShortValueExtractor(String fieldName, SmallIntVector.Accessor accessor) {
            super(fieldName, accessor.getValueCount());
            this.accessor = accessor;
        }

        @Override
        public void extract(DBDocumentImpl doc, int iRow) {
            short v = this.accessor.get(iRow);
            doc.set(this.fieldPath, v);
        }
    }

    public static class NullableDoubleValueExtractor
    extends ValueExtractor {
        private final NullableFloat8Vector.Accessor accessor;

        public NullableDoubleValueExtractor(String fieldName, NullableFloat8Vector.Accessor accessor) {
            super(fieldName, accessor.getValueCount());
            this.accessor = accessor;
        }

        @Override
        public void extract(DBDocumentImpl doc, int iRow) {
            if (!this.accessor.isNull(iRow)) {
                double v = this.accessor.get(iRow);
                doc.set(this.fieldPath, v);
            }
        }
    }

    public static class DoubleValueExtractor
    extends ValueExtractor {
        private final Float8Vector.Accessor accessor;

        public DoubleValueExtractor(String fieldName, Float8Vector.Accessor accessor) {
            super(fieldName, accessor.getValueCount());
            this.accessor = accessor;
        }

        @Override
        public void extract(DBDocumentImpl doc, int iRow) {
            double v = this.accessor.get(iRow);
            doc.set(this.fieldPath, v);
        }
    }

    public static class NullableFloatValueExtractor
    extends ValueExtractor {
        private final NullableFloat4Vector.Accessor accessor;

        public NullableFloatValueExtractor(String fieldName, NullableFloat4Vector.Accessor accessor) {
            super(fieldName, accessor.getValueCount());
            this.accessor = accessor;
        }

        @Override
        public void extract(DBDocumentImpl doc, int iRow) {
            if (!this.accessor.isNull(iRow)) {
                float v = this.accessor.get(iRow);
                doc.set(this.fieldPath, v);
            }
        }
    }

    public static class FloatValueExtractor
    extends ValueExtractor {
        private final Float4Vector.Accessor accessor;

        public FloatValueExtractor(String fieldName, Float4Vector.Accessor accessor) {
            super(fieldName, accessor.getValueCount());
            this.accessor = accessor;
        }

        @Override
        public void extract(DBDocumentImpl doc, int iRow) {
            float v = this.accessor.get(iRow);
            doc.set(this.fieldPath, v);
        }
    }

    public static class NullableBooleanValueExtractor
    extends ValueExtractor {
        private final NullableBitVector.Accessor accessor;

        public NullableBooleanValueExtractor(String fieldName, NullableBitVector.Accessor accessor) {
            super(fieldName, accessor.getValueCount());
            this.accessor = accessor;
        }

        @Override
        public void extract(DBDocumentImpl doc, int iRow) {
            if (!this.accessor.isNull(iRow)) {
                int v = this.accessor.get(iRow);
                doc.set(this.fieldPath, v != 0);
            }
        }
    }

    public static class BooleanValueExtractor
    extends ValueExtractor {
        private final BitVector.Accessor accessor;

        public BooleanValueExtractor(String fieldName, BitVector.Accessor accessor) {
            super(fieldName, accessor.getValueCount());
            this.accessor = accessor;
        }

        @Override
        public void extract(DBDocumentImpl doc, int iRow) {
            int v = this.accessor.get(iRow);
            doc.set(this.fieldPath, v != 0);
        }
    }

    public static class NullableIntValueExtractor
    extends ValueExtractor {
        private final NullableIntVector.Accessor accessor;

        public NullableIntValueExtractor(String fieldName, NullableIntVector.Accessor accessor) {
            super(fieldName, accessor.getValueCount());
            this.accessor = accessor;
        }

        @Override
        public void extract(DBDocumentImpl doc, int iRow) {
            if (!this.accessor.isNull(iRow)) {
                int v = this.accessor.getObject(iRow);
                doc.set(this.fieldPath, v);
            }
        }
    }

    public static class IntValueExtractor
    extends ValueExtractor {
        private final IntVector.Accessor accessor;

        public IntValueExtractor(String fieldName, IntVector.Accessor accessor) {
            super(fieldName, accessor.getValueCount());
            this.accessor = accessor;
        }

        @Override
        public void extract(DBDocumentImpl doc, int iRow) {
            int v = this.accessor.getObject(iRow);
            doc.set(this.fieldPath, v);
        }
    }

    public static class NullableDateValueExtractor
    extends ValueExtractor {
        private final NullableDateVector.Accessor accessor;

        public NullableDateValueExtractor(String fieldName, NullableDateVector.Accessor accessor) {
            super(fieldName, accessor.getValueCount());
            this.accessor = accessor;
        }

        @Override
        public void extract(DBDocumentImpl doc, int iRow) {
            if (!this.accessor.isNull(iRow)) {
                LocalDate localDate = new LocalDate(this.accessor.get(iRow), TIME_ZONE_UTC);
                ODate oDate = new ODate(localDate.getYear(), localDate.getMonthOfYear(), localDate.getDayOfMonth());
                doc.set(this.fieldPath, oDate);
            }
        }
    }

    public static class DateValueExtractor
    extends ValueExtractor {
        private final DateVector.Accessor accessor;

        public DateValueExtractor(String fieldName, DateVector.Accessor accessor) {
            super(fieldName, accessor.getValueCount());
            this.accessor = accessor;
        }

        @Override
        public void extract(DBDocumentImpl doc, int iRow) {
            LocalDate localDate = new LocalDate(this.accessor.get(iRow), TIME_ZONE_UTC);
            ODate oDate = new ODate(localDate.getYear(), localDate.getMonthOfYear(), localDate.getDayOfMonth());
            doc.set(this.fieldPath, oDate);
        }
    }

    public static class NullableBigIntValueExtractor
    extends ValueExtractor {
        private final NullableBigIntVector.Accessor accessor;

        public NullableBigIntValueExtractor(String fieldName, NullableBigIntVector.Accessor accessor) {
            super(fieldName, accessor.getValueCount());
            this.accessor = accessor;
        }

        @Override
        public void extract(DBDocumentImpl doc, int iRow) {
            if (!this.accessor.isNull(iRow)) {
                long v = this.accessor.getObject(iRow);
                doc.set(this.fieldPath, v);
            }
        }
    }

    public static class BigIntValueExtractor
    extends ValueExtractor {
        private final BigIntVector.Accessor accessor;

        public BigIntValueExtractor(String fieldName, BigIntVector.Accessor accessor) {
            super(fieldName, accessor.getValueCount());
            this.accessor = accessor;
        }

        @Override
        public void extract(DBDocumentImpl doc, int iRow) {
            long v = this.accessor.getObject(iRow);
            doc.set(this.fieldPath, v);
        }
    }

    public static class RepeatedScalarValueExtractor
    extends ValueExtractor {
        private final ValueVector.Accessor accessor;

        public RepeatedScalarValueExtractor(String fieldName, ValueVector.Accessor accessor) {
            super(fieldName, accessor.getValueCount());
            this.accessor = accessor;
        }

        @Override
        public void extract(DBDocumentImpl doc, int iRow) {
            List vList;
            if (!this.accessor.isNull(iRow) && (vList = (List)this.accessor.getObject(iRow)).size() > 0) {
                doc.set(this.fieldPath, ValueExtractors.drillListToOjaiList(vList));
            }
        }
    }
}

