/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.mapr.ojai.store.impl.Values;
import java.util.Arrays;
import org.ojai.DocumentReader;
import org.ojai.Value;

public class ReaderPathBuilder {
    private static final int STACK_START_SIZE = 6;
    private int[] lengthStack = new int[6];
    private boolean[] inArrayStack = new boolean[6];
    private int stackIdx = -1;
    private final StringBuilder pathBuilder = new StringBuilder(32);

    private void pushField(DocumentReader docReader, boolean inArray) {
        boolean wasArray;
        if (++this.stackIdx == this.lengthStack.length) {
            int newSize = (this.stackIdx - 1) * 2;
            this.lengthStack = Arrays.copyOf(this.lengthStack, newSize);
            this.inArrayStack = Arrays.copyOf(this.inArrayStack, newSize);
        }
        this.lengthStack[this.stackIdx] = this.pathBuilder.length();
        this.inArrayStack[this.stackIdx] = inArray;
        boolean bl = wasArray = this.stackIdx > 0 && this.inArrayStack[this.stackIdx - 1];
        if (wasArray) {
            this.pathBuilder.append('[');
            this.pathBuilder.append(docReader.getArrayIndex());
            this.pathBuilder.append(']');
        } else {
            String mapName = docReader.getFieldName();
            if (mapName != null) {
                if (this.stackIdx > 1) {
                    this.pathBuilder.append('.');
                }
                this.pathBuilder.append(mapName);
            }
        }
    }

    public String pushField(DocumentReader docReader) {
        this.pushField(docReader, false);
        return this.pathBuilder.toString();
    }

    public void popField() {
        this.pathBuilder.setLength(this.lengthStack[this.stackIdx--]);
    }

    public void startArray(DocumentReader docReader) {
        this.pushField(docReader, true);
    }

    public void endArray() {
        this.popField();
    }

    public void startMap(DocumentReader docReader) {
        this.pushField(docReader, false);
    }

    public void endMap() {
        this.popField();
    }

    public static Value getValue(DocumentReader docReader) {
        DocumentReader.EventType eventType = docReader.getCurrentEvent();
        Values.BaseValue value = null;
        switch (eventType) {
            case NULL: {
                value = Values.NULL;
                break;
            }
            case BOOLEAN: {
                value = new Values.BooleanValue(docReader.getBoolean());
                break;
            }
            case STRING: {
                value = new Values.StringValue(docReader.getString());
                break;
            }
            case BYTE: {
                value = new Values.ByteValue(docReader.getByte());
                break;
            }
            case SHORT: {
                value = new Values.ShortValue(docReader.getShort());
                break;
            }
            case INT: {
                value = new Values.IntValue(docReader.getInt());
                break;
            }
            case LONG: {
                value = new Values.LongValue(docReader.getLong());
                break;
            }
            case FLOAT: {
                value = new Values.FloatValue(docReader.getFloat());
                break;
            }
            case DOUBLE: {
                value = new Values.DoubleValue(docReader.getDouble());
                break;
            }
            case DECIMAL: {
                value = new Values.DecimalValue(docReader.getDecimal());
                break;
            }
            case DATE: {
                value = new Values.DateValue(docReader.getDate());
                break;
            }
            case TIME: {
                value = new Values.TimeValue(docReader.getTime());
                break;
            }
            case TIMESTAMP: {
                value = new Values.TimestampValue(docReader.getTimestamp());
                break;
            }
            case INTERVAL: {
                value = new Values.IntervalValue(docReader.getInterval());
                break;
            }
            case BINARY: {
                value = new Values.BinaryValue(docReader.getBinary());
                break;
            }
            default: {
                throw new IllegalStateException("unimplemented eventType " + eventType);
            }
        }
        return value;
    }
}

