/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.mapr.db.impl.ConditionImpl;
import com.mapr.ojai.store.impl.OjaiConnection;
import com.mapr.ojai.store.impl.OjaiQuery;
import com.mapr.ojai.store.impl.OjaiTest;
import com.mapr.tests.annotations.SimpleTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.store.QueryCondition;

@Category(value={SimpleTest.class})
public class TestOjaiQuery_MAPRDB_2332
extends OjaiTest {
    final OjaiConnection ojaiConnection = TestOjaiQuery_MAPRDB_2332.getConnection();

    @Test
    public void testQuery_SQL() throws Exception {
        ConditionImpl condition = (ConditionImpl)this.ojaiConnection.newCondition().and().is("key", QueryCondition.Op.EQUAL, "abc2").is("data.space_id", QueryCondition.Op.EQUAL, "12345").is("controls[].scope", QueryCondition.Op.EQUAL, "analytics").close().build();
        String goldSqlString = "select t.`$$ENC00FIAF62LE`,t.`$$document` from dfs.`/apps/payrolls` t where ((t.`key` = 'abc2') and (t.`data`.`space_id` = '12345') and t._id in( select _id from ( select _id, flatten(t1.`controls`) f2 from dfs.`/apps/payrolls` t1 ) as t1 where ((t1.f2.`scope` = 'analytics')) ))  limit 1";
        OjaiQuery query = (OjaiQuery)this.ojaiConnection.newQuery().where((QueryCondition)condition).limit(1L).setOption("ojai.mapr.query.force-drill", (Object)true).build();
        String sqlString = query.buildSqlString("dfs", "/apps/payrolls");
        Assert.assertEquals((Object)"select t.`$$ENC00FIAF62LE`,t.`$$document` from dfs.`/apps/payrolls` t where ((t.`key` = 'abc2') and (t.`data`.`space_id` = '12345') and t._id in( select _id from ( select _id, flatten(t1.`controls`) f2 from dfs.`/apps/payrolls` t1 ) as t1 where ((t1.f2.`scope` = 'analytics')) ))  limit 1", (Object)sqlString);
    }

    @Test
    public void testQuery_ConditionStructure() throws Exception {
        ConditionImpl c0 = (ConditionImpl)this.ojaiConnection.newCondition().is("a.b.c", QueryCondition.Op.EQUAL, "value").build();
        Assert.assertFalse((boolean)c0.hasMultiLevelArray());
        ConditionImpl c1 = (ConditionImpl)this.ojaiConnection.newCondition().is("a[][].c", QueryCondition.Op.EQUAL, "value").build();
        Assert.assertTrue((boolean)c1.hasMultiLevelArray());
        ConditionImpl c2 = (ConditionImpl)this.ojaiConnection.newCondition().is("a[].b[].c", QueryCondition.Op.EQUAL, "value").build();
        Assert.assertTrue((boolean)c2.hasMultiLevelArray());
        ConditionImpl c3 = (ConditionImpl)this.ojaiConnection.newCondition().and().is("a[].b", QueryCondition.Op.EQUAL, "value").is("a[].c", QueryCondition.Op.EQUAL, "value").close().build();
        Assert.assertFalse((boolean)c3.hasMultiLevelArray());
        ConditionImpl c4 = (ConditionImpl)this.ojaiConnection.newCondition().and().is("a[][]", QueryCondition.Op.EQUAL, "value").is("a[].c", QueryCondition.Op.EQUAL, "value").close().build();
        Assert.assertTrue((boolean)c4.hasMultiLevelArray());
        ConditionImpl c5 = (ConditionImpl)this.ojaiConnection.newCondition().elementAnd("a[]").is("b", QueryCondition.Op.EQUAL, "value").is("c", QueryCondition.Op.EQUAL, "value").close().build();
        Assert.assertFalse((boolean)c5.hasMultiLevelArray());
        ConditionImpl c6 = (ConditionImpl)this.ojaiConnection.newCondition().elementAnd("a[][]").is("b", QueryCondition.Op.EQUAL, "value").is("c", QueryCondition.Op.EQUAL, "value").close().build();
        Assert.assertTrue((boolean)c6.hasMultiLevelArray());
        ConditionImpl c7 = (ConditionImpl)this.ojaiConnection.newCondition().elementAnd("a[].b[]").is("b", QueryCondition.Op.EQUAL, "value").is("c", QueryCondition.Op.EQUAL, "value").close().build();
        Assert.assertTrue((boolean)c7.hasMultiLevelArray());
        ConditionImpl c8 = (ConditionImpl)this.ojaiConnection.newCondition().elementAnd("a[]").is("b[][]", QueryCondition.Op.EQUAL, "value").is("c", QueryCondition.Op.EQUAL, "value").close().build();
        Assert.assertTrue((boolean)c8.hasMultiLevelArray());
    }
}

