/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.mapr.db.tests.utils.DBTests;
import com.mapr.ojai.store.impl.OjaiConnection;
import com.mapr.ojai.store.impl.SingleRowListener;
import com.mapr.security.MutableInt;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import io.netty.buffer.DrillBuf;
import java.io.IOException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.RecordBatchLoader;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.rpc.user.QueryDataBatch;
import org.apache.drill.exec.rpc.user.UserResultsListener;
import org.apache.drill.exec.rpc.user.clusterclient.DrillSession;
import org.apache.drill.exec.vector.ValueVector;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.store.Connection;
import org.ojai.store.Driver;
import org.ojai.store.DriverManager;

public class TestOjaiDriver
extends BaseTest {
    private static final int TIMEOUT_SECONDS = 5;
    private static final String DRILLBIT_QUERY = "select count(*) from sys.drillbits";

    @Test
    @Category(value={ClusterTest.class})
    public void testDrillClusterClient() throws IOException {
        Driver ojaiDriver = DriverManager.getDriver((String)"ojai:mapr:@");
        Document connectionOptions = ojaiDriver.newDocument();
        String maprHome = System.getenv("MAPR_HOME");
        if (maprHome == null) {
            maprHome = "/opt/mapr";
        }
        connectionOptions.set("mapr.client.conf_file", maprHome + "/conf/mapr-clusters.conf");
        Connection connection = ojaiDriver.connect("ojai:mapr:", connectionOptions);
        Assert.assertNotNull((Object)connection);
        Assert.assertTrue((String)"connection is not an OjaiConnection", (boolean)(connection instanceof OjaiConnection));
        OjaiConnection ojaiConnection = (OjaiConnection)connection;
        Assert.assertNotNull((Object)ojaiConnection);
        final DrillSession session = ojaiConnection.getDrillSession(DBTests.maprfs().getDefaultClusterName());
        Assert.assertNotNull((Object)session);
        final MutableInt rowCount = new MutableInt();
        final MutableInt bitCount = new MutableInt();
        final Semaphore resultSem = new Semaphore(0);
        session.executeStatement(DRILLBIT_QUERY, (UserResultsListener)new SingleRowListener(){

            protected void rowArrived(QueryDataBatch queryDataBatch) {
                UserBitShared.QueryData queryData = queryDataBatch.getHeader();
                rowCount.SetValue(queryData.getRowCount());
                DrillBuf drillBuf = queryDataBatch.getData();
                RecordBatchLoader loader = new RecordBatchLoader(session.getAllocator());
                try {
                    loader.load(queryData.getDef(), drillBuf);
                }
                catch (SchemaChangeException e) {
                    throw new RuntimeException("Unexpected exception", e);
                }
                for (VectorWrapper vw : loader) {
                    ValueVector vv = vw.getValueVector();
                    ValueVector.Accessor acc = vv.getAccessor();
                    Assert.assertEquals((long)acc.getValueCount(), (long)1L);
                    Object obj = acc.getObject(0);
                    Assert.assertTrue((boolean)(obj instanceof Long));
                    bitCount.SetValue(((Long)obj).intValue());
                }
                drillBuf.release();
                resultSem.release();
            }
        });
        try {
            if (!resultSem.tryAcquire(5L, TimeUnit.SECONDS)) {
                Assert.fail((String)"Drill query did not return within timeout");
            } else {
                Assert.assertTrue((String)"We were able to query drill", (rowCount.GetValue() == 1 ? 1 : 0) != 0);
                Assert.assertTrue((String)"There are drillbits running", (bitCount.GetValue() >= 1 ? 1 : 0) != 0);
            }
        }
        catch (InterruptedException e) {
            Assert.fail((String)"Interrupted while waiting for Drill query result");
        }
        session.close();
        connection.close();
    }

    @Test
    public void testNewEmptyDocument() {
        Document doc = DriverManager.getDriver((String)"ojai:mapr:@").newDocument("{}");
        Assert.assertNotNull((Object)doc);
        Assert.assertEquals((long)0L, (long)doc.size());
    }
}

