/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;

public class StringGenerator {
    private final int maxLength;
    private final Random random;
    private Set<String> uniqueStrings;
    private static final String chars = "abcdefghijklmnopqrstuvwxyz01234567890ABCDEFGHIJKLMNOPQRSTUVWXYZ";

    public StringGenerator(int maxLength, long seed) {
        this(maxLength, new Random(seed));
    }

    public StringGenerator(int maxLength, Random random) {
        Preconditions.checkArgument((maxLength > 0 ? 1 : 0) != 0, (Object)"maxLength must be positive");
        Preconditions.checkNotNull((Object)random, (Object)"random number generator cannot be null");
        this.maxLength = maxLength;
        this.random = random;
    }

    private void appendChar(StringBuilder sb) {
        sb.append(chars.charAt(this.random.nextInt(chars.length())));
    }

    public String nextString() {
        StringBuilder sb = new StringBuilder(this.maxLength);
        for (int i = 0; i < this.maxLength; ++i) {
            this.appendChar(sb);
            int pOneMoreChar = (int)((double)(this.maxLength - 1 - i) * (100.0 / (double)this.maxLength));
            int p = this.random.nextInt(100);
            if (p >= pOneMoreChar) break;
        }
        return sb.toString();
    }

    public String nextString(int length) {
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            this.appendChar(sb);
        }
        return sb.toString();
    }

    public String nextUniqueString() {
        String result;
        if (this.uniqueStrings == null) {
            this.uniqueStrings = new HashSet<String>();
        }
        while (this.uniqueStrings.contains(result = this.nextString())) {
        }
        this.uniqueStrings.add(result);
        return result;
    }
}

