/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.ojai.exceptions.OjaiException;
import org.ojai.exceptions.QueryTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BlockingHandoff<T>
implements Iterable<T> {
    private static final Logger logger = LoggerFactory.getLogger(BlockingHandoff.class);
    private static final AtomicInteger idGenerator = new AtomicInteger(0);
    private final LinkedList<Action> resultQueue = new LinkedList();
    private boolean closeRequested;
    private final long timeoutMs;
    private final int id = idGenerator.incrementAndGet();

    public BlockingHandoff(long timeoutMs) {
        this.timeoutMs = timeoutMs;
    }

    protected void throwQueryTimeout() {
        throw new QueryTimeoutException("Query exceeded timeout (" + this.timeoutMs + ")");
    }

    protected abstract void itemTimeout(long var1);

    private synchronized boolean hasNext(Action action) {
        logger.debug("BlockingHandoff[{}].hasNext(action) action.close = {}, action.ex = {}, action.nextItem != null => {}", new Object[]{this.id, action.close, action.ex, action.nextItem != null});
        if (action.close) {
            return false;
        }
        if (action.ex != null) {
            Action firstAction = this.resultQueue.remove();
            if (firstAction != action) {
                throw new IllegalStateException();
            }
            if (action.ex instanceof OjaiException) {
                throw (OjaiException)action.ex;
            }
            throw new OjaiException((Throwable)action.ex);
        }
        return true;
    }

    private synchronized void waitForAction() {
        long timeLeftMs = this.timeoutMs;
        while (timeLeftMs > 0L && this.resultQueue.size() == 0) {
            try {
                long startTime = System.currentTimeMillis();
                logger.debug("BlockingHandoff[{}].waitForAction() wait({})", (Object)this.id, (Object)timeLeftMs);
                this.wait(timeLeftMs);
                long endTime = System.currentTimeMillis();
                long waitTime = endTime - startTime;
                logger.debug("BlockingHandoff[{}].waitForAction() waited for {}", (Object)this.id, (Object)waitTime);
                timeLeftMs -= waitTime;
            }
            catch (InterruptedException iex) {
                logger.debug("BlockingHandoff[{}].waitForAction() interrupted {}", (Throwable)iex);
                this.enqueueClose();
            }
        }
        logger.debug("BlockingHandoff[{}].waitForAction() timeLeftMs = {} queue size = {}", (Object)timeLeftMs, (Object)this.resultQueue.size());
        if (this.resultQueue.size() == 0) {
            this.itemTimeout(this.timeoutMs);
            throw new IllegalStateException();
        }
    }

    private synchronized boolean hasNext() {
        this.waitForAction();
        Action action = this.resultQueue.peek();
        return this.hasNext(action);
    }

    private synchronized T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Action action = this.resultQueue.poll();
        this.notifyAll();
        return action.nextItem;
    }

    private synchronized void waitForSpace() {
        while (!this.closeRequested && this.resultQueue.size() > 0) {
            try {
                logger.debug("BlockingHandoff[{}].waitForSpace() wait()", (Object)this.id);
                this.wait();
            }
            catch (InterruptedException iex) {
                logger.debug("BlockingHandoff[{}].waitForSpace() interrupted {}", (Object)this.id, (Object)iex);
                this.enqueueClose();
            }
        }
        logger.debug("BlockingHandoff[{}].waitForSpace() closeRequested = {}, resultQueue.size() = {}", new Object[]{this.id, this.closeRequested, this.resultQueue.size()});
    }

    private synchronized void put(Action action) {
        if (this.closeRequested) {
            logger.debug("BlockingHandoff[{}].put() requested after closeRequested", (Object)this.id);
            return;
        }
        this.waitForSpace();
        if (this.closeRequested) {
            logger.debug("BlockingHandoff[{}].put() requested after closeRequested (after waitForSpace())", (Object)this.id);
            return;
        }
        logger.debug("BlockingHandoff[{}].put() => adding item", (Object)this.id);
        this.resultQueue.add(action);
        this.notifyAll();
    }

    public void put(T item) {
        Preconditions.checkArgument((item != null ? 1 : 0) != 0);
        this.put(new Action(item));
    }

    public synchronized void putException(Exception ex) {
        Preconditions.checkArgument((ex != null ? 1 : 0) != 0);
        this.put(new Action(ex));
        this.enqueueClose();
    }

    public synchronized void putEos() {
        this.enqueueClose();
        this.notifyAll();
    }

    protected abstract void setup(CountDownLatch var1);

    protected abstract void iteratorTimeout();

    @Override
    public Iterator<T> iterator() {
        ItemIterator itemIterator = new ItemIterator();
        CountDownLatch readyLatch = new CountDownLatch(1);
        this.setup(readyLatch);
        try {
            readyLatch.await(this.timeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException iex) {
            logger.debug("BlockingHandoff[{}].iterator() => iteratorTimeout()", (Object)this.id);
            this.iteratorTimeout();
            throw new IllegalStateException();
        }
        return itemIterator;
    }

    private synchronized void enqueueClose() {
        if (!this.closeRequested) {
            logger.debug("BlockingHandoff[{}].enqueueClose()", (Object)this.id);
            this.resultQueue.add(new Action());
            this.closeRequested = true;
        }
    }

    private class ItemIterator
    implements Iterator<T> {
        private ItemIterator() {
        }

        @Override
        public boolean hasNext() {
            return BlockingHandoff.this.hasNext();
        }

        @Override
        public T next() {
            return BlockingHandoff.this.next();
        }
    }

    private class Action {
        public final T nextItem;
        public final boolean close;
        public final Exception ex;

        private Action(T nextItem, Exception ex, boolean close) {
            this.nextItem = nextItem;
            this.ex = ex;
            this.close = close;
        }

        public Action() {
            this(null, null, true);
        }

        public Action(T item) {
            this(item, null, false);
        }

        public Action(Exception ex) {
            this(null, ex, false);
        }
    }
}

