/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.google.common.collect.ImmutableSet;
import com.mapr.db.MetaTable;
import com.mapr.db.Table;
import com.mapr.db.impl.BaseJsonTable;
import com.mapr.db.impl.ClonedCondition;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.CorrelationTracker;
import com.mapr.db.index.IndexDesc;
import com.mapr.db.index.IndexFieldDesc;
import com.mapr.db.scan.ScanStats;
import com.mapr.ojai.store.impl.ElementAndToAnd;
import com.mapr.ojai.store.impl.Expression;
import com.mapr.ojai.store.impl.ExpressionPruner;
import com.mapr.ojai.store.impl.ExpressionToCondition;
import com.mapr.ojai.store.impl.IdIndexDesc;
import com.mapr.ojai.store.impl.OjaiConnection;
import com.mapr.ojai.store.impl.OjaiDocumentStore;
import com.mapr.ojai.store.impl.OjaiDriver;
import com.mapr.ojai.store.impl.OjaiQuery;
import com.mapr.ojai.store.impl.QueryAnalyzer;
import com.mapr.ojai.store.impl.SharedReleaser;
import com.mapr.ojai.store.impl.SharedResource;
import com.mapr.ojai.store.impl.SharedTable;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ojai.FieldPath;
import org.ojai.store.QueryCondition;

public class EligibleIndex {
    private static final String PARTITION_FACTOR_NAME = "ojai.mapr.query.hashed-partition-cost-factor";
    private static final String PARTITION_FACTOR_DEFAULT = "0.5";
    private static final double PARTITION_FACTOR = Double.parseDouble(System.getProperty("ojai.mapr.query.hashed-partition-cost-factor", "0.5"));
    public final IndexDesc indexDesc;
    public final int scanFields;
    public final boolean isCovering;
    public final boolean isArrayIndex;
    public final boolean canBeUsedForSort;
    public final List<FieldPath> sortLimitExtras;
    public final QueryCondition prunedCondition;
    public final boolean conditionCovered;
    public final ScanStats indexStats;
    public final ScanStats fullIndexStats;
    public final double rowSelectivity;
    public final double ioCost;
    public final double cpuCost;
    public final double sortCpuCost;
    public final double simpleCost;
    public final int nIndexedFields;
    public final int nIncludedFields;
    public static final Comparator<EligibleIndex> COST_COMPARATOR = new Comparator<EligibleIndex>(){

        @Override
        public int compare(EligibleIndex o1, EligibleIndex o2) {
            if (o1.simpleCost < o2.simpleCost) {
                return -1;
            }
            if (o1.simpleCost > o2.simpleCost) {
                return 1;
            }
            if (o1.isCovering) {
                if (!o2.isCovering) {
                    return -1;
                }
            } else if (o2.isCovering) {
                return 1;
            }
            if (IdIndexDesc.isIdIndex(o1.indexDesc)) {
                return 1;
            }
            if (IdIndexDesc.isIdIndex(o2.indexDesc)) {
                return -1;
            }
            return 0;
        }
    };

    private static boolean hasArrayFields(Collection<IndexFieldDesc> descriptors) {
        for (IndexFieldDesc fieldDesc : descriptors) {
            FieldPath fieldPath = fieldDesc.getFieldPath();
            if (!CorrelationTracker.isOpenArrayPath((FieldPath)fieldPath)) continue;
            return true;
        }
        return false;
    }

    public EligibleIndex(IndexDesc indexDesc, int scanFields, boolean isCovering, boolean isArrayIndex, boolean needsSort, boolean canBeUsedForSort, List<FieldPath> sortLimitExtras, OjaiConnection ojaiConnection, OjaiQuery ojaiQuery, ClonedCondition clonedCondition, ScanStats tableStats, SharedTable sharedPrimaryTable) throws IOException {
        double rowSelectivity;
        long tableEstRows;
        int nHashPartitions;
        long averageRowSize;
        this.indexDesc = indexDesc;
        this.scanFields = scanFields;
        this.isArrayIndex = isArrayIndex;
        this.canBeUsedForSort = canBeUsedForSort;
        this.sortLimitExtras = sortLimitExtras;
        List indexedFields = indexDesc.getIndexedFields();
        Collection includedFields = indexDesc.getIncludedFields();
        ConditionImpl fullCondition = ojaiQuery.getCondition();
        if (IdIndexDesc.isIdIndex(indexDesc)) {
            this.conditionCovered = true;
            this.prunedCondition = fullCondition;
            this.isCovering = isCovering;
        } else {
            QueryCondition prunedCondition;
            QueryCondition prunedIncludeCondition;
            HashSet<FieldPath> keyFields = new HashSet<FieldPath>();
            keyFields.add(FieldPath.parseFrom((String)"_id"));
            int usableFields = 0;
            boolean mutableIsCovering = isCovering;
            for (IndexFieldDesc ifd : indexedFields) {
                if (usableFields++ >= scanFields) break;
                FieldPath fieldPath = ifd.getFieldPath();
                String fieldPathStr = fieldPath.toString();
                if (CorrelationTracker.isOpenArrayPath((String)fieldPathStr) && clonedCondition != null) continue;
                keyFields.add(ifd.getFieldPath());
            }
            QueryAnalyzer queryAnalyzer = ojaiQuery.getQueryAnalyzer();
            Set keepConditions = clonedCondition == null ? Collections.EMPTY_SET : ImmutableSet.of((Object)clonedCondition);
            ExpressionPruner.PartialElementAndMatch pElementAndMatchHolder = new ExpressionPruner.PartialElementAndMatch();
            Expression prunedRawExpr = queryAnalyzer.getPrunedExpression(keyFields, keepConditions, pElementAndMatchHolder);
            boolean partialElmentAndMatch = false;
            if (pElementAndMatchHolder.partialElmentAndMatch) {
                mutableIsCovering = false;
                partialElmentAndMatch = true;
            }
            ElementAndToAnd.PartialMatchHolder partialMatchHolder = new ElementAndToAnd.PartialMatchHolder();
            boolean needElementAndConversion = isArrayIndex && prunedRawExpr != null;
            Expression prunedKeyExpr = needElementAndConversion ? ElementAndToAnd.convert(prunedRawExpr, partialMatchHolder) : prunedRawExpr;
            QueryCondition prunedKeyCondition = ExpressionToCondition.convert(prunedKeyExpr, (OjaiDriver)ojaiConnection.getDriver());
            if (partialMatchHolder.partialMatch) {
                mutableIsCovering = false;
                partialElmentAndMatch = true;
            }
            this.isCovering = mutableIsCovering;
            if (includedFields.isEmpty() || !this.isCovering && clonedCondition != null || !this.isCovering && partialElmentAndMatch) {
                prunedIncludeCondition = ojaiConnection.newCondition();
            } else {
                HashSet<FieldPath> indexIncludedFields = new HashSet<FieldPath>(includedFields.size());
                for (IndexFieldDesc ifd : includedFields) {
                    indexIncludedFields.add(ifd.getFieldPath());
                }
                Expression prunedIncludeExpr = queryAnalyzer.getPrunedExpression(indexIncludedFields, Collections.EMPTY_SET, null);
                prunedIncludeCondition = ExpressionToCondition.convert(prunedIncludeExpr, (OjaiDriver)ojaiConnection.getDriver());
            }
            if ((prunedIncludeCondition == null || prunedIncludeCondition.isEmpty()) && prunedRawExpr != null) {
                prunedCondition = prunedKeyCondition;
            } else if (prunedRawExpr != null) {
                prunedCondition = ojaiConnection.newCondition().and().condition(prunedKeyCondition).condition(prunedIncludeCondition).close().build();
                ((ConditionImpl)prunedCondition).setUseIdxFieldTill(scanFields);
            } else {
                prunedCondition = fullCondition;
            }
            this.conditionCovered = prunedCondition.equals(fullCondition);
            this.prunedCondition = this.conditionCovered ? fullCondition : prunedCondition;
        }
        long limit = ojaiQuery.getLimit();
        try (SharedReleaser<BaseJsonTable> autoReleasedIndex = OjaiDocumentStore.getSharedIndex(indexDesc, sharedPrimaryTable);){
            SharedResource<BaseJsonTable> sharedIndex = autoReleasedIndex.getSharedResource();
            Table indexTable = (Table)sharedIndex.get();
            try (MetaTable metaTable = indexTable.getMetaTable();){
                this.indexStats = metaTable.getScanStats(this.prunedCondition);
                this.fullIndexStats = metaTable.getScanStats();
                averageRowSize = metaTable.getAverageRowSize();
                averageRowSize = averageRowSize != 0L ? averageRowSize : 1L;
            }
        }
        long indexEstRows = this.indexStats.getEstimatedNumRows();
        double ioCost = this.indexStats.getEstimatedSize();
        if ((!(indexDesc instanceof IdIndexDesc) || !ojaiQuery.hasCondition()) && limit != -1L && this.conditionCovered && (!needsSort || needsSort && canBeUsedForSort)) {
            if (indexEstRows > 0L) {
                ioCost *= (double)limit / (double)indexEstRows;
            }
            indexEstRows = limit;
        }
        if (indexDesc.isHashed() && (nHashPartitions = indexDesc.getNumHashPartitions()) > 1) {
            ioCost /= (double)nHashPartitions * PARTITION_FACTOR;
        }
        this.rowSelectivity = (tableEstRows = tableStats.getEstimatedNumRows()) == 0L || tableEstRows <= indexEstRows ? 1.0 : ((rowSelectivity = (double)indexEstRows / (double)this.fullIndexStats.getEstimatedNumRows()) > 1.0 ? 1.0 : rowSelectivity);
        double cpuCost = indexEstRows;
        if (!isCovering) {
            ioCost += (double)(indexEstRows * averageRowSize);
            cpuCost += (double)indexEstRows;
        }
        this.ioCost = ioCost;
        this.cpuCost = cpuCost;
        double sortCpuCost = 0.0;
        if (needsSort && !canBeUsedForSort && indexEstRows > 0L) {
            double expectedRowsToSort = indexEstRows;
            if (limit != -1L) {
                expectedRowsToSort = limit > 1L ? (double)limit : 1.1;
            }
            sortCpuCost = (double)indexEstRows * Math.log(expectedRowsToSort);
        }
        this.sortCpuCost = sortCpuCost;
        this.simpleCost = ioCost * ojaiQuery.getRowCpuIoRatio() + cpuCost + sortCpuCost;
        this.nIndexedFields = indexedFields.size();
        this.nIncludedFields = IdIndexDesc.isIdIndex(indexDesc) ? Integer.MAX_VALUE : includedFields.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("\"EligibleIndex:{\"");
        sb.append("\"indexName\":\"" + this.indexDesc.getIndexName() + "\", ");
        sb.append("\"scanFields\":" + this.scanFields + ", ");
        sb.append("\"isCovering\":" + Boolean.toString(this.isCovering) + ", ");
        sb.append("\"prunedCondition\":\"" + this.prunedCondition + "\", ");
        sb.append("\"rowSelectivity\":" + this.rowSelectivity + ", ");
        sb.append("\"ioCost\":" + this.ioCost + " ,");
        sb.append("\"cpuCost\":" + this.cpuCost + " ,");
        sb.append("\"sortCpuCost\":" + this.sortCpuCost + " ,");
        sb.append("\"simpleCost\":" + this.simpleCost);
        sb.append("}");
        return sb.toString();
    }
}

