/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.mapr.db.Admin;
import com.mapr.db.Table;
import com.mapr.db.impl.AdminImpl;
import com.mapr.db.impl.BaseJsonTable;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.FieldPathStack;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.ojai.store.impl.EligibleIndex;
import com.mapr.ojai.store.impl.Expression;
import com.mapr.ojai.store.impl.ExpressionToCondition;
import com.mapr.ojai.store.impl.OjaiConnection;
import com.mapr.ojai.store.impl.OjaiDriver;
import com.mapr.ojai.store.impl.OjaiQuery;
import com.mapr.ojai.store.impl.OjaiTest;
import com.mapr.ojai.store.impl.QueryAnalyzer;
import com.mapr.ojai.store.impl.SharedTable;
import com.mapr.ojai.store.impl.SharedTestTable;
import com.mapr.tests.annotations.IsolatedTest;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.FieldPath;
import org.ojai.store.Connection;
import org.ojai.store.Query;
import org.ojai.store.QueryCondition;

@Category(value={IsolatedTest.class})
public class TestQueryAnalyzer
extends OjaiTest {
    private final OjaiDriver ojaiDriver = TestQueryAnalyzer.getDriver();
    private final Query query01 = this.ojaiDriver.newQuery().where(this.ojaiDriver.newCondition().and().is("x", QueryCondition.Op.EQUAL, 42).is("y", QueryCondition.Op.EQUAL, 17).close().build()).build();
    private final Query query02 = this.ojaiDriver.newQuery().where(this.ojaiDriver.newCondition().elementAnd("foo[]").is("x", QueryCondition.Op.EQUAL, 42).is("y", QueryCondition.Op.EQUAL, 17).close().build()).build();
    private final Query query03 = this.ojaiDriver.newQuery().where(this.ojaiDriver.newCondition().or().is("z", QueryCondition.Op.EQUAL, 2018).is("w[]", QueryCondition.Op.EQUAL, "foo").is("t[][].b", QueryCondition.Op.EQUAL, 121).elementAnd("foo[][]").is("x", QueryCondition.Op.EQUAL, 42).is("y", QueryCondition.Op.EQUAL, 17).close().close().build()).build();
    private static final SharedTableTestArrayEligibleIndexes sharedTableTestArrayEligibleIndexes = new SharedTableTestArrayEligibleIndexes();

    @Test
    public void testFieldPathStack() {
        FieldPathStack fps = new FieldPathStack();
        Assert.assertEquals((Object)"foo", (Object)fps.getPath("foo"));
        fps.push("a");
        Assert.assertEquals((Object)"a.foo", (Object)fps.getPath("foo"));
        fps.pop();
        Assert.assertEquals((Object)"foo", (Object)fps.getPath("foo"));
        fps.push("a[]");
        Assert.assertEquals((Object)"a[].foo", (Object)fps.getPath("foo"));
        fps.pop();
        Assert.assertEquals((Object)"foo", (Object)fps.getPath("foo"));
        fps.push("x");
        fps.push("a[]");
        Assert.assertEquals((Object)"x.a[].foo", (Object)fps.getPath("foo"));
        fps.pop();
        Assert.assertEquals((Object)"x.foo", (Object)fps.getPath("foo"));
        fps.pop();
        Assert.assertEquals((Object)"foo", (Object)fps.getPath("foo"));
    }

    @Test(expected=IllegalStateException.class)
    public void testFieldPathStack_empty() {
        FieldPathStack fps = new FieldPathStack();
        fps.pop();
    }

    private static Set<FieldPath> makeFieldSet(String ... fieldNames) {
        HashSet<FieldPath> fieldSet = new HashSet<FieldPath>(fieldNames.length);
        for (String fieldName : fieldNames) {
            fieldSet.add(FieldPath.parseFrom((String)fieldName));
        }
        return fieldSet;
    }

    private static <T> void assertSetEquality(String label, Set<T> expectedSet, Set<T> actualSet) {
        for (T t : expectedSet) {
            Assert.assertTrue((String)(label + " expected " + t + " not in actual set"), (boolean)actualSet.contains(t));
        }
        for (T t : actualSet) {
            Assert.assertTrue((String)(label + " actual" + t + " not in expected set"), (boolean)expectedSet.contains(t));
        }
    }

    private static void checkTopRelations(Query query, Set<FieldPath> topExprFields) {
        OjaiQuery ojaiQuery = (OjaiQuery)query;
        QueryAnalyzer queryAnalyzer = ojaiQuery.getQueryAnalyzer();
        Map topRelations = queryAnalyzer.getTopRelations();
        TestQueryAnalyzer.assertSetEquality("checkTopRelations " + query, topExprFields, topRelations.keySet());
    }

    @Test
    public void testTopRelations() {
        TestQueryAnalyzer.checkTopRelations(this.query01, TestQueryAnalyzer.makeFieldSet("x", "y"));
        TestQueryAnalyzer.checkTopRelations(this.query02, TestQueryAnalyzer.makeFieldSet("foo[].x", "foo[].y"));
        TestQueryAnalyzer.checkTopRelations(this.query03, TestQueryAnalyzer.makeFieldSet("z", "w[]", "t[][].b", "foo[][].x", "foo[][].y"));
    }

    private void checkPruning(Query query, Set<FieldPath> keepFields, Query prunedQuery) {
        OjaiQuery ojaiQuery = (OjaiQuery)query;
        QueryAnalyzer queryAnalyzer = ojaiQuery.getQueryAnalyzer();
        Expression checkExpr = queryAnalyzer.getPrunedExpression(keepFields, Collections.EMPTY_SET, null);
        QueryCondition checkCondition = ExpressionToCondition.convert((Expression)checkExpr, (OjaiDriver)this.ojaiDriver);
        ConditionImpl prunedCondition = ((OjaiQuery)prunedQuery).getCondition();
        Assert.assertTrue((boolean)prunedCondition.equals(checkCondition));
    }

    @Test
    public void testPruning() {
        this.checkPruning(this.query01, TestQueryAnalyzer.makeFieldSet("x"), this.ojaiDriver.newQuery().where(this.ojaiDriver.newCondition().is("x", QueryCondition.Op.EQUAL, 42).build()).build());
        this.checkPruning(this.query02, TestQueryAnalyzer.makeFieldSet("foo[].x"), this.ojaiDriver.newQuery().where(this.ojaiDriver.newCondition().elementAnd("foo[]").is("x", QueryCondition.Op.EQUAL, 42).close().build()).build());
        this.checkPruning(this.query03, TestQueryAnalyzer.makeFieldSet("z"), this.ojaiDriver.newQuery().where(this.ojaiDriver.newCondition().is("z", QueryCondition.Op.EQUAL, 2018).build()).build());
        this.checkPruning(this.query03, TestQueryAnalyzer.makeFieldSet("w[]"), this.ojaiDriver.newQuery().where(this.ojaiDriver.newCondition().is("w[]", QueryCondition.Op.EQUAL, "foo").build()).build());
        this.checkPruning(this.query03, TestQueryAnalyzer.makeFieldSet("t[][].b"), this.ojaiDriver.newQuery().where(this.ojaiDriver.newCondition().is("t[][].b", QueryCondition.Op.EQUAL, 121).build()).build());
        this.checkPruning(this.query03, TestQueryAnalyzer.makeFieldSet("z", "t[][].b"), this.ojaiDriver.newQuery().where(this.ojaiDriver.newCondition().or().is("z", QueryCondition.Op.EQUAL, 2018).is("t[][].b", QueryCondition.Op.EQUAL, 121).close().build()).build());
        this.checkPruning(this.query03, TestQueryAnalyzer.makeFieldSet("foo[][].y"), this.ojaiDriver.newQuery().where(this.ojaiDriver.newCondition().elementAnd("foo[][]").is("y", QueryCondition.Op.EQUAL, 17).close().build()).build());
        this.checkPruning(this.query03, TestQueryAnalyzer.makeFieldSet("foo[][].y", "w[]"), this.ojaiDriver.newQuery().where(this.ojaiDriver.newCondition().or().is("w[]", QueryCondition.Op.EQUAL, "foo").elementAnd("foo[][]").is("y", QueryCondition.Op.EQUAL, 17).close().close().build()).build());
    }

    private void checkEligibleIndex(Query query, String rawTableName, Table table, String indexSuffix, String[] indexKey, boolean shouldCover, Connection connection) throws Exception {
        OjaiQuery ojaiQuery = (OjaiQuery)query;
        AdminImpl admin = DBTests.admin();
        Path tablePath = table.getPath();
        SharedTable sharedTable = new SharedTable((BaseJsonTable)table);
        List indexes = ojaiQuery.getEligibleIndexes((Admin)admin, tablePath, sharedTable, (OjaiConnection)connection);
        Assert.assertEquals((long)1L, (long)indexes.size());
        String indexName = rawTableName + '_' + indexSuffix + "_idx";
        DBTests.createIndex((Table)table, (String)indexName, (boolean)false, (int)0, (String[])indexKey, null, null);
        indexes = ojaiQuery.getEligibleIndexes((Admin)admin, tablePath, sharedTable, (OjaiConnection)connection);
        Assert.assertEquals((long)2L, (long)indexes.size());
        EligibleIndex eligibleIndex = (EligibleIndex)indexes.get(0);
        Assert.assertEquals((Object)shouldCover, (Object)eligibleIndex.isCovering);
        Assert.assertEquals((Object)indexName, (Object)eligibleIndex.indexDesc.getIndexName());
    }

    @Test
    public void testEligibleIndexes_arrays() throws Exception {
        String rawTableName = "testArrayEligibleIndexes";
        try (OjaiConnection connection = TestQueryAnalyzer.getConnection();){
            sharedTableTestArrayEligibleIndexes.prepare((Connection)connection);
            try (Table table = DBTests.createOrGetTable((String)"testArrayEligibleIndexes");){
                Query query01 = connection.newQuery().where(connection.newCondition().is("a[]", QueryCondition.Op.EQUAL, 5).build()).build();
                this.checkEligibleIndex(query01, "testArrayEligibleIndexes", table, "aArray", new String[]{"a[]"}, false, (Connection)connection);
                Query query02 = connection.newQuery().where(connection.newCondition().and().is("b[]", QueryCondition.Op.EQUAL, 5).is("c[][]", QueryCondition.Op.GREATER, 0).is("d", QueryCondition.Op.LESS, 17).close().build()).build();
                String cBracketsIndexName = "testArrayEligibleIndexes_cArray_idx";
                DBTests.createIndex((Table)table, (String)"testArrayEligibleIndexes_cArray_idx", (boolean)false, (int)0, (String[])new String[]{"c[]"}, null, null);
                Query query03 = connection.newQuery().where(connection.newCondition().elementAnd("e[]").is("f", QueryCondition.Op.EQUAL, 5).is("g", QueryCondition.Op.GREATER, 0).close().build()).build();
                this.checkEligibleIndex(query03, "testArrayEligibleIndexes", table, "eArrayDotg_eArrayDotf", new String[]{"e[].g", "e[].f"}, false, (Connection)connection);
                Query query04 = connection.newQuery().select(new String[]{"e[].f"}).where(connection.newCondition().and().is("h", QueryCondition.Op.GREATER, 0).is("e[].f", QueryCondition.Op.EQUAL, 42).close().build()).build();
                this.checkEligibleIndex(query04, "testArrayEligibleIndexes", table, "eArrayDotf", new String[]{"e[].f"}, false, (Connection)connection);
                Query query05 = connection.newQuery().select(new String[]{"h"}).where(connection.newCondition().and().is("h", QueryCondition.Op.EQUAL, 42).elementAnd("j[]").is("k", QueryCondition.Op.EQUAL, 5).is("m", QueryCondition.Op.GREATER, 0).close().close().build()).build();
                this.checkEligibleIndex(query05, "testArrayEligibleIndexes", table, "h_jArrayDotm", new String[]{"h", "j[].m"}, false, (Connection)connection);
            }
        }
    }

    private static class SharedTableTestArrayEligibleIndexes
    extends SharedTestTable {
        public static final String TABLE_NAME = "testArrayEligibleIndexes";

        public SharedTableTestArrayEligibleIndexes() {
            super(TABLE_NAME);
        }

        @Override
        protected String initialize(Connection connection, String rawTableName) throws Exception {
            try (Table table = DBTests.createOrGetTable((String)rawTableName);){
                String tableName;
                Path tablePath = table.getPath();
                String string = tableName = tablePath.toString();
                return string;
            }
        }

        @Override
        public long getNumRows() {
            return 0L;
        }
    }
}

