/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.mapr.db.Table;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.impl.OjaiQueryProperties;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.fs.utils.ssh.TestCluster;
import com.mapr.ojai.store.impl.OjaiConnection;
import com.mapr.ojai.store.impl.OjaiTest;
import com.mapr.ojai.store.impl.bean.DrillConnectionParams;
import com.mapr.tests.annotations.ClusterTest;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.DocumentStream;
import org.ojai.store.DocumentStore;
import org.ojai.store.Query;
import org.ojai.store.QueryCondition;

@Category(value={ClusterTest.class})
public class TestOjaiQuery_bug30193
extends OjaiTest {
    @Test
    public void testQuery_bug30193() throws Exception {
        String tableName = "testtable-bug30193";
        String tablePath = DBTests.getFullPath((String)"testtable-bug30193");
        String qsCmd = "maprcli cluster queryservice setconfig";
        DBTests.setTableStatsSendInterval((long)1L);
        String[] splitKeys = new String[]{"user001", "user002", "user003", "user004", "user005"};
        String clusterName = null;
        String clusterId = null;
        String storagePlugin = null;
        String znode = null;
        try (Table table1 = DBTests.createOrReplaceTable((String)"testtable-bug30193", (String[])splitKeys);){
            Throwable throwable;
            Object docStore;
            table1.insertOrReplace(MapRDBImpl.newDocument((String)"{\"_id\":\"user001\", \"age\":43, \"salary\":43000, \"name\": {\"first\":\"Sam\", \"last\":\"Harris\"}}"));
            table1.insertOrReplace(MapRDBImpl.newDocument((String)"{\"_id\":\"user002\", \"age\":12, \"salary\":340000, \"name\": {\"first\":\"Leon\", \"last\":\"Russel\"}}"));
            table1.insertOrReplace(MapRDBImpl.newDocument((String)"{\"_id\":\"user003\", \"age\":87, \"salary\":9999999, \"name\": {\"first\":\"David\", \"last\":\"Bowie\"}}"));
            table1.insertOrReplace(MapRDBImpl.newDocument((String)"{\"_id\":\"user004\", \"age\":56, \"salary\":7, \"name\": {\"first\":\"Bob\", \"last\":\"Dylan\"}}"));
            table1.insertOrReplace(MapRDBImpl.newDocument((String)"{\"_id\":\"user005\", \"age\":54, \"salary\":123, \"name\": {\"first\":\"David\", \"last\":\"Ackert\"}}"));
            table1.flush();
            DBTests.waitForRowCountFromNC((Path)table1.getPath(), (long)5L, (long)60000L);
            try (OjaiConnection connection = TestOjaiQuery_bug30193.getConnection();){
                docStore = connection.getStore(tablePath);
                throwable = null;
                try {
                    Path tPath = new Path(tablePath);
                    clusterName = connection.getFileSystem().getClusterName(tPath.toUri());
                    Assert.assertTrue((String)("Query service is not enabled for cluster " + clusterName), (boolean)connection.getQueryServiceParam(clusterName).isEnabled());
                    DrillConnectionParams dp = connection.getQueryServiceParam(clusterName);
                    clusterId = dp.getClusterId();
                    storagePlugin = dp.getStoragePlugin();
                    znode = dp.getZnode();
                    Query query = connection.newQuery().select(new String[]{"age"}).limit(1000L).where(connection.newCondition().is("age", QueryCondition.Op.NOT_EQUAL, 10).build()).build();
                    try (DocumentStream docStream = docStore.findQuery(query);){
                        Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DRILL, (Object)TestOjaiQuery_bug30193.getQueryPath(docStream));
                    }
                    catch (Exception e) {
                        Assert.fail((String)e.getMessage());
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (docStore != null) {
                        if (throwable != null) {
                            try {
                                docStore.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            docStore.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
            }
            Assert.assertNotNull(clusterId);
            Assert.assertNotNull(storagePlugin);
            Assert.assertNotNull(znode);
            String disableCmd = "maprcli cluster queryservice setconfig -enabled false -clusterid " + clusterId + " -storageplugin " + storagePlugin + " -znode " + znode;
            TestCluster.runCommand((String)disableCmd);
            try {
                OjaiConnection connection = TestOjaiQuery_bug30193.getConnection();
                docStore = null;
                try (DocumentStore docStore2 = connection.getStore(tablePath);){
                    Assert.assertFalse((boolean)connection.getQueryServiceParam(clusterName).isEnabled());
                    Query query = connection.newQuery().select(new String[]{"age"}).limit(1000L).where(connection.newCondition().is("age", QueryCondition.Op.NOT_EQUAL, 10).build()).build();
                    try (DocumentStream docStream = docStore2.findQuery(query);){
                        Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)TestOjaiQuery_bug30193.getQueryPath(docStream));
                    }
                    catch (Exception e) {
                        Assert.fail((String)e.getMessage());
                    }
                }
                catch (Throwable throwable4) {
                    docStore = throwable4;
                    throw throwable4;
                }
                finally {
                    if (connection != null) {
                        if (docStore != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable5) {
                                ((Throwable)docStore).addSuppressed(throwable5);
                            }
                        } else {
                            connection.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
            }
            String enableCmd = "maprcli cluster queryservice setconfig -enabled true -clusterid " + clusterId + " -storageplugin " + storagePlugin + " -znode " + znode;
            TestCluster.runCommand((String)enableCmd);
            throwable = null;
            try (OjaiConnection connection = TestOjaiQuery_bug30193.getConnection();){
                Assert.assertTrue((boolean)connection.getQueryServiceParam(clusterName).isEnabled());
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        DBTests.deleteTables((String[])new String[]{"testtable-bug30193"});
        DBTests.setTableStatsSendInterval((long)5L);
    }
}

