/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.mapr.db.impl.FieldPathStack;
import com.mapr.utils.CommaSeparated;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.ojai.DocumentReader;
import org.ojai.FieldPath;
import org.ojai.FieldSegment;

public class PathCollector {
    private final Set<String> pathsSeen = new HashSet<String>();
    private final FieldPathStack pathStack = new FieldPathStack();
    private final Stack<PushEvent> eventStack = new Stack();
    private static final String ARRAY_MEMBER_NAME = "$";
    private static final String EMPTY_BRACKETS = "[]";
    private static final String EMPTY_STRING = "";
    private static final char DOT = '.';
    private static final String STAR = "*";

    private boolean inArray() {
        if (this.eventStack.isEmpty()) {
            return false;
        }
        return this.eventStack.peek().eventType == DocumentReader.EventType.START_ARRAY;
    }

    public void collect(DocumentReader docReader) {
        DocumentReader.EventType eventType;
        block4: while ((eventType = docReader.next()) != null) {
            String name;
            String leafName;
            switch (eventType) {
                case START_ARRAY: 
                case START_MAP: {
                    if (this.inArray()) {
                        leafName = null;
                    } else {
                        leafName = docReader.getFieldName();
                        if (leafName != null) {
                            name = this.pathStack.getPath(leafName);
                            this.pathsSeen.add(name);
                            this.pathStack.push(leafName + (DocumentReader.EventType.START_ARRAY == eventType ? EMPTY_BRACKETS : EMPTY_STRING));
                        }
                    }
                    PushEvent pushEvent = new PushEvent(eventType, leafName);
                    this.eventStack.push(pushEvent);
                    continue block4;
                }
                case END_MAP: 
                case END_ARRAY: {
                    if (this.eventStack.peek().fieldName != null) {
                        this.pathStack.pop();
                    }
                    this.eventStack.pop();
                    continue block4;
                }
            }
            leafName = this.inArray() ? ARRAY_MEMBER_NAME : docReader.getFieldName();
            name = this.pathStack.getPath(leafName);
            this.pathsSeen.add(name);
        }
    }

    private String getSingletonArrayPath(String seenPath) {
        FieldPath fieldPath = FieldPath.parseFrom((String)seenPath);
        FieldSegment lastNameSegment = null;
        int nSegments = 0;
        for (FieldSegment fieldSegment : fieldPath) {
            ++nSegments;
            if (fieldSegment.isArray()) {
                lastNameSegment = null;
                continue;
            }
            if (!fieldSegment.isNamed()) continue;
            lastNameSegment = fieldSegment;
        }
        if (lastNameSegment == null || nSegments == 1) {
            return seenPath + EMPTY_BRACKETS;
        }
        FieldSegment.NameSegment nameSegment = lastNameSegment.getNameSegment();
        String name = nameSegment.getName();
        String arrayPath = seenPath.substring(0, seenPath.length() - (name.length() + 1));
        return arrayPath + EMPTY_BRACKETS + '.' + name;
    }

    public List<String> getExtraPaths(String ... projectedFields) {
        LinkedList<String> extraPaths = new LinkedList<String>();
        HashSet<String> fieldSet = new HashSet<String>(projectedFields.length);
        for (String field : projectedFields) {
            fieldSet.add(field);
            if (!field.equals(STAR)) continue;
            return extraPaths;
        }
        for (String seenPath : this.pathsSeen) {
            if (fieldSet.contains(seenPath)) continue;
            String seenPathSingleton = this.getSingletonArrayPath(seenPath);
            boolean hasPrefixPath = false;
            for (String field : projectedFields) {
                if (!field.startsWith(seenPath) && !field.startsWith(seenPathSingleton)) continue;
                hasPrefixPath = true;
                break;
            }
            if (hasPrefixPath) continue;
            extraPaths.add(seenPath);
        }
        return extraPaths;
    }

    private static class PushEvent {
        public final DocumentReader.EventType eventType;
        public final String fieldName;

        public PushEvent(DocumentReader.EventType eventType, String fieldName) {
            this.eventType = eventType;
            this.fieldName = fieldName;
        }

        public String toString() {
            CommaSeparated cs = new CommaSeparated("PushEvent(", ")");
            cs.append("eventType = " + this.eventType);
            if (this.fieldName != null) {
                cs.append("fieldName = " + this.fieldName);
            }
            cs.build();
            return cs.toString();
        }
    }
}

