/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.google.common.base.Preconditions;
import com.mapr.db.impl.OjaiQueryProperties;
import com.mapr.db.index.IndexFieldDesc;
import com.mapr.db.indexrowkeyfmt.IndexRowKeyEncoder;
import com.mapr.ojai.store.impl.AbstractDocumentFilter;
import com.mapr.ojai.store.impl.ReaderPathBuilder;
import com.mapr.ojai.store.impl.SortKey;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.ojai.Document;
import org.ojai.DocumentReader;
import org.ojai.DocumentStream;
import org.ojai.FieldPath;
import org.ojai.Value;
import org.ojai.util.DocumentReaderWithProjection;
import org.ojai.util.FieldProjector;

public class TopKStream
extends AbstractDocumentFilter {
    private final PriorityQueue<UndecodedDocument> heap;
    private final int limit;
    private final List<SortKey> sortKeys;
    private final FieldPath[] extras;
    private final FieldProjector fieldProjector;
    private final int[] cmpSense;
    private final TObjectIntHashMap<String> sortKeyFieldToIndex;
    private static final FieldPath[] FIELD_PATH_ARRAY = new FieldPath[0];
    private final ReaderPathBuilder pathBuilder = new ReaderPathBuilder();

    public TopKStream(DocumentStream upstreamStream, int limit, List<SortKey> sortKeys, List<FieldPath> extras) {
        super(upstreamStream);
        Preconditions.checkNotNull(sortKeys);
        Preconditions.checkArgument((sortKeys.size() > 0 ? 1 : 0) != 0);
        this.limit = limit;
        this.sortKeys = sortKeys;
        this.extras = extras == null ? null : extras.toArray(FIELD_PATH_ARRAY);
        int nKeys = sortKeys.size();
        FieldPath[] sortPaths = new FieldPath[nKeys];
        this.cmpSense = new int[nKeys];
        this.sortKeyFieldToIndex = new TObjectIntHashMap(nKeys, 0.75f, -1);
        int i = 0;
        for (SortKey sortKey : sortKeys) {
            sortPaths[i] = sortKey.fieldPath;
            this.cmpSense[i] = sortKey.order == IndexFieldDesc.Order.Asc ? -1 : 1;
            this.sortKeyFieldToIndex.put((Object)sortKey.fieldPath.toString(), i);
            ++i;
        }
        this.fieldProjector = new FieldProjector(sortPaths);
        this.heap = new PriorityQueue(limit + 1);
    }

    @Override
    public Iterator<Document> iterator() {
        this.checkState();
        this.isUsed = true;
        this.docIter = this.upstreamStream.iterator();
        UndecodedDocument wrapper = new UndecodedDocument(this.cmpSense.length);
        while (this.docIter.hasNext()) {
            Document doc = (Document)this.docIter.next();
            wrapper.wrap(doc, this.fieldProjector);
            this.heap.add(wrapper);
            if (this.heap.size() > this.limit) {
                wrapper = (UndecodedDocument)this.heap.remove();
                continue;
            }
            wrapper = new UndecodedDocument(this.cmpSense.length);
        }
        LinkedList<Document> reversedList = new LinkedList<Document>();
        while ((wrapper = this.heap.poll()) != null) {
            Document doc = wrapper.getDocument();
            reversedList.addFirst(doc);
            if (this.extras == null) continue;
            for (FieldPath fieldPath : this.extras) {
                doc.delete(fieldPath);
            }
        }
        return reversedList.iterator();
    }

    private static Map<String, Object> makeSortKey(SortKey sortKey) {
        HashMap<String, Object> sk = new HashMap<String, Object>(2);
        sk.put("fieldName", sortKey.fieldString);
        sk.put("sortOrder", sortKey.order.name());
        return sk;
    }

    public void getQueryPlan(List<Map<String, Object>> planList) {
        if (this.upstreamStream == null) {
            return;
        }
        ((OjaiQueryProperties)this.upstreamStream).getQueryPlan(planList);
        HashMap<String, Object> myMap = new HashMap<String, Object>();
        myMap.put("streamName", this.getClass().getSimpleName());
        HashMap<String, Serializable> valueMap = new HashMap<String, Serializable>();
        valueMap.put("limit", Integer.valueOf(this.limit));
        if (this.sortKeys != null) {
            ArrayList<Map<String, Object>> keys = new ArrayList<Map<String, Object>>(this.sortKeys.size());
            for (SortKey sortKey : this.sortKeys) {
                keys.add(TopKStream.makeSortKey(sortKey));
            }
            valueMap.put("sortKeys", keys);
        }
        if (this.extras != null) {
            ArrayList<String> fieldNames = new ArrayList<String>(this.extras.length);
            for (FieldPath extra : this.extras) {
                fieldNames.add(extra.asPathString());
            }
            valueMap.put("extras", fieldNames);
        }
        myMap.put("parameters", valueMap);
        planList.add(myMap);
    }

    private class UndecodedDocument
    implements Comparable<UndecodedDocument> {
        private final Value[] sortKey;
        private Document doc;

        UndecodedDocument(int n) {
            this.sortKey = new Value[n];
        }

        public Document getDocument() {
            return this.doc;
        }

        public void wrap(Document doc, FieldProjector fieldProjector) {
            DocumentReader.EventType eventType;
            this.doc = doc;
            for (int i = 0; i < this.sortKey.length; ++i) {
                this.sortKey[i] = null;
            }
            DocumentReaderWithProjection docReader = new DocumentReaderWithProjection(doc.asReader(), fieldProjector);
            while ((eventType = docReader.next()) != null) {
                Value value = null;
                switch (eventType) {
                    case START_MAP: {
                        TopKStream.this.pathBuilder.startMap((DocumentReader)docReader);
                        break;
                    }
                    case END_MAP: {
                        TopKStream.this.pathBuilder.endMap();
                        break;
                    }
                    case START_ARRAY: {
                        TopKStream.this.pathBuilder.startArray((DocumentReader)docReader);
                        break;
                    }
                    case END_ARRAY: {
                        TopKStream.this.pathBuilder.endArray();
                        break;
                    }
                    default: {
                        value = ReaderPathBuilder.getValue((DocumentReader)docReader);
                    }
                }
                if (value == null) continue;
                String fieldName = TopKStream.this.pathBuilder.pushField((DocumentReader)docReader);
                int index = TopKStream.this.sortKeyFieldToIndex.get((Object)fieldName);
                TopKStream.this.pathBuilder.popField();
                this.sortKey[index] = value;
            }
        }

        @Override
        public int compareTo(UndecodedDocument o) {
            if (this == o) {
                return 0;
            }
            UndecodedDocument other = o;
            for (int i = 0; i < this.sortKey.length; ++i) {
                int cmp = IndexRowKeyEncoder.VALUE_COMPARATOR.compare(this.sortKey[i], other.sortKey[i]);
                if (cmp == 0) continue;
                return TopKStream.this.cmpSense[i] * cmp;
            }
            return 0;
        }
    }
}

