/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.google.common.base.Preconditions;
import com.mapr.db.impl.ConditionVisitor;
import com.mapr.ojai.store.impl.Expression;
import com.mapr.ojai.store.impl.ExpressionPruner;
import com.mapr.ojai.store.impl.ExpressionVisitor;
import com.mapr.ojai.store.impl.FieldExpression;
import com.mapr.ojai.store.impl.FieldInBundle;
import com.mapr.ojai.store.impl.FieldPathHelper;
import com.mapr.ojai.store.impl.LiteralExpression;
import com.mapr.ojai.store.impl.NaryOperator;
import com.mapr.ojai.store.impl.OjaiQuery;
import com.mapr.ojai.store.impl.RelationalOperator;
import com.mapr.ojai.store.impl.SortKey;
import com.mapr.ojai.store.impl.UnaryOperator;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.drill.exec.util.EncodedSchemaPathSet;
import org.ojai.DocumentConstants;
import org.ojai.FieldPath;
import org.ojai.Value;
import org.ojai.store.QueryCondition;
import org.ojai.types.ODate;
import org.ojai.types.OInterval;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;

class QueryAnalyzer
implements ConditionVisitor {
    private final LinkedList<Expression> exprStack = new LinkedList();
    private static final Set<FieldPath> STAR_PROJECTION;
    private static final Expression ID_EQUALS;
    private Map<FieldPath, List<NaryOperator>> topRelations;
    private Set<Expression> otherPredicates;

    QueryAnalyzer() {
    }

    public boolean structuralEquals(QueryAnalyzer other) {
        Preconditions.checkState((this.exprStack.size() == 1 ? 1 : 0) != 0);
        return this.exprStack.peek().structuralEquals(other.exprStack.peek());
    }

    public int structuralHashCode() {
        Preconditions.checkState((this.exprStack.size() == 1 ? 1 : 0) != 0);
        return this.exprStack.peek().structuralHashCode();
    }

    protected LinkedList<Expression> peekOperands(int nOperands) {
        Preconditions.checkArgument((nOperands <= this.exprStack.size() ? 1 : 0) != 0);
        LinkedList<Expression> operandList = new LinkedList<Expression>();
        for (int i = 0; i < nOperands; ++i) {
            operandList.addFirst(this.exprStack.get(i));
        }
        return operandList;
    }

    public void visit(ExpressionVisitor ev) {
        Preconditions.checkState((this.exprStack.size() <= 1 ? 1 : 0) != 0);
        if (this.exprStack.size() == 0) {
            return;
        }
        this.exprStack.peek().visit(ev);
    }

    public Expression getPrunedExpression(Set<FieldPath> keepFields) {
        Preconditions.checkState((this.exprStack.size() <= 1 ? 1 : 0) != 0);
        Expression exprRoot = this.exprStack.peek();
        if (exprRoot == null) {
            return null;
        }
        ExpressionPruner pruner = new ExpressionPruner(keepFields);
        exprRoot.visit(pruner);
        return pruner.getPrunedExpression();
    }

    public String buildSql(Set<FieldPath> userProjectedFieldSet, String engineName, String tableName, List<SortKey> sortKeys, long offset, long limit) {
        Set<FieldPath> projectedFieldSet;
        if (userProjectedFieldSet == null || userProjectedFieldSet.size() == 0) {
            projectedFieldSet = STAR_PROJECTION;
        } else if (userProjectedFieldSet.contains(DocumentConstants.ID_FIELD)) {
            projectedFieldSet = userProjectedFieldSet;
        } else {
            projectedFieldSet = new HashSet<FieldPath>(userProjectedFieldSet);
            projectedFieldSet.add(DocumentConstants.ID_FIELD);
        }
        StringBuilder sb = new StringBuilder();
        String tableAlias = null;
        if (projectedFieldSet != null && projectedFieldSet.size() > 0 || this.exprStack.size() == 1 || sortKeys != null && sortKeys.size() > 0) {
            tableAlias = "t";
        }
        sb.append("select ");
        if (projectedFieldSet == null || projectedFieldSet.size() == 0) {
            FieldPathHelper.emitQuotedFieldPath(sb, tableAlias, EncodedSchemaPathSet.ENCODED_STAR_COLUMN);
            sb.append(',');
        } else {
            String[] encodedPath;
            String[] fieldPathStrArray = new String[projectedFieldSet.size()];
            Iterator<FieldPath> fpItr = projectedFieldSet.iterator();
            for (int i = 0; i < fieldPathStrArray.length; ++i) {
                fieldPathStrArray[i] = fpItr.next().asPathString(false);
            }
            for (String fieldPath : encodedPath = EncodedSchemaPathSet.encode((String[])fieldPathStrArray)) {
                FieldPathHelper.emitQuotedFieldPath(sb, tableAlias, fieldPath);
                sb.append(',');
            }
        }
        FieldPathHelper.emitQuotedFieldPath(sb, tableAlias, "$$document");
        sb.append(" from " + engineName + ".`" + tableName + "`");
        if (tableAlias != null) {
            sb.append(' ');
            sb.append(tableAlias);
        }
        if (this.exprStack.size() == 1) {
            sb.append(" where ");
            this.exprStack.peek().emitSql(sb, tableAlias);
        }
        if (sortKeys != null && sortKeys.size() > 0) {
            sb.append(" order by ");
            boolean isFirst = true;
            for (SortKey sortKey : sortKeys) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(',');
                }
                FieldPathHelper.emitFieldPath(sb, tableAlias, sortKey.fieldPath);
                sb.append(' ');
                sb.append(sortKey.sortOrder.toString());
            }
        }
        if (limit != -1L) {
            sb.append(" limit ");
            sb.append(limit);
        }
        if (offset > 0L) {
            sb.append(" offset ");
            sb.append(offset);
        }
        return sb.toString();
    }

    public boolean isAlwaysFalse() {
        LiteralExpression litExpr;
        Expression expr;
        Preconditions.checkState((this.exprStack.size() <= 1 ? 1 : 0) != 0, (Object)"Expression stack must have one element or less");
        return this.exprStack.size() == 1 && (expr = this.exprStack.get(0)) instanceof LiteralExpression && (litExpr = (LiteralExpression)expr).getType() == Value.Type.BOOLEAN && !litExpr.getBoolean();
    }

    public boolean isIdEquals() {
        Preconditions.checkState((this.exprStack.size() == 1 ? 1 : 0) != 0, (Object)"Expression stack must have exactly one element");
        return ID_EQUALS.structuralEquals(this.exprStack.peek());
    }

    public Value getIdForLookup() {
        Preconditions.checkState((boolean)this.isIdEquals());
        NaryOperator top = (NaryOperator)this.exprStack.peek();
        LiteralExpression key = (LiteralExpression)(top.arg[0] instanceof LiteralExpression ? top.arg[0] : top.arg[1]);
        if (key.getType() == Value.Type.NULL) {
            return null;
        }
        return key;
    }

    public boolean isUnion() {
        Preconditions.checkState((this.exprStack.size() <= 1 ? 1 : 0) != 0, (Object)"Expression stack must have at least one element");
        Expression topExpr = this.exprStack.peek();
        if (topExpr != null && topExpr instanceof NaryOperator) {
            NaryOperator naryOp = (NaryOperator)topExpr;
            if (naryOp.opName.equals("or")) {
                return true;
            }
        }
        return false;
    }

    private static <T> T getSingleMember(Set<T> set) {
        Iterator<T> iter = set.iterator();
        if (!iter.hasNext()) {
            return null;
        }
        T t = iter.next();
        return t;
    }

    public FieldInBundle getFieldInBundle() {
        Preconditions.checkState((this.exprStack.size() == 1 ? 1 : 0) != 0, (Object)"Expression stack must have exactly one element");
        Expression exprRoot = this.exprStack.peek();
        if (!(exprRoot instanceof NaryOperator)) {
            return null;
        }
        NaryOperator nOp = (NaryOperator)exprRoot;
        if (nOp.opName.equals("in")) {
            LinkedList<LiteralExpression> values = new LinkedList<LiteralExpression>();
            for (Expression expr : nOp.arg) {
                if (!(expr instanceof LiteralExpression)) {
                    throw new IllegalStateException();
                }
                LiteralExpression literalArg = (LiteralExpression)expr;
                values.add(literalArg);
            }
            this.gatherExpressions();
            FieldPath topField = QueryAnalyzer.getSingleMember(this.topRelations.keySet());
            return new FieldInBundle(topField, values);
        }
        if (!nOp.opName.equals("or")) {
            return null;
        }
        this.gatherExpressions();
        if (this.topRelations.size() != 1) {
            return null;
        }
        if (this.otherPredicates.size() != 0) {
            return null;
        }
        LinkedList<LiteralExpression> values = new LinkedList<LiteralExpression>();
        for (Expression expr : nOp.arg) {
            if (!(expr instanceof RelationalOperator)) {
                return null;
            }
            RelationalOperator relOp = (RelationalOperator)expr;
            String opName = relOp.opName;
            if (!opName.equals("=")) continue;
            if (!(relOp.arg[0] instanceof FieldExpression)) {
                return null;
            }
            if (!(relOp.arg[1] instanceof LiteralExpression)) {
                return null;
            }
            values.add((LiteralExpression)relOp.arg[1]);
        }
        FieldPath topField = QueryAnalyzer.getSingleMember(this.topRelations.keySet());
        return new FieldInBundle(topField, values);
    }

    public void gatherExpressions() {
        if (this.topRelations == null) {
            Preconditions.checkState((this.exprStack.size() <= 1 ? 1 : 0) != 0);
            this.topRelations = new HashMap<FieldPath, List<NaryOperator>>();
            this.otherPredicates = new HashSet<Expression>();
            Expression expr = this.exprStack.peek();
            if (expr != null) {
                expr.gatherExpressions(0, this.topRelations, this.otherPredicates);
            }
        }
    }

    public void build() {
        this.gatherExpressions();
    }

    public Map<FieldPath, List<NaryOperator>> getTopRelations() {
        this.gatherExpressions();
        return this.topRelations;
    }

    public Set<Expression> getOtherPredicates() {
        this.gatherExpressions();
        return this.otherPredicates;
    }

    public void operator(QueryCondition.Op op, int nOperands) {
        this.operator((String)OjaiQuery.OP_TO_NAME.get((Object)op), nOperands);
    }

    public void operator(String name, int nOperands) {
        if (nOperands < 1) {
            throw new IllegalArgumentException("Operators must have at least one operand");
        }
        boolean logicalOperator = NaryOperator.isLogicalOperator(name);
        if (nOperands == 1 && !logicalOperator) {
            if (this.exprStack.size() < 1) {
                throw new IllegalStateException("No operands on stack for unary operator");
            }
            Expression operand = this.exprStack.pop();
            UnaryOperator unOp = new UnaryOperator(name, operand);
            this.exprStack.push(unOp);
            return;
        }
        if (this.exprStack.size() < nOperands) {
            throw new IllegalStateException("Insufficient operands on stack");
        }
        LinkedList<Expression> operandList = new LinkedList<Expression>();
        if (!logicalOperator) {
            for (int i = 0; i < nOperands; ++i) {
                operandList.addFirst(this.exprStack.pop());
            }
            String inverseOp = null;
            if (operandList.size() == 2 && (inverseOp = NaryOperator.getInverseOperator(name)) != null) {
                Expression rightExpr = operandList.get(1);
                if (rightExpr instanceof FieldExpression) {
                    operandList.set(1, operandList.get(0));
                    operandList.set(0, rightExpr);
                    name = inverseOp;
                }
                RelationalOperator rOp = new RelationalOperator(name, operandList);
                this.exprStack.push(rOp);
                return;
            }
        } else {
            for (int i = 0; i < nOperands; ++i) {
                Expression expr = this.exprStack.pop();
                if (expr instanceof NaryOperator) {
                    NaryOperator naryOp = (NaryOperator)expr;
                    if (naryOp.opName.equals(name)) {
                        for (int ni = naryOp.arg.length - 1; ni >= 0; --ni) {
                            operandList.addFirst(naryOp.arg[ni]);
                        }
                        continue;
                    }
                }
                operandList.addFirst(expr);
            }
        }
        if (operandList.size() > 1) {
            NaryOperator nOp = new NaryOperator(name, operandList);
            this.exprStack.push(nOp);
        } else {
            this.exprStack.push(operandList.get(0));
        }
    }

    public void field(FieldPath fieldPath) {
        this.exprStack.push(new FieldExpression(fieldPath));
    }

    public void binaryLiteral(ByteBuffer value) {
        this.exprStack.push(new LiteralExpression(value));
    }

    public void booleanLiteral(boolean value) {
        this.exprStack.push(new LiteralExpression(value));
    }

    public void byteLiteral(byte value) {
        this.exprStack.push(new LiteralExpression(value));
    }

    public void dateLiteral(ODate value) {
        this.exprStack.push(new LiteralExpression(value));
    }

    public void decimalLiteral(BigDecimal value) {
        throw new RuntimeException("unimplemented");
    }

    public void doubleLiteral(double value) {
        this.exprStack.push(new LiteralExpression(value));
    }

    public void floatLiteral(float value) {
        this.exprStack.push(new LiteralExpression(value));
    }

    public void intLiteral(int value) {
        this.exprStack.push(new LiteralExpression(value));
    }

    public void intervalLiteral(OInterval value) {
        this.exprStack.push(new LiteralExpression(value));
    }

    public void longLiteral(long value) {
        this.exprStack.push(new LiteralExpression(value));
    }

    public void mapLiteral(Map<String, Object> value) {
        this.exprStack.push(new LiteralExpression(value));
    }

    public void nullLiteral() {
        this.exprStack.push(new LiteralExpression());
    }

    public void shortLiteral(short value) {
        this.exprStack.push(new LiteralExpression(value));
    }

    public void stringLiteral(String value) {
        this.exprStack.push(new LiteralExpression(value));
    }

    public void timeLiteral(OTime value) {
        this.exprStack.push(new LiteralExpression(value));
    }

    public void timestampLiteral(OTimestamp value) {
        this.exprStack.push(new LiteralExpression(value));
    }

    static {
        HashSet<FieldPath> starProjection = new HashSet<FieldPath>();
        starProjection.add(FieldPath.parseFrom((String)"*"));
        starProjection.add(DocumentConstants.ID_FIELD);
        STAR_PROJECTION = Collections.unmodifiableSet(starProjection);
        ArrayList<Expression> operand = new ArrayList<Expression>(2);
        operand.add(new FieldExpression(DocumentConstants.ID_FIELD));
        operand.add(new LiteralExpression("0"));
        ID_EQUALS = new RelationalOperator("=", operand);
    }
}

