/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.ojai.DBValueBuilder;
import com.mapr.ojai.store.impl.OjaiConnection;
import com.mapr.ojai.store.impl.OjaiQuery;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.ojai.Document;
import org.ojai.DocumentBuilder;
import org.ojai.exceptions.DecodingException;
import org.ojai.exceptions.OjaiException;
import org.ojai.store.Connection;
import org.ojai.store.DocumentMutation;
import org.ojai.store.Driver;
import org.ojai.store.DriverManager;
import org.ojai.store.Query;
import org.ojai.store.QueryCondition;
import org.ojai.store.ValueBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OjaiDriver
implements Driver {
    private static final Logger logger = LoggerFactory.getLogger(OjaiDriver.class);
    private static final Driver DRIVER_INSTANCE = new OjaiDriver();
    private static final boolean DRILL_IN_CLASSPATH;
    private static final String THREAD_POOL_LIMIT_NAME = "ojai.mapr.driver.executor.threadpoollimit";
    private static final int CORE_POOL_SIZE = 2;
    private static final String THREAD_POOL_LIMIT_DEFAULT = "500";
    private static final int MAXIMUM_POOL_SIZE;
    private static final int KEEP_ALIVE_TIME_SEC = 60;
    private static final ExecutorService executorService;

    public ExecutorService getExecutorService() {
        return executorService;
    }

    public ValueBuilder getValueBuilder() {
        return DBValueBuilder.INSTANCE;
    }

    public Document newDocument() {
        return MapRDBImpl.newDocument();
    }

    public Document newDocument(String documentJson) throws DecodingException {
        return MapRDBImpl.newDocument((String)documentJson);
    }

    public Document newDocument(Map<String, Object> map) throws DecodingException {
        return MapRDBImpl.newDocument(map);
    }

    public Document newDocument(Object bean) throws DecodingException {
        return MapRDBImpl.newDocument((Object)bean);
    }

    public DocumentBuilder newDocumentBuilder() {
        return MapRDBImpl.newDocumentBuilder();
    }

    public DocumentMutation newMutation() {
        return MapRDBImpl.newMutation();
    }

    public QueryCondition newCondition() {
        return MapRDBImpl.newCondition();
    }

    public Query newQuery() {
        return new OjaiQuery();
    }

    public Query newQuery(String queryJson) {
        OjaiQuery ojaiQuery = new OjaiQuery();
        ojaiQuery.where(queryJson);
        return ojaiQuery;
    }

    public boolean accepts(String url) {
        return url.equals("ojai:mapr:") || url.startsWith("ojai:mapr:@");
    }

    public Connection connect(String url, Document options) throws OjaiException {
        if (!this.accepts(url)) {
            throw new OjaiException("Connection string does not start with 'ojai:mapr:@'.");
        }
        return new OjaiConnection(this);
    }

    public String getName() {
        return "MapR OJAI Driver";
    }

    public String toString() {
        return this.getName();
    }

    public static boolean isDrillInClasspath() {
        return DRILL_IN_CLASSPATH;
    }

    static {
        DriverManager.registerDriver((Driver)DRIVER_INSTANCE);
        boolean foundDrill = false;
        try {
            Class<?> guavaPatcherClass = Class.forName("org.apache.drill.exec.util.GuavaPatcher");
            Method patchMethod = guavaPatcherClass.getMethod("patch", new Class[0]);
            patchMethod.invoke(null, new Object[0]);
            foundDrill = true;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            // empty catch block
        }
        DRILL_IN_CLASSPATH = foundDrill;
        MAXIMUM_POOL_SIZE = Integer.parseInt(System.getProperty(THREAD_POOL_LIMIT_NAME, THREAD_POOL_LIMIT_DEFAULT));
        executorService = new ThreadPoolExecutor(2, MAXIMUM_POOL_SIZE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable);
                String threadName = "OjaiDriver-" + thread.getName();
                logger.info("Created new worker thread " + threadName);
                thread.setName(threadName);
                thread.setDaemon(true);
                return thread;
            }
        });
    }
}

