/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.ojai.store.impl.Expression;
import com.mapr.ojai.store.impl.ExpressionVisitor;
import com.mapr.ojai.store.impl.FieldExpression;
import com.mapr.ojai.store.impl.LiteralExpression;
import com.mapr.ojai.store.impl.NaryOperator;
import com.mapr.ojai.store.impl.OjaiConnection;
import com.mapr.ojai.store.impl.RelationalOperator;
import com.mapr.ojai.store.impl.UnaryOperator;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.ojai.FieldPath;
import org.ojai.Value;
import org.ojai.store.QueryCondition;

public class ExpressionToCondition
extends ExpressionVisitor {
    private final OjaiConnection ojaiConnection;
    private QueryCondition queryCond;
    private static final QueryCondition EMPTY_CONDITION = MapRDBImpl.newCondition().build();
    private static final Map<String, QueryCondition.Op> QUERY_CONDITIONS;

    public static QueryCondition convert(Expression expr, OjaiConnection ojaiConnection) {
        if (expr == null) {
            return EMPTY_CONDITION;
        }
        ExpressionToCondition etoc = new ExpressionToCondition(ojaiConnection);
        expr.visit(etoc);
        return etoc.queryCond;
    }

    private ExpressionToCondition(OjaiConnection ojaiConnection) {
        this.ojaiConnection = ojaiConnection;
    }

    @Override
    public void visitField(FieldExpression fieldExpr) {
        throw new IllegalStateException();
    }

    @Override
    public void visitLiteral(LiteralExpression literalExpr) {
        if (literalExpr.getType() != Value.Type.BOOLEAN) {
            throw new IllegalStateException();
        }
        boolean b = literalExpr.getBoolean();
        this.addToCondTree(b ? ConditionImpl.QUERY_COND_TRUE : ConditionImpl.QUERY_COND_FALSE);
    }

    private void addToCondTree(QueryCondition newCond) {
        this.queryCond = this.queryCond == null ? newCond : this.ojaiConnection.newCondition().and().condition(this.queryCond).condition(newCond).close().build();
    }

    @Override
    public void visitNary(NaryOperator naryOp) {
        QueryCondition newCond = this.ojaiConnection.newCondition();
        String opName = naryOp.opName;
        if (opName.equals("and")) {
            newCond = newCond.and();
        } else if (opName.equals("or")) {
            newCond = newCond.or();
        } else {
            if (opName.equals("matches") || opName.equals("notMatches")) {
                if (naryOp.arg.length > 2) {
                    throw new IllegalArgumentException(opName + " takes two arguments");
                }
                if (!(naryOp.arg[0] instanceof FieldExpression)) {
                    throw new IllegalArgumentException("The first argument to " + opName + " must be a field reference");
                }
                if (!(naryOp.arg[1] instanceof LiteralExpression)) {
                    throw new IllegalArgumentException("The second argument to " + opName + " must be a string");
                }
                FieldPath fieldPath = ((FieldExpression)naryOp.arg[0]).getFieldPath();
                String regex = ((LiteralExpression)naryOp.arg[1]).getString();
                newCond = opName.equals("matches") ? newCond.matches(fieldPath, regex) : newCond.notMatches(fieldPath, regex);
                this.addToCondTree(newCond.build());
                return;
            }
            if (opName.equals("ojai_condition")) {
                LiteralExpression litExpr = (LiteralExpression)naryOp.arg[1];
                String condString = litExpr.getString();
                byte[] condBytes = Base64.decodeBase64((String)condString);
                ByteBuffer condBuffer = ByteBuffer.wrap(condBytes);
                QueryCondition condition = ConditionImpl.parseFrom((ByteBuffer)condBuffer);
                this.addToCondTree(condition);
                return;
            }
        }
        for (Expression arg : naryOp.arg) {
            QueryCondition argCond = ExpressionToCondition.convert(arg, this.ojaiConnection);
            newCond = newCond.condition(argCond);
        }
        newCond = newCond.close().build();
        this.addToCondTree(newCond);
    }

    @Override
    public void visitRelational(RelationalOperator relOp) {
        FieldPath fieldPath = relOp.getLeftField();
        QueryCondition.Op op = QUERY_CONDITIONS.get(relOp.opName);
        LiteralExpression literal = relOp.getRightLiteral();
        QueryCondition newCond = this.ojaiConnection.newCondition();
        if (relOp.arg[0] instanceof UnaryOperator) {
            UnaryOperator unOp = (UnaryOperator)relOp.arg[0];
            switch (unOp.opName) {
                case "typeOf": {
                    Value.Type typeValue = Value.Type.valueOf((int)literal.getInt());
                    if (op == QueryCondition.Op.EQUAL) {
                        newCond.typeOf(fieldPath, typeValue);
                        break;
                    }
                    if (op == QueryCondition.Op.NOT_EQUAL) {
                        newCond.notTypeOf(fieldPath, typeValue);
                        break;
                    }
                    throw new IllegalStateException();
                }
                case "sizeOf": {
                    if (literal.getType() != Value.Type.INT) {
                        throw new IllegalStateException();
                    }
                    newCond.sizeOf(fieldPath, op, (long)literal.getInt());
                    break;
                }
                default: {
                    throw new IllegalStateException("unary operator " + unOp.opName);
                }
            }
        } else {
            switch (literal.getType()) {
                case ARRAY: {
                    if (op != QueryCondition.Op.EQUAL) {
                        throw new IllegalStateException("arrays can only be equal");
                    }
                    newCond = newCond.equals(fieldPath, literal.getList());
                    break;
                }
                case BINARY: {
                    newCond = newCond.is(fieldPath, op, literal.getBinary());
                    break;
                }
                case BOOLEAN: {
                    newCond = newCond.is(fieldPath, op, literal.getBoolean());
                    break;
                }
                case BYTE: {
                    newCond = newCond.is(fieldPath, op, literal.getByte());
                    break;
                }
                case DATE: {
                    newCond = newCond.is(fieldPath, op, literal.getDate());
                    break;
                }
                case DECIMAL: {
                    throw new IllegalStateException("unimplemented");
                }
                case DOUBLE: {
                    newCond = newCond.is(fieldPath, op, literal.getDouble());
                    break;
                }
                case FLOAT: {
                    newCond = newCond.is(fieldPath, op, literal.getFloat());
                    break;
                }
                case INT: {
                    newCond = newCond.is(fieldPath, op, literal.getInt());
                    break;
                }
                case INTERVAL: {
                    newCond = newCond.is(fieldPath, op, literal.getInterval());
                    break;
                }
                case LONG: {
                    newCond = newCond.is(fieldPath, op, literal.getLong());
                    break;
                }
                case MAP: {
                    throw new IllegalStateException("unimplemented");
                }
                case NULL: {
                    newCond = newCond.exists(fieldPath);
                    break;
                }
                case SHORT: {
                    newCond = newCond.is(fieldPath, op, literal.getShort());
                    break;
                }
                case STRING: {
                    newCond = newCond.is(fieldPath, op, literal.getString());
                    break;
                }
                case TIME: {
                    newCond = newCond.is(fieldPath, op, literal.getTime());
                    break;
                }
                case TIMESTAMP: {
                    newCond = newCond.is(fieldPath, op, literal.getTimestamp());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown switch case " + literal.getType());
                }
            }
        }
        newCond = newCond.build();
        this.addToCondTree(newCond);
    }

    @Override
    public void visitUnary(UnaryOperator unaryOp) {
        throw new IllegalStateException("unknown operator " + unaryOp.opName);
    }

    static {
        HashMap<String, QueryCondition.Op> relopInverse = new HashMap<String, QueryCondition.Op>(6);
        relopInverse.put("=", QueryCondition.Op.EQUAL);
        relopInverse.put("<>", QueryCondition.Op.NOT_EQUAL);
        relopInverse.put("<", QueryCondition.Op.LESS);
        relopInverse.put("<=", QueryCondition.Op.LESS_OR_EQUAL);
        relopInverse.put(">", QueryCondition.Op.GREATER);
        relopInverse.put(">=", QueryCondition.Op.GREATER_OR_EQUAL);
        QUERY_CONDITIONS = Collections.unmodifiableMap(relopInverse);
    }
}

