/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.mapr.db.Table;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.impl.OjaiQueryProperties;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.fs.utils.ssh.TestCluster;
import com.mapr.ojai.store.impl.OjaiConnection;
import com.mapr.ojai.store.impl.OjaiTest;
import com.mapr.tests.annotations.ClusterTest;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.DocumentStream;
import org.ojai.store.DocumentStore;
import org.ojai.store.Query;
import org.ojai.store.QueryCondition;

@Category(value={ClusterTest.class})
public class TestOjaiQuery_bug30193
extends OjaiTest {
    @Test
    public void testQuery_bug30193() throws Exception {
        String tableName = "testtable-bug30193";
        String tablePath = DBTests.getFullPath((String)"testtable-bug30193");
        String clearCmd = "maprcli cluster queryservice clearconfig";
        String enableCmd = "maprcli cluster queryservice setconfig -enabled true -clusterid \"default-drillbit-cluster-name-drillbits\" -storageplugin \"dfs\" -znode \"/drill\"";
        String disableCmd = "maprcli cluster queryservice setconfig -enabled false -clusterid \"default-drillbit-cluster-name-drillbits\" -storageplugin \"dfs\" -znode \"/drill\"";
        DBTests.setTableStatsSendInterval((long)1L);
        String[] splitKeys = new String[]{"user001", "user002", "user003", "user004", "user005"};
        try (Table table1 = DBTests.createOrReplaceTable((String)"testtable-bug30193", (String[])splitKeys);){
            Throwable throwable;
            DocumentStream docStream;
            Query query2;
            Throwable throwable2;
            DocumentStore docStore2;
            Throwable throwable3;
            OjaiConnection connection;
            table1.insertOrReplace(MapRDBImpl.newDocument((String)"{\"_id\":\"user001\", \"age\":43, \"salary\":43000, \"name\": {\"first\":\"Sam\", \"last\":\"Harris\"}}"));
            table1.insertOrReplace(MapRDBImpl.newDocument((String)"{\"_id\":\"user002\", \"age\":12, \"salary\":340000, \"name\": {\"first\":\"Leon\", \"last\":\"Russel\"}}"));
            table1.insertOrReplace(MapRDBImpl.newDocument((String)"{\"_id\":\"user003\", \"age\":87, \"salary\":9999999, \"name\": {\"first\":\"David\", \"last\":\"Bowie\"}}"));
            table1.insertOrReplace(MapRDBImpl.newDocument((String)"{\"_id\":\"user004\", \"age\":56, \"salary\":7, \"name\": {\"first\":\"Bob\", \"last\":\"Dylan\"}}"));
            table1.insertOrReplace(MapRDBImpl.newDocument((String)"{\"_id\":\"user005\", \"age\":54, \"salary\":123, \"name\": {\"first\":\"David\", \"last\":\"Ackert\"}}"));
            table1.flush();
            DBTests.waitForRowCountFromNC((Path)table1.getPath(), (long)5L, (long)60000L);
            try {
                connection = TestOjaiQuery_bug30193.getConnection();
                throwable3 = null;
                try {
                    if (!connection.getFileSystem().getQueryServiceParam().isEnabled()) {
                        TestCluster.runCommand((String)"maprcli cluster queryservice setconfig -enabled true -clusterid \"default-drillbit-cluster-name-drillbits\" -storageplugin \"dfs\" -znode \"/drill\"");
                    }
                }
                catch (Throwable throwable4) {
                    throwable3 = throwable4;
                    throw throwable4;
                }
                finally {
                    if (connection != null) {
                        if (throwable3 != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable5) {
                                throwable3.addSuppressed(throwable5);
                            }
                        } else {
                            connection.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
            }
            try {
                connection = TestOjaiQuery_bug30193.getConnection();
                throwable3 = null;
                try {
                    docStore2 = connection.getStore(tablePath);
                    throwable2 = null;
                    try {
                        Assert.assertTrue((boolean)connection.getFileSystem().getQueryServiceParam().isEnabled());
                        query2 = connection.newQuery().select(new String[]{"age"}).limit(1000L).where(connection.newCondition().is("age", QueryCondition.Op.NOT_EQUAL, 10).build()).build();
                        try {
                            docStream = docStore2.findQuery(query2);
                            throwable = null;
                            try {
                                Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DRILL, (Object)TestOjaiQuery_bug30193.getQueryPath(docStream));
                            }
                            catch (Throwable throwable6) {
                                throwable = throwable6;
                                throw throwable6;
                            }
                            finally {
                                if (docStream != null) {
                                    if (throwable != null) {
                                        try {
                                            docStream.close();
                                        }
                                        catch (Throwable throwable7) {
                                            throwable.addSuppressed(throwable7);
                                        }
                                    } else {
                                        docStream.close();
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            Assert.fail((String)e.getMessage());
                        }
                    }
                    catch (Throwable query2) {
                        throwable2 = query2;
                        throw query2;
                    }
                    finally {
                        if (docStore2 != null) {
                            if (throwable2 != null) {
                                try {
                                    docStore2.close();
                                }
                                catch (Throwable query2) {
                                    throwable2.addSuppressed(query2);
                                }
                            } else {
                                docStore2.close();
                            }
                        }
                    }
                }
                catch (Throwable docStore2) {
                    throwable3 = docStore2;
                    throw docStore2;
                }
                finally {
                    if (connection != null) {
                        if (throwable3 != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable docStore2) {
                                throwable3.addSuppressed(docStore2);
                            }
                        } else {
                            connection.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
            }
            TestCluster.runCommand((String)"maprcli cluster queryservice clearconfig");
            try {
                connection = TestOjaiQuery_bug30193.getConnection();
                throwable3 = null;
                try {
                    docStore2 = connection.getStore(tablePath);
                    throwable2 = null;
                    try {
                        Assert.assertFalse((boolean)connection.getFileSystem().getQueryServiceParam().isEnabled());
                        query2 = connection.newQuery().select(new String[]{"age"}).limit(1000L).where(connection.newCondition().is("age", QueryCondition.Op.NOT_EQUAL, 10).build()).build();
                        try {
                            docStream = docStore2.findQuery(query2);
                            throwable = null;
                            try {
                                Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)TestOjaiQuery_bug30193.getQueryPath(docStream));
                            }
                            catch (Throwable throwable8) {
                                throwable = throwable8;
                                throw throwable8;
                            }
                            finally {
                                if (docStream != null) {
                                    if (throwable != null) {
                                        try {
                                            docStream.close();
                                        }
                                        catch (Throwable throwable9) {
                                            throwable.addSuppressed(throwable9);
                                        }
                                    } else {
                                        docStream.close();
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            Assert.fail((String)e.getMessage());
                        }
                    }
                    catch (Throwable query3) {
                        throwable2 = query3;
                        throw query3;
                    }
                    finally {
                        if (docStore2 != null) {
                            if (throwable2 != null) {
                                try {
                                    docStore2.close();
                                }
                                catch (Throwable query3) {
                                    throwable2.addSuppressed(query3);
                                }
                            } else {
                                docStore2.close();
                            }
                        }
                    }
                }
                catch (Throwable docStore3) {
                    throwable3 = docStore3;
                    throw docStore3;
                }
                finally {
                    if (connection != null) {
                        if (throwable3 != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable docStore3) {
                                throwable3.addSuppressed(docStore3);
                            }
                        } else {
                            connection.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
            }
            TestCluster.runCommand((String)"maprcli cluster queryservice setconfig -enabled false -clusterid \"default-drillbit-cluster-name-drillbits\" -storageplugin \"dfs\" -znode \"/drill\"");
            try {
                connection = TestOjaiQuery_bug30193.getConnection();
                throwable3 = null;
                try {
                    docStore2 = connection.getStore(tablePath);
                    throwable2 = null;
                    try {
                        Assert.assertFalse((boolean)connection.getFileSystem().getQueryServiceParam().isEnabled());
                        query2 = connection.newQuery().select(new String[]{"age"}).limit(1000L).where(connection.newCondition().is("age", QueryCondition.Op.NOT_EQUAL, 10).build()).build();
                        try {
                            docStream = docStore2.findQuery(query2);
                            throwable = null;
                            try {
                                Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)TestOjaiQuery_bug30193.getQueryPath(docStream));
                            }
                            catch (Throwable throwable10) {
                                throwable = throwable10;
                                throw throwable10;
                            }
                            finally {
                                if (docStream != null) {
                                    if (throwable != null) {
                                        try {
                                            docStream.close();
                                        }
                                        catch (Throwable throwable11) {
                                            throwable.addSuppressed(throwable11);
                                        }
                                    } else {
                                        docStream.close();
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            Assert.fail((String)e.getMessage());
                        }
                    }
                    catch (Throwable throwable12) {
                        throwable2 = throwable12;
                        throw throwable12;
                    }
                    finally {
                        if (docStore2 != null) {
                            if (throwable2 != null) {
                                try {
                                    docStore2.close();
                                }
                                catch (Throwable throwable13) {
                                    throwable2.addSuppressed(throwable13);
                                }
                            } else {
                                docStore2.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable14) {
                    throwable3 = throwable14;
                    throw throwable14;
                }
                finally {
                    if (connection != null) {
                        if (throwable3 != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable15) {
                                throwable3.addSuppressed(throwable15);
                            }
                        } else {
                            connection.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
            }
            TestCluster.runCommand((String)"maprcli cluster queryservice setconfig -enabled true -clusterid \"default-drillbit-cluster-name-drillbits\" -storageplugin \"dfs\" -znode \"/drill\"");
            connection = TestOjaiQuery_bug30193.getConnection();
            throwable3 = null;
            try {
                Assert.assertTrue((boolean)connection.getFileSystem().getQueryServiceParam().isEnabled());
            }
            catch (Throwable throwable16) {
                throwable3 = throwable16;
                throw throwable16;
            }
            finally {
                if (connection != null) {
                    if (throwable3 != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable17) {
                            throwable3.addSuppressed(throwable17);
                        }
                    } else {
                        connection.close();
                    }
                }
            }
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        DBTests.deleteTables((String[])new String[]{"testtable-bug30193"});
        DBTests.setTableStatsSendInterval((long)5L);
    }
}

