/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl.results;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.mapr.db.impl.IdCodec;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.ojai.DBDocumentReader2;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.db.util.ByteBufs;
import com.mapr.ojai.store.impl.QueryContext;
import com.mapr.ojai.store.impl.results.QueryResultProcessor;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.RecordBatchLoader;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.complex.MapVector;
import org.ojai.Document;
import org.ojai.DocumentBuilder;
import org.ojai.DocumentReader;
import org.ojai.Value;
import org.ojai.util.DocumentReaderWithProjection;
import org.ojai.util.Documents;
import org.ojai.util.FieldProjector;

public class OjaiResultProcessor
implements QueryResultProcessor {
    private final QueryContext queryContext;
    private final boolean needFieldProjection;
    private final FieldProjector projector;
    private MapVector.Accessor mapAccessor;

    public OjaiResultProcessor(QueryContext queryContext) {
        this.queryContext = queryContext;
        this.needFieldProjection = queryContext.isNeedFieldProjection();
        this.projector = this.needFieldProjection ? new FieldProjector(queryContext.getProjectedFields()) : null;
    }

    @Override
    public Document extractFirst(RecordBatchLoader loader) {
        for (VectorWrapper vw : loader) {
            ValueVector vv = vw.getValueVector();
            UserBitShared.SerializedField serializedField = vv.getMetadata();
            String fieldName = serializedField.getNamePart().getName();
            if (!"$$document".equals(fieldName)) continue;
            assert (serializedField.getMajorType().getMinorType() == TypeProtos.MinorType.MAP);
            this.mapAccessor = (MapVector.Accessor)vv.getAccessor();
            return this.extractDoc(0);
        }
        throw new IllegalStateException("No ValueVector containing OJAI documents was found in the record batch");
    }

    @Override
    public Document extractNext(int rowNum) {
        Preconditions.checkState((this.mapAccessor != null ? 1 : 0) != 0, (Object)"extractFirst() must be called before calling extractNext().");
        return this.extractDoc(rowNum);
    }

    private Document extractDoc(int iRow) {
        Map v = (Map)this.mapAccessor.getObject(iRow);
        if (v.size() > 0) {
            DBDocumentImpl dbDoc;
            HashMap cfIdDataMap = Maps.newHashMap();
            ByteBuffer rowkeyBuffer = null;
            for (Map.Entry entry : v.entrySet()) {
                if ("_id".equals(entry.getKey())) {
                    rowkeyBuffer = ByteBufs.wrap((byte[])((byte[])entry.getValue()));
                    continue;
                }
                cfIdDataMap.put(Integer.valueOf((String)entry.getKey()), ByteBufs.wrap((byte[])((byte[])entry.getValue())));
            }
            if (this.needFieldProjection) {
                assert (this.projector != null);
                KeyValue idValue = rowkeyBuffer != null ? IdCodec.decode(rowkeyBuffer) : null;
                DBDocumentReader2 innerReader = new DBDocumentReader2((Map)cfIdDataMap, this.queryContext.fieldPathToFamilyIdMap(), idValue, idValue == null);
                DocumentReaderWithProjection reader = new DocumentReaderWithProjection((DocumentReader)innerReader, this.projector);
                DocumentBuilder builder = MapRDBImpl.newDocumentBuilder((FieldProjector)this.projector);
                Documents.writeReaderToBuilder((DocumentReader)reader, (DocumentBuilder)builder);
                dbDoc = (DBDocumentImpl)builder.getDocument();
                dbDoc.setId((Value)idValue, this.queryContext.excludeId());
            } else {
                dbDoc = new DBDocumentImpl();
                dbDoc.setSerializedJson((Map)cfIdDataMap, this.queryContext.fieldPathToFamilyIdMap(), this.queryContext.familyIdToFieldPathMap(), rowkeyBuffer, this.queryContext.excludeId(), false, false, null, null);
            }
            return dbDoc;
        }
        throw new IllegalStateException(String.format("Row %d does not exist in the ValueVector of size %d.", iRow, v.size()));
    }
}

