/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.google.common.base.Preconditions;
import com.mapr.db.impl.OjaiQueryProperties;
import com.mapr.db.index.IndexFieldDesc;
import com.mapr.db.indexrowkeyfmt.IndexRowKeyEncoder;
import com.mapr.ojai.store.impl.AbstractDocumentFilter;
import com.mapr.ojai.store.impl.SortKey;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.FieldPath;
import org.ojai.Value;

public class TopKStream
extends AbstractDocumentFilter {
    private final PriorityQueue<Document> heap;
    private final int limit;
    private final List<SortKey> sortKeys;
    private final FieldPath[] extras;
    private final Comparator<Document> comparator;
    private static final FieldPath[] FIELD_PATH_ARRAY = new FieldPath[0];
    private long rowsSeen = 0L;

    public TopKStream(DocumentStream upstreamStream, int limit, final List<SortKey> sortKeys, List<FieldPath> extras) {
        super(upstreamStream);
        Preconditions.checkNotNull(sortKeys);
        Preconditions.checkArgument((sortKeys.size() > 0 ? 1 : 0) != 0);
        this.limit = limit;
        this.sortKeys = sortKeys;
        this.extras = extras == null ? null : extras.toArray(FIELD_PATH_ARRAY);
        this.comparator = new Comparator<Document>(){

            @Override
            public int compare(Document doc1, Document doc2) {
                if (doc1 == doc2) {
                    return 0;
                }
                for (SortKey sortKey : sortKeys) {
                    Value v2;
                    int cmpSense;
                    int n = cmpSense = sortKey.order == IndexFieldDesc.Order.Asc ? -1 : 1;
                    Value v1 = doc1.getValue(sortKey.fieldPath);
                    int cmp = IndexRowKeyEncoder.VALUE_COMPARATOR.compare(v1, v2 = doc2.getValue(sortKey.fieldPath));
                    if (cmp == 0) continue;
                    return cmpSense * cmp;
                }
                return 0;
            }
        };
        this.heap = new PriorityQueue<Document>(limit + 1, this.comparator);
    }

    @Override
    public Iterator<Document> iterator() {
        Document doc;
        this.checkState();
        this.isUsed = true;
        for (Document doc2 : this.upstreamStream) {
            this.heap.add(doc2);
            ++this.rowsSeen;
            if (this.heap.size() <= this.limit) continue;
            this.heap.remove();
        }
        LinkedList<Document> reversedList = new LinkedList<Document>();
        while ((doc = this.heap.poll()) != null) {
            reversedList.addFirst(doc);
            if (this.extras == null) continue;
            for (FieldPath fieldPath : this.extras) {
                doc.delete(fieldPath);
            }
        }
        return reversedList.iterator();
    }

    private static Map<String, Object> makeSortKey(SortKey sortKey) {
        HashMap<String, Object> sk = new HashMap<String, Object>(2);
        sk.put("fieldName", sortKey.fieldString);
        sk.put("sortOrder", sortKey.order.name());
        return sk;
    }

    public void getQueryPlan(List<Map<String, Object>> planList) {
        if (this.upstreamStream == null) {
            return;
        }
        ((OjaiQueryProperties)this.upstreamStream).getQueryPlan(planList);
        HashMap<String, Object> myMap = new HashMap<String, Object>();
        myMap.put("streamName", this.getClass().getSimpleName());
        HashMap<String, Serializable> valueMap = new HashMap<String, Serializable>();
        valueMap.put("limit", Integer.valueOf(this.limit));
        if (this.sortKeys != null) {
            ArrayList<Map<String, Object>> keys = new ArrayList<Map<String, Object>>(this.sortKeys.size());
            for (SortKey sortKey : this.sortKeys) {
                keys.add(TopKStream.makeSortKey(sortKey));
            }
            valueMap.put("sortKeys", keys);
        }
        if (this.extras != null) {
            ArrayList<String> fieldNames = new ArrayList<String>(this.extras.length);
            for (FieldPath extra : this.extras) {
                fieldNames.add(extra.asPathString());
            }
            valueMap.put("extras", fieldNames);
        }
        myMap.put("parameters", valueMap);
        planList.add(myMap);
    }
}

