/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunnableQueue {
    private static final Logger logger = LoggerFactory.getLogger(RunnableQueue.class);
    private final LinkedList<Runnable> queue = new LinkedList();
    private boolean running;
    private Thread currentThread;
    private boolean terminated;
    private final ExecutorService executorService;
    private final int id;

    public RunnableQueue(ExecutorService executorService, int id) {
        this.executorService = executorService;
        this.id = id;
    }

    public synchronized void execute(Runnable runnable) {
        if (!this.terminated) {
            this.queue.add(runnable);
            if (!this.running) {
                this.running = true;
                logger.debug("RunnableQueue[" + this.id + "] executing new QueueRunner()");
                this.executorService.execute(new QueueRunner());
            }
        }
    }

    public synchronized void terminate() {
        if (!this.terminated) {
            if (this.running && this.currentThread != null) {
                this.currentThread.interrupt();
            }
            this.terminated = true;
        }
    }

    private class QueueRunner
    implements Runnable {
        private QueueRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            logger.debug("QueueRunner[" + RunnableQueue.this.id + "] starting");
            while (true) {
                Runnable runnable;
                RunnableQueue runnableQueue = RunnableQueue.this;
                synchronized (runnableQueue) {
                    if (RunnableQueue.this.terminated || RunnableQueue.this.queue.size() == 0) {
                        RunnableQueue.this.running = false;
                        RunnableQueue.this.currentThread = null;
                        Thread.interrupted();
                        break;
                    }
                    runnable = (Runnable)RunnableQueue.this.queue.remove();
                    RunnableQueue.this.currentThread = Thread.currentThread();
                }
                logger.debug("QueueRunner[" + RunnableQueue.this.id + "] running " + runnable.getClass());
                runnable.run();
                logger.debug("QueueRunner[" + RunnableQueue.this.id + "] finished " + runnable.getClass());
            }
            logger.debug("QueueRunner[" + RunnableQueue.this.id + "] ended");
        }
    }
}

