/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mapr.db.util.ConditionParser;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.ojai.exceptions.DecodingException;
import org.ojai.store.DriverManager;
import org.ojai.store.Query;
import org.ojai.store.SortOrder;

public class QueryParser {
    private Query query = DriverManager.getDriver((String)"ojai:mapr:").newQuery();
    boolean isWhere;
    boolean isSelect;

    public Query parseQuery(String jsonQuery) {
        this.isWhere = false;
        this.isSelect = false;
        Map queryMap = null;
        try {
            queryMap = (Map)new ObjectMapper().readValue(jsonQuery, (TypeReference)new TypeReference<Map<String, JsonNode>>(){});
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Iterator iterator = queryMap.keySet().iterator();
        block16: while (iterator.hasNext()) {
            String op;
            switch (op = (String)iterator.next()) {
                case "$where": {
                    if (this.isWhere) {
                        throw new IllegalArgumentException("$where already given");
                    }
                    this.isWhere = true;
                    ConditionParser cp = new ConditionParser();
                    this.query.where(cp.parseCondition(((JsonNode)queryMap.get(op)).toString()));
                    break;
                }
                case "$select": {
                    if (this.isSelect) {
                        throw new IllegalArgumentException("$select already given");
                    }
                    this.isSelect = true;
                    String proj = ((JsonNode)queryMap.get(op)).toString();
                    if (proj.startsWith("[") && proj.endsWith("]")) {
                        String[] projList = proj.substring(1, proj.length() - 1).split(",");
                        for (int i = 0; i < projList.length; ++i) {
                            projList[i] = projList[i].substring(1, projList[i].length() - 1);
                        }
                        this.query.select(projList);
                        break;
                    }
                    this.query.select(new String[]{proj.substring(1, proj.length() - 1)});
                    break;
                }
                case "$orderby": {
                    String orders = ((JsonNode)queryMap.get(op)).toString();
                    if (orders.startsWith("[") && orders.endsWith("]")) {
                        String[] orderList;
                        for (String ele : orderList = orders.substring(1, orders.length() - 1).split(",")) {
                            if (ele.charAt(0) == '{' && ele.charAt(ele.length() - 1) == '}') {
                                ele = ele.substring(1, ele.length() - 1);
                                int separatorIdx = ele.lastIndexOf(":");
                                this.buildOrderBy(ele, separatorIdx);
                                continue;
                            }
                            this.query = this.query.orderBy(ele.substring(1, ele.length() - 1), SortOrder.ASC);
                        }
                        continue block16;
                    }
                    if (orders.startsWith("{") && orders.endsWith("}")) {
                        orders = orders.substring(1, orders.length() - 1);
                        int separatorIdx = orders.lastIndexOf(":");
                        this.buildOrderBy(orders, separatorIdx);
                        break;
                    }
                    this.query = this.query.orderBy(orders.substring(1, orders.length() - 1), SortOrder.ASC);
                    break;
                }
                case "$offset": {
                    this.query.offset((long)Integer.parseInt(((JsonNode)queryMap.get(op)).toString()));
                    break;
                }
                case "$limit": {
                    this.query.limit((long)Integer.parseInt(((JsonNode)queryMap.get(op)).toString()));
                    break;
                }
                default: {
                    throw new DecodingException("Invalid Query Parameter");
                }
            }
        }
        return this.query.build();
    }

    void buildOrderBy(String field, int separatorIdx) {
        String orderStr = field.substring(separatorIdx + 1).toLowerCase();
        String fieldStr = field.substring(1, separatorIdx - 1);
        if (orderStr.equals("\"asc\"")) {
            this.query = this.query.orderBy(fieldStr, SortOrder.ASC);
        } else if (orderStr.equals("\"desc\"")) {
            this.query = this.query.orderBy(fieldStr, SortOrder.DESC);
        } else {
            throw new IllegalArgumentException("unrecognizable sort order format");
        }
    }
}

