/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.mapr.db.MetaTable;
import com.mapr.db.Table;
import com.mapr.db.exceptions.DBException;
import com.mapr.db.exceptions.ExceptionHandler;
import com.mapr.db.exceptions.TableClosedException;
import com.mapr.db.impl.BaseJsonTable;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.impl.MapRDBIndexImpl;
import com.mapr.db.impl.OjaiQueryProperties;
import com.mapr.db.impl.scan.ScanStatsImpl;
import com.mapr.db.index.IndexDesc;
import com.mapr.db.scan.ScanRange;
import com.mapr.db.scan.ScanStats;
import com.mapr.fs.proto.Dbserver;
import com.mapr.ojai.store.impl.DocumentStreamFactory;
import com.mapr.ojai.store.impl.EligibleIndex;
import com.mapr.ojai.store.impl.EmptyQueryStream;
import com.mapr.ojai.store.impl.Expression;
import com.mapr.ojai.store.impl.IdDocumentStream;
import com.mapr.ojai.store.impl.IdIndexDesc;
import com.mapr.ojai.store.impl.MaterializedDocumentStream;
import com.mapr.ojai.store.impl.NaryOperator;
import com.mapr.ojai.store.impl.OjaiConnection;
import com.mapr.ojai.store.impl.OjaiOptions;
import com.mapr.ojai.store.impl.OjaiQuery;
import com.mapr.ojai.store.impl.QueryAnalyzer;
import com.mapr.ojai.store.impl.QueryContext;
import com.mapr.ojai.store.impl.QueryParser;
import com.mapr.ojai.store.impl.RowkeyLookup;
import com.mapr.ojai.store.impl.SharedReleaser;
import com.mapr.ojai.store.impl.SharedResource;
import com.mapr.ojai.store.impl.SharedTable;
import com.mapr.ojai.store.impl.UnionDocumentStream;
import com.mapr.ojai.store.impl.bean.DrillConnectionParams;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import org.apache.hadoop.fs.Path;
import org.ojai.Document;
import org.ojai.DocumentConstants;
import org.ojai.DocumentStream;
import org.ojai.FieldPath;
import org.ojai.Value;
import org.ojai.annotation.API;
import org.ojai.exceptions.OjaiException;
import org.ojai.store.DocumentMutation;
import org.ojai.store.DocumentStore;
import org.ojai.store.Query;
import org.ojai.store.QueryCondition;
import org.ojai.store.exceptions.MultiOpException;
import org.ojai.store.exceptions.StoreException;
import org.ojai.util.Fields;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API.NotThreadSafe
public class OjaiDocumentStore
implements DocumentStore {
    private static final Logger logger = LoggerFactory.getLogger(OjaiDocumentStore.class);
    private static final String TABLET_LIMIT_NAME = "ojai.mapr.query.tablet-scan-limit";
    private static final String TABLET_LIMIT_DEFAULT = "4";
    private static final int TABLET_LIMIT = Integer.parseInt(System.getProperty("ojai.mapr.query.tablet-scan-limit", "4"));
    private static final String HASHED_TABLET_LIMIT_NAME = "ojai.mapr.query.hashed-tablet-scan-limit";
    private static final String HASHED_TABLET_LIMIT_DEFAULT = "32";
    private static final int HASHED_TABLET_LIMIT = Integer.parseInt(System.getProperty("ojai.mapr.query.hashed-tablet-scan-limit", "32"));
    private static final String INDEX_SELECTIVITY_MAX_NAME = "ojai.mapr.query.index-selectivity-max";
    private static final String INDEX_SELECTIVITY_MAX_DEFAULT = "0.25";
    private static final double INDEX_SELECTIVITY_MAX = Double.parseDouble(System.getProperty("ojai.mapr.query.index-selectivity-max", "0.25"));
    private final OjaiConnection ojaiConnection;
    private final String tableName;
    private final Path tablePath;
    private final OjaiOptions options;
    private final String clusterName;
    private String engineName;
    private boolean isClosed = false;
    private static final ObjectMapper objectMapper = new ObjectMapper().setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
    private SharedTable sharedTable;
    private static final FieldPath[] SELECT_ROWKEY = new FieldPath[]{DocumentConstants.ID_FIELD};

    public OjaiDocumentStore(OjaiConnection ojaiConnection, String tableName, Document options) {
        this.ojaiConnection = ojaiConnection;
        this.tableName = tableName;
        this.options = new OjaiOptions(options);
        this.tablePath = new Path(tableName);
        try {
            this.clusterName = ojaiConnection.getFileSystem().getClusterName(this.tablePath.toUri());
        }
        catch (IOException e) {
            throw ExceptionHandler.handle((IOException)e, (String)"OjaiDocumentStore.<init>()");
        }
        this.getTable();
    }

    @VisibleForTesting
    public BaseJsonTable getTable() {
        if (this.isClosed) {
            throw new TableClosedException();
        }
        if (this.sharedTable == null) {
            BaseJsonTable jsonTable = (BaseJsonTable)MapRDBImpl.getTable((String)this.tableName).setOption(Table.TableOption.BUFFERWRITE, this.options.getBoolean("ojai.mapr.documentstore.buffer-writes", true));
            this.sharedTable = new SharedTable(jsonTable);
            logger.debug("getTable " + this.tableName + " fid " + jsonTable.getFidStr());
        }
        return (BaseJsonTable)this.sharedTable.get();
    }

    public static String queryPlanToString(List<Map<String, Object>> queryPlan) {
        try {
            String queryPlanJson = objectMapper.writeValueAsString(queryPlan);
            return queryPlanJson;
        }
        catch (IOException ioe) {
            throw new StoreException((Throwable)ioe);
        }
    }

    public static void logQueryPlan(DocumentStream ds) {
        if (!logger.isTraceEnabled()) {
            return;
        }
        if (!(ds instanceof OjaiQueryProperties)) {
            logger.trace("OjaiQueryProperties is not implemented in '{}',", (Object)ds.getClass().getSimpleName());
            return;
        }
        ArrayList<Map<String, Object>> planList = new ArrayList<Map<String, Object>>();
        ((OjaiQueryProperties)ds).getQueryPlan(planList);
        String queryPlanJson = OjaiDocumentStore.queryPlanToString(planList);
        logger.trace("Ojai Query Plan: '{}'", (Object)queryPlanJson);
    }

    static SharedReleaser<BaseJsonTable> getSharedIndex(IndexDesc indexDesc, SharedTable sharedPrimaryTable) {
        SharedReleaser<BaseJsonTable> sharedReleaser;
        if (indexDesc instanceof IdIndexDesc) {
            sharedPrimaryTable.addRef();
            sharedReleaser = new SharedReleaser<BaseJsonTable>(sharedPrimaryTable);
        } else {
            Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)indexDesc);
            logger.debug("getSharedIndex " + indexDesc.getIndexName() + " fid " + indexDesc.getIndexFid() + " table " + indexDesc.getPrimaryTablePath());
            SharedTable sharedIndex = new SharedTable((BaseJsonTable)indexTable);
            sharedReleaser = new SharedReleaser<BaseJsonTable>(sharedIndex);
        }
        return sharedReleaser;
    }

    private String getEngineName() {
        if (this.engineName == null) {
            DrillConnectionParams connectParam = this.ojaiConnection.getQueryServiceParam(this.clusterName);
            if (!connectParam.isEnabled()) {
                throw new DBException("MapR-DB Query Service is not enabled for cluster: " + this.clusterName);
            }
            this.engineName = connectParam.getStoragePlugin();
        }
        return this.engineName;
    }

    public boolean checkAndDelete(String _id, QueryCondition condition) throws StoreException {
        BaseJsonTable table = this.getTable();
        return table.checkAndDelete(_id, condition);
    }

    public boolean checkAndDelete(Value _id, QueryCondition condition) throws StoreException {
        BaseJsonTable table = this.getTable();
        return table.checkAndDelete(_id, condition);
    }

    public boolean checkAndMutate(String _id, QueryCondition condition, DocumentMutation mutation) throws StoreException {
        BaseJsonTable table = this.getTable();
        return table.checkAndMutate(_id, condition, mutation);
    }

    public boolean checkAndMutate(Value _id, QueryCondition condition, DocumentMutation mutation) throws StoreException {
        BaseJsonTable table = this.getTable();
        return table.checkAndMutate(_id, condition, mutation);
    }

    public boolean checkAndReplace(String _id, QueryCondition condition, Document document) throws StoreException {
        BaseJsonTable table = this.getTable();
        return table.checkAndReplace(_id, condition, document);
    }

    public boolean checkAndReplace(Value _id, QueryCondition condition, Document document) throws StoreException {
        BaseJsonTable table = this.getTable();
        return table.checkAndReplace(_id, condition, document);
    }

    public void close() throws StoreException {
        if (this.isClosed) {
            return;
        }
        if (this.sharedTable != null) {
            this.sharedTable.release();
            this.sharedTable = null;
            this.isClosed = true;
        }
    }

    public void delete(String _id) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.delete(_id);
    }

    public void delete(Value _id) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.delete(_id);
    }

    public void delete(Document document) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.delete(document);
    }

    public void delete(DocumentStream stream) throws MultiOpException {
        BaseJsonTable table = this.getTable();
        table.delete(stream);
    }

    public void delete(Document document, FieldPath fieldPath) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.delete(document, fieldPath);
    }

    public void delete(Document document, String fieldAsKey) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.delete(document, fieldAsKey);
    }

    public void delete(DocumentStream stream, FieldPath fieldPath) throws MultiOpException {
        BaseJsonTable table = this.getTable();
        table.delete(stream, fieldPath);
    }

    public void delete(DocumentStream stream, String fieldAsKey) throws MultiOpException {
        BaseJsonTable table = this.getTable();
        table.delete(stream, fieldAsKey);
    }

    public DocumentStream find() throws StoreException {
        OjaiQuery query = new OjaiQuery().build();
        return this.findQuery(query);
    }

    public DocumentStream find(String ... paths) throws StoreException {
        OjaiQuery query = new OjaiQuery().select(paths).build();
        return this.findQuery(query);
    }

    public DocumentStream find(FieldPath ... fieldPaths) throws StoreException {
        OjaiQuery query = new OjaiQuery().select(fieldPaths).build();
        return this.findQuery(query);
    }

    public DocumentStream findQuery(String jsonQuery) throws StoreException {
        QueryParser queryParser = new QueryParser();
        return this.findQuery(queryParser.parseQuery(jsonQuery));
    }

    @VisibleForTesting
    public EligibleIndex getBestIndex(OjaiQuery ojaiQuery, List<EligibleIndex> eligibleIndexes) {
        int n;
        String indexHint;
        if (logger.isDebugEnabled()) {
            for (EligibleIndex eligibleIndex : eligibleIndexes) {
                logger.debug("getBestIndex() eligibleIndexes:");
                logger.debug(eligibleIndex.toString());
            }
        }
        if ((indexHint = ojaiQuery.getIndexHint()) != null) {
            for (EligibleIndex eligibleIndex : eligibleIndexes) {
                if (!indexHint.equals(eligibleIndex.indexDesc.getIndexName())) continue;
                logger.debug("getBestIndex() => using hinted index " + indexHint);
                return eligibleIndex;
            }
            logger.debug("getBestIndex() => hinted index " + indexHint + " not found");
        }
        if ((n = eligibleIndexes.size()) == 0) {
            return null;
        }
        PriorityQueue<EligibleIndex> heap = new PriorityQueue<EligibleIndex>(n, EligibleIndex.COST_COMPARATOR);
        for (EligibleIndex eligibleIndex : eligibleIndexes) {
            if (!eligibleIndex.isCovering && !(eligibleIndex.rowSelectivity <= INDEX_SELECTIVITY_MAX) && !eligibleIndex.canBeUsedForSort) continue;
            heap.add(eligibleIndex);
        }
        EligibleIndex bestIndex = heap.peek();
        return bestIndex;
    }

    private static QueryCondition getCompleteScanCondition(QueryCondition userCond, ScanRange scanRange) {
        QueryCondition rangeCondition = scanRange.getCondition();
        if (userCond == null || userCond.isEmpty()) {
            return rangeCondition;
        }
        if (rangeCondition.isEmpty()) {
            return userCond;
        }
        ConditionImpl scanCondition = MapRDBImpl.newCondition().and().condition(scanRange.getCondition()).condition(userCond).close().build();
        return scanCondition;
    }

    private static FieldPath[] addExtraFields(FieldPath[] selectFieldPaths, List<FieldPath> extras) {
        int arraySize = 0;
        if (extras == null) {
            return selectFieldPaths;
        }
        arraySize += extras.size();
        if (selectFieldPaths != null) {
            arraySize += selectFieldPaths.length;
        }
        if (arraySize == 0) {
            return null;
        }
        FieldPath[] fieldPaths = new FieldPath[arraySize];
        int destPosition = 0;
        if (selectFieldPaths != null) {
            System.arraycopy(selectFieldPaths, 0, fieldPaths, 0, selectFieldPaths.length);
            destPosition = selectFieldPaths.length;
        }
        if (extras != null) {
            for (FieldPath extra : extras) {
                fieldPaths[destPosition++] = extra;
            }
        }
        return fieldPaths;
    }

    private static DocumentStream createDocumentStream(final SharedResource<BaseJsonTable> sharedTable, final FieldPath[] fieldPaths, final QueryCondition cond) {
        List scanRanges;
        final Table table = (Table)sharedTable.get();
        try (MetaTable metaTable = table.getMetaTable();){
            scanRanges = cond == null ? metaTable.getScanRanges() : metaTable.getScanRanges(cond);
        }
        catch (IOException ex) {
            throw new OjaiException((Throwable)ex);
        }
        int nRanges = scanRanges.size();
        if (nRanges == 0) {
            return new EmptyQueryStream();
        }
        if (nRanges == 1) {
            QueryCondition scanCondition = OjaiDocumentStore.getCompleteScanCondition(cond, (ScanRange)scanRanges.get(0));
            DocumentStream docStream = fieldPaths == null ? table.find(scanCondition) : table.find(scanCondition, fieldPaths);
            return docStream;
        }
        sharedTable.addRef();
        final String indexUsed = table instanceof MapRDBIndexImpl ? ((MapRDBIndexImpl)table).getIndexName() : table.getName();
        final Iterator rangeIter = scanRanges.iterator();
        return new UnionDocumentStream(new DocumentStreamFactory(){

            @Override
            public DocumentStream create() {
                if (!rangeIter.hasNext()) {
                    return null;
                }
                ScanRange scanRange = (ScanRange)rangeIter.next();
                QueryCondition scanCondition = OjaiDocumentStore.getCompleteScanCondition(cond, scanRange);
                DocumentStream docStream = fieldPaths == null ? table.find(scanCondition) : table.find(scanCondition, fieldPaths);
                return docStream;
            }

            @Override
            public Iterator<OjaiQueryProperties> iterator() {
                return new Iterator<OjaiQueryProperties>(){
                    private final Iterator<? extends ScanRange> ri;
                    {
                        this.ri = scanRanges.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.ri.hasNext();
                    }

                    @Override
                    public OjaiQueryProperties next() {
                        ScanRange scanRange = this.ri.next();
                        return new ScanRangeProperties(table, scanRange);
                    }
                };
            }
        }){

            @Override
            protected void closeDerived() {
                sharedTable.release();
                super.closeDerived();
            }

            @Override
            public String getIndexUsed() {
                return indexUsed;
            }
        };
    }

    private static DocumentStream createEmptyStream(FieldPath[] fieldPaths) {
        MaterializedDocumentStream emptyStream = new MaterializedDocumentStream(null, OjaiQueryProperties.QueryPath.DIRECT, null, fieldPaths);
        return emptyStream;
    }

    private static int getTabletLimit(BaseJsonTable table) {
        Dbserver.SIndexInfo indexInfo;
        if (table.isIndex() && (indexInfo = table.getIndexInfo()).getHashed()) {
            return HASHED_TABLET_LIMIT;
        }
        return TABLET_LIMIT;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DocumentStream findQuery(Query query) throws StoreException {
        Set<Expression> otherPredicates;
        Preconditions.checkNotNull((Object)query, (Object)"Query must be non-null");
        Preconditions.checkArgument((boolean)(query instanceof OjaiQuery), (Object)"Query argument is not a MapR OJAI query");
        OjaiQuery ojaiQuery = (OjaiQuery)query;
        Preconditions.checkArgument((boolean)ojaiQuery.isBuilt(), (Object)"Query is not built");
        BaseJsonTable table = this.getTable();
        QueryAnalyzer queryAnalyzer = ojaiQuery.getQueryAnalyzer();
        FieldPath[] fieldPaths = ojaiQuery.getSelectListAsArray();
        if (queryAnalyzer.isAlwaysFalse()) {
            return OjaiDocumentStore.createEmptyStream(fieldPaths);
        }
        Map<FieldPath, List<NaryOperator>> topRelations = queryAnalyzer.getTopRelations();
        if (topRelations.get(DocumentConstants.ID_FIELD) != null && (otherPredicates = queryAnalyzer.getOtherPredicates()).size() == 0) {
            boolean sortOnId;
            if (queryAnalyzer.isIdEquals()) {
                String id = queryAnalyzer.getIdForLookup();
                if (id != null) return this._findById(queryAnalyzer.getIdForLookup(), ojaiQuery.includeId(), fieldPaths);
                return OjaiDocumentStore.createEmptyStream(fieldPaths);
            }
            Set<FieldPath> sortFields = ojaiQuery.getOrderByFields();
            int nSortFields = sortFields.size();
            boolean hasSort = nSortFields > 0;
            boolean bl = sortOnId = nSortFields == 1 && sortFields.contains(DocumentConstants.ID_FIELD);
            if (ojaiQuery.isIdIn() && (!hasSort || sortOnId)) {
                OjaiDocumentStore.setIdReturn((Table)table, ojaiQuery.includeId());
                IdDocumentStream idDocStream = new IdDocumentStream(this.ojaiConnection, queryAnalyzer.getFieldInBundle(), ojaiQuery.getFieldOrdering(DocumentConstants.ID_FIELD));
                RowkeyLookup rowkeyLookup = new RowkeyLookup(idDocStream, this.sharedTable, (QueryCondition)ojaiQuery.getCondition(), fieldPaths);
                OjaiDocumentStore.logQueryPlan(rowkeyLookup);
                return rowkeyLookup;
            }
        }
        if (!queryAnalyzer.isUnion() && !ojaiQuery.getForceDrill()) {
            List<EligibleIndex> eligibleIndexes;
            try {
                eligibleIndexes = ojaiQuery.getEligibleIndexes(this.ojaiConnection.getAdmin(), this.tablePath, this.sharedTable, this.ojaiConnection);
            }
            catch (IOException ioe) {
                throw new StoreException((Throwable)ioe);
            }
            EligibleIndex bestIndex = this.getBestIndex(ojaiQuery, eligibleIndexes);
            if (bestIndex != null) {
                IndexDesc indexDesc22 = bestIndex.indexDesc;
                try (SharedReleaser<BaseJsonTable> autoReleasedIndex = OjaiDocumentStore.getSharedIndex(indexDesc22, this.sharedTable);){
                    SharedResource<BaseJsonTable> sharedIndex = autoReleasedIndex.getSharedResource();
                    if (bestIndex.isCovering) {
                        ConditionImpl queryCondition = ojaiQuery.getCondition();
                        OjaiDocumentStore.setIdReturn((Table)sharedIndex.get(), ojaiQuery.includeId());
                        DocumentStream docStream = OjaiDocumentStore.createDocumentStream(sharedIndex, OjaiDocumentStore.addExtraFields(fieldPaths, bestIndex.sortLimitExtras), (QueryCondition)queryCondition);
                        DocumentStream documentStream2 = ojaiQuery.decorateStream(docStream, this.ojaiConnection, bestIndex.canBeUsedForSort, bestIndex.sortLimitExtras, sharedIndex);
                        return documentStream2;
                    }
                    if (!ojaiQuery.getForceNonCoveringSort() || ojaiQuery.isSortLimit()) {
                        OjaiDocumentStore.setIdReturn((Table)sharedIndex.get(), ojaiQuery.includeId());
                        DocumentStream indexStream = OjaiDocumentStore.createDocumentStream(sharedIndex, SELECT_ROWKEY, bestIndex.prunedCondition);
                        OjaiDocumentStore.setIdReturn((Table)table, ojaiQuery.includeId());
                        RowkeyLookup rowkeyLookup = new RowkeyLookup(indexStream, this.sharedTable, (QueryCondition)ojaiQuery.getCondition(), OjaiDocumentStore.addExtraFields(fieldPaths, bestIndex.sortLimitExtras));
                        DocumentStream documentStream3 = ojaiQuery.decorateStream(rowkeyLookup, this.ojaiConnection, bestIndex.canBeUsedForSort, bestIndex.sortLimitExtras, this.sharedTable);
                        return documentStream3;
                    }
                }
            }
        }
        if (ojaiQuery.getForceDirect() || !ojaiQuery.getForceDrill() && (ojaiQuery.isSortLimit() || !ojaiQuery.hasOrderBy())) {
            ConditionImpl queryCondition = ojaiQuery.getCondition();
            try (MetaTable primaryMetaTable = table.getMetaTable();){
                ScanStats scanStats = primaryMetaTable.getScanStats((QueryCondition)queryCondition);
                int nTablets = ((ScanStatsImpl)scanStats).getTabletCount();
                int tabletLimit = OjaiDocumentStore.getTabletLimit(table);
                if (nTablets <= tabletLimit) {
                    OjaiDocumentStore.setIdReturn((Table)this.sharedTable.get(), ojaiQuery.includeId());
                    List<FieldPath> sortLimitExtras = ojaiQuery.getSortLimitExtras();
                    DocumentStream docStream = OjaiDocumentStore.createDocumentStream(this.sharedTable, OjaiDocumentStore.addExtraFields(fieldPaths, sortLimitExtras), (QueryCondition)queryCondition);
                    DocumentStream documentStream = ojaiQuery.decorateStream(docStream, this.ojaiConnection, ojaiQuery.isSortOnId(), sortLimitExtras, this.sharedTable);
                    return documentStream;
                }
            }
            catch (IOException ex) {
                throw new StoreException((Throwable)ex);
            }
        }
        String sql = ojaiQuery.buildSqlString(this.getEngineName(), this.tableName);
        QueryContext queryContext = QueryContext.newBuilder(sql).clusterName(this.clusterName).familyIdToFieldPathMap(table.idToCFNameMap()).fieldPathToFamilyIdMap(table.sortedByPath()).query(ojaiQuery).build();
        DocumentStream drillStream = ojaiQuery.createDrillStream(this.ojaiConnection, this.sharedTable, queryContext);
        OjaiDocumentStore.logQueryPlan(drillStream);
        return drillStream;
    }

    private static void setIdReturn(Table table, boolean includeId) {
        table.setOption(Table.TableOption.EXCLUDEID, !includeId);
    }

    private DocumentStream _findById(String idValue, boolean includeId, FieldPath ... fieldPath) {
        BaseJsonTable table = this.getTable();
        OjaiDocumentStore.setIdReturn((Table)table, includeId);
        Document doc = fieldPath == null || fieldPath.length == 0 ? table.findById(idValue) : table.findById(idValue, fieldPath);
        MaterializedDocumentStream mds = new MaterializedDocumentStream(doc, OjaiQueryProperties.QueryPath.DIRECT, table.getName(), new FieldPath[0]);
        OjaiDocumentStore.logQueryPlan(mds);
        return mds;
    }

    public DocumentStream find(QueryCondition condition) throws StoreException {
        OjaiQuery ojaiQuery = new OjaiQuery().where(condition).build();
        return this.findQuery(ojaiQuery);
    }

    public DocumentStream find(QueryCondition condition, String ... field) throws StoreException {
        OjaiQuery ojaiQuery = new OjaiQuery().select(field).where(condition).build();
        return this.findQuery(ojaiQuery);
    }

    public DocumentStream find(QueryCondition condition, FieldPath ... fieldPath) throws StoreException {
        OjaiQuery ojaiQuery = new OjaiQuery().select(fieldPath).where(condition).build();
        return this.findQuery(ojaiQuery);
    }

    public void flush() throws StoreException {
        BaseJsonTable table = this.getTable();
        table.flush();
    }

    public void increment(String _id, String field, byte inc) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.increment(_id, field, inc);
    }

    public void increment(String _id, String field, short inc) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.increment(_id, field, inc);
    }

    public void increment(String _id, String field, int inc) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.increment(_id, field, inc);
    }

    public void increment(String _id, String field, long inc) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.increment(_id, field, inc);
    }

    public void increment(String _id, String field, float inc) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.increment(_id, field, inc);
    }

    public void increment(String _id, String field, double inc) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.increment(_id, field, inc);
    }

    public void increment(String _id, String field, BigDecimal inc) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.increment(_id, field, inc);
    }

    public void increment(Value value, String field, byte v) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.increment(value, field, v);
    }

    public void increment(Value value, String field, short v) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.increment(value, field, v);
    }

    public void increment(Value value, String field, int v) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.increment(value, field, v);
    }

    public void increment(Value value, String field, long v) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.increment(value, field, v);
    }

    public void increment(Value value, String field, float v) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.increment(value, field, v);
    }

    public void increment(Value value, String field, double v) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.increment(value, field, v);
    }

    public void increment(Value value, String field, BigDecimal v) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.increment(value, field, v);
    }

    public void insert(Document document) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.insert(document);
    }

    public void insert(DocumentStream stream) throws MultiOpException {
        BaseJsonTable table = this.getTable();
        table.insert(stream);
    }

    public void insert(String _id, Document document) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.insert(_id, document);
    }

    public void insert(Value value, Document document) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.insert(value, document);
    }

    public void insert(Document document, FieldPath fieldPath) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.insert(document, fieldPath);
    }

    public void insert(Document document, String fieldAsKey) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.insert(document, fieldAsKey);
    }

    public void insert(DocumentStream stream, FieldPath fieldPath) throws MultiOpException {
        BaseJsonTable table = this.getTable();
        table.insert(stream, fieldPath);
    }

    public void insert(DocumentStream stream, String fieldAsKey) throws MultiOpException {
        BaseJsonTable table = this.getTable();
        table.insert(stream, fieldAsKey);
    }

    public void insertOrReplace(Document document) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.insertOrReplace(document);
    }

    public void insertOrReplace(DocumentStream stream) throws MultiOpException {
        BaseJsonTable table = this.getTable();
        table.insertOrReplace(stream);
    }

    public void insertOrReplace(String _id, Document document) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.insertOrReplace(_id, document);
    }

    public void insertOrReplace(Value _id, Document document) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.insertOrReplace(_id, document);
    }

    public void insertOrReplace(Document document, FieldPath fieldPath) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.insertOrReplace(document, fieldPath);
    }

    public void insertOrReplace(Document document, String fieldAsKey) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.insertOrReplace(document, fieldAsKey);
    }

    public void insertOrReplace(DocumentStream stream, FieldPath fieldPath) throws MultiOpException {
        BaseJsonTable table = this.getTable();
        table.insertOrReplace(stream, fieldPath);
    }

    public void insertOrReplace(DocumentStream stream, String fieldAsKey) throws MultiOpException {
        BaseJsonTable table = this.getTable();
        table.insertOrReplace(stream, fieldAsKey);
    }

    public boolean isReadOnly() {
        BaseJsonTable table = this.getTable();
        return table.isReadOnly();
    }

    public void replace(Document document) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.replace(document);
    }

    public void replace(DocumentStream stream) throws MultiOpException {
        BaseJsonTable table = this.getTable();
        table.replace(stream);
    }

    public void replace(String _id, Document document) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.replace(_id, document);
    }

    public void replace(Value value, Document document) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.replace(value, document);
    }

    public void replace(Document document, FieldPath fieldPath) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.replace(document, fieldPath);
    }

    public void replace(Document document, String fieldAsKey) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.replace(document, fieldAsKey);
    }

    public void replace(DocumentStream stream, FieldPath fieldPath) throws MultiOpException {
        BaseJsonTable table = this.getTable();
        table.replace(stream, fieldPath);
    }

    public void replace(DocumentStream stream, String fieldAsKey) throws MultiOpException {
        BaseJsonTable table = this.getTable();
        table.replace(stream, fieldAsKey);
    }

    public void update(String _id, DocumentMutation mutation) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.update(_id, mutation);
    }

    public void update(Value value, DocumentMutation mutation) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.update(value, mutation);
    }

    public String endTrackingWrites() throws StoreException {
        BaseJsonTable table = this.getTable();
        return table.endTrackingWrites();
    }

    public void beginTrackingWrites() throws StoreException {
        BaseJsonTable table = this.getTable();
        table.beginTrackingWrites();
    }

    public void beginTrackingWrites(String previousWritesContext) throws StoreException, IllegalArgumentException, IllegalStateException {
        Preconditions.checkNotNull((Object)previousWritesContext);
        BaseJsonTable table = this.getTable();
        table.beginTrackingWrites(previousWritesContext);
    }

    public void clearTrackedWrites() throws StoreException {
        BaseJsonTable table = this.getTable();
        table.clearTrackedWrites();
    }

    public OjaiOptions getStoreOptions() {
        return this.options;
    }

    public Document findById(String _id) throws StoreException {
        Preconditions.checkNotNull((Object)_id);
        BaseJsonTable table = this.getTable();
        OjaiDocumentStore.setIdReturn((Table)table, true);
        return table.findById(_id);
    }

    public Document findById(Value _id) throws StoreException {
        Preconditions.checkNotNull((Object)_id);
        BaseJsonTable table = this.getTable();
        OjaiDocumentStore.setIdReturn((Table)table, true);
        return table.findById(_id);
    }

    private static boolean hasId(FieldPath[] fieldPaths) {
        if (fieldPaths == null) {
            return true;
        }
        for (FieldPath fieldPath : fieldPaths) {
            if (!fieldPath.equals((Object)DocumentConstants.ID_FIELD)) continue;
            return true;
        }
        return false;
    }

    public Document findById(String _id, FieldPath ... fieldPaths) throws StoreException {
        Preconditions.checkNotNull((Object)_id);
        BaseJsonTable table = this.getTable();
        OjaiDocumentStore.setIdReturn((Table)table, OjaiDocumentStore.hasId(fieldPaths));
        return table.findById(_id, fieldPaths);
    }

    public Document findById(String _id, String ... fieldPaths) throws StoreException {
        return this.findById(_id, Fields.toFieldPathArray((String[])fieldPaths));
    }

    public Document findById(Value _id, String ... fieldPaths) throws StoreException {
        return this.findById(_id, Fields.toFieldPathArray((String[])fieldPaths));
    }

    public Document findById(Value _id, FieldPath ... fieldPaths) throws StoreException {
        Preconditions.checkNotNull((Object)_id);
        BaseJsonTable table = this.getTable();
        OjaiDocumentStore.setIdReturn((Table)table, OjaiDocumentStore.hasId(fieldPaths));
        return table.findById(_id, fieldPaths);
    }

    public Document findById(String _id, QueryCondition condition) throws StoreException {
        Preconditions.checkNotNull((Object)_id);
        Preconditions.checkNotNull((Object)condition);
        BaseJsonTable table = this.getTable();
        OjaiDocumentStore.setIdReturn((Table)table, true);
        return table.findById(_id, condition);
    }

    public Document findById(Value _id, QueryCondition condition) throws StoreException {
        Preconditions.checkNotNull((Object)_id);
        Preconditions.checkNotNull((Object)condition);
        BaseJsonTable table = this.getTable();
        OjaiDocumentStore.setIdReturn((Table)table, true);
        return table.findById(_id, condition);
    }

    public Document findById(String _id, QueryCondition condition, String ... fieldPaths) throws StoreException {
        return this.findById(_id, condition, Fields.toFieldPathArray((String[])fieldPaths));
    }

    public Document findById(String _id, QueryCondition condition, FieldPath ... fieldPaths) throws StoreException {
        Preconditions.checkNotNull((Object)_id);
        Preconditions.checkNotNull((Object)condition);
        BaseJsonTable table = this.getTable();
        OjaiDocumentStore.setIdReturn((Table)table, OjaiDocumentStore.hasId(fieldPaths));
        return table.findById(_id, condition, fieldPaths);
    }

    public Document findById(Value _id, QueryCondition condition, String ... fieldPaths) throws StoreException {
        return this.findById(_id, condition, Fields.toFieldPathArray((String[])fieldPaths));
    }

    public Document findById(Value _id, QueryCondition condition, FieldPath ... fieldPaths) throws StoreException {
        Preconditions.checkNotNull((Object)_id);
        Preconditions.checkNotNull((Object)condition);
        BaseJsonTable table = this.getTable();
        OjaiDocumentStore.setIdReturn((Table)table, OjaiDocumentStore.hasId(fieldPaths));
        return table.findById(_id, condition, fieldPaths);
    }

    private static class ScanRangeProperties
    implements OjaiQueryProperties {
        private final String indexUsed;
        private final ScanRange scanRange;

        public ScanRangeProperties(Table table, ScanRange scanRange) {
            BaseJsonTable baseTable = (BaseJsonTable)table;
            this.indexUsed = baseTable.isIndex() ? baseTable.getIndexInfo().getIndexName() : baseTable.getName();
            this.scanRange = scanRange;
        }

        public OjaiQueryProperties.QueryPath getQueryPath() {
            return OjaiQueryProperties.QueryPath.DIRECT;
        }

        public String getIndexUsed() {
            return this.indexUsed;
        }

        public void getQueryPlan(List<Map<String, Object>> planList) {
            HashMap queryPlan = new HashMap();
            planList.add(queryPlan);
            HashMap<String, Object> scan = new HashMap<String, Object>();
            queryPlan.put("ScanRange", scan);
            scan.put("cond", this.scanRange.getCondition());
            scan.put("locations", this.scanRange.getLocations());
        }
    }
}

