/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.mapr.db.MetaTable;
import com.mapr.db.Table;
import com.mapr.db.impl.BaseJsonTable;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.index.IndexDesc;
import com.mapr.db.index.IndexFieldDesc;
import com.mapr.db.scan.ScanStats;
import com.mapr.ojai.store.impl.Expression;
import com.mapr.ojai.store.impl.ExpressionToCondition;
import com.mapr.ojai.store.impl.IdIndexDesc;
import com.mapr.ojai.store.impl.OjaiConnection;
import com.mapr.ojai.store.impl.OjaiDocumentStore;
import com.mapr.ojai.store.impl.OjaiQuery;
import com.mapr.ojai.store.impl.QueryAnalyzer;
import com.mapr.ojai.store.impl.SharedReleaser;
import com.mapr.ojai.store.impl.SharedResource;
import com.mapr.ojai.store.impl.SharedTable;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.ojai.FieldPath;
import org.ojai.store.QueryCondition;

public class EligibleIndex {
    private static final String PARTITION_FACTOR_NAME = "ojai.mapr.query.hashed-partition-cost-factor";
    private static final String PARTITION_FACTOR_DEFAULT = "0.5";
    private static final double PARTITION_FACTOR = Double.parseDouble(System.getProperty("ojai.mapr.query.hashed-partition-cost-factor", "0.5"));
    public final IndexDesc indexDesc;
    public final int scanFields;
    public final boolean isCovering;
    public final boolean canBeUsedForSort;
    public final List<FieldPath> sortLimitExtras;
    public final QueryCondition prunedCondition;
    public final boolean conditionCovered;
    public final ScanStats indexStats;
    public final double rowSelectivity;
    public final double ioCost;
    public final double cpuCost;
    public final double sortCpuCost;
    public final double simpleCost;
    public final int nIndexedFields;
    public final int nIncludedFields;
    public static final Comparator<EligibleIndex> COST_COMPARATOR = new Comparator<EligibleIndex>(){

        @Override
        public int compare(EligibleIndex o1, EligibleIndex o2) {
            if (o1.simpleCost < o2.simpleCost) {
                return -1;
            }
            if (o1.simpleCost > o2.simpleCost) {
                return 1;
            }
            if (o1.isCovering) {
                if (!o2.isCovering) {
                    return -1;
                }
            } else if (o2.isCovering) {
                return 1;
            }
            if (o1.indexDesc instanceof IdIndexDesc) {
                return 1;
            }
            if (o2.indexDesc instanceof IdIndexDesc) {
                return -1;
            }
            return 0;
        }
    };

    public EligibleIndex(IndexDesc indexDesc, int scanFields, boolean isCovering, boolean needsSort, boolean canBeUsedForSort, List<FieldPath> sortLimitExtras, OjaiConnection ojaiConnection, OjaiQuery ojaiQuery, ScanStats tableStats, SharedTable sharedPrimaryTable) throws IOException {
        long tableEstRows;
        int nHashPartitions;
        this.indexDesc = indexDesc;
        this.scanFields = scanFields;
        this.isCovering = isCovering;
        this.canBeUsedForSort = canBeUsedForSort;
        this.sortLimitExtras = sortLimitExtras;
        HashSet<FieldPath> keyFields = new HashSet<FieldPath>();
        int usableFields = 0;
        List indexedFields = indexDesc.getIndexedFields();
        for (IndexFieldDesc ifd : indexedFields) {
            if (usableFields++ >= scanFields) break;
            keyFields.add(ifd.getFieldPath());
        }
        QueryAnalyzer queryAnalyzer = ojaiQuery.getQueryAnalyzer();
        Expression prunedExpr = queryAnalyzer.getPrunedExpression(keyFields);
        QueryCondition prunedCondition = ExpressionToCondition.convert(prunedExpr, ojaiConnection);
        ConditionImpl fullCondition = ojaiQuery.getCondition();
        this.conditionCovered = prunedCondition.equals(fullCondition);
        this.prunedCondition = this.conditionCovered ? fullCondition : prunedCondition;
        long limit = ojaiQuery.getLimit();
        try (SharedReleaser<BaseJsonTable> autoReleasedIndex = OjaiDocumentStore.getSharedIndex(indexDesc, sharedPrimaryTable);){
            SharedResource<BaseJsonTable> sharedIndex = autoReleasedIndex.getSharedResource();
            Table indexTable = (Table)sharedIndex.get();
            try (MetaTable metaTable = indexTable.getMetaTable();){
                this.indexStats = metaTable.getScanStats(prunedCondition);
            }
        }
        long indexEstRows = this.indexStats.getEstimatedNumRows();
        double ioCost = this.indexStats.getPartitionCount();
        if (limit != -1L && this.conditionCovered) {
            if (indexEstRows > 0L) {
                ioCost *= (double)limit / (double)indexEstRows;
            }
            indexEstRows = limit;
        }
        if (indexDesc.isHashed() && (nHashPartitions = indexDesc.getNumHashPartitions()) > 1) {
            ioCost /= (double)nHashPartitions * PARTITION_FACTOR;
        }
        this.rowSelectivity = (tableEstRows = tableStats.getEstimatedNumRows()) == 0L || tableEstRows <= indexEstRows ? 1.0 : (double)indexEstRows / (double)tableEstRows;
        double cpuCost = indexEstRows;
        if (!isCovering) {
            ioCost += (double)indexEstRows;
            cpuCost += (double)indexEstRows;
        }
        this.ioCost = ioCost;
        this.cpuCost = cpuCost;
        double sortCpuCost = 0.0;
        if (needsSort && !canBeUsedForSort && indexEstRows > 0L) {
            sortCpuCost = (double)indexEstRows * Math.log(limit != -1L ? (double)limit : (double)indexEstRows);
        }
        this.sortCpuCost = sortCpuCost;
        double tableRowsPerPartition = (double)tableStats.getEstimatedNumRows() / (double)tableStats.getPartitionCount();
        this.simpleCost = ioCost * tableRowsPerPartition * ojaiQuery.getRowCpuIoRatio() + cpuCost + sortCpuCost;
        this.nIndexedFields = indexedFields.size();
        this.nIncludedFields = indexDesc instanceof IdIndexDesc ? Integer.MAX_VALUE : indexDesc.getIncludedFields().size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("\"EligibleIndex:{\"");
        sb.append("\"indexName\":\"" + this.indexDesc.getIndexName() + "\", ");
        sb.append("\"scanFields\":" + this.scanFields + ", ");
        sb.append("\"isCovering\":" + Boolean.toString(this.isCovering) + ", ");
        sb.append("\"prunedCondition\":\"" + this.prunedCondition + "\", ");
        sb.append("\"rowSelectivity\":" + this.rowSelectivity + ", ");
        sb.append("\"ioCost\":" + this.ioCost + " ,");
        sb.append("\"cpuCost\":" + this.cpuCost + " ,");
        sb.append("\"sortCpuCost\":" + this.sortCpuCost + " ,");
        sb.append("\"simpleCost\":" + this.simpleCost);
        sb.append("}");
        return sb.toString();
    }
}

