/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.mapr.ojai.store.impl.RunnableQueue;
import java.util.concurrent.ExecutorService;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.proto.helper.QueryIdHelper;
import org.apache.drill.exec.rpc.ConnectionThrottle;
import org.apache.drill.exec.rpc.user.QueryDataBatch;
import org.apache.drill.exec.rpc.user.UserResultsListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingResultsListener
implements UserResultsListener {
    private static final Logger logger = LoggerFactory.getLogger(DelegatingResultsListener.class);
    private final RunnableQueue runnableQueue;
    private final UserResultsListener delegateListener;
    private final int id;

    public DelegatingResultsListener(ExecutorService executorService, int id, UserResultsListener delegateListener) {
        this.runnableQueue = new RunnableQueue(executorService, id);
        this.delegateListener = delegateListener;
        this.id = id;
    }

    public void queryIdArrived(final UserBitShared.QueryId queryId) {
        logger.debug("DelegatingResultsListener[" + this.id + "].queryIdArrived(queryId = " + QueryIdHelper.getQueryId((UserBitShared.QueryId)queryId) + ")");
        this.runnableQueue.execute(new Runnable(){

            @Override
            public void run() {
                DelegatingResultsListener.this.delegateListener.queryIdArrived(queryId);
            }
        });
        logger.debug("DelegatingResultsListener[" + this.id + "].queryIdArrived(queryId = " + QueryIdHelper.getQueryId((UserBitShared.QueryId)queryId) + ") submitted");
    }

    public void submissionFailed(final UserException ex) {
        logger.debug("DelegatingResultsListener[" + this.id + "].submissionFailed(ex = " + ex + ")");
        this.runnableQueue.execute(new Runnable(){

            @Override
            public void run() {
                DelegatingResultsListener.this.delegateListener.submissionFailed(ex);
            }
        });
        logger.debug("DelegatingResultsListener[" + this.id + "].submissionFailed(ex = " + ex + ") submitted");
    }

    public void dataArrived(final QueryDataBatch result, final ConnectionThrottle throttle) {
        logger.debug("DelegatingResultsListener[" + this.id + "].dataArrived(...)");
        this.runnableQueue.execute(new Runnable(){

            @Override
            public void run() {
                DelegatingResultsListener.this.delegateListener.dataArrived(result, throttle);
            }
        });
        logger.debug("DelegatingResultsListener[" + this.id + "].dataArrived(...) submitted");
    }

    public void queryCompleted(final UserBitShared.QueryResult.QueryState state) {
        logger.debug("DelegatingResultsListener[" + this.id + "].queryCompleted(" + state + ")");
        this.runnableQueue.execute(new Runnable(){

            @Override
            public void run() {
                DelegatingResultsListener.this.delegateListener.queryCompleted(state);
            }
        });
        logger.debug("DelegatingResultsListener[" + this.id + "].queryCompleted(" + state + ") submitted");
    }

    public void terminate() {
        this.runnableQueue.terminate();
    }
}

