/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.mapr.db.impl.BaseJsonTable;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.impl.MapRDBIndexImpl;
import com.mapr.db.impl.MapRDBTableImpl;
import com.mapr.db.impl.OjaiQueryProperties;
import com.mapr.fs.jni.IndexSyncStateTracker;
import com.mapr.fs.proto.Dbserver;
import com.mapr.ojai.store.impl.AbstractDocumentFilter;
import com.mapr.ojai.store.impl.ErrorIterator;
import com.mapr.ojai.store.impl.SharedResource;
import com.mapr.ojai.store.impl.SharedTable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.exceptions.OjaiException;

public class CommitWaitStream
extends AbstractDocumentFilter {
    private final SharedResource<BaseJsonTable> sharedTable;
    private final MapRDBTableImpl dbTable;
    private final Dbserver.CommitContext commitContext;
    private final String priTablePath;

    public CommitWaitStream(DocumentStream upstreamStream, SharedResource<BaseJsonTable> sharedTable, Dbserver.CommitContext commitContext) {
        super(upstreamStream);
        BaseJsonTable argTable = sharedTable.get();
        if (argTable instanceof MapRDBTableImpl) {
            this.dbTable = (MapRDBTableImpl)argTable;
            this.sharedTable = sharedTable;
            sharedTable.addRef();
        } else if (argTable instanceof MapRDBIndexImpl) {
            Path tablePath = ((MapRDBIndexImpl)argTable).getTablePath();
            this.dbTable = (MapRDBTableImpl)MapRDBImpl.getTable((Path)tablePath);
            this.sharedTable = new SharedTable((BaseJsonTable)this.dbTable);
        } else {
            throw new IllegalArgumentException("unexpected table implementation " + argTable.getClass());
        }
        this.priTablePath = this.dbTable.getPath().toString();
        this.commitContext = commitContext;
    }

    @Override
    public Iterator<Document> iterator() {
        this.checkState();
        IndexSyncStateTracker tracker = this.dbTable.createIndexSyncStateTracker(this.commitContext);
        try {
            while (!tracker.haveIndexesSynced()) {
                long waitMs = tracker.getEstimatedWaitMs();
                Thread.sleep(waitMs);
            }
        }
        catch (IOException ioe) {
            return new ErrorIterator<Document>(){

                @Override
                protected void throwException() {
                    throw new OjaiException((Throwable)ioe);
                }
            };
        }
        catch (InterruptedException ie) {
            return new ErrorIterator<Document>(){

                @Override
                protected void throwException() {
                    throw new OjaiException((Throwable)ie);
                }
            };
        }
        return super.iterator();
    }

    @Override
    protected void closeDerived() {
        this.sharedTable.release();
        super.closeDerived();
    }

    public void getQueryPlan(List<Map<String, Object>> planList) {
        if (this.upstreamStream == null) {
            return;
        }
        ((OjaiQueryProperties)this.upstreamStream).getQueryPlan(planList);
        HashMap<String, Object> myMap = new HashMap<String, Object>();
        myMap.put("streamName", this.getClass().getSimpleName());
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        if (this.commitContext != null) {
            valueMap.put("commitContext", this.commitContext);
        }
        valueMap.put("primaryTable", this.priTablePath);
        myMap.put("parameters", valueMap);
        planList.add(myMap);
    }
}

