/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.ojai.exceptions.OjaiException;
import org.ojai.exceptions.QueryTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BlockingHandoff<T>
implements Iterable<T>,
AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(BlockingHandoff.class);
    private final T END_SENTINEL;
    private final Action ACTION_CLOSE;
    private final LinkedList<Action> resultQueue = new LinkedList();
    private boolean closeRequested;
    private final long timeoutMs;

    public BlockingHandoff(T endSentinel, long timeoutMs) {
        this.END_SENTINEL = endSentinel;
        this.timeoutMs = timeoutMs;
        this.ACTION_CLOSE = new Action(this.END_SENTINEL, null, true);
    }

    protected void throwQueryTimeout() {
        throw new QueryTimeoutException("Query exceeded timeout (" + this.timeoutMs + ")");
    }

    protected abstract void itemTimeout(long var1);

    private synchronized boolean hasNext(Action action) {
        logger.debug("hasNext(action) {} {} {} {}", new Object[]{action.close, action.ex, action.nextItem != null, action.nextItem != this.END_SENTINEL});
        if (action.close) {
            return false;
        }
        if (action.ex != null) {
            Action firstAction = this.resultQueue.remove();
            if (firstAction != action) {
                throw new IllegalStateException();
            }
            if (action.ex instanceof OjaiException) {
                throw (OjaiException)action.ex;
            }
            throw new OjaiException((Throwable)action.ex);
        }
        return action.nextItem != this.END_SENTINEL;
    }

    private synchronized void waitForAction() {
        long timeLeftMs = this.timeoutMs;
        while (timeLeftMs > 0L && this.resultQueue.size() == 0) {
            try {
                long startTime = System.currentTimeMillis();
                logger.debug("waitForAction() wait({})", (Object)timeLeftMs);
                this.wait(timeLeftMs);
                long endTime = System.currentTimeMillis();
                timeLeftMs -= endTime - startTime;
            }
            catch (InterruptedException iex) {
                this.enqueueClose();
            }
        }
        logger.debug("waitForAction() timeLeftMs {} queue size {}", (Object)timeLeftMs, (Object)this.resultQueue.size());
        if (this.resultQueue.size() == 0) {
            this.itemTimeout(this.timeoutMs);
            throw new IllegalStateException();
        }
    }

    private synchronized boolean hasNext() {
        this.waitForAction();
        Action action = this.resultQueue.peek();
        return this.hasNext(action);
    }

    private synchronized T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Action action = this.resultQueue.poll();
        this.notifyAll();
        return action.nextItem;
    }

    private synchronized void waitForSpace() {
        while (!this.closeRequested && this.resultQueue.size() > 0) {
            try {
                logger.debug("waitForSpace() wait()");
                this.wait();
            }
            catch (InterruptedException iex) {
                this.enqueueClose();
            }
        }
        logger.debug("waitForSpace() closedRequested {} resultQueue.size() {}", (Object)this.closeRequested, (Object)this.resultQueue.size());
    }

    public synchronized boolean put(T item) {
        Preconditions.checkArgument((item != null ? 1 : 0) != 0);
        this.waitForSpace();
        if (this.closeRequested) {
            return false;
        }
        if (item == this.END_SENTINEL) {
            this.enqueueClose();
        } else {
            logger.debug("put() => adding item");
            this.resultQueue.add(new Action(item));
        }
        this.notifyAll();
        return true;
    }

    public synchronized void putException(Exception ex) {
        Preconditions.checkArgument((ex != null ? 1 : 0) != 0);
        this.waitForSpace();
        if (this.closeRequested) {
            return;
        }
        this.resultQueue.add(new Action(ex));
        this.enqueueClose();
        this.notifyAll();
    }

    public void putEos() {
        this.put(this.END_SENTINEL);
    }

    protected abstract void setup(CountDownLatch var1);

    protected abstract void iteratorTimeout();

    @Override
    public Iterator<T> iterator() {
        ItemIterator itemIterator = new ItemIterator();
        CountDownLatch readyLatch = new CountDownLatch(1);
        this.setup(readyLatch);
        try {
            readyLatch.await(this.timeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException iex) {
            logger.debug("iterator() => iteratorTimeout()");
            this.iteratorTimeout();
            throw new IllegalStateException();
        }
        return itemIterator;
    }

    private synchronized void enqueueClose() {
        if (!this.closeRequested) {
            logger.debug("enqueueClose()");
            this.resultQueue.add(this.ACTION_CLOSE);
            this.closeRequested = true;
        }
    }

    @Override
    public synchronized void close() {
        this.enqueueClose();
        this.notifyAll();
    }

    private class ItemIterator
    implements Iterator<T> {
        private ItemIterator() {
        }

        @Override
        public boolean hasNext() {
            return BlockingHandoff.this.hasNext();
        }

        @Override
        public T next() {
            return BlockingHandoff.this.next();
        }
    }

    private class Action {
        public final T nextItem;
        public final boolean close;
        public final Exception ex;

        private Action(T nextItem, Exception ex, boolean close) {
            this.nextItem = nextItem;
            this.ex = ex;
            this.close = close;
        }

        public Action(T item) {
            this(item, null, false);
        }

        public Action(Exception ex) {
            this(null, ex, false);
        }
    }
}

