/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.google.common.base.Equivalence;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mapr.db.Admin;
import com.mapr.db.Table;
import com.mapr.db.impl.AdminImpl;
import com.mapr.db.impl.BaseJsonTable;
import com.mapr.db.impl.OjaiQueryProperties;
import com.mapr.db.index.IndexDesc;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.ojai.store.impl.AbstractDocumentStream;
import com.mapr.ojai.store.impl.DelayDocumentFilter;
import com.mapr.ojai.store.impl.DummyDocumentStream;
import com.mapr.ojai.store.impl.EligibleIndex;
import com.mapr.ojai.store.impl.Expression;
import com.mapr.ojai.store.impl.ExpressionToCondition;
import com.mapr.ojai.store.impl.ExpressionToSql;
import com.mapr.ojai.store.impl.FieldInBundle;
import com.mapr.ojai.store.impl.LiteralExpression;
import com.mapr.ojai.store.impl.OjaiConnection;
import com.mapr.ojai.store.impl.OjaiDriver;
import com.mapr.ojai.store.impl.OjaiQuery;
import com.mapr.ojai.store.impl.OjaiTest;
import com.mapr.ojai.store.impl.QueryAnalyzer;
import com.mapr.ojai.store.impl.SharedTable;
import com.mapr.ojai.store.impl.SharedTable29281;
import com.mapr.ojai.store.impl.SharedTestTable;
import com.mapr.ojai.store.impl.StringGenerator;
import com.mapr.ojai.store.impl.TimeoutDocumentFilter;
import com.mapr.ojai.store.impl.TopKStream;
import com.mapr.tests.annotations.ClusterTest;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.fs.Path;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.DocumentConstants;
import org.ojai.DocumentListener;
import org.ojai.DocumentStream;
import org.ojai.FieldPath;
import org.ojai.Value;
import org.ojai.exceptions.QueryTimeoutException;
import org.ojai.store.Connection;
import org.ojai.store.DocumentStore;
import org.ojai.store.Query;
import org.ojai.store.QueryCondition;
import org.ojai.store.SortOrder;
import org.ojai.types.ODate;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;

@Category(value={ClusterTest.class})
public class TestOjaiQuery
extends OjaiTest {
    private final OjaiDriver driver = TestOjaiQuery.getDriver();
    private static final SharedTable27089 sharedTable27089 = new SharedTable27089();
    private static final int TIMEOUT_SECONDS = 5;
    private static final SharedTable27302 sharedTable27302 = new SharedTable27302();
    private static final String[] bug28129States = new String[]{"TX", "MN", "NV", "CA", "NY", "VT", "OR"};
    private static final SharedTable29013 sharedTable29013 = new SharedTable29013();
    private static final SharedTable29281 sharedTable29281 = new SharedTable29281();
    private static final SharedTable28299 sharedTable28299 = new SharedTable28299();
    private static final SharedTable29267 sharedTable29267 = new SharedTable29267();
    private static final SharedTable29504 sharedTable29504 = new SharedTable29504();

    @AfterClass
    public static void cleanup() throws IOException {
        SharedTestTable.cleanup();
    }

    @Test
    public void testOjaiQuery() {
        Query query = this.driver.newQuery().build();
        Assert.assertNotNull((Object)query);
        Assert.assertTrue((boolean)(query instanceof OjaiQuery));
    }

    @Test
    public void testQueryGeneration() {
        Query query1 = this.driver.newQuery();
        query1.select(new String[]{"foo"});
        query1.select(new String[]{"bar.f", "baz[2]"});
        QueryCondition queryCond1 = this.driver.newCondition();
        queryCond1.is("foo", QueryCondition.Op.GREATER_OR_EQUAL, "abc").build();
        query1.where(queryCond1);
        OjaiQuery ojaiQuery1 = (OjaiQuery)query1.build();
        String sqlString1 = ojaiQuery1.buildSqlString("dfs", "foo");
        TestOjaiQuery.assertEncodedFields(sqlString1, "foo", "bar.f", "baz[2]", "_id");
        Query query2 = this.driver.newQuery();
        OjaiQuery ojaiQuery2 = (OjaiQuery)query2.build();
        String sqlString2 = ojaiQuery2.buildSqlString("dfs", "foo");
        TestOjaiQuery.assertEncodedFields(sqlString2, "*", "_id");
        Query query3 = this.driver.newQuery();
        QueryCondition queryCond3 = this.driver.newCondition();
        queryCond3.and().is("foo", QueryCondition.Op.GREATER_OR_EQUAL, "abc").is("bar.f", QueryCondition.Op.EQUAL, "Acme").close().build();
        query3.where(queryCond3);
        OjaiQuery ojaiQuery3 = (OjaiQuery)query3.build();
        String sqlString3 = ojaiQuery3.buildSqlString("dfs", "foo");
        TestOjaiQuery.assertEncodedFields(sqlString3, "*", "_id");
    }

    @Test
    public void testQueryGeneration_offset() {
        Query query = this.driver.newQuery();
        query.select(new String[]{"foo"});
        query.offset(2L);
        OjaiQuery ojaiQuery = (OjaiQuery)query.build();
        String sqlString = ojaiQuery.buildSqlString("dfs", "sometable");
        TestOjaiQuery.assertEncodedFields(sqlString, "foo", "_id");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testQuery_Bug28535() {
        Query query = this.driver.newQuery().waitForTrackedWrites(new String("invalid")).select(new String[]{"foo"}).build();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testQueryGeneration_offsetError() {
        Query query = this.driver.newQuery().select(new String[]{"foo"}).offset(-2L).build();
    }

    @Test
    public void testQueryGeneration_offset_limit() {
        Query query = this.driver.newQuery();
        query.select(new String[]{"foo"});
        query.limit(2L);
        query.offset(4L);
        OjaiQuery ojaiQuery = (OjaiQuery)query.build();
        String sqlString = ojaiQuery.buildSqlString("dfs", "sometable");
        TestOjaiQuery.assertEncodedFields(sqlString, "foo", "_id");
    }

    @Test
    public void testQueryGeneration_limit() {
        Query query = this.driver.newQuery();
        query.select(new String[]{"foo"});
        query.limit(2L);
        OjaiQuery ojaiQuery = (OjaiQuery)query.build();
        String sqlString = ojaiQuery.buildSqlString("dfs", "sometable");
        TestOjaiQuery.assertEncodedFields(sqlString, "foo", "_id");
    }

    private static void insertBug27262(Connection connection, Table table, String id, int i, String s) {
        Document doc = connection.newDocument();
        doc.setId(id);
        doc.set("i1", i);
        doc.set("s1", s);
        table.insert(doc);
    }

    private static void verifyQueryResultSize(DocumentStream docStream, int expectedCount) {
        int docCount = 0;
        for (Document doc : docStream) {
            Assert.assertNotNull((Object)doc.getIdString());
            ++docCount;
        }
        Assert.assertEquals((long)expectedCount, (long)docCount);
    }

    private static OjaiQuery makeQuery(OjaiDriver driver, String fieldPathStr, QueryCondition condition) {
        OjaiQuery query = (OjaiQuery)driver.newQuery().select(new String[]{fieldPathStr}).where(condition).build();
        return query;
    }

    @Test
    public void testQuery_bug27262() throws Exception {
        String rawTableName = "bug27262";
        this.addCleanupTable("bug27262");
        try (OjaiConnection ojaiConnection = TestOjaiQuery.getConnection();
             Table table = DBTests.createOrGetTable((String)"bug27262");){
            Path tablePath = table.getPath();
            String tableName = tablePath.toString();
            DBTests.createIndex((Table)table, (String)"bug27262_idx", (boolean)false, (int)0, (String[])new String[]{"i1"}, null, null);
            TestOjaiQuery.insertBug27262((Connection)ojaiConnection, table, "1", 1, "foo");
            TestOjaiQuery.insertBug27262((Connection)ojaiConnection, table, "2", 2, "bar");
            TestOjaiQuery.insertBug27262((Connection)ojaiConnection, table, "3", 3, "baz");
            DBTests.waitForIndexFlush((String)"bug27262");
            DBTests.waitForRowCount((String)"bug27262", (long)3L);
            try (DocumentStore docStore = ojaiConnection.getStore(tableName);){
                ArrayList emptyIntList = new ArrayList(0);
                ArrayList<Integer> intList = new ArrayList<Integer>();
                intList.add(2);
                intList.add(3);
                QueryCondition condition1 = this.driver.newCondition().in("i1", emptyIntList).build();
                try (DocumentStream docStream = docStore.findQuery((Query)TestOjaiQuery.makeQuery(this.driver, "i1", condition1));){
                    TestOjaiQuery.verifyQueryResultSize(docStream, 0);
                }
                QueryCondition condition2 = this.driver.newCondition().notIn("i1", emptyIntList).build();
                try (DocumentStream docStream = docStore.findQuery((Query)TestOjaiQuery.makeQuery(this.driver, "i1", condition2));){
                    TestOjaiQuery.verifyQueryResultSize(docStream, 3);
                }
                QueryCondition condition3 = this.driver.newCondition().and().in("i1", emptyIntList).in("i1", emptyIntList).close().build();
                try (DocumentStream docStream = docStore.findQuery((Query)TestOjaiQuery.makeQuery(this.driver, "i1", condition3));){
                    TestOjaiQuery.verifyQueryResultSize(docStream, 0);
                }
                QueryCondition condition4 = this.driver.newCondition().and().in("i1", emptyIntList).notIn("i1", emptyIntList).close().build();
                try (DocumentStream docStream = docStore.findQuery((Query)TestOjaiQuery.makeQuery(this.driver, "i1", condition4));){
                    TestOjaiQuery.verifyQueryResultSize(docStream, 0);
                }
                QueryCondition condition5 = this.driver.newCondition().and().notIn("i1", emptyIntList).notIn("i1", emptyIntList).close().build();
                try (DocumentStream docStream = docStore.findQuery((Query)TestOjaiQuery.makeQuery(this.driver, "i1", condition5));){
                    TestOjaiQuery.verifyQueryResultSize(docStream, 3);
                }
                QueryCondition condition6 = this.driver.newCondition().or().in("i1", emptyIntList).in("i1", emptyIntList).close().build();
                try (DocumentStream docStream = docStore.findQuery((Query)TestOjaiQuery.makeQuery(this.driver, "i1", condition6));){
                    TestOjaiQuery.verifyQueryResultSize(docStream, 0);
                }
                QueryCondition condition7 = this.driver.newCondition().or().in("i1", emptyIntList).notIn("i1", emptyIntList).close().build();
                try (DocumentStream docStream = docStore.findQuery((Query)TestOjaiQuery.makeQuery(this.driver, "i1", condition7));){
                    TestOjaiQuery.verifyQueryResultSize(docStream, 3);
                }
                QueryCondition condition8 = this.driver.newCondition().or().notIn("i1", emptyIntList).notIn("i1", emptyIntList).close().build();
                try (DocumentStream docStream = docStore.findQuery((Query)TestOjaiQuery.makeQuery(this.driver, "i1", condition8));){
                    TestOjaiQuery.verifyQueryResultSize(docStream, 3);
                }
                QueryCondition condition9 = this.driver.newCondition().or().in("i1", emptyIntList).and().notIn("i1", emptyIntList).in("i1", intList).close().close().build();
                try (DocumentStream docStream = docStore.findQuery((Query)TestOjaiQuery.makeQuery(this.driver, "i1", condition9));){
                    TestOjaiQuery.verifyQueryResultSize(docStream, 2);
                }
            }
        }
    }

    @Test
    public void testQuery_bug27089() throws Exception {
        try (OjaiConnection connection = TestOjaiQuery.getConnection();){
            String tableName = sharedTable27089.prepare((Connection)connection);
            ArrayList<Integer> intList = new ArrayList<Integer>(0);
            intList.add(17);
            intList.add(42);
            Query query = connection.newQuery().select(new String[]{"i1"}).where(this.driver.newCondition().in("i1", intList).build()).build();
            try (DocumentStore docStore = connection.getStore(tableName);
                 DocumentStream docStream = docStore.findQuery(query);){
                int docCount = 0;
                for (Document doc : docStream) {
                    int i = doc.getInt("i1");
                    Assert.assertTrue((boolean)intList.contains(i));
                    ++docCount;
                }
                Assert.assertEquals((long)2L, (long)docCount);
            }
        }
    }

    @Test
    public void testQuery_bug28100() throws Exception {
        try (OjaiConnection connection = TestOjaiQuery.getConnection();){
            String id;
            Throwable throwable;
            DocumentStream docStream2;
            Throwable throwable2;
            DocumentStore docStore;
            int docCount;
            Query query;
            String tableName = sharedTable27089.prepare((Connection)connection);
            String limitString = Long.toString(Long.MAX_VALUE);
            while (limitString.length() > 1) {
                query = connection.newQuery().limit(Long.parseLong(limitString)).build();
                docCount = 0;
                docStore = connection.getStore(tableName);
                throwable2 = null;
                try {
                    docStream2 = docStore.findQuery(query);
                    throwable = null;
                    try {
                        for (Document doc : docStream2) {
                            id = doc.getIdString();
                            Assert.assertNotNull((Object)id);
                            ++docCount;
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (docStream2 != null) {
                            if (throwable != null) {
                                try {
                                    docStream2.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                            } else {
                                docStream2.close();
                            }
                        }
                    }
                }
                catch (Throwable docStream2) {
                    throwable2 = docStream2;
                    throw docStream2;
                }
                finally {
                    if (docStore != null) {
                        if (throwable2 != null) {
                            try {
                                docStore.close();
                            }
                            catch (Throwable docStream2) {
                                throwable2.addSuppressed(docStream2);
                            }
                        } else {
                            docStore.close();
                        }
                    }
                }
                Assert.assertEquals((long)sharedTable27089.getNumRows(), (long)docCount);
                limitString = limitString.substring(0, limitString.length() - 1);
            }
            String offsetString = Long.toString(Long.MAX_VALUE);
            while (offsetString.length() > 1) {
                query = connection.newQuery().offset(Long.parseLong(offsetString)).build();
                docCount = 0;
                docStore = connection.getStore(tableName);
                throwable2 = null;
                try {
                    docStream2 = docStore.findQuery(query);
                    throwable = null;
                    try {
                        for (Document doc : docStream2) {
                            id = doc.getIdString();
                            Assert.assertNotNull((Object)id);
                            ++docCount;
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (docStream2 != null) {
                            if (throwable != null) {
                                try {
                                    docStream2.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                            } else {
                                docStream2.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable7) {
                    throwable2 = throwable7;
                    throw throwable7;
                }
                finally {
                    if (docStore != null) {
                        if (throwable2 != null) {
                            try {
                                docStore.close();
                            }
                            catch (Throwable throwable8) {
                                throwable2.addSuppressed(throwable8);
                            }
                        } else {
                            docStore.close();
                        }
                    }
                }
                Assert.assertEquals((long)0L, (long)docCount);
                offsetString = offsetString.substring(0, offsetString.length() - 1);
            }
        }
    }

    private static void bug27872Verify(DocumentStream docStream) {
        int docCount = 0;
        for (Document doc : docStream) {
            String id = doc.getIdString();
            Assert.assertEquals((Object)"3", (Object)id);
            String s1 = doc.getString("s1");
            Assert.assertEquals((Object)"baz", (Object)s1);
            Integer i1 = doc.getIntObj("i1");
            Assert.assertNull((Object)i1);
            Assert.assertEquals((long)1L, (long)doc.size());
            ++docCount;
        }
        Assert.assertEquals((long)1L, (long)docCount);
    }

    @Test
    public void testQuery_bug27872() throws Exception {
        try (OjaiConnection connection = TestOjaiQuery.getConnection();){
            String tableName = sharedTable27089.prepare((Connection)connection);
            try (DocumentStore docStore = connection.getStore(tableName);){
                Query query = connection.newQuery().select(new String[]{"s1"}).where(connection.newCondition().is("s1", QueryCondition.Op.EQUAL, "baz").build()).build();
                try (DocumentStream docStream = docStore.findQuery(query);){
                    TestOjaiQuery.bug27872Verify(docStream);
                }
                String queryString = "{\"$select\":\"s1\",\"$where\":{\"$eq\":{\"s1\":\"baz\"}}}";
                try (DocumentStream docStream = docStore.findQuery("{\"$select\":\"s1\",\"$where\":{\"$eq\":{\"s1\":\"baz\"}}}");){
                    TestOjaiQuery.bug27872Verify(docStream);
                }
            }
        }
    }

    @Test
    public void testCondition_bug27619() {
        QueryCondition condition = this.driver.newCondition().notIn("x", new ArrayList()).build();
    }

    @Test
    public void testQuery_bug27469() throws Exception {
        String rawTableName = "bug27469";
        this.addCleanupTable("bug27469");
        try (OjaiConnection connection = TestOjaiQuery.getConnection();
             Table table = DBTests.createOrGetTable((String)"bug27469");){
            Throwable throwable;
            Path tablePath = table.getPath();
            String tableName = tablePath.toString();
            DBTests.createIndex((Table)table, (String)"bug27469_idx", (boolean)false, (int)0, (String[])new String[]{"i1"}, null, null);
            TestOjaiQuery.insertBug27262((Connection)connection, table, "1", 1, "foo");
            TestOjaiQuery.insertBug27262((Connection)connection, table, "2", 42, "bar");
            TestOjaiQuery.insertBug27262((Connection)connection, table, "3", 3, "baz");
            TestOjaiQuery.insertBug27262((Connection)connection, table, "4", 17, "tip");
            DBTests.waitForIndexFlush((String)"bug27469");
            DBTests.waitForRowCount((String)"bug27469", (long)4L);
            Query queryNotEquals = connection.newQuery().select(new String[]{"i1", "_id"}).where(this.driver.newCondition().is("i1", QueryCondition.Op.NOT_EQUAL, 17).build()).build();
            try (DocumentStore docStore = connection.getStore(tableName);){
                throwable = null;
                try (DocumentStream docStream = docStore.findQuery(queryNotEquals);){
                    int docCount = 0;
                    for (Document doc : docStream) {
                        String id = doc.getIdString();
                        Assert.assertTrue((Integer.valueOf(id) > 0 ? 1 : 0) != 0);
                        int i1 = doc.getInt("i1");
                        Assert.assertNotEquals((long)17L, (long)i1);
                        ++docCount;
                    }
                    Assert.assertEquals((long)3L, (long)docCount);
                }
                catch (Throwable docCount) {
                    throwable = docCount;
                    throw docCount;
                }
            }
            ArrayList<Integer> intList = new ArrayList<Integer>(0);
            intList.add(17);
            intList.add(42);
            Query query = connection.newQuery().select(new String[]{"i1", "_id"}).where(connection.newCondition().notIn("i1", intList).build()).build();
            throwable = null;
            try (DocumentStore docStore = connection.getStore(tableName);){
                DocumentStream docStream = docStore.findQuery(query);
                Object object = null;
                try {
                    int docCount = 0;
                    for (Document doc : docStream) {
                        String id = doc.getIdString();
                        Assert.assertTrue((Integer.valueOf(id) > 0 ? 1 : 0) != 0);
                        int i = doc.getInt("i1");
                        Assert.assertFalse((boolean)intList.contains(i));
                        ++docCount;
                    }
                    Assert.assertEquals((long)2L, (long)docCount);
                }
                catch (Throwable throwable2) {
                    object = throwable2;
                    throw throwable2;
                }
                finally {
                    if (docStream != null) {
                        if (object != null) {
                            try {
                                docStream.close();
                            }
                            catch (Throwable throwable3) {
                                ((Throwable)object).addSuppressed(throwable3);
                            }
                        } else {
                            docStream.close();
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testQueryGeneration_limitError() {
        Query query = this.driver.newQuery();
        query.select(new String[]{"foo"});
        query.limit(-2L);
    }

    private Query makeEhcTestCase(Query query, String s1, String s2) {
        QueryCondition queryCond = this.driver.newCondition();
        queryCond.and().is("foo", QueryCondition.Op.GREATER_OR_EQUAL, s1).is("bar.f", QueryCondition.Op.EQUAL, s2).close().build();
        query.select(new String[]{"foo"}).select(new String[]{"bar"}).limit(17L).offset(42L).where(queryCond);
        return query.build();
    }

    @Test
    public void testQuery_equals_hashCode() {
        OjaiQuery query1 = (OjaiQuery)this.driver.newQuery();
        this.makeEhcTestCase((Query)query1, "abc", "Acme");
        OjaiQuery query2 = (OjaiQuery)this.driver.newQuery();
        this.makeEhcTestCase((Query)query2, "abc", "Excelsior");
        Assert.assertTrue((boolean)query1.structuralEquals(query2));
        Assert.assertEquals((long)query1.structuralHashCode(), (long)query2.structuralHashCode());
        Equivalence.Wrapper wrap1 = OjaiQuery.EQUIVALENCE.wrap((Object)query1);
        Equivalence.Wrapper wrap2 = OjaiQuery.EQUIVALENCE.wrap((Object)query2);
        Assert.assertTrue((boolean)wrap1.equals((Object)wrap2));
        Assert.assertEquals((long)wrap1.hashCode(), (long)wrap2.hashCode());
        QueryCondition queryCond3 = this.driver.newCondition();
        queryCond3.or().is("x", QueryCondition.Op.EQUAL, "x").is("y", QueryCondition.Op.EQUAL, "y").close().build();
        OjaiQuery query3 = (OjaiQuery)this.driver.newQuery();
        query3.select(new String[]{"baz"}).where(queryCond3).build();
        Assert.assertFalse((boolean)query3.structuralEquals(query1));
        Assert.assertNotEquals((long)query3.structuralHashCode(), (long)query1.structuralHashCode());
        Equivalence.Wrapper wrap3 = OjaiQuery.EQUIVALENCE.wrap((Object)query3);
        Assert.assertFalse((boolean)wrap3.equals((Object)wrap1));
        Assert.assertNotEquals((long)wrap3.hashCode(), (long)wrap1.hashCode());
    }

    @Test
    public void testFlatteningLogicalOperators() {
        OjaiQuery query1 = (OjaiQuery)this.driver.newQuery().where(this.driver.newCondition().and().is("foo", QueryCondition.Op.EQUAL, "x").is("bar", QueryCondition.Op.EQUAL, "y").is("baz", QueryCondition.Op.EQUAL, "z").is("gleep", QueryCondition.Op.EQUAL, "w").close().build()).build();
        String sql1 = query1.buildSqlString("dfs", "mytable");
        TestOjaiQuery.assertEncodedFields(sql1, "*", "_id");
        OjaiQuery query2 = (OjaiQuery)this.driver.newQuery().where(this.driver.newCondition().and().is("foo", QueryCondition.Op.EQUAL, "x").is("bar", QueryCondition.Op.EQUAL, "y").and().is("baz", QueryCondition.Op.EQUAL, "z").is("gleep", QueryCondition.Op.EQUAL, "w").close().close().build()).build();
        String sql2 = query2.buildSqlString("dfs", "mytable");
        TestOjaiQuery.assertEncodedFields(sql2, "*", "_id");
        OjaiQuery query3 = (OjaiQuery)this.driver.newQuery().where(this.driver.newCondition().and().and().is("foo", QueryCondition.Op.EQUAL, "x").is("bar", QueryCondition.Op.EQUAL, "y").close().and().is("baz", QueryCondition.Op.EQUAL, "z").is("gleep", QueryCondition.Op.EQUAL, "w").close().close().build()).build();
        String sql3 = query3.buildSqlString("dfs", "mytable");
        TestOjaiQuery.assertEncodedFields(sql3, "*", "_id");
        OjaiQuery query4 = (OjaiQuery)this.driver.newQuery().where(this.driver.newCondition().and().and().is("foo", QueryCondition.Op.EQUAL, "x").is("bar", QueryCondition.Op.EQUAL, "y").close().or().is("baz", QueryCondition.Op.EQUAL, "z").is("baz", QueryCondition.Op.EQUAL, "q").or().is("baz", QueryCondition.Op.EQUAL, "r").is("baz", QueryCondition.Op.EQUAL, "s").close().close().and().is("gleep", QueryCondition.Op.EQUAL, "w").is("flubber", QueryCondition.Op.EQUAL, "t").close().close().build()).build();
        String sql4 = query4.buildSqlString("dfs", "mytable");
        TestOjaiQuery.assertEncodedFields(sql4, "*", "_id");
    }

    @Test
    public void testIdEquals() {
        String theId = "x";
        OjaiQuery queryId = (OjaiQuery)this.driver.newQuery().where(this.driver.newCondition().is(DocumentConstants.ID_FIELD, QueryCondition.Op.EQUAL, "x").build()).build();
        QueryAnalyzer idAnalzyer = queryId.getQueryAnalyzer();
        Assert.assertTrue((boolean)idAnalzyer.isIdEquals());
        Assert.assertEquals((Object)"x", (Object)idAnalzyer.getIdForLookup());
        OjaiQuery queryOther = (OjaiQuery)this.driver.newQuery().where(this.driver.newCondition().is("foo", QueryCondition.Op.EQUAL, "x").build()).build();
        QueryAnalyzer otherAnalyzer = queryOther.getQueryAnalyzer();
        Assert.assertFalse((boolean)otherAnalyzer.isIdEquals());
    }

    private static boolean hasSameLiterals(List<String> idList, List<LiteralExpression> values) {
        if (idList.size() != values.size()) {
            return false;
        }
        ArrayList<String> sortedIdList = new ArrayList<String>(idList);
        Collections.sort(sortedIdList);
        ArrayList<String> sortedValueList = new ArrayList<String>(values.size());
        for (LiteralExpression litExpr : values) {
            sortedValueList.add(litExpr.getString());
        }
        Collections.sort(sortedValueList);
        return sortedIdList.equals(sortedValueList);
    }

    @Test
    public void testFieldIn() {
        LinkedList<String> idList = new LinkedList<String>();
        idList.add("x");
        idList.add("y");
        idList.add("z");
        idList.add("w");
        OjaiQuery queryIn = (OjaiQuery)this.driver.newQuery().where(this.driver.newCondition().in(DocumentConstants.ID_FIELD, idList).build()).build();
        QueryAnalyzer inAnalyzer = queryIn.getQueryAnalyzer();
        FieldInBundle fibIn = inAnalyzer.getFieldInBundle();
        Assert.assertNotNull((Object)fibIn);
        Assert.assertEquals((Object)DocumentConstants.ID_FIELD, (Object)fibIn.fieldPath);
        Assert.assertTrue((boolean)TestOjaiQuery.hasSameLiterals(idList, fibIn.values));
        OjaiQuery queryOrEquals = (OjaiQuery)this.driver.newQuery().where(this.driver.newCondition().or().or().is(DocumentConstants.ID_FIELD, QueryCondition.Op.EQUAL, "z").is(DocumentConstants.ID_FIELD, QueryCondition.Op.EQUAL, "w").close().is(DocumentConstants.ID_FIELD, QueryCondition.Op.EQUAL, "y").is(DocumentConstants.ID_FIELD, QueryCondition.Op.EQUAL, "x").close().build()).build();
        QueryAnalyzer orEqualsAnalyzer = queryOrEquals.getQueryAnalyzer();
        FieldInBundle fibOrEquals = orEqualsAnalyzer.getFieldInBundle();
        Assert.assertNotNull((Object)fibOrEquals);
        Assert.assertEquals((Object)DocumentConstants.ID_FIELD, (Object)fibOrEquals.fieldPath);
        Assert.assertTrue((boolean)TestOjaiQuery.hasSameLiterals(idList, fibOrEquals.values));
    }

    private static Document insertAbc(OjaiConnection ojaiConnection, Table table, String id, int a, int b, int c) {
        Document document = ojaiConnection.newDocument();
        document.set("_id", id);
        document.set("a", a);
        document.set("b", b);
        document.set("c", c);
        table.insert(document);
        return document;
    }

    @Test
    public void testPlanning_eligibleIndexes() throws Exception {
        String rawTableName = "ei_one";
        this.addCleanupTable("ei_one");
        AdminImpl admin = DBTests.admin();
        try (OjaiConnection ojaiConnection = TestOjaiQuery.getConnection();
             Table table = DBTests.createOrGetTable((String)"ei_one");){
            BaseJsonTable jsonTable = (BaseJsonTable)table;
            Path tablePath = table.getPath();
            OjaiQuery querya = (OjaiQuery)this.driver.newQuery().select(new String[]{"a"}).select(new String[]{"b"}).where(this.driver.newCondition().and().is("a", QueryCondition.Op.LESS, 42).is("a", QueryCondition.Op.GREATER_OR_EQUAL, 12).close().build()).build();
            SharedTable sharedTable = new SharedTable(jsonTable);
            List indexes = querya.getEligibleIndexes((Admin)admin, tablePath, sharedTable, ojaiConnection);
            Assert.assertEquals((long)0L, (long)indexes.size());
            String coveringName = "aIdx";
            DBTests.createIndex((Table)table, (String)"aIdx", (boolean)false, (int)0, (String[])new String[]{"a"}, null, (String[])new String[]{"b"});
            indexes = querya.getEligibleIndexes((Admin)admin, tablePath, sharedTable, ojaiConnection);
            Assert.assertEquals((long)1L, (long)indexes.size());
            EligibleIndex eligibleIndex = (EligibleIndex)indexes.get(0);
            IndexDesc indexDesc = eligibleIndex.indexDesc;
            Assert.assertEquals((Object)"aIdx", (Object)DBTests.getNameWithoutPath((String)indexDesc.getIndexName()));
            Assert.assertEquals((Object)tablePath.toString(), (Object)indexDesc.getPrimaryTablePath());
            Assert.assertTrue((boolean)eligibleIndex.isCovering);
            String goldConditiona = "((a < {\"$numberLong\":42}) and (a >= {\"$numberLong\":12}))";
            QueryCondition scanConditiona = querya.getScanCondition(ojaiConnection, eligibleIndex);
            Assert.assertEquals((Object)"((a < {\"$numberLong\":42}) and (a >= {\"$numberLong\":12}))", (Object)scanConditiona.toString());
            String nonCoveringName = "cIdx";
            DBTests.createIndex((Table)table, (String)"cIdx", (boolean)false, (int)0, (String[])new String[]{"c"}, null, null);
            indexes = querya.getEligibleIndexes((Admin)admin, tablePath, sharedTable, ojaiConnection);
            Assert.assertEquals((long)1L, (long)indexes.size());
            eligibleIndex = (EligibleIndex)indexes.get(0);
            Assert.assertEquals((Object)"aIdx", (Object)DBTests.getNameWithoutPath((String)indexDesc.getIndexName()));
            OjaiQuery queryac = (OjaiQuery)this.driver.newQuery().where(this.driver.newCondition().and().is("a", QueryCondition.Op.LESS, 42).is("c", QueryCondition.Op.GREATER_OR_EQUAL, 12).close().build()).build();
            indexes = queryac.getEligibleIndexes((Admin)admin, tablePath, sharedTable, ojaiConnection);
            Assert.assertEquals((long)2L, (long)indexes.size());
            Collections.sort(indexes, new Comparator<EligibleIndex>(){

                @Override
                public int compare(EligibleIndex o1, EligibleIndex o2) {
                    return DBTests.getNameWithoutPath((String)o1.indexDesc.getIndexName()).compareTo(DBTests.getNameWithoutPath((String)o2.indexDesc.getIndexName()));
                }
            });
            eligibleIndex = (EligibleIndex)indexes.get(0);
            indexDesc = eligibleIndex.indexDesc;
            Assert.assertEquals((Object)"aIdx", (Object)DBTests.getNameWithoutPath((String)indexDesc.getIndexName()));
            Assert.assertFalse((boolean)eligibleIndex.isCovering);
            String goldScanConditionaOpen = "(a < {\"$numberLong\":42})";
            QueryCondition scanConditionaOpen = queryac.getScanCondition(ojaiConnection, eligibleIndex);
            Assert.assertEquals((Object)"(a < {\"$numberLong\":42})", (Object)scanConditionaOpen.toString());
            eligibleIndex = (EligibleIndex)indexes.get(1);
            indexDesc = eligibleIndex.indexDesc;
            Assert.assertEquals((Object)"cIdx", (Object)DBTests.getNameWithoutPath((String)indexDesc.getIndexName()));
            Assert.assertFalse((boolean)eligibleIndex.isCovering);
            Assert.assertEquals((Object)tablePath.toString(), (Object)indexDesc.getPrimaryTablePath());
            String goldScanConditioncOpen = "(c >= {\"$numberLong\":12})";
            QueryCondition scanConditioncOpen = queryac.getScanCondition(ojaiConnection, eligibleIndex);
            Assert.assertEquals((Object)"(c >= {\"$numberLong\":12})", (Object)scanConditioncOpen.toString());
            Document includedDoc = TestOjaiQuery.insertAbc(ojaiConnection, table, "1", 30, 45, 7);
            TestOjaiQuery.insertAbc(ojaiConnection, table, "2", 45, 100, 17);
            TestOjaiQuery.insertAbc(ojaiConnection, table, "3", 50, 144, 0);
            table.flush();
            DBTests.waitForIndexFlush((Path)tablePath);
            DocumentStore docStore = ojaiConnection.getStore(tablePath.toString());
            OjaiTest.DocumentStreamRef docRef = new OjaiTest.DocumentStreamRef();
            Query queryaeq = this.driver.newQuery().select(new String[]{"a"}).select(new String[]{"b"}).where(this.driver.newCondition().is("a", QueryCondition.Op.EQUAL, 30).build()).build();
            List<Document> queryaeqResult = OjaiTest.collectStreamingFind(docStore, queryaeq, 5, docRef);
            Assert.assertEquals((long)1L, (long)queryaeqResult.size());
            Assert.assertTrue((boolean)OjaiTest.isNearlyEqual(includedDoc, queryaeqResult.get(0)));
            Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)OjaiTest.getQueryPath(docRef.docStream));
            List<Document> queryaResult = OjaiTest.collectStreamingFind(docStore, (Query)querya, 5, docRef);
            Assert.assertEquals((long)1L, (long)queryaResult.size());
            Assert.assertTrue((boolean)OjaiTest.isNearlyEqual(includedDoc, queryaResult.get(0)));
            Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)OjaiTest.getQueryPath(docRef.docStream));
        }
    }

    @Test
    public void testPlanning_sortKeyIndexSuffix() throws Exception {
        String rawTableName = "ei_suffix_sort";
        this.addCleanupTable("ei_suffix_sort");
        AdminImpl admin = DBTests.admin();
        try (OjaiConnection ojaiConnection = TestOjaiQuery.getConnection();
             Table table = DBTests.createOrGetTable((String)"ei_suffix_sort");){
            BaseJsonTable jsonTable = (BaseJsonTable)table;
            Path tablePath = table.getPath();
            OjaiQuery querya = (OjaiQuery)this.driver.newQuery().select(new String[]{"a"}).select(new String[]{"b"}).select(new String[]{"c"}).where(this.driver.newCondition().and().is("a", QueryCondition.Op.EQUAL, 42).is("b", QueryCondition.Op.EQUAL, 17).close().build()).orderBy("c", SortOrder.ASC).build();
            SharedTable sharedTable = new SharedTable(jsonTable);
            List indexes = querya.getEligibleIndexes((Admin)admin, tablePath, sharedTable, ojaiConnection);
            Assert.assertEquals((long)0L, (long)indexes.size());
            String coveringName = "abc_Idx";
            DBTests.createIndex((Table)table, (String)"abc_Idx", (boolean)false, (int)0, (String[])new String[]{"a", "b", "c"}, (SortOrder[])new SortOrder[]{SortOrder.DESC}, null);
            indexes = querya.getEligibleIndexes((Admin)admin, tablePath, sharedTable, ojaiConnection);
            Assert.assertEquals((long)1L, (long)indexes.size());
            EligibleIndex eligibleIndex = (EligibleIndex)indexes.get(0);
            IndexDesc indexDesc = eligibleIndex.indexDesc;
            Assert.assertEquals((Object)"abc_Idx", (Object)DBTests.getNameWithoutPath((String)indexDesc.getIndexName()));
            Assert.assertEquals((Object)tablePath.toString(), (Object)indexDesc.getPrimaryTablePath());
            Assert.assertTrue((boolean)eligibleIndex.isCovering);
            String goldConditiona = "((a = {\"$numberLong\":42}) and (b = {\"$numberLong\":17}))";
            QueryCondition scanConditiona = querya.getScanCondition(ojaiConnection, eligibleIndex);
            Assert.assertEquals((Object)"((a = {\"$numberLong\":42}) and (b = {\"$numberLong\":17}))", (Object)scanConditiona.toString());
            TestOjaiQuery.insertAbc(ojaiConnection, table, "1", 41, 16, 7);
            TestOjaiQuery.insertAbc(ojaiConnection, table, "2", 43, 18, 7);
            TestOjaiQuery.insertAbc(ojaiConnection, table, "3", 42, 17, 7);
            TestOjaiQuery.insertAbc(ojaiConnection, table, "4", 42, 17, 5);
            TestOjaiQuery.insertAbc(ojaiConnection, table, "5", 42, 17, 6);
            TestOjaiQuery.insertAbc(ojaiConnection, table, "6", 42, 17, 4);
            DBTests.waitForIndexFlush((Path)tablePath);
            DBTests.waitForRowCount((String)"ei_suffix_sort", (long)6L);
            DocumentStore docStore = ojaiConnection.getStore(tablePath.toString());
            DocumentStream docStream = docStore.findQuery((Query)querya);
            Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)OjaiTest.getQueryPath(docStream));
            int docCount = 0;
            int lastC = Integer.MIN_VALUE;
            for (Document doc : docStream) {
                ++docCount;
                int c = doc.getInt("c");
                Assert.assertTrue((c > lastC ? 1 : 0) != 0);
                lastC = c;
            }
            Assert.assertEquals((long)4L, (long)docCount);
        }
    }

    @Test
    public void testPlanning_hashedIndexSort() throws Exception {
        String rawTableName = "ei_hashed";
        this.addCleanupTable("ei_hashed");
        AdminImpl admin = DBTests.admin();
        try (OjaiConnection ojaiConnection = TestOjaiQuery.getConnection();
             Table table = DBTests.createOrGetTable((String)"ei_hashed");){
            BaseJsonTable jsonTable = (BaseJsonTable)table;
            Path tablePath = table.getPath();
            DBTests.createIndex((Table)table, (String)"ei_hashed_hashedIdx", (boolean)true, (int)2, (String[])new String[]{"c"}, null, null);
            OjaiQuery query = (OjaiQuery)this.driver.newQuery().setOption("ojai.mapr.query.use-index", (Object)"_hashedIdx").select(new String[]{"a", "b", "c"}).where(this.driver.newCondition().is("c", QueryCondition.Op.EQUAL, 42).build()).build();
            SharedTable sharedTable = new SharedTable(jsonTable);
            List indexes = query.getEligibleIndexes((Admin)admin, tablePath, sharedTable, ojaiConnection);
            Assert.assertEquals((long)1L, (long)indexes.size());
            OjaiQuery querySort = (OjaiQuery)this.driver.newQuery().setOption("ojai.mapr.query.use-index", (Object)"_hashedIdx").select(new String[]{"a", "b", "c"}).where(this.driver.newCondition().is("c", QueryCondition.Op.EQUAL, 42).build()).orderBy("c", SortOrder.ASC).build();
            indexes = querySort.getEligibleIndexes((Admin)admin, tablePath, sharedTable, ojaiConnection);
            Assert.assertEquals((long)0L, (long)indexes.size());
        }
    }

    @Test
    public void testQuery_analyzerPruning() {
        String tableAlias = "t";
        FieldPath fpa = FieldPath.parseFrom((String)"a");
        HashSet<FieldPath> aSet = new HashSet<FieldPath>(1);
        aSet.add(fpa);
        FieldPath fpc = FieldPath.parseFrom((String)"c");
        HashSet<FieldPath> cSet = new HashSet<FieldPath>(1);
        cSet.add(fpc);
        try (OjaiConnection ojaiConnection = TestOjaiQuery.getConnection();){
            OjaiQuery oq1 = (OjaiQuery)this.driver.newQuery().where(this.driver.newCondition().and().is(fpa, QueryCondition.Op.LESS, 42).is(fpc, QueryCondition.Op.GREATER_OR_EQUAL, 12).close().build()).build();
            QueryAnalyzer qa1 = oq1.getQueryAnalyzer();
            String a1SqlGold = "(t.`a` < 42)";
            Expression a1Expr = qa1.getPrunedExpression(aSet);
            String a1Sql = ExpressionToSql.convert((Expression)a1Expr, (String)"t");
            Assert.assertEquals((Object)"(t.`a` < 42)", (Object)a1Sql);
            String a1CondGold = "(a < {\"$numberLong\":42})";
            QueryCondition aqc1 = ExpressionToCondition.convert((Expression)a1Expr, (OjaiConnection)ojaiConnection);
            Assert.assertEquals((Object)"(a < {\"$numberLong\":42})", (Object)aqc1.toString());
            String c1SqlGold = "(t.`c` >= 12)";
            Expression c1Expr = qa1.getPrunedExpression(cSet);
            String c1Sql = ExpressionToSql.convert((Expression)c1Expr, (String)"t");
            Assert.assertEquals((Object)"(t.`c` >= 12)", (Object)c1Sql);
            String c1CondGold = "(c >= {\"$numberLong\":12})";
            QueryCondition cqc1 = ExpressionToCondition.convert((Expression)c1Expr, (OjaiConnection)ojaiConnection);
            Assert.assertEquals((Object)"(c >= {\"$numberLong\":12})", (Object)cqc1.toString());
            ImmutableList aList = ImmutableList.of((Object)19, (Object)23, (Object)47);
            OjaiQuery oq2 = (OjaiQuery)this.driver.newQuery().where(this.driver.newCondition().and().is(fpa, QueryCondition.Op.LESS, 42).is(fpc, QueryCondition.Op.GREATER_OR_EQUAL, 12).and().is("b", QueryCondition.Op.EQUAL, 7).is(fpc, QueryCondition.Op.LESS, 144).in(fpa, (List)aList).close().close().build()).build();
            QueryAnalyzer qa2 = oq2.getQueryAnalyzer();
            String a2SqlGold = "((t.`a` < 42) and ((t.`a` = 19) or (t.`a` = 23) or (t.`a` = 47)))";
            Expression a2Expr = qa2.getPrunedExpression(aSet);
            String a2Sql = ExpressionToSql.convert((Expression)a2Expr, (String)"t");
            Assert.assertEquals((Object)"((t.`a` < 42) and ((t.`a` = 19) or (t.`a` = 23) or (t.`a` = 47)))", (Object)a2Sql);
            String a2CondGold = "((a < {\"$numberLong\":42}) and ((a = {\"$numberLong\":19}) or (a = {\"$numberLong\":23}) or (a = {\"$numberLong\":47})))";
            QueryCondition aqc2 = ExpressionToCondition.convert((Expression)a2Expr, (OjaiConnection)ojaiConnection);
            Assert.assertEquals((Object)"((a < {\"$numberLong\":42}) and ((a = {\"$numberLong\":19}) or (a = {\"$numberLong\":23}) or (a = {\"$numberLong\":47})))", (Object)aqc2.toString());
            String c2SqlGold = "((t.`c` >= 12) and (t.`c` < 144))";
            Expression c2Expr = qa2.getPrunedExpression(cSet);
            String c2Sql = ExpressionToSql.convert((Expression)c2Expr, (String)"t");
            Assert.assertEquals((Object)"((t.`c` >= 12) and (t.`c` < 144))", (Object)c2Sql);
            String c2CondGold = "((c >= {\"$numberLong\":12}) and (c < {\"$numberLong\":144}))";
            QueryCondition cqc2 = ExpressionToCondition.convert((Expression)c2Expr, (OjaiConnection)ojaiConnection);
            Assert.assertEquals((Object)"((c >= {\"$numberLong\":12}) and (c < {\"$numberLong\":144}))", (Object)cqc2.toString());
        }
    }

    @Test
    public void testQueryGeneration_udf() {
        Query sizeOfQuery = this.driver.newQuery().select(new String[]{"foo"}).where(this.driver.newCondition().sizeOf("foo", QueryCondition.Op.GREATER_OR_EQUAL, 2L).build());
        OjaiQuery sizeOfOjaiQuery = (OjaiQuery)sizeOfQuery.build();
        String sizeOfSqlString = sizeOfOjaiQuery.buildSqlString("dfs", "sometable");
        TestOjaiQuery.assertEncodedFields(sizeOfSqlString, "foo", "_id");
        Query typeOfQuery = this.driver.newQuery().select(new String[]{"foo"}).where(this.driver.newCondition().typeOf("foo", Value.Type.STRING).build());
        OjaiQuery typeOfOjaiQuery = (OjaiQuery)typeOfQuery.build();
        String typeOfSqlString = typeOfOjaiQuery.buildSqlString("dfs", "sometable");
        TestOjaiQuery.assertEncodedFields(typeOfSqlString, "foo", "_id");
        Query notTypeOfQuery = this.driver.newQuery().select(new String[]{"foo"}).where(this.driver.newCondition().notTypeOf("foo", Value.Type.INT).build());
        OjaiQuery notTypeOfOjaiQuery = (OjaiQuery)notTypeOfQuery.build();
        String notTypeOfSqlString = notTypeOfOjaiQuery.buildSqlString("dfs", "sometable");
        TestOjaiQuery.assertEncodedFields(notTypeOfSqlString, "foo", "_id");
        Query matchesQuery = this.driver.newQuery().select(new String[]{"foo"}).where(this.driver.newCondition().matches("foo", "[0-9]+").build());
        OjaiQuery matchesOjaiQuery = (OjaiQuery)matchesQuery.build();
        String matchesSqlString = matchesOjaiQuery.buildSqlString("dfs", "sometable");
        TestOjaiQuery.assertEncodedFields(matchesSqlString, "foo", "_id");
        Query notMatchesQuery = this.driver.newQuery().select(new String[]{"foo"}).where(this.driver.newCondition().notMatches("foo", "[0-9]+").build());
        OjaiQuery notMatchesOjaiQuery = (OjaiQuery)notMatchesQuery.build();
        String notMatchesSqlString = notMatchesOjaiQuery.buildSqlString("dfs", "sometable");
        TestOjaiQuery.assertEncodedFields(notMatchesSqlString, "foo", "_id");
        LinkedList<Integer> equalsList = new LinkedList<Integer>();
        equalsList.add(17);
        equalsList.add(42);
        equalsList.add(2010);
        Query equalsQuery = this.driver.newQuery().select(new String[]{"foo"}).where(this.driver.newCondition().equals("foo", equalsList).build());
        OjaiQuery equalsOjaiQuery = (OjaiQuery)equalsQuery.build();
        String equalsSqlString = equalsOjaiQuery.buildSqlString("dfs", "sometable");
        TestOjaiQuery.assertEncodedFields(equalsSqlString, "foo", "_id");
    }

    @Test
    public void testQueryOnInt() throws Exception {
        QueryOnInt test = new QueryOnInt();
        String rawTableName = "conditionOnIntTest";
        this.addCleanupTable("conditionOnIntTest");
        try (OjaiConnection connection = TestOjaiQuery.getConnection();
             Table table = DBTests.createOrGetTable((String)"conditionOnIntTest");){
            Path tablePath = table.getPath();
            String tableName = tablePath.toString();
            test.insertDocs((Connection)connection, table, "conditionOnIntTest");
            try (DocumentStore docStore = connection.getStore(tableName);){
                test.runQueries((Connection)connection, docStore, OjaiQueryProperties.QueryPath.DIRECT);
                DBTests.createIndex((Table)table, (String)"conditionOnIntTest_idx", (boolean)false, (int)0, (String[])new String[]{"d1", "d2"}, null, null);
                DBTests.waitForIndexFlush((String)"conditionOnIntTest");
                test.runQueries((Connection)connection, docStore, OjaiQueryProperties.QueryPath.DIRECT);
            }
        }
    }

    @Test
    public void testQueryOnInt0() throws Exception {
        QueryOnInt0 test = new QueryOnInt0();
        String rawTableName = "conditionOnIntTest0";
        this.addCleanupTable("conditionOnIntTest0");
        try (OjaiConnection connection = TestOjaiQuery.getConnection();
             Table table = DBTests.createOrGetTable((String)"conditionOnIntTest0");){
            Path tablePath = table.getPath();
            String tableName = tablePath.toString();
            test.insertDocs((Connection)connection, table, "conditionOnIntTest0");
            try (DocumentStore docStore = connection.getStore(tableName);){
                test.runQueries((Connection)connection, docStore, OjaiQueryProperties.QueryPath.DIRECT);
                DBTests.createIndex((Table)table, (String)"conditionOnIntTest0_idx", (boolean)false, (int)0, (String[])new String[]{"d1", "d2", "d3", "d4"}, null, null);
                DBTests.waitForIndexFlush((String)"conditionOnIntTest0");
                test.runQueries((Connection)connection, docStore, OjaiQueryProperties.QueryPath.DIRECT);
            }
        }
    }

    @Test
    public void testQueryOnTime() throws Exception {
        QueryOnTime test = new QueryOnTime();
        String rawTableName = "conditionOnTimeTest";
        this.addCleanupTable("conditionOnTimeTest");
        try (OjaiConnection connection = TestOjaiQuery.getConnection();
             Table table = DBTests.createOrGetTable((String)"conditionOnTimeTest");){
            Path tablePath = table.getPath();
            String tableName = tablePath.toString();
            test.insertDocs((Connection)connection, table, "conditionOnTimeTest");
            try (DocumentStore docStore = connection.getStore(tableName);){
                test.runQueries((Connection)connection, docStore, OjaiQueryProperties.QueryPath.DIRECT);
                DBTests.createIndex((Table)table, (String)"conditionOnTimeTest_idx", (boolean)false, (int)0, (String[])new String[]{"d1", "d2"}, null, null);
                DBTests.waitForIndexFlush((String)"conditionOnTimeTest");
                test.runQueries((Connection)connection, docStore, OjaiQueryProperties.QueryPath.DIRECT);
            }
        }
    }

    @Test
    public void testQueryOnTimestamp() throws Exception {
        QueryOnTimestamp test = new QueryOnTimestamp();
        String rawTableName = "conditionOnTimestampTest";
        this.addCleanupTable("conditionOnTimestampTest");
        try (OjaiConnection connection = TestOjaiQuery.getConnection();
             Table table = DBTests.createOrGetTable((String)"conditionOnTimestampTest");){
            Path tablePath = table.getPath();
            String tableName = tablePath.toString();
            test.insertDocs((Connection)connection, "conditionOnTimestampTest", table);
            try (DocumentStore docStore = connection.getStore(tableName);){
                test.runQueries((Connection)connection, docStore, OjaiQueryProperties.QueryPath.DIRECT);
                DBTests.createIndex((Table)table, (String)"conditionOnTimestampTest_idx", (boolean)false, (int)0, (String[])new String[]{"d1", "d2"}, null, null);
                DBTests.waitForIndexFlush((String)"conditionOnTimestampTest");
                test.runQueries((Connection)connection, docStore, OjaiQueryProperties.QueryPath.DIRECT);
            }
        }
    }

    @Test
    public void testQueryOnDate() throws Exception {
        String rawTableName = "conditionOnDateTest";
        this.addCleanupTable("conditionOnDateTest");
        QueryOnDate test = new QueryOnDate();
        try (OjaiConnection connection = TestOjaiQuery.getConnection();
             Table table = DBTests.createOrGetTable((String)"conditionOnDateTest");){
            Path tablePath = table.getPath();
            String tableName = tablePath.toString();
            test.insertDocs((Connection)connection, table, "conditionOnDateTest");
            try (DocumentStore docStore = connection.getStore(tableName);){
                test.runQueries((Connection)connection, docStore, OjaiQueryProperties.QueryPath.DIRECT);
                DBTests.createIndex((Table)table, (String)"conditionOnDateTest_idx", (boolean)false, (int)0, (String[])new String[]{"d1", "d2"}, null, null);
                DBTests.waitForIndexFlush((String)"conditionOnDateTest");
                test.runQueries((Connection)connection, docStore, OjaiQueryProperties.QueryPath.DIRECT);
            }
        }
    }

    @Test
    public void testQueriesOnDateTimestampTime() throws Exception {
        String rawTableName = "conditionOnDateTimestampTimeTest";
        this.addCleanupTable("conditionOnDateTimestampTimeTest");
        try (OjaiConnection connection = TestOjaiQuery.getConnection();
             Table table = DBTests.createOrGetTable((String)"conditionOnDateTimestampTimeTest");){
            Path tablePath = table.getPath();
            String tableName = tablePath.toString();
            QueriesOnDateTimestampTime.insertDocs((Connection)connection, table);
            DBTests.waitForRowCount((String)"conditionOnDateTimestampTimeTest", (long)9L);
            try (DocumentStore docStore = connection.getStore(tableName);){
                DBTests.createIndex((Table)table, (String)"conditionOnDateTimestampTimeTest_idx", (boolean)false, (int)0, (String[])new String[]{"d1", "d2"}, null, null);
                DBTests.waitForIndexFlush((String)"conditionOnDateTimestampTimeTest");
                QueriesOnDateTimestampTime.runQueries((Connection)connection, docStore, OjaiQueryProperties.QueryPath.DIRECT);
            }
        }
    }

    private static void insertBug27093(Connection connection, Table table, String id, ODate d1, ODate d2) {
        Document doc = connection.newDocument();
        doc.setId(id);
        doc.set("d1", d1);
        doc.set("d2", d2);
        table.insert(doc);
    }

    @Test
    public void testQuery_bug27093() throws Exception {
        String rawTableName = "bug27093";
        this.addCleanupTable("bug27093");
        try (OjaiConnection connection = TestOjaiQuery.getConnection();
             Table table = DBTests.createOrGetTable((String)"bug27093");){
            Path tablePath = table.getPath();
            String tableName = tablePath.toString();
            String indexName = "bug27093_idx";
            DBTests.createIndex((Table)table, (String)"bug27093_idx", (boolean)false, (int)0, (String[])new String[]{"d1", "d2"}, null, null);
            ODate theDate = new ODate(2001, 4, 5);
            TestOjaiQuery.insertBug27093((Connection)connection, table, "1", new ODate(2000, 3, 4), new ODate(2017, 5, 15));
            TestOjaiQuery.insertBug27093((Connection)connection, table, "2", theDate, new ODate(2017, 5, 15));
            TestOjaiQuery.insertBug27093((Connection)connection, table, "3", new ODate(2002, 5, 6), new ODate(2017, 5, 15));
            DBTests.waitForIndexFlush((String)"bug27093");
            DBTests.waitForRowCount((String)"bug27093", (long)3L);
            Query query = connection.newQuery().select(new String[]{"d1"}).where(connection.newCondition().and().is("d1", QueryCondition.Op.EQUAL, theDate).close().build()).build();
            try (DocumentStore docStore = connection.getStore(tableName);
                 DocumentStream docStream = docStore.findQuery(query);){
                int docCount = 0;
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertEquals((Object)"2", (Object)id);
                    ODate d1 = doc.getDate("d1");
                    Assert.assertEquals((Object)theDate, (Object)d1);
                    ++docCount;
                }
                Assert.assertEquals((long)1L, (long)docCount);
                Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)TestOjaiQuery.getQueryPath(docStream));
                Assert.assertEquals((Object)"bug27093_idx", (Object)TestOjaiQuery.getIndexUsed(docStream));
            }
        }
    }

    private static void insertBug27256(Connection connection, Table table, String id, String bytesAsString, int i) {
        Document doc = connection.newDocument();
        doc.setId(id);
        ByteBuffer d1 = ByteBuffer.wrap(bytesAsString.getBytes());
        doc.set("b1", d1);
        doc.set("i1", i);
        table.insert(doc);
    }

    @Test
    public void testQuery_bug27256() throws Exception {
        String rawTableName = "q_binary";
        this.addCleanupTable("q_binary");
        try (OjaiConnection ojaiConnection = TestOjaiQuery.getConnection();
             Table table = DBTests.createOrGetTable((String)"q_binary");){
            boolean[] useDrillOptions;
            Path tablePath = table.getPath();
            String tableName = tablePath.toString();
            DBTests.createIndex((Table)table, (String)"q_binary_idx", (boolean)false, (int)0, (String[])new String[]{"b1"}, null, null);
            String theOne = "The quick brown fox jumped over the lazy dog.";
            byte[] theOneBytes = "The quick brown fox jumped over the lazy dog.".getBytes();
            ByteBuffer theOneBuffer = ByteBuffer.wrap(theOneBytes);
            TestOjaiQuery.insertBug27256((Connection)ojaiConnection, table, "1", "foo", 1);
            TestOjaiQuery.insertBug27256((Connection)ojaiConnection, table, "2", "The quick brown fox jumped over the lazy dog.", 2);
            TestOjaiQuery.insertBug27256((Connection)ojaiConnection, table, "3", "bar", 3);
            DBTests.waitForIndexFlush((String)"q_binary");
            DBTests.waitForRowCount((String)"q_binary", (long)3L);
            for (boolean useDrill : useDrillOptions = new boolean[]{true, false}) {
                OjaiQuery query = (OjaiQuery)this.driver.newQuery().setOption("ojai.mapr.query.force-drill", (Object)useDrill).select(new String[]{"b1"}).where(this.driver.newCondition().and().is("b1", QueryCondition.Op.EQUAL, theOneBuffer).is("b1", QueryCondition.Op.EQUAL, theOneBuffer).close().build()).build();
                DocumentStore docStore = ojaiConnection.getStore(tableName);
                DocumentStream docStream = docStore.findQuery((Query)query);
                Assert.assertEquals((Object)(useDrill ? OjaiQueryProperties.QueryPath.DRILL : OjaiQueryProperties.QueryPath.DIRECT), (Object)TestOjaiQuery.getQueryPath(docStream));
                int docCount = 0;
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertEquals((Object)"2", (Object)id);
                    ByteBuffer b1 = doc.getBinary("b1");
                    Assert.assertArrayEquals((byte[])theOneBytes, (byte[])b1.array());
                    ++docCount;
                }
                Assert.assertEquals((long)1L, (long)docCount);
            }
        }
    }

    @Test
    public void testQuery_bug27461() throws Exception {
        String rawTableName = "bug27461";
        this.addCleanupTable("bug27461");
        try (OjaiConnection ojaiConnection = TestOjaiQuery.getConnection();
             Table table = DBTests.createOrGetTable((String)"bug27461");){
            Path tablePath = table.getPath();
            String tableName = tablePath.toString();
            DBTests.createIndex((Table)table, (String)"bug27461_idx", (boolean)false, (int)0, (String[])new String[]{"i1"}, null, null);
            Document doc = ojaiConnection.newDocument();
            doc.setId("row1");
            doc.set("i1", 1.2345679f);
            table.insert(doc);
            DBTests.waitForIndexFlush((String)"bug27461");
            DBTests.waitForRowCount((String)"bug27461", (long)1L);
            OjaiQuery query = (OjaiQuery)this.driver.newQuery().setOption("ojai.mapr.query.force-drill", (Object)true).select(new String[]{"i1"}).where(this.driver.newCondition().and().is("i1", QueryCondition.Op.EQUAL, 1.2345679f).close().build()).build();
            DocumentStore docStore = ojaiConnection.getStore(tableName);
            DocumentStream docStream = docStore.findQuery((Query)query);
            int docCount = 0;
            for (Document Doc : docStream) {
                String id = Doc.getIdString();
                Assert.assertEquals((Object)"row1", (Object)id);
                ++docCount;
            }
            Assert.assertEquals((long)1L, (long)docCount);
        }
    }

    @Test
    public void testQuery_bug27302() throws Exception {
        try (OjaiConnection connection = TestOjaiQuery.getConnection();){
            String tableName = sharedTable27302.prepare((Connection)connection);
            OjaiQuery query = (OjaiQuery)this.driver.newQuery().select(new String[]{"_id"}).where(this.driver.newCondition().and().is("_id", QueryCondition.Op.GREATER, "ccc").is("v1", QueryCondition.Op.GREATER, 4).close().build()).build();
            try (DocumentStore docStore = connection.getStore(tableName);
                 DocumentStream docStream = docStore.findQuery((Query)query);){
                int docCount = 0;
                for (Document doc : docStream) {
                    Assert.assertNotNull((Object)doc.getId());
                    ++docCount;
                }
                Assert.assertTrue((docCount > 0 ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testQuery_bug27529() throws Exception {
        String rawTableName = "bug27529";
        this.addCleanupTable("bug27529");
        try (OjaiConnection ojaiConnection = TestOjaiQuery.getConnection();
             Table table = DBTests.createOrGetTable((String)"bug27529");){
            Path tablePath = table.getPath();
            String tableName = tablePath.toString();
            DBTests.createIndex((Table)table, (String)"bug27529_idx", (boolean)false, (int)0, (String[])new String[]{"v1.a"}, null, null);
            int nRows = 300;
            Random valueGenerator = new Random(27529L);
            StringGenerator idGenerator = new StringGenerator(5, valueGenerator);
            int v1aGenerator = 0;
            for (int i = 0; i < 300; ++i) {
                Document doc = ojaiConnection.newDocument();
                String id = idGenerator.nextUniqueString();
                doc.setId(id);
                int v1a = ++v1aGenerator;
                int v1b = valueGenerator.nextInt(100);
                int v2 = valueGenerator.nextInt(100);
                Document vDoc = ojaiConnection.newDocument();
                vDoc.set("a", v1a);
                vDoc.set("b", v1b);
                doc.set("v1", vDoc);
                doc.set("v2", v2);
                table.insert(doc);
            }
            DBTests.waitForIndexFlush((String)"bug27529");
            DBTests.waitForRowCount((String)"bug27529", (long)300L);
            int v1aBound = 250;
            OjaiQuery query = (OjaiQuery)this.driver.newQuery().select(new String[]{"v1.a", "_id"}).where(this.driver.newCondition().is("v1.a", QueryCondition.Op.GREATER, 250).build()).build();
            DocumentStore docStore = ojaiConnection.getStore(tableName);
            DocumentStream docStream = docStore.findQuery((Query)query);
            int docCount = 0;
            for (Document doc : docStream) {
                Assert.assertNotNull((Object)doc.getId());
                ++docCount;
            }
            Assert.assertEquals((long)50L, (long)docCount);
        }
    }

    @Test
    public void testQuery_timeoutFilter() {
        try (final OjaiConnection ojaiConnection = TestOjaiQuery.getConnection();){
            ExecutorService executorService = ojaiConnection.getExecutorService();
            DummyDocumentStream dummyStream = new DummyDocumentStream(){
                private int idGen = 0;

                @Override
                protected Document nextDocument() {
                    ++this.idGen;
                    Document doc = ojaiConnection.newDocument();
                    doc.setId(Integer.toString(this.idGen));
                    doc.set("i", this.idGen);
                    return doc;
                }
            };
            DelayDocumentFilter delayFilter = new DelayDocumentFilter((DocumentStream)dummyStream, 5000);
            try (TimeoutDocumentFilter timeoutFilter = new TimeoutDocumentFilter((DocumentStream)delayFilter, executorService, 2000L);){
                final CountDownLatch failedSignal = new CountDownLatch(1);
                long startTime = System.currentTimeMillis();
                timeoutFilter.streamTo(new DocumentListener(){

                    public boolean documentArrived(Document arg0) {
                        Assert.fail();
                        return false;
                    }

                    public void eos() {
                        Assert.fail();
                    }

                    public void failed(Exception ex) {
                        Assert.assertTrue((boolean)(ex instanceof QueryTimeoutException));
                        failedSignal.countDown();
                    }
                });
                int testTimeout = 6000;
                try {
                    failedSignal.await(6000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException ie) {
                    Assert.fail();
                }
                long endTime = System.currentTimeMillis();
                long elapsedTime = endTime - startTime;
                Assert.assertTrue((elapsedTime < 6000L ? 1 : 0) != 0);
                System.out.println("Actual time elapsed " + elapsedTime);
            }
        }
    }

    @Test
    public void testQuery_iteratorTimeout() throws Exception {
        try (final OjaiConnection ojaiConnection = TestOjaiQuery.getConnection();){
            ExecutorService executorService = ojaiConnection.getExecutorService();
            final long[] sleep = new long[]{100L, 500L, 9000L};
            AbstractDocumentStream documentSource = new AbstractDocumentStream(){
                int idGenerator = 0;
                int sleepIdx = 0;

                public Iterator<Document> iterator() {
                    return new Iterator<Document>(){
                        private Document nextDoc;

                        @Override
                        public boolean hasNext() {
                            if (this.nextDoc != null) {
                                return true;
                            }
                            if (sleepIdx >= sleep.length) {
                                return false;
                            }
                            long sleepTime = sleep[sleepIdx++];
                            try {
                                Thread.sleep(sleepTime);
                            }
                            catch (InterruptedException ie) {
                                Assert.fail((String)ie.toString());
                            }
                            this.nextDoc = ojaiConnection.newDocument();
                            this.nextDoc.setId(Integer.toString(++idGenerator));
                            this.nextDoc.set("sleepTime", sleep[sleepIdx - 1]);
                            return true;
                        }

                        @Override
                        public Document next() {
                            if (!this.hasNext()) {
                                throw new NoSuchElementException();
                            }
                            Document returnDoc = this.nextDoc;
                            this.nextDoc = null;
                            return returnDoc;
                        }
                    };
                }

                public Document getQueryPlan() {
                    return new DBDocumentImpl();
                }
            };
            try (TimeoutDocumentFilter timeoutFilter = new TimeoutDocumentFilter((DocumentStream)documentSource, executorService, 2000L);){
                int docCount = 0;
                boolean timedOut = false;
                try {
                    for (Document doc : timeoutFilter) {
                        Assert.assertNotNull((Object)doc.getIdString());
                        ++docCount;
                        Thread.sleep(3000L);
                    }
                }
                catch (QueryTimeoutException qte) {
                    timedOut = true;
                }
                Assert.assertTrue((boolean)timedOut);
                Assert.assertEquals((long)2L, (long)docCount);
            }
        }
    }

    @Test(expected=QueryTimeoutException.class)
    public void testQuery_timeoutOption() throws Exception {
        try (OjaiConnection connection = TestOjaiQuery.getConnection();){
            String tableName = sharedTable27302.prepare((Connection)connection);
            OjaiQuery query = (OjaiQuery)this.driver.newQuery().setTimeout(1L).select(new String[]{"_id"}).where(this.driver.newCondition().is("v1", QueryCondition.Op.GREATER, 4).build()).build();
            try (DocumentStore docStore = connection.getStore(tableName);
                 DocumentStream docStream = docStore.findQuery((Query)query);){
                int docCount = 0;
                for (Document doc : docStream) {
                    ++docCount;
                }
            }
        }
    }

    @Test
    public void testFindWithUnbuiltQuery() throws Exception {
        String rawTableName = "testFindWithUnbuiltQuery";
        this.addCleanupTable("testFindWithUnbuiltQuery");
        try (OjaiConnection ojaiConnection = TestOjaiQuery.getConnection();
             Table table = DBTests.createOrGetTable((String)"testFindWithUnbuiltQuery");){
            String tableName = table.getPath().toString();
            try (DocumentStore docStore = ojaiConnection.getStore(tableName);){
                OjaiQuery query = (OjaiQuery)this.driver.newQuery().select(new String[]{"a"});
                docStore.findQuery((Query)query);
                Assert.fail();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testQuery_bug27042() throws Exception {
        String rawTableName = "bug27042";
        this.addCleanupTable("bug27042");
        try (OjaiConnection connection = TestOjaiQuery.getConnection();
             Table table = DBTests.createOrGetTable((String)"bug27042");){
            Path tablePath = table.getPath();
            String tableName = tablePath.toString();
            DBTests.createIndex((Table)table, (String)"bug27042_idx", (boolean)false, (int)0, (String[])new String[]{"v1"}, null, null);
            int nRows = 40;
            for (int i = 1; i <= 40; ++i) {
                Document doc = connection.newDocument();
                doc.setId(Integer.toString(i));
                OTimestamp v = new OTimestamp(1, 2, 3, 4, 5, 6 + i, 7);
                doc.set("v1", v);
                table.insert(doc);
            }
            DBTests.waitForIndexFlush((String)"bug27042");
            DBTests.waitForRowCount((String)"bug27042", (long)40L);
            OTimestamp midTs = new OTimestamp(1, 2, 3, 4, 5, 26, 7);
            Query query = connection.newQuery().select(new String[]{"v1"}).where(connection.newCondition().is("v1", QueryCondition.Op.GREATER, midTs).build()).build();
            try (DocumentStore docStore = connection.getStore(tableName);
                 DocumentStream docStream = docStore.findQuery(query);){
                int docCount = 0;
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertTrue((Integer.parseInt(id) > 0 ? 1 : 0) != 0);
                    OTimestamp v = doc.getTimestamp("v1");
                    Assert.assertTrue((v.compareTo(midTs) > 0 ? 1 : 0) != 0);
                    ++docCount;
                }
                Assert.assertEquals((long)20L, (long)docCount);
            }
        }
    }

    @Test
    public void testApi_bug27883() {
        Query query = this.driver.newQuery().select(new String[]{"a", "_id"}).where(this.driver.newCondition().build()).build();
    }

    @Test
    public void testPlanning_bug27679() throws Exception {
        String rawTableName = "bug27679";
        this.addCleanupTable("bug27679");
        try (OjaiConnection connection = TestOjaiQuery.getConnection();
             Table table = DBTests.createOrGetTable((String)"bug27679");){
            Path tablePath = table.getPath();
            String tableName = tablePath.toString();
            String indexName = "bug27679_idx";
            DBTests.createIndex((Table)table, (String)"bug27679_idx", (boolean)false, (int)0, (String[])new String[]{"a", "b", "c", "d"}, null, null);
            int nRows = 10;
            for (int i = 1; i <= 10; ++i) {
                Document doc = connection.newDocument();
                String id = Integer.toString(i);
                doc.setId(id);
                doc.set("a", i);
                doc.set("b", i * 10);
                doc.set("c", i * 100);
                doc.set("d", i * 1000);
                table.insert(doc);
            }
            DBTests.waitForIndexFlush((String)"bug27679");
            DBTests.waitForRowCount((String)"bug27679", (long)10L);
            Query query = connection.newQuery().select(new String[]{"a", "b", "c"}).where(connection.newCondition().and().is("a", QueryCondition.Op.EQUAL, 5).is("c", QueryCondition.Op.EQUAL, 500).close().build()).build();
            SharedTable sharedTable = new SharedTable((BaseJsonTable)table);
            OjaiQuery ojaiQuery = (OjaiQuery)query;
            AdminImpl admin = DBTests.admin();
            List indexes = ojaiQuery.getEligibleIndexes((Admin)admin, tablePath, sharedTable, connection);
            Assert.assertEquals((long)1L, (long)indexes.size());
            EligibleIndex eligibleIndex = (EligibleIndex)indexes.get(0);
            Assert.assertTrue((boolean)eligibleIndex.isCovering);
            Assert.assertEquals((Object)"bug27679_idx", (Object)eligibleIndex.indexDesc.getIndexName());
            int docCount = 0;
            try (DocumentStore docStore = connection.getStore(tableName);
                 DocumentStream docStream = docStore.findQuery(query);){
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertTrue((Integer.valueOf(id) > 0 ? 1 : 0) != 0);
                    int a = doc.getInt("a");
                    int b = doc.getInt("b");
                    int c = doc.getInt("c");
                    Integer dObject = doc.getIntObj("d");
                    Assert.assertNull((Object)dObject);
                    Assert.assertTrue((c == b * 10 ? 1 : 0) != 0);
                    Assert.assertTrue((b == a * 10 ? 1 : 0) != 0);
                    Assert.assertEquals((long)5L, (long)a);
                    ++docCount;
                }
                Assert.assertEquals((long)1L, (long)docCount);
                Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)TestOjaiQuery.getQueryPath(docStream));
                Assert.assertEquals((Object)"bug27679_idx", (Object)TestOjaiQuery.getIndexUsed(docStream));
            }
        }
    }

    @Test
    public void testSort_bug27655() throws Exception {
        String rawTableName = "bug27655";
        this.addCleanupTable("bug27655");
        try (OjaiConnection connection = TestOjaiQuery.getConnection();
             Table table = DBTests.createOrGetTable((String)"bug27655");){
            Path tablePath = table.getPath();
            String tableName = tablePath.toString();
            int nRows = 17;
            Random random = new Random(27655L);
            for (int i = 1; i <= 17; ++i) {
                Document doc = connection.newDocument();
                String id = Integer.toString(i);
                doc.setId(id);
                Document docA = connection.newDocument();
                docA.set("b", random.nextInt(10000));
                doc.set("a", docA);
                table.insert(doc);
            }
            DBTests.waitForRowCount((String)"bug27655", (long)17L);
            Query query = connection.newQuery().select(new String[]{"a.b"}).orderBy(new String[]{"a.b"}).build();
            int docCount = 0;
            int lastAb = Integer.MIN_VALUE;
            try (DocumentStore docStore = connection.getStore(tableName);
                 DocumentStream docStream = docStore.findQuery(query);){
                for (Document doc : docStream) {
                    int ab = doc.getInt("a.b");
                    Assert.assertTrue((String)("last a.b = " + lastAb + ", this a.b = " + ab), (ab >= lastAb ? 1 : 0) != 0);
                    lastAb = ab;
                    ++docCount;
                }
                Assert.assertEquals((long)17L, (long)docCount);
                Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DRILL, (Object)TestOjaiQuery.getQueryPath(docStream));
            }
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testQuery_bug27939() {
        Query query = this.driver.newQuery().setTimeout(-1L).select(new String[]{"foo"}).build();
    }

    @Test
    public void testQuery_bug27967() throws Exception {
        String rawTableName = "bug27967";
        this.addCleanupTable("bug27967");
        try (OjaiConnection connection = TestOjaiQuery.getConnection();
             Table table = DBTests.createOrGetTable((String)"bug27967");){
            Path tablePath = table.getPath();
            String tableName = tablePath.toString();
            int nRows = 13;
            for (int i = 1; i <= 13; ++i) {
                Document doc = connection.newDocument();
                String id = Integer.toString(i);
                doc.setId(id);
                doc.set("i", i);
                doc.set("b", i % 2 == 0);
                table.insert(doc);
            }
            DBTests.waitForRowCount((String)"bug27967", (long)13L);
            Query query = connection.newQuery().select(new String[]{"b", "_id"}).where(connection.newCondition().is("b", QueryCondition.Op.EQUAL, true).build()).build();
            int docCount = 0;
            try (DocumentStore docStore = connection.getStore(tableName);
                 DocumentStream docStream = docStore.findQuery(query);){
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertTrue((Integer.parseInt(id) > 0 ? 1 : 0) != 0);
                    boolean b = doc.getBoolean("b");
                    Assert.assertTrue((boolean)b);
                    Integer iObject = doc.getIntObj("i");
                    Assert.assertNull((Object)iObject);
                    ++docCount;
                }
                Assert.assertTrue((docCount > 0 ? 1 : 0) != 0);
                Assert.assertTrue((docCount < 13 ? 1 : 0) != 0);
                Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)TestOjaiQuery.getQueryPath(docStream));
            }
        }
    }

    private static void bug27990Query(Connection connection, String tableName) {
        int docCount = 0;
        try (DocumentStore docStore = connection.getStore(tableName);
             DocumentStream docStream = docStore.find();){
            for (Document doc : docStream) {
                String id = doc.getIdString();
                Assert.assertTrue((Integer.parseInt(id) > 0 ? 1 : 0) != 0);
                ++docCount;
            }
            Assert.assertEquals((long)4L, (long)docCount);
            Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)TestOjaiQuery.getQueryPath(docStream));
        }
    }

    @Test
    public void testQuery_bug27990() throws Exception {
        String rawTableName = "bug27990";
        this.addCleanupTable("bug27990");
        try (OjaiConnection connection = TestOjaiQuery.getConnection();
             Table table = DBTests.createOrGetTable((String)"bug27990");){
            Path tablePath = table.getPath();
            String tableName = tablePath.toString();
            Document doc1 = connection.newDocument();
            doc1.setId("1");
            doc1.set("a", 1);
            doc1.set("b", 1);
            table.insert(doc1);
            Document doc2 = connection.newDocument();
            doc2.setId("2");
            doc2.set("a", 0);
            doc2.set("b", 1);
            table.insert(doc2);
            Document doc3 = connection.newDocument();
            doc3.setId("3");
            doc3.set("a", 0);
            doc3.set("b", connection.newDocument());
            table.insert(doc3);
            Document doc4 = connection.newDocument();
            doc4.setId("4");
            doc4.set("a", new ArrayList(0));
            doc4.set("b", 1);
            table.insert(doc4);
            DBTests.waitForRowCount((String)"bug27990", (long)4L);
            TestOjaiQuery.bug27990Query((Connection)connection, tableName);
            DBTests.createIndex((Table)table, (String)"bug27990_idx", (boolean)false, (int)0, (String[])new String[]{"a", "b"}, null, null);
            DBTests.waitForIndexFlush((String)"bug27990");
            TestOjaiQuery.bug27990Query((Connection)connection, tableName);
        }
    }

    @Test
    @Category(value={ClusterTest.class})
    public void testQuery_bug27926() {
        try (OjaiConnection connection = TestOjaiQuery.getConnection();){
            Query query = connection.newQuery().where(connection.newCondition().is("b", QueryCondition.Op.EQUAL, "pk").build()).where(connection.newCondition().is("a", QueryCondition.Op.EQUAL, 3).build()).build();
            Assert.assertNotNull((Object)query);
        }
    }

    @Test
    public void testQuery_bug28129() throws Exception, InterruptedException {
        String rawTableName = "bug28129";
        this.addCleanupTable("bug28129");
        try (OjaiConnection connection = TestOjaiQuery.getConnection();
             Table table = DBTests.createOrGetTable((String)"bug28129");){
            Path tablePath = table.getPath();
            String tableName = tablePath.toString();
            DBTests.createIndex((Table)table, (String)"bug28129_idx", (boolean)false, (int)0, (String[])new String[]{"city", "state"}, null, null);
            int nCities = 5;
            int nRows = 237;
            String pickedCity = null;
            String pickedState = null;
            StringGenerator stringGenerator = new StringGenerator(128, 28129L);
            for (int i = 1; i <= 237; ++i) {
                Document doc = connection.newDocument();
                String id = Integer.toString(i);
                doc.setId(id);
                String city = "City" + i % 5;
                String state = bug28129States[i % bug28129States.length];
                if (i >= 118 && pickedCity == null) {
                    pickedCity = city;
                    pickedState = state;
                }
                doc.set("city", city);
                doc.set("state", state);
                doc.set("other", stringGenerator.nextUniqueString());
                doc.set("more", stringGenerator.nextUniqueString());
                table.insert(doc);
            }
            DBTests.waitForRowCount((String)"bug28129", (long)237L);
            DBTests.waitForIndexFlush((String)"bug28129");
            String theCity = pickedCity;
            String theState = pickedState;
            Query query = connection.newQuery().select(new String[]{"other", "city", "state"}).where(connection.newCondition().and().is("city", QueryCondition.Op.EQUAL, theCity).is("state", QueryCondition.Op.EQUAL, theState).close().build()).build();
            int nThreads = 17;
            CountDownLatch startLatch = new CountDownLatch(1);
            CountDownLatch continueLatch = new CountDownLatch(17);
            ExecutorService executorService = connection.getExecutorService();
            for (int i = 0; i < 17; ++i) {
                executorService.execute(new Runnable((Connection)connection, tableName, startLatch, query, theCity, theState, continueLatch){
                    final /* synthetic */ Connection val$connection;
                    final /* synthetic */ String val$tableName;
                    final /* synthetic */ CountDownLatch val$startLatch;
                    final /* synthetic */ Query val$query;
                    final /* synthetic */ String val$theCity;
                    final /* synthetic */ String val$theState;
                    final /* synthetic */ CountDownLatch val$continueLatch;
                    {
                        this.val$connection = connection;
                        this.val$tableName = string;
                        this.val$startLatch = countDownLatch;
                        this.val$query = query;
                        this.val$theCity = string2;
                        this.val$theState = string3;
                        this.val$continueLatch = countDownLatch2;
                    }

                    @Override
                    public void run() {
                        int docCount = 0;
                        try (DocumentStore docStore = this.val$connection.getStore(this.val$tableName);){
                            try {
                                this.val$startLatch.await(30L, TimeUnit.SECONDS);
                            }
                            catch (InterruptedException ie) {
                                Assert.fail();
                            }
                            try (DocumentStream docStream = docStore.findQuery(this.val$query);){
                                for (Document doc : docStream) {
                                    String id = doc.getIdString();
                                    Assert.assertTrue((Integer.parseInt(id) > 0 ? 1 : 0) != 0);
                                    String city = doc.getString("city");
                                    Assert.assertEquals((Object)this.val$theCity, (Object)city);
                                    String state = doc.getString("state");
                                    Assert.assertEquals((Object)this.val$theState, (Object)state);
                                    ++docCount;
                                }
                                Assert.assertTrue((docCount > 0 ? 1 : 0) != 0);
                                Assert.assertTrue((docCount < 237 ? 1 : 0) != 0);
                                Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)OjaiTest.getQueryPath(docStream));
                            }
                        }
                        this.val$continueLatch.countDown();
                    }
                });
            }
            startLatch.countDown();
            continueLatch.await(60L, TimeUnit.SECONDS);
        }
    }

    @Test
    public void testQuery_idFilter() throws Exception {
        try (OjaiConnection connection = TestOjaiQuery.getConnection();){
            String tableName = sharedTable27089.prepare((Connection)connection);
            String rawTableName = sharedTable27089.getRawTableName();
            Query query = this.driver.newQuery().where(this.driver.newCondition().and().is("i", QueryCondition.Op.EQUAL, 17).is("_id", QueryCondition.Op.EQUAL, "5").close().build()).build();
            try (DocumentStore docStore = connection.getStore(tableName);
                 DocumentStream docStream = docStore.findQuery(query);){
                int docCount = 0;
                for (Document doc : docStream) {
                    System.out.println(doc);
                    ++docCount;
                }
                Assert.assertEquals((long)0L, (long)docCount);
                TestOjaiQuery.assertQueryPath(docStream, OjaiQueryProperties.QueryPath.DIRECT);
                Assert.assertEquals((Object)rawTableName, (Object)OjaiTest.getIndexUsed(docStream));
            }
        }
    }

    private static void bug28085_queryString(Connection connection, String tableName, Query query, String cString, String indexName) {
        try (DocumentStore docStore = connection.getStore(tableName);
             DocumentStream docStream = docStore.findQuery(query);){
            int docCount = 0;
            for (Document doc : docStream) {
                String id = doc.getIdString();
                Assert.assertTrue((Integer.parseInt(id) > 0 ? 1 : 0) != 0);
                String c = doc.getString("c");
                Assert.assertEquals((Object)cString, (Object)c);
                ++docCount;
            }
            Assert.assertEquals((long)1L, (long)docCount);
            TestOjaiQuery.assertQueryPath(docStream, OjaiQueryProperties.QueryPath.DIRECT);
            Assert.assertEquals((Object)indexName, (Object)OjaiTest.getIndexUsed(docStream));
        }
    }

    @Test
    public void testQuery_bug28085() throws Exception {
        String rawTableName = "bug28085";
        this.addCleanupTable("bug28085");
        try (OjaiConnection connection = TestOjaiQuery.getConnection();
             Table table = DBTests.createOrGetTable((String)"bug28085");){
            Path tablePath = table.getPath();
            String tableName = tablePath.toString();
            String indexName = "bug28085_idx";
            DBTests.createIndex((Table)table, (String)"bug28085_idx", (boolean)false, (int)0, (String[])new String[]{"c"}, null, null);
            String cString = "a string";
            ImmutableMap.Builder builder = ImmutableMap.builder();
            ImmutableMap cMap = builder.put((Object)"hcssim", (Object)17).put((Object)"hhg2tg", (Object)42).build();
            Document doc1 = connection.newDocument();
            doc1.setId("1");
            doc1.set("c", "a string");
            table.insert(doc1);
            Document doc2 = connection.newDocument();
            doc2.setId("2");
            ArrayList<String> doc2c = new ArrayList<String>(3);
            doc2c.add("x");
            doc2c.add("y");
            doc2c.add("z");
            doc2.set("c", doc2c);
            table.insert(doc2);
            Document doc3 = connection.newDocument();
            doc3.setId("3");
            doc3.set("c", (Map)cMap);
            table.insert(doc3);
            DBTests.waitForRowCount((String)"bug28085", (long)3L);
            DBTests.waitForIndexFlush((String)"bug28085");
            Query queryScalar = this.driver.newQuery().where(this.driver.newCondition().is("c", QueryCondition.Op.EQUAL, "a string").build()).build();
            TestOjaiQuery.bug28085_queryString((Connection)connection, tableName, queryScalar, "a string", "bug28085");
            Query queryScalarIndex = this.driver.newQuery().setOption("ojai.mapr.query.use-index", (Object)"bug28085_idx").where(this.driver.newCondition().is("c", QueryCondition.Op.EQUAL, "a string").build()).build();
            TestOjaiQuery.bug28085_queryString((Connection)connection, tableName, queryScalarIndex, "a string", "bug28085_idx");
            Query queryMap = this.driver.newQuery().where(this.driver.newCondition().equals("c", (Map)cMap).build()).build();
            try (DocumentStore docStore = connection.getStore(tableName);
                 DocumentStream docStream = docStore.findQuery(queryMap);){
                int docCount = 0;
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertTrue((Integer.parseInt(id) > 0 ? 1 : 0) != 0);
                    Map c = doc.getMap("c");
                    Assert.assertEquals((Object)cMap, (Object)c);
                    ++docCount;
                }
                Assert.assertEquals((long)1L, (long)docCount);
                TestOjaiQuery.assertQueryPath(docStream, OjaiQueryProperties.QueryPath.DIRECT);
                Assert.assertEquals((Object)"bug28085", (Object)OjaiTest.getIndexUsed(docStream));
            }
        }
    }

    @Test(expected=NullPointerException.class)
    public void testQuery_bug28217_set() throws Exception {
        Query query = this.driver.newQuery().waitForTrackedWrites(null).build();
    }

    @Test
    public void testQuery_bug27547() throws Exception {
        QueryCondition condition = this.driver.newCondition().build();
        Query query = this.driver.newQuery().where(condition).build();
    }

    @Test
    public void testOptions_bug28072() throws Exception {
        try (OjaiConnection connection = TestOjaiQuery.getConnection();){
            String tableName = sharedTable27089.prepare((Connection)connection);
            Query query = connection.newQuery().setOption("ojai.mapr.query.force-drill", (Object)true).setOption("ojai.mapr.drill.exec.query.progress.update", (Object)true).setOption("ojai.mapr.drill.exec.query_profile.save", (Object)true).select(new String[]{"i1"}).where(this.driver.newCondition().is("i1", QueryCondition.Op.EQUAL, 42).build()).build();
            try (DocumentStore docStore = connection.getStore(tableName);
                 DocumentStream docStream = docStore.findQuery(query);){
                int docCount = 0;
                for (Document doc : docStream) {
                    int i = doc.getInt("i1");
                    Assert.assertEquals((long)42L, (long)i);
                    ++docCount;
                }
                Assert.assertEquals((long)1L, (long)docCount);
            }
        }
    }

    private static void bug28585_simple_query(DocumentStore docStore, Query query, long limit, String indexName) {
        try (DocumentStream docStream = docStore.findQuery(query);){
            int docCount = 0;
            for (Document doc : docStream) {
                int i = doc.getInt("i1");
                Assert.assertTrue((i >= 0 ? 1 : 0) != 0);
                ++docCount;
            }
            TestOjaiQuery.assertQueryPath(docStream, OjaiQueryProperties.QueryPath.DIRECT);
            Assert.assertEquals((long)limit, (long)docCount);
            Assert.assertEquals((Object)indexName, (Object)OjaiTest.getIndexUsed(docStream));
        }
    }

    @Test
    public void testQuery_bug28585_simple() throws Exception {
        try (OjaiConnection connection = TestOjaiQuery.getConnection();){
            String tableName = sharedTable27089.prepare((Connection)connection);
            String rawTableName = sharedTable27089.getRawTableName();
            String indexName = sharedTable27089.getIndexName();
            long limit = 2L;
            try (DocumentStore docStore = connection.getStore(tableName);){
                Query queryCovered = connection.newQuery().select(new String[]{"i1"}).where(this.driver.newCondition().is("i1", QueryCondition.Op.GREATER_OR_EQUAL, 0).build()).limit(2L).build();
                TestOjaiQuery.bug28585_simple_query(docStore, queryCovered, 2L, indexName);
                Query queryNonCovered = connection.newQuery().select(new String[]{"i1"}).select(new String[]{"s1"}).where(this.driver.newCondition().is("i1", QueryCondition.Op.GREATER_OR_EQUAL, 0).build()).limit(2L).build();
                TestOjaiQuery.bug28585_simple_query(docStore, queryNonCovered, 2L, rawTableName);
                Query queryNonCoveredIndex = connection.newQuery().setOption("ojai.mapr.query.use-index", (Object)indexName).select(new String[]{"i1"}).select(new String[]{"s1"}).where(this.driver.newCondition().is("i1", QueryCondition.Op.GREATER_OR_EQUAL, 0).build()).limit(2L).build();
                TestOjaiQuery.bug28585_simple_query(docStore, queryNonCoveredIndex, 2L, indexName);
            }
        }
    }

    @Test
    public void testQuery_bug28585_threads() throws Exception {
        try (OjaiConnection connection = TestOjaiQuery.getConnection();){
            int corePoolSize;
            int poolSize;
            String tableName = sharedTable27302.prepare((Connection)connection);
            int nQuery = 10;
            Query[] query = new Query[10];
            for (int i = 1; i <= 10; ++i) {
                Query thisQuery;
                query[i - 1] = thisQuery = this.driver.newQuery().select(new String[]{"v1"}).where(this.driver.newCondition().is("v1", QueryCondition.Op.GREATER_OR_EQUAL, i).build()).limit(2L).build();
            }
            Random queryPicker = new Random(28585L);
            final AtomicInteger errorCount = new AtomicInteger(0);
            int nThreads = 11;
            int nRep = 37;
            final CountDownLatch startLatch = new CountDownLatch(1);
            CountDownLatch continueLatch = new CountDownLatch(11);
            ExecutorService executorService = Executors.newFixedThreadPool(11);
            for (int t = 0; t < 11; ++t) {
                executorService.execute(new Runnable((Connection)connection, tableName, query, queryPicker, continueLatch){
                    final /* synthetic */ Connection val$connection;
                    final /* synthetic */ String val$tableName;
                    final /* synthetic */ Query[] val$query;
                    final /* synthetic */ Random val$queryPicker;
                    final /* synthetic */ CountDownLatch val$continueLatch;
                    {
                        this.val$connection = connection;
                        this.val$tableName = string;
                        this.val$query = queryArray;
                        this.val$queryPicker = random;
                        this.val$continueLatch = countDownLatch2;
                    }

                    @Override
                    public void run() {
                        try {
                            startLatch.await();
                        }
                        catch (InterruptedException ex) {
                            errorCount.incrementAndGet();
                            return;
                        }
                        try (DocumentStore docStore = this.val$connection.getStore(this.val$tableName);){
                            for (int r = 0; r < 37; ++r) {
                                try (DocumentStream docStream = docStore.findQuery(this.val$query[this.val$queryPicker.nextInt(this.val$query.length)]);){
                                    int docCount = 0;
                                    for (Document doc : docStream) {
                                        String id = doc.getIdString();
                                        if (id == null) {
                                            errorCount.incrementAndGet();
                                        }
                                        ++docCount;
                                    }
                                    if (docCount <= 2) continue;
                                    errorCount.incrementAndGet();
                                    continue;
                                }
                            }
                        }
                        this.val$continueLatch.countDown();
                    }
                });
            }
            startLatch.countDown();
            try {
                continueLatch.await(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ex) {
                Assert.fail((String)"threads didn't complete in time ");
            }
            Assert.assertEquals((long)0L, (long)errorCount.get());
            ThreadPoolExecutor tpe = (ThreadPoolExecutor)connection.getExecutorService();
            long keepAliveMs = tpe.getKeepAliveTime(TimeUnit.MILLISECONDS);
            long maxThreadDeathWaitMs = (long)((double)keepAliveMs * 1.25);
            long threadWaitStartMs = System.currentTimeMillis();
            do {
                Thread.sleep(keepAliveMs / 10L);
                corePoolSize = tpe.getCorePoolSize();
            } while ((poolSize = tpe.getPoolSize()) > corePoolSize && System.currentTimeMillis() - threadWaitStartMs < maxThreadDeathWaitMs);
            Assert.assertTrue((poolSize <= corePoolSize ? 1 : 0) != 0);
            executorService.shutdownNow();
        }
    }

    private static void bug28691_query(DocumentStore docStore, Query query, String theId, String indexName) {
        try (DocumentStream docStream = docStore.findQuery(query);){
            int docCount = 0;
            for (Document doc : docStream) {
                String id = doc.getIdString();
                Assert.assertEquals((Object)theId, (Object)id);
                ++docCount;
            }
            Assert.assertEquals((long)1L, (long)docCount);
            Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)TestOjaiQuery.getQueryPath(docStream));
            Assert.assertEquals((Object)indexName, (Object)OjaiTest.getIndexUsed(docStream));
        }
    }

    @Ignore(value="http://10.250.1.25/show_bug.cgi?id=28691")
    @Test
    public void testQuery_bug28691() throws Exception {
        String rawTableName = "bug28691";
        OjaiTest.createTableAndLoad("bug28691");
        this.addCleanupTable("bug28691");
        String indexName = "bug28691_idx";
        DBTests.createIndex((String)"bug28691", (String)"bug28691_idx", (String[])new String[]{"a", "b"}, null);
        DBTests.waitForRowCount((String)"bug28691", (long)5L);
        DBTests.waitForIndexFlush((String)"bug28691");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ImmutableMap cMap = builder.put((Object)"c", (Object)4).build();
        try (OjaiConnection connection = TestOjaiQuery.getConnection();
             Table table = DBTests.createOrGetTable((String)"bug28691");){
            Path tablePath = table.getPath();
            String tableName = tablePath.toString();
            Query baseQuery = connection.newQuery().select(new String[]{"a"}).where(connection.newCondition().and().is("a", QueryCondition.Op.EQUAL, 1).equals("b", (Map)cMap).close().build());
            String theId = "004";
            try (DocumentStore docStore = connection.getStore(tableName);){
                OjaiQuery query = new OjaiQuery((Query)((OjaiQuery)baseQuery)).build();
                TestOjaiQuery.bug28691_query(docStore, (Query)query, "004", "bug28691");
                Query queryA = connection.newQuery().setOption("ojai.mapr.query.use-index", (Object)"bug28691_idx").select(new String[]{"a"}).where(connection.newCondition().is("a", QueryCondition.Op.EQUAL, 1).build()).build();
                try (DocumentStream docStream = docStore.findQuery(queryA);){
                    int docCount = 0;
                    for (Document doc : docStream) {
                        int a = doc.getInt("a");
                        Assert.assertEquals((long)1L, (long)a);
                        ++docCount;
                    }
                    Assert.assertEquals((long)3L, (long)docCount);
                }
                OjaiQuery queryIndex = new OjaiQuery((Query)((OjaiQuery)baseQuery)).setOption("ojai.mapr.query.use-index", (Object)"bug28691_idx").build();
                TestOjaiQuery.bug28691_query(docStore, (Query)queryIndex, "004", "bug28691_idx");
            }
        }
    }

    private static void bug29074_query(Connection connection, String tableName, Query query, int rowCount, OjaiQueryProperties.QueryPath queryPath) {
        try (DocumentStore docStore = connection.getStore(tableName);
             DocumentStream docStream = docStore.findQuery(query);){
            int docCount = 0;
            for (Document doc : docStream) {
                String id = doc.getIdString();
                Assert.assertTrue((Integer.parseInt(id) > 0 ? 1 : 0) != 0);
                ++docCount;
            }
            Assert.assertEquals((long)rowCount, (long)docCount);
            Assert.assertEquals((Object)queryPath, (Object)TestOjaiQuery.getQueryPath(docStream));
        }
    }

    @Test
    public void testQuery_bug29074() throws Exception {
        String rawTableName = "bug29074";
        try (OjaiConnection connection = TestOjaiQuery.getConnection();){
            String tableName;
            boolean rowCount = true;
            try (Table table = DBTests.createOrGetTable((String)"bug29074");){
                this.addCleanupTable("bug29074");
                Path tablePath = table.getPath();
                tableName = tablePath.toString();
                Document doc = connection.newDocument();
                doc.setId("1");
                doc.set("a", 1);
                doc.set("b", "anisha");
                table.insert(doc);
                table.flush();
            }
            DBTests.waitForRowCount((String)"bug29074", (long)1L);
            Query querySortA = connection.newQuery().orderBy(new String[]{"a"}).build();
            TestOjaiQuery.bug29074_query((Connection)connection, tableName, querySortA, 1, OjaiQueryProperties.QueryPath.DRILL);
            String indexName = "bug29074_idx";
            DBTests.createIndex((String)"bug29074", (String)"bug29074_idx", (String[])new String[]{"a"}, (String[])new String[]{"b"});
            DBTests.waitForIndexFlush((String)"bug29074");
            TestOjaiQuery.bug29074_query((Connection)connection, tableName, querySortA, 1, OjaiQueryProperties.QueryPath.DIRECT);
            Query querySortB = connection.newQuery().orderBy(new String[]{"b"}).build();
            TestOjaiQuery.bug29074_query((Connection)connection, tableName, querySortB, 1, OjaiQueryProperties.QueryPath.DRILL);
        }
    }

    public void testSortLimit() throws Exception {
        String topKLimitClass = TopKStream.class.getSimpleName();
        int theLimit = 10;
        try (OjaiConnection connection = TestOjaiQuery.getConnection();){
            String tableName = sharedTable27302.prepare((Connection)connection);
            String indexName = sharedTable27302.getIndexName();
            try (DocumentStore docStore = connection.getStore(tableName);){
                Query queryCovered = connection.newQuery().select(new String[]{"v1"}).orderBy(new String[]{"v1"}).limit(10L).build();
                try (DocumentStream docStream = docStore.findQuery(queryCovered);){
                    int docCount = 0;
                    int lastV1 = Integer.MIN_VALUE;
                    for (Object doc : docStream) {
                        String id = doc.getIdString();
                        Assert.assertNotNull((Object)id);
                        int v1 = doc.getInt("v1");
                        Assert.assertTrue((v1 >= lastV1 ? 1 : 0) != 0);
                        lastV1 = v1;
                        ++docCount;
                    }
                    Assert.assertEquals((long)10L, (long)docCount);
                    Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)TestOjaiQuery.getQueryPath(docStream));
                    Assert.assertEquals((Object)indexName, (Object)OjaiTest.getIndexUsed(docStream));
                    String queryPlan = OjaiTest.getQueryPlanString(docStream);
                    Assert.assertFalse((boolean)queryPlan.contains(topKLimitClass));
                }
                Query queryNonCovered = connection.newQuery().select(new String[]{"v1", "s1"}).orderBy(new String[]{"v1"}).limit(10L).build();
                try (DocumentStream docStream = docStore.findQuery(queryNonCovered);){
                    int docCount = 0;
                    int lastV1 = Integer.MIN_VALUE;
                    for (Document doc : docStream) {
                        String id = doc.getIdString();
                        Assert.assertNotNull((Object)id);
                        int v1 = doc.getInt("v1");
                        Assert.assertTrue((v1 >= lastV1 ? 1 : 0) != 0);
                        lastV1 = v1;
                        String s1 = doc.getString("s1");
                        Assert.assertNotNull((Object)s1);
                        ++docCount;
                    }
                    Assert.assertEquals((long)10L, (long)docCount);
                    Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)TestOjaiQuery.getQueryPath(docStream));
                    Assert.assertEquals((Object)indexName, (Object)OjaiTest.getIndexUsed(docStream));
                    String queryPlan = OjaiTest.getQueryPlanString(docStream);
                    Assert.assertFalse((boolean)queryPlan.contains(topKLimitClass));
                }
                int largestV1 = Integer.MIN_VALUE;
                Query queryNonCoveredPerfectSort = connection.newQuery().setOption("ojai.mapr.query.force-noncovering-sort", (Object)true).select(new String[]{"v1", "s1"}).orderBy(new String[]{"v1"}).limit(10L).build();
                try (DocumentStream docStream = docStore.findQuery(queryNonCoveredPerfectSort);){
                    int docCount = 0;
                    int lastV1 = Integer.MIN_VALUE;
                    for (Document doc : docStream) {
                        String id = doc.getIdString();
                        Assert.assertNotNull((Object)id);
                        int v1 = doc.getInt("v1");
                        Assert.assertTrue((v1 >= lastV1 ? 1 : 0) != 0);
                        lastV1 = v1;
                        largestV1 = v1;
                        String s1 = doc.getString("s1");
                        Assert.assertNotNull((Object)s1);
                        ++docCount;
                    }
                    Assert.assertEquals((long)10L, (long)docCount);
                    Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)TestOjaiQuery.getQueryPath(docStream));
                    Assert.assertEquals((Object)indexName, (Object)OjaiTest.getIndexUsed(docStream));
                    String queryPlan = OjaiTest.getQueryPlanString(docStream);
                    Assert.assertTrue((boolean)queryPlan.contains(topKLimitClass));
                }
                Query queryNonCoveredOtherIndex = connection.newQuery().select(new String[]{"v1", "s1"}).where(connection.newCondition().is("v1", QueryCondition.Op.LESS_OR_EQUAL, largestV1).build()).orderBy(new String[]{"s1"}).limit(10L).build();
                try (DocumentStream docStream = docStore.findQuery(queryNonCoveredOtherIndex);){
                    int docCount = 0;
                    String lastS1 = "";
                    for (Document doc : docStream) {
                        String id = doc.getIdString();
                        Assert.assertNotNull((Object)id);
                        int v1 = doc.getInt("v1");
                        Assert.assertTrue((v1 <= largestV1 ? 1 : 0) != 0);
                        String s1 = doc.getString("s1");
                        Assert.assertTrue((s1.compareTo(lastS1) >= 0 ? 1 : 0) != 0);
                        lastS1 = s1;
                        ++docCount;
                    }
                    Assert.assertEquals((long)10L, (long)docCount);
                    Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)TestOjaiQuery.getQueryPath(docStream));
                    Assert.assertEquals((Object)indexName, (Object)OjaiTest.getIndexUsed(docStream));
                    String queryPlan = OjaiTest.getQueryPlanString(docStream);
                    Assert.assertTrue((boolean)queryPlan.contains(topKLimitClass));
                }
            }
        }
    }

    @Test
    public void testQuery_fullIndexScan() throws Exception {
        try (OjaiConnection connection = TestOjaiQuery.getConnection();){
            String tableName = sharedTable27089.prepare((Connection)connection);
            long nRows = sharedTable27089.getNumRows();
            String indexName = sharedTable27089.getIndexName();
            Query query = this.driver.newQuery().select(new String[]{"i1"}).build();
            try (DocumentStore docStore = connection.getStore(tableName);
                 DocumentStream docStream = docStore.findQuery(query);){
                int docCount = 0;
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertNotNull((Object)id);
                    Integer iObj = doc.getIntObj("i1");
                    Assert.assertNotNull((Object)iObj);
                    ++docCount;
                }
                Assert.assertEquals((long)nRows, (long)docCount);
                TestOjaiQuery.assertQueryPath(docStream, OjaiQueryProperties.QueryPath.DIRECT);
                Assert.assertEquals((Object)indexName, (Object)OjaiTest.getIndexUsed(docStream));
            }
        }
    }

    @Test
    public void testQuery_sortedFullIndexScan() throws Exception {
        try (OjaiConnection connection = TestOjaiQuery.getConnection();){
            String tableName = sharedTable27089.prepare((Connection)connection);
            long nRows = sharedTable27089.getNumRows();
            String indexName = sharedTable27089.getIndexName();
            Query query = this.driver.newQuery().select(new String[]{"i1"}).orderBy(new String[]{"i1"}).build();
            try (DocumentStore docStore = connection.getStore(tableName);
                 DocumentStream docStream = docStore.findQuery(query);){
                int docCount = 0;
                int lastI = Integer.MIN_VALUE;
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertNotNull((Object)id);
                    int i = doc.getInt("i1");
                    Assert.assertTrue((i >= lastI ? 1 : 0) != 0);
                    lastI = i;
                    ++docCount;
                }
                Assert.assertEquals((long)nRows, (long)docCount);
                TestOjaiQuery.assertQueryPath(docStream, OjaiQueryProperties.QueryPath.DIRECT);
                Assert.assertEquals((Object)indexName, (Object)OjaiTest.getIndexUsed(docStream));
            }
        }
    }

    @Test
    public void testQuery_indexHint() throws Exception {
        try (OjaiConnection connection = TestOjaiQuery.getConnection();){
            String tableName = sharedTable29013.prepare((Connection)connection);
            String aIndexName = sharedTable29013.getAIndexName();
            String bIndexName = sharedTable29013.getBIndexName();
            Query query = this.driver.newQuery().select(new String[]{"a", "b"}).where(connection.newCondition().and().is("a", QueryCondition.Op.GREATER, 0).is("b", QueryCondition.Op.GREATER, 0).close().build());
            OjaiQuery queryA = new OjaiQuery(query).setOption("ojai.mapr.query.use-index", (Object)aIndexName).build();
            try (DocumentStore docStore = connection.getStore(tableName);
                 DocumentStream docStream = docStore.findQuery((Query)queryA);){
                int docCount = 0;
                int lastA = Integer.MIN_VALUE;
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertNotNull((Object)id);
                    int a = doc.getInt("a");
                    Assert.assertTrue((a >= lastA ? 1 : 0) != 0);
                    lastA = a;
                    ++docCount;
                }
                Assert.assertTrue((docCount > 0 ? 1 : 0) != 0);
                TestOjaiQuery.assertQueryPath(docStream, OjaiQueryProperties.QueryPath.DIRECT);
                Assert.assertEquals((Object)aIndexName, (Object)OjaiTest.getIndexUsed(docStream));
            }
            OjaiQuery queryB = new OjaiQuery(query).setOption("ojai.mapr.query.use-index", (Object)bIndexName).build();
            try (DocumentStore docStore = connection.getStore(tableName);
                 DocumentStream docStream = docStore.findQuery((Query)queryB);){
                int docCount = 0;
                int lastB = Integer.MIN_VALUE;
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertNotNull((Object)id);
                    int b = doc.getInt("b");
                    Assert.assertTrue((b >= lastB ? 1 : 0) != 0);
                    lastB = b;
                    ++docCount;
                }
                Assert.assertTrue((docCount > 0 ? 1 : 0) != 0);
                TestOjaiQuery.assertQueryPath(docStream, OjaiQueryProperties.QueryPath.DIRECT);
                Assert.assertEquals((Object)bIndexName, (Object)OjaiTest.getIndexUsed(docStream));
            }
        }
    }

    @Test
    public void testQuery_bug29170() throws Exception {
        String rawTableName = "bug29170";
        this.addCleanupTable("bug29170");
        try (OjaiConnection connection = TestOjaiQuery.getConnection();
             Table table = DBTests.createOrGetTable((String)"bug29170");){
            Path tablePath = table.getPath();
            String tableName = tablePath.toString();
            DBTests.createIndex((Table)table, (String)"bug29170_idx", (boolean)false, (int)0, (String[])new String[]{"d", "i"}, null, null);
            Random random = new Random(29170L);
            StringGenerator idGenerator = new StringGenerator(32, random);
            double dValue = random.nextDouble();
            int iValue = random.nextInt();
            Document doc = connection.newDocument();
            String id = idGenerator.nextUniqueString();
            doc.setId(id);
            doc.set("d", dValue);
            doc.set("i", iValue);
            table.insert(doc);
            DBTests.waitForIndexFlush((String)"bug29170");
            DBTests.waitForRowCount((String)"bug29170", (long)1L);
            Query query = connection.newQuery().select(new String[]{"i", "_id"}).where(this.driver.newCondition().and().is("d", QueryCondition.Op.EQUAL, dValue).notTypeOf("i", Value.Type.INT).close().build()).build();
            try (DocumentStore docStore = connection.getStore(tableName);
                 DocumentStream docStream = docStore.findQuery(query);){
                int docCount = 0;
                for (Document doc2 : docStream) {
                    String id2 = doc2.getIdString();
                    Assert.assertNotNull((Object)id2);
                    int i = doc2.getInt("i");
                    Assert.assertEquals((long)iValue, (long)i);
                    ++docCount;
                }
                Assert.assertEquals((long)0L, (long)docCount);
            }
        }
    }

    @Test
    public void testQuery_bug29281() throws Exception {
        String topKLimitClass = TopKStream.class.getSimpleName();
        try (OjaiConnection connection = TestOjaiQuery.getConnection();){
            String tableName = sharedTable29281.prepare((Connection)connection);
            String indexName = sharedTable29281.getCityStateReviewsIndexName();
            String city = SharedTable29281.CITY[0];
            String state = SharedTable29281.STATE[0];
            int reviewCount = 10;
            int limit = 100;
            QueryCondition queryCondition = this.driver.newCondition().and().and().is("city", QueryCondition.Op.EQUAL, city).is("state", QueryCondition.Op.EQUAL, state).close().is("review_count", QueryCondition.Op.GREATER, 10).close().build();
            Query queryBase = this.driver.newQuery().setOption("ojai.mapr.query.use-index", (Object)indexName).select(new String[]{"_id", "name", "city", "state", "review_count"}).where(queryCondition).orderBy(new String[]{"stars"}).limit(100L);
            OjaiQuery query1 = new OjaiQuery(queryBase).build();
            OjaiQuery query2 = new OjaiQuery(queryBase).select(new String[]{"stars"}).build();
            HashMap<String, Document> docMap = new HashMap<String, Document>(100);
            try (DocumentStore docStore = connection.getStore(tableName);){
                try (DocumentStream docStream = docStore.findQuery((Query)query2);){
                    int docCount = 0;
                    int lastStars = Integer.MIN_VALUE;
                    for (Document doc : docStream) {
                        String id = doc.getIdString();
                        Assert.assertNotNull((Object)id);
                        int stars = doc.getInt("stars");
                        Assert.assertTrue((stars >= lastStars ? 1 : 0) != 0);
                        lastStars = stars;
                        Document oldDoc = docMap.put(id, doc);
                        Assert.assertNull((Object)oldDoc);
                        ++docCount;
                    }
                    Assert.assertTrue((docCount > 0 ? 1 : 0) != 0);
                    TestOjaiQuery.assertQueryPath(docStream, OjaiQueryProperties.QueryPath.DIRECT);
                    Assert.assertEquals((Object)indexName, (Object)OjaiTest.getIndexUsed(docStream));
                    String queryPlan = OjaiTest.getQueryPlanString(docStream);
                    Assert.assertTrue((boolean)queryPlan.contains(topKLimitClass));
                }
                int lastStars = Integer.MIN_VALUE;
                try (DocumentStream docStream = docStore.findQuery((Query)query1);){
                    for (Document doc : docStream) {
                        String id = doc.getIdString();
                        Assert.assertNotNull((Object)id);
                        Integer starObj = doc.getIntObj("stars");
                        Assert.assertNull((Object)starObj);
                        Document starDoc = (Document)docMap.get(id);
                        Assert.assertNotNull((Object)starDoc);
                        int stars = starDoc.getInt("stars");
                        Assert.assertTrue((stars >= lastStars ? 1 : 0) != 0);
                        lastStars = stars;
                    }
                    TestOjaiQuery.assertQueryPath(docStream, OjaiQueryProperties.QueryPath.DIRECT);
                    Assert.assertEquals((Object)indexName, (Object)OjaiTest.getIndexUsed(docStream));
                    String queryPlan = OjaiTest.getQueryPlanString(docStream);
                    Assert.assertTrue((boolean)queryPlan.contains(topKLimitClass));
                }
            }
        }
    }

    @Test
    public void testQuery_bug28299() throws Exception {
        try (OjaiConnection connection = TestOjaiQuery.getConnection();){
            String tableName = sharedTable28299.prepare((Connection)connection);
            try (DocumentStore docStore = connection.getStore(tableName);){
                Query query1 = this.driver.newQuery().select(new String[]{"a[1]"}).where(this.driver.newCondition().and().exists("a").is("_id", QueryCondition.Op.EQUAL, "3").close().build()).build();
                try (DocumentStream docStream = docStore.findQuery(query1);){
                    int docCount = 0;
                    for (Document doc : docStream) {
                        String id = doc.getIdString();
                        Assert.assertNotNull((Object)id);
                        List aList = doc.getList("a");
                        Assert.assertEquals((long)2L, (long)aList.size());
                        Object a0 = aList.get(0);
                        Assert.assertNull(a0);
                        Object a1 = aList.get(1);
                        Assert.assertEquals(Integer.class, a1.getClass());
                        Assert.assertEquals((long)2L, (long)((Integer)a1).intValue());
                        ++docCount;
                    }
                    Assert.assertEquals((long)1L, (long)docCount);
                    TestOjaiQuery.assertQueryPath(docStream, OjaiQueryProperties.QueryPath.DIRECT);
                }
            }
        }
    }

    @Test
    public void testQuery_bug29279() throws Exception {
        String rawTableName = "bug29279";
        try (OjaiConnection connection = TestOjaiQuery.getConnection();){
            boolean rowCount = true;
            try (Table table = DBTests.createOrGetTable((String)"bug29279");){
                this.addCleanupTable("bug29279");
                Path tablePath = table.getPath();
                String tableName = tablePath.toString();
                String indexName = "bug29279_idx";
                DBTests.createIndex((Table)table, (String)"bug29279_idx", (boolean)false, (int)0, (String[])new String[]{"a"}, null, null);
                Document doc1 = connection.newDocument();
                doc1.setId("1");
                doc1.setNull("a");
                table.insert(doc1);
                Document doc2 = connection.newDocument();
                doc2.setId("2");
                doc2.setNull("a");
                table.insert(doc2);
                table.flush();
                DBTests.waitForRowCount((String)"bug29279", (long)1L);
                DBTests.waitForIndexFlush((String)"bug29279");
                Query baseQuery = connection.newQuery().select(new String[]{"_id", "a"}).where(connection.newCondition().typeOf("a", Value.Type.NULL).build());
                try (DocumentStore docStore = connection.getStore(tableName);){
                    OjaiQuery query = new OjaiQuery((Query)((OjaiQuery)baseQuery)).build();
                    try (DocumentStream docStream = docStore.findQuery((Query)query);){
                        int docCount = 0;
                        for (Document doc : docStream) {
                            String id = doc.getIdString();
                            Assert.assertNotNull((Object)id);
                            Value a = doc.getValue("a");
                            Assert.assertEquals((Object)Value.Type.NULL, (Object)a.getType());
                            ++docCount;
                        }
                        Assert.assertEquals((long)2L, (long)docCount);
                        Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)TestOjaiQuery.getQueryPath(docStream));
                        Assert.assertEquals((Object)"bug29279_idx", (Object)TestOjaiQuery.getIndexUsed(docStream));
                    }
                }
            }
        }
    }

    @Test
    public void testQuery_bug29267() throws Exception {
        try (OjaiConnection connection = TestOjaiQuery.getConnection();){
            String tableName = sharedTable29267.prepare((Connection)connection);
            String bIndexName = sharedTable29267.getBusinessIdIndexName();
            String csrIndexName = sharedTable29267.getCityStateReviewsIndexName();
            String lastBusinessName = sharedTable29267.getLastBusinessName();
            String city = SharedTable29267.CITY[0];
            String state = SharedTable29267.STATE[0];
            int reviewCount = 10;
            int limit = 100;
            Query queryById = connection.newQuery().setOption("ojai.mapr.query.use-index", (Object)bIndexName).where(connection.newCondition().is("name", QueryCondition.Op.EQUAL, lastBusinessName).build()).build();
            QueryCondition queryCondition = connection.newCondition().and().and().is("city", QueryCondition.Op.EQUAL, city).is("state", QueryCondition.Op.EQUAL, state).close().is("review_count", QueryCondition.Op.GREATER, 10).close().build();
            Query queryBase = connection.newQuery().setOption("ojai.mapr.query.use-index", (Object)csrIndexName).select(new String[]{"_id", "name", "city", "state", "review_count"}).where(queryCondition).limit(100L);
            OjaiQuery query1 = new OjaiQuery(queryBase).build();
            OjaiQuery query2 = new OjaiQuery(queryBase).select(new String[]{"stars"}).build();
            try (DocumentStore docStore = connection.getStore(tableName);){
                String id;
                int docCount;
                try (DocumentStream docStream = docStore.findQuery(queryById);){
                    docCount = 0;
                    for (Document doc : docStream) {
                        id = doc.getIdString();
                        Assert.assertNotNull((Object)id);
                        String name = doc.getString("name");
                        Assert.assertEquals((Object)lastBusinessName, (Object)name);
                        ++docCount;
                    }
                    Assert.assertEquals((long)1L, (long)docCount);
                    TestOjaiQuery.assertQueryPath(docStream, OjaiQueryProperties.QueryPath.DIRECT);
                    Assert.assertEquals((Object)bIndexName, (Object)OjaiTest.getIndexUsed(docStream));
                }
                docStream = docStore.findQuery((Query)query2);
                var19_23 = null;
                try {
                    docCount = 0;
                    for (Document doc : docStream) {
                        id = doc.getIdString();
                        Assert.assertNotNull((Object)id);
                        ++docCount;
                    }
                    Assert.assertTrue((docCount > 0 ? 1 : 0) != 0);
                    TestOjaiQuery.assertQueryPath(docStream, OjaiQueryProperties.QueryPath.DIRECT);
                    Assert.assertEquals((Object)csrIndexName, (Object)OjaiTest.getIndexUsed(docStream));
                }
                catch (Throwable throwable) {
                    var19_23 = throwable;
                    throw throwable;
                }
                finally {
                    if (docStream != null) {
                        if (var19_23 != null) {
                            try {
                                docStream.close();
                            }
                            catch (Throwable throwable) {
                                var19_23.addSuppressed(throwable);
                            }
                        } else {
                            docStream.close();
                        }
                    }
                }
            }
        }
    }

    @Test
    public void testQuery_bug29410() throws Exception {
        try (OjaiConnection connection = TestOjaiQuery.getConnection();){
            String tableName = sharedTable29267.prepare((Connection)connection);
            String csrIndexName = sharedTable29267.getCityStateReviewsIndexName();
            String city = SharedTable29267.CITY[0];
            int offset = 31;
            int limit = 27;
            Query queryBase = connection.newQuery().setOption("ojai.mapr.query.use-index", (Object)csrIndexName).select(new String[]{"city", "state", "review_count"}).where(connection.newCondition().is("city", QueryCondition.Op.EQUAL, city).build()).orderBy(new String[]{"review_count"});
            OjaiQuery queryLimit = new OjaiQuery(queryBase).limit(58L).build();
            OjaiQuery queryOffsetLimit = new OjaiQuery(queryBase).limit(27L).offset(31L).build();
            try (DocumentStore docStore = connection.getStore(tableName);){
                LinkedList<Document> fullList = new LinkedList<Document>();
                try (DocumentStream docStream = docStore.findQuery((Query)queryLimit);){
                    int docCount = 0;
                    for (Document doc : docStream) {
                        String id = doc.getIdString();
                        Assert.assertNotNull((Object)id);
                        fullList.add(doc);
                        ++docCount;
                    }
                    Assert.assertEquals((long)58L, (long)docCount);
                    TestOjaiQuery.assertQueryPath(docStream, OjaiQueryProperties.QueryPath.DIRECT);
                    Assert.assertEquals((Object)csrIndexName, (Object)OjaiTest.getIndexUsed(docStream));
                }
                docStream = docStore.findQuery((Query)queryOffsetLimit);
                var15_19 = null;
                try {
                    String queryPlan = OjaiTest.getQueryPlanString(docStream);
                    System.err.println("queryPlan " + queryPlan);
                    int docCount = 0;
                    for (Document doc : docStream) {
                        String id = doc.getIdString();
                        Assert.assertNotNull((Object)id);
                        Document otherDoc = (Document)fullList.get(31 + docCount);
                        Assert.assertEquals((Object)otherDoc, (Object)doc);
                        ++docCount;
                    }
                    Assert.assertEquals((long)27L, (long)docCount);
                    TestOjaiQuery.assertQueryPath(docStream, OjaiQueryProperties.QueryPath.DIRECT);
                    Assert.assertEquals((Object)csrIndexName, (Object)OjaiTest.getIndexUsed(docStream));
                }
                catch (Throwable throwable) {
                    var15_19 = throwable;
                    throw throwable;
                }
                finally {
                    if (docStream != null) {
                        if (var15_19 != null) {
                            try {
                                docStream.close();
                            }
                            catch (Throwable throwable) {
                                var15_19.addSuppressed(throwable);
                            }
                        } else {
                            docStream.close();
                        }
                    }
                }
            }
        }
    }

    @Test
    public void testQuery_bug29504() throws Exception {
        String topKLimitClass = TopKStream.class.getSimpleName();
        try (OjaiConnection connection = TestOjaiQuery.getConnection();){
            String tableName = sharedTable29504.prepare((Connection)connection);
            String csrIndexName = sharedTable29504.getCityStateReviewsIndexName();
            String city = SharedTable29267.CITY[0];
            String state = SharedTable29267.STATE[0];
            boolean reviewCount = true;
            int limit = OjaiQuery.MAX_CLIENT_SORT_LIMIT + 1;
            Query query = connection.newQuery().setOption("ojai.mapr.query.force-direct", (Object)true).setOption("ojai.mapr.query.use-index", (Object)csrIndexName).select(new String[]{"name", "review_count"}).where(connection.newCondition().and().is("city", QueryCondition.Op.EQUAL, city).is("state", QueryCondition.Op.EQUAL, state).is("review_count", QueryCondition.Op.GREATER, 1).close().build()).orderBy("review_count", SortOrder.DESC).limit((long)limit).build();
            try (DocumentStore docStore = connection.getStore(tableName);
                 DocumentStream docStream = docStore.findQuery(query);){
                int docCount = 0;
                int lastReviewCount = Integer.MAX_VALUE;
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertNotNull((Object)id);
                    int rc = doc.getInt("review_count");
                    Assert.assertTrue((rc <= lastReviewCount ? 1 : 0) != 0);
                    lastReviewCount = rc;
                    ++docCount;
                }
                Assert.assertTrue((docCount > 0 ? 1 : 0) != 0);
                TestOjaiQuery.assertQueryPath(docStream, OjaiQueryProperties.QueryPath.DIRECT);
                Assert.assertEquals((Object)csrIndexName, (Object)OjaiTest.getIndexUsed(docStream));
                String queryPlan = OjaiTest.getQueryPlanString(docStream);
                System.err.println(queryPlan);
                Assert.assertFalse((boolean)queryPlan.contains(topKLimitClass));
            }
        }
    }

    private static void bug29475Query(DocumentStore docStore, Query query, int expectedDocs, String indexName) {
        try (DocumentStream docStream = docStore.findQuery(query);){
            int docCount = 0;
            for (Document doc : docStream) {
                String id = doc.getIdString();
                Assert.assertNotNull((Object)id);
                ++docCount;
            }
            Assert.assertEquals((long)expectedDocs, (long)docCount);
            TestOjaiQuery.assertQueryPath(docStream, OjaiQueryProperties.QueryPath.DIRECT);
            Assert.assertEquals((Object)indexName, (Object)OjaiTest.getIndexUsed(docStream));
        }
    }

    @Test
    public void testQuery_bug29475() throws Exception {
        try (OjaiConnection connection = TestOjaiQuery.getConnection();){
            String tableName = sharedTable29281.prepare((Connection)connection);
            String indexName = sharedTable29281.getCityStateReviewsIndexName();
            int rcOver50 = sharedTable29281.getRcOver50();
            String city = SharedTable29281.CITY[0];
            String state = SharedTable29281.STATE[0];
            int reviewCount = 50;
            int offset = 5;
            int limit = 17;
            Assert.assertTrue((22 < rcOver50 ? 1 : 0) != 0);
            Query baseQuery = this.driver.newQuery().setOption("ojai.mapr.query.use-index", (Object)indexName).select(new String[]{"_id", "name", "city", "state", "nc_review_count"}).where(this.driver.newCondition().and().is("city", QueryCondition.Op.EQUAL, city).is("state", QueryCondition.Op.EQUAL, state).is("nc_review_count", QueryCondition.Op.GREATER, 50).close().build());
            try (DocumentStore docStore = connection.getStore(tableName);){
                OjaiQuery query = new OjaiQuery((Query)((OjaiQuery)baseQuery)).build();
                TestOjaiQuery.bug29475Query(docStore, (Query)query, rcOver50, indexName);
                OjaiQuery queryLimit = new OjaiQuery((Query)((OjaiQuery)baseQuery)).limit(17L).build();
                TestOjaiQuery.bug29475Query(docStore, (Query)queryLimit, 17, indexName);
                OjaiQuery queryOffset = new OjaiQuery((Query)((OjaiQuery)baseQuery)).offset(5L).build();
                TestOjaiQuery.bug29475Query(docStore, (Query)queryOffset, rcOver50 - 5, indexName);
                OjaiQuery queryOffsetLimit = new OjaiQuery((Query)((OjaiQuery)baseQuery)).offset(5L).limit(17L).build();
                TestOjaiQuery.bug29475Query(docStore, (Query)queryOffsetLimit, 17, indexName);
                OjaiQuery querySortLimit = new OjaiQuery((Query)((OjaiQuery)baseQuery)).orderBy(new String[]{"nc_review_count"}).limit(17L).build();
                TestOjaiQuery.bug29475Query(docStore, (Query)querySortLimit, 17, indexName);
            }
        }
    }

    private static class SharedTable29504
    extends SharedTable29281 {
        public SharedTable29504() {
            super("bug29504");
        }

        @Override
        protected void createIndexes(String rawTableName, Table table) throws Exception {
            this.cityStateReviewsIndexName = rawTableName + "_h_csr_idx";
            DBTests.createIndex((Table)table, (String)this.cityStateReviewsIndexName, (boolean)false, (int)0, (String[])new String[]{"city", "state", "review_count"}, (SortOrder[])new SortOrder[]{SortOrder.ASC, SortOrder.ASC, SortOrder.DESC}, (String[])new String[]{"name"});
        }
    }

    private static class SharedTable29267
    extends SharedTable29281 {
        private String businessIdIndexName;

        public SharedTable29267() {
            super("bug29267");
        }

        @Override
        protected void createIndexes(String rawTableName, Table table) throws Exception {
            this.cityStateReviewsIndexName = rawTableName + "_h_csr_idx";
            DBTests.createIndex((Table)table, (String)this.cityStateReviewsIndexName, (boolean)true, (int)32, (String[])new String[]{"city", "state", "review_count"}, null, (String[])new String[]{"name"});
            this.businessIdIndexName = rawTableName + "_h_b_idx";
            DBTests.createIndex((Table)table, (String)this.businessIdIndexName, (boolean)true, (int)64, (String[])new String[]{"name"}, null, null);
        }

        public String getBusinessIdIndexName() {
            return this.businessIdIndexName;
        }
    }

    private static class SharedTable28299
    extends SharedTestTable {
        public SharedTable28299() {
            super("bug28299");
        }

        @Override
        protected String initialize(Connection connection, String rawTableName) throws Exception {
            try (Table table = DBTests.createOrGetTable((String)rawTableName);){
                Path tablePath = table.getPath();
                String tableName = tablePath.toString();
                Document doc1 = connection.newDocument();
                doc1.setId("1");
                doc1.set("a", 1);
                table.insert(doc1);
                Document doc2 = connection.newDocument();
                doc2.setId("2");
                HashMap<String, Integer> doc2aMap = new HashMap<String, Integer>();
                doc2aMap.put("b", 1);
                doc2.set("a", doc2aMap);
                table.insert(doc2);
                Document doc3 = connection.newDocument();
                doc3.setId("3");
                ArrayList<Integer> doc3aList = new ArrayList<Integer>(4);
                for (int i = 1; i <= 4; ++i) {
                    doc3aList.add(i);
                }
                doc3.set("a", doc3aList);
                table.insert(doc3);
                String string = tableName;
                return string;
            }
        }

        @Override
        public long getNumRows() {
            return 3L;
        }
    }

    private static class SharedTable29013
    extends SharedTestTable {
        private String aIndexName;
        private String bIndexName;

        public SharedTable29013() {
            super("bug29013");
        }

        @Override
        protected String initialize(Connection connection, String rawTableName) throws Exception {
            try (Table table = DBTests.createOrGetTable((String)rawTableName);){
                Path tablePath = table.getPath();
                String tableName = tablePath.toString();
                this.aIndexName = rawTableName + "_a_idx";
                DBTests.createIndex((Table)table, (String)this.aIndexName, (boolean)false, (int)0, (String[])new String[]{"a"}, null, (String[])new String[]{"b"});
                this.bIndexName = rawTableName + "_b_idx";
                DBTests.createIndex((Table)table, (String)this.bIndexName, (boolean)false, (int)0, (String[])new String[]{"b"}, null, (String[])new String[]{"a"});
                DBTests.waitForIndexFlush((String)rawTableName);
                Random random = new Random(28585L);
                StringGenerator idGenerator = new StringGenerator(32, random);
                long numRows = this.getNumRows();
                int i = 1;
                while ((long)i <= numRows) {
                    Document doc = connection.newDocument();
                    String id = idGenerator.nextUniqueString();
                    doc.setId(id);
                    doc.set("a", this.nextInt(random));
                    doc.set("b", this.nextInt(random));
                    doc.set("c", this.nextInt(random));
                    doc.set("d", this.nextInt(random));
                    table.insert(doc);
                    ++i;
                }
                String string = tableName;
                return string;
            }
        }

        private int nextInt(Random random) {
            int valueBound = (int)(this.getNumRows() / 11L);
            return valueBound + 1 - 2 * random.nextInt(valueBound);
        }

        @Override
        public long getNumRows() {
            return 419L;
        }

        public String getAIndexName() {
            return this.aIndexName;
        }

        public String getBIndexName() {
            return this.bIndexName;
        }
    }

    private static class SharedTable27302
    extends SharedTestTable {
        private final int nRows = 300;
        private String indexName;

        public SharedTable27302() {
            super("bug27302");
        }

        @Override
        protected String initialize(Connection connection, String rawTableName) throws Exception {
            try (Table table = DBTests.createOrGetTable((String)rawTableName);){
                Path tablePath = table.getPath();
                String tableName = tablePath.toString();
                this.indexName = rawTableName + "_idx";
                DBTests.createIndex((Table)table, (String)this.indexName, (boolean)false, (int)0, (String[])new String[]{"v1"}, null, null);
                Random valueGenerator = new Random(27302L);
                StringGenerator idGenerator = new StringGenerator(32, valueGenerator);
                for (int i = 0; i < 300; ++i) {
                    Document doc = connection.newDocument();
                    String id = idGenerator.nextUniqueString();
                    doc.setId(id);
                    int value = valueGenerator.nextInt(10);
                    doc.set("v1", value);
                    doc.set("s1", idGenerator.nextString());
                    doc.set("s2", idGenerator.nextString());
                    doc.set("s3", idGenerator.nextString());
                    table.insert(doc);
                }
                String string = tableName;
                return string;
            }
        }

        @Override
        public long getNumRows() {
            return 300L;
        }

        public String getIndexName() {
            return this.indexName;
        }
    }

    private static class QueriesOnDateTimestampTime {
        private QueriesOnDateTimestampTime() {
        }

        static void insertDocs(Connection connection, Table table) {
            QueryOnDate.insertDoc(connection, table, "1", QueryOnDate.date1, ODate.parse((String)"2017-05-15"));
            QueryOnDate.insertDoc(connection, table, "2", QueryOnDate.date2, ODate.parse((String)"2017-05-15"));
            QueryOnDate.insertDoc(connection, table, "3", QueryOnDate.date3, ODate.parse((String)"2016-05-15"));
            QueryOnTimestamp.insertDoc(connection, table, "4", QueryOnTimestamp.timestamp1, OTimestamp.parse((String)"2007-01-10T20:00:21.000+00:00"));
            QueryOnTimestamp.insertDoc(connection, table, "5", QueryOnTimestamp.timestamp2, OTimestamp.parse((String)"2000-01-31T22:02:05.000+00:00"));
            QueryOnTimestamp.insertDoc(connection, table, "6", QueryOnTimestamp.timestamp3, OTimestamp.parse((String)"2015-03-14T10:10:10.000+00:00"));
            QueryOnTime.insertDoc(connection, table, "7", QueryOnTime.time1, OTime.parse((String)"20:00:21"));
            QueryOnTime.insertDoc(connection, table, "8", QueryOnTime.time2, OTime.parse((String)"22:02:05"));
            QueryOnTime.insertDoc(connection, table, "9", QueryOnTime.time3, OTime.parse((String)"10:10:10"));
        }

        static void runQueries(Connection connection, DocumentStore docStore, OjaiQueryProperties.QueryPath expectedPath) {
            QueryOnDate.runQuery(connection, docStore, QueryCondition.Op.LESS, QueryOnDate.date2, "1", QueryOnDate.date1, expectedPath);
            QueryOnDate.runQuery(connection, docStore, QueryCondition.Op.EQUAL, QueryOnDate.date2, "2", QueryOnDate.date2, expectedPath);
            QueryOnDate.runQuery(connection, docStore, QueryCondition.Op.GREATER, QueryOnDate.date2, "3", QueryOnDate.date3, expectedPath);
            QueryOnTimestamp.runQuery(connection, docStore, QueryCondition.Op.LESS, QueryOnTimestamp.timestamp2, "4", QueryOnTimestamp.timestamp1, expectedPath);
            QueryOnTimestamp.runQuery(connection, docStore, QueryCondition.Op.EQUAL, QueryOnTimestamp.timestamp2, "5", QueryOnTimestamp.timestamp2, expectedPath);
            QueryOnTimestamp.runQuery(connection, docStore, QueryCondition.Op.GREATER, QueryOnTimestamp.timestamp2, "6", QueryOnTimestamp.timestamp3, expectedPath);
            QueryOnTime.runQuery(connection, docStore, QueryCondition.Op.LESS, QueryOnTime.time2, "9", QueryOnTime.time3, expectedPath);
            QueryOnTime.runQuery(connection, docStore, QueryCondition.Op.EQUAL, QueryOnTime.time2, "8", QueryOnTime.time2, expectedPath);
            QueryOnTime.runQuery(connection, docStore, QueryCondition.Op.GREATER, QueryOnTime.time2, "7", QueryOnTime.time1, expectedPath);
        }
    }

    private static class QueryOnDate {
        static final ODate date1 = ODate.parse((String)"1-03-04");
        static final ODate date2 = ODate.parse((String)"1969-09-22");
        static final ODate date3 = ODate.parse((String)"4526002-05-01");

        private QueryOnDate() {
        }

        private static void insertDoc(Connection connection, Table table, String id, ODate ts1, ODate ts2) {
            Document doc = connection.newDocument();
            doc.setId(id);
            doc.set("d1", ts1);
            doc.set("d2", ts2);
            table.insert(doc);
        }

        public void insertDocs(Connection connection, Table table, String rawTableName) throws IOException {
            QueryOnDate.insertDoc(connection, table, "1", date1, ODate.parse((String)"2017-05-15"));
            QueryOnDate.insertDoc(connection, table, "2", date2, ODate.parse((String)"2017-05-15"));
            QueryOnDate.insertDoc(connection, table, "3", date3, ODate.parse((String)"2016-05-15"));
            DBTests.waitForRowCount((String)rawTableName, (long)3L);
        }

        private static void runQuery(Connection connection, DocumentStore docStore, QueryCondition.Op op, ODate queryDate, String expectedId, ODate expectedDate, OjaiQueryProperties.QueryPath expectedPath) {
            Query query = connection.newQuery().select(new String[]{"d1", "_id"}).where(connection.newCondition().is("d1", op, queryDate).build()).build();
            try (DocumentStream docStream = docStore.findQuery(query);){
                int docCount = 0;
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertEquals((Object)expectedId, (Object)id);
                    ODate d1 = doc.getDate("d1");
                    Assert.assertEquals((Object)expectedDate, (Object)d1);
                    ++docCount;
                }
                Assert.assertEquals((long)1L, (long)docCount);
                Assert.assertEquals((Object)expectedPath, (Object)OjaiTest.getQueryPath(docStream));
            }
        }

        public void runQueries(Connection connection, DocumentStore docStore, OjaiQueryProperties.QueryPath expectedPath) {
            QueryOnDate.runQuery(connection, docStore, QueryCondition.Op.LESS, date2, "1", date1, expectedPath);
            QueryOnDate.runQuery(connection, docStore, QueryCondition.Op.EQUAL, date2, "2", date2, expectedPath);
            QueryOnDate.runQuery(connection, docStore, QueryCondition.Op.GREATER, date2, "3", date3, expectedPath);
        }
    }

    private static class QueryOnTimestamp {
        static final OTimestamp timestamp1 = OTimestamp.parse((String)"10-03-14T20:12:21.000+00:00");
        static final OTimestamp timestamp2 = OTimestamp.parse((String)"1969-12-31T20:12:21.000+00:00");
        static final OTimestamp timestamp3 = OTimestamp.parse((String)"148818705-10-07T09:58:24.613Z");

        private QueryOnTimestamp() {
        }

        private static void insertDoc(Connection connection, Table table, String id, OTimestamp ts1, OTimestamp ts2) {
            Document doc = connection.newDocument();
            doc.setId(id);
            doc.set("d1", ts1);
            doc.set("d2", ts2);
            table.insert(doc);
        }

        void insertDocs(Connection connection, String rawTableName, Table table) throws IOException {
            QueryOnTimestamp.insertDoc(connection, table, "1", timestamp1, OTimestamp.parse((String)"2007-01-10T20:00:21.000+00:00"));
            QueryOnTimestamp.insertDoc(connection, table, "2", timestamp2, OTimestamp.parse((String)"2000-01-31T22:02:05.000+00:00"));
            QueryOnTimestamp.insertDoc(connection, table, "3", timestamp3, OTimestamp.parse((String)"2015-03-14T10:10:10.000+00:00"));
            DBTests.waitForRowCount((String)rawTableName, (long)3L);
        }

        private static void runQuery(Connection connection, DocumentStore docStore, QueryCondition.Op op, OTimestamp queryTimestamp, String expectedId, OTimestamp expectedTimestamp, OjaiQueryProperties.QueryPath expectedPath) {
            Query query = connection.newQuery().select(new String[]{"d1", "_id"}).where(connection.newCondition().is("d1", op, queryTimestamp).build()).build();
            try (DocumentStream docStream = docStore.findQuery(query);){
                int docCount = 0;
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertEquals((Object)expectedId, (Object)id);
                    OTimestamp d1 = doc.getTimestamp("d1");
                    Assert.assertEquals((Object)expectedTimestamp, (Object)d1);
                    ++docCount;
                }
                Assert.assertEquals((long)1L, (long)docCount);
                Assert.assertEquals((Object)expectedPath, (Object)OjaiTest.getQueryPath(docStream));
            }
        }

        public void runQueries(Connection connection, DocumentStore docStore, OjaiQueryProperties.QueryPath expectedPath) {
            QueryOnTimestamp.runQuery(connection, docStore, QueryCondition.Op.LESS, timestamp2, "1", timestamp1, expectedPath);
            QueryOnTimestamp.runQuery(connection, docStore, QueryCondition.Op.EQUAL, timestamp2, "2", timestamp2, expectedPath);
            QueryOnTimestamp.runQuery(connection, docStore, QueryCondition.Op.GREATER, timestamp2, "3", timestamp3, expectedPath);
        }
    }

    private static class QueryOnTime {
        static final OTime time1 = OTime.parse((String)"20:12:22");
        static final OTime time2 = OTime.parse((String)"20:12:21");
        static final OTime time3 = OTime.parse((String)"10:12:21");

        private QueryOnTime() {
        }

        private static void insertDoc(Connection connection, Table table, String id, OTime ts1, OTime ts2) {
            Document doc = connection.newDocument();
            doc.setId(id);
            doc.set("d1", ts1);
            doc.set("d2", ts2);
            table.insert(doc);
        }

        private void insertDocs(Connection connection, Table table, String rawTableName) throws IOException {
            QueryOnTime.insertDoc(connection, table, "1", time1, OTime.parse((String)"20:00:21"));
            QueryOnTime.insertDoc(connection, table, "2", time2, OTime.parse((String)"22:02:05"));
            QueryOnTime.insertDoc(connection, table, "3", time3, OTime.parse((String)"10:10:10"));
            DBTests.waitForRowCount((String)rawTableName, (long)3L);
        }

        private static void runQuery(Connection connection, DocumentStore docStore, QueryCondition.Op op, OTime queryTime, String expectedId, OTime expectedTime, OjaiQueryProperties.QueryPath expectedPath) {
            Query query = connection.newQuery().select(new String[]{"d1", "_id"}).where(connection.newCondition().is("d1", op, queryTime).build()).build();
            try (DocumentStream docStream = docStore.findQuery(query);){
                int docCount = 0;
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertEquals((Object)expectedId, (Object)id);
                    OTime d1 = doc.getTime("d1");
                    Assert.assertEquals((Object)expectedTime, (Object)d1);
                    ++docCount;
                }
                Assert.assertEquals((long)1L, (long)docCount);
                Assert.assertEquals((Object)expectedPath, (Object)OjaiTest.getQueryPath(docStream));
            }
        }

        private void runQueries(Connection connection, DocumentStore docStore, OjaiQueryProperties.QueryPath expectedPath) {
            QueryOnTime.runQuery(connection, docStore, QueryCondition.Op.LESS, time2, "3", time3, expectedPath);
            QueryOnTime.runQuery(connection, docStore, QueryCondition.Op.EQUAL, time2, "2", time2, expectedPath);
            QueryOnTime.runQuery(connection, docStore, QueryCondition.Op.GREATER, time2, "1", time1, expectedPath);
        }
    }

    private static class QueryOnInt0 {
        static final int nDocs = 20;
        static final int condOperand1 = 10;
        static final int condOperand2 = 12;
        static final int condOperand3 = 112;
        static final int condOperand4 = 114;
        static final int condOperand5 = 117;
        static final int condOperand6 = 1017;

        private QueryOnInt0() {
        }

        private static void insertDoc(Connection connection, Table table, String id, int i1, int i2, int i3, int i4) {
            Document doc = connection.newDocument();
            doc.setId(id);
            doc.set("d1", i1);
            doc.set("d2", i2);
            doc.set("d3", i3);
            doc.set("d4", i4);
            table.insert(doc);
        }

        private void insertDocs(Connection connection, Table table, String rawTableName) throws IOException {
            for (int i = 0; i < 20; ++i) {
                QueryOnInt0.insertDoc(connection, table, Integer.toString(i), 10, 12 <= i && i <= 17 ? 12 : i, i + 100, 1017);
            }
            DBTests.waitForRowCount((String)rawTableName, (long)20L);
        }

        private static void runQuery(Connection connection, DocumentStore docStore, Query query, List<String> expectedId, OjaiQueryProperties.QueryPath expectedPath) {
            try (DocumentStream docStream = docStore.findQuery(query);){
                int docCount = 0;
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertEquals((Object)expectedId.get(docCount), (Object)id);
                    ++docCount;
                }
                Assert.assertEquals((long)3L, (long)docCount);
                Assert.assertEquals((Object)expectedPath, (Object)OjaiTest.getQueryPath(docStream));
            }
        }

        private void runQueries(Connection connection, DocumentStore docStore, OjaiQueryProperties.QueryPath expectedPath) {
            Query query = connection.newQuery().select(new String[]{"d1", "_id"}).where(connection.newCondition().and().is("d1", QueryCondition.Op.EQUAL, 10).is("d2", QueryCondition.Op.EQUAL, 12).or().is("d3", QueryCondition.Op.EQUAL, 112).is("d3", QueryCondition.Op.EQUAL, 114).is("d3", QueryCondition.Op.EQUAL, 117).close().is("d4", QueryCondition.Op.EQUAL, 1017).close().build()).build();
            QueryOnInt0.runQuery(connection, docStore, query, Arrays.asList("12", "14", "17"), expectedPath);
        }
    }

    private static class QueryOnInt {
        static final int nDocs = 20;
        static final int condOperand1 = 10;
        static final int condOperand2 = 10;

        private QueryOnInt() {
        }

        private static void insertDoc(Connection connection, Table table, String id, int i1, int i2) {
            Document doc = connection.newDocument();
            doc.setId(id);
            doc.set("d1", i1);
            doc.set("d2", i2);
            table.insert(doc);
        }

        private void insertDocs(Connection connection, Table table, String rawTableName) throws IOException {
            for (int i = 0; i < 20; ++i) {
                QueryOnInt.insertDoc(connection, table, "" + i, 10, i);
            }
            DBTests.waitForRowCount((String)rawTableName, (long)20L);
        }

        private static void runQuery(Connection connection, DocumentStore docStore, Query query, String expectedId, int expectedInt, OjaiQueryProperties.QueryPath expectedPath) {
            try (DocumentStream docStream = docStore.findQuery(query);){
                int docCount = 0;
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertEquals((Object)expectedId, (Object)id);
                    int d1 = doc.getInt("d1");
                    Assert.assertEquals((long)expectedInt, (long)d1);
                    ++docCount;
                }
                Assert.assertEquals((long)1L, (long)docCount);
                Assert.assertEquals((Object)expectedPath, (Object)OjaiTest.getQueryPath(docStream));
            }
        }

        private void runQueries(Connection connection, DocumentStore docStore, OjaiQueryProperties.QueryPath expectedPath) {
            Query query = connection.newQuery().select(new String[]{"d1", "_id"}).where(connection.newCondition().and().is("d1", QueryCondition.Op.EQUAL, 10).is("d2", QueryCondition.Op.EQUAL, 10).close().build()).build();
            QueryOnInt.runQuery(connection, docStore, query, "10", 10, expectedPath);
            query = connection.newQuery().select(new String[]{"d1", "_id"}).where(connection.newCondition().and().is("d1", QueryCondition.Op.EQUAL, 10).is("d2", QueryCondition.Op.LESS_OR_EQUAL, 10).is("d2", QueryCondition.Op.GREATER_OR_EQUAL, 10).close().build()).build();
            QueryOnInt.runQuery(connection, docStore, query, "10", 10, expectedPath);
            query = connection.newQuery().select(new String[]{"d1", "_id"}).where(connection.newCondition().and().is("d1", QueryCondition.Op.LESS_OR_EQUAL, 10).is("d1", QueryCondition.Op.GREATER_OR_EQUAL, 10).is("d2", QueryCondition.Op.EQUAL, 10).close().build()).build();
            QueryOnInt.runQuery(connection, docStore, query, "10", 10, expectedPath);
            query = connection.newQuery().select(new String[]{"d1", "_id"}).where(connection.newCondition().and().is("d1", QueryCondition.Op.LESS_OR_EQUAL, 10).is("d1", QueryCondition.Op.GREATER_OR_EQUAL, 10).is("d2", QueryCondition.Op.LESS_OR_EQUAL, 10).is("d2", QueryCondition.Op.GREATER_OR_EQUAL, 10).close().build()).build();
            QueryOnInt.runQuery(connection, docStore, query, "10", 10, expectedPath);
        }
    }

    private static class SharedTable27089
    extends SharedTestTable {
        private String indexName;

        public SharedTable27089() {
            super("bug27089");
        }

        @Override
        protected String initialize(Connection connection, String rawTableName) throws Exception {
            try (Table table = DBTests.createOrGetTable((String)rawTableName);){
                Path tablePath = table.getPath();
                String tableName = tablePath.toString();
                this.indexName = rawTableName + "_idx";
                DBTests.createIndex((Table)table, (String)this.indexName, (boolean)false, (int)0, (String[])new String[]{"i1"}, null, null);
                this.insertDoc(connection, table, "1", 1, "foo");
                this.insertDoc(connection, table, "2", 42, "bar");
                this.insertDoc(connection, table, "3", 3, "baz");
                this.insertDoc(connection, table, "4", 17, "tip");
                String string = tableName;
                return string;
            }
        }

        private void insertDoc(Connection connection, Table table, String id, int i, String s) {
            Document doc = connection.newDocument();
            doc.setId(id);
            doc.set("i1", i);
            doc.set("s1", s);
            table.insert(doc);
        }

        @Override
        public long getNumRows() {
            return 4L;
        }

        public String getIndexName() {
            return this.indexName;
        }
    }
}

