/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.mapr.db.Table;
import com.mapr.db.exceptions.TableClosedException;
import com.mapr.db.exceptions.TableNotFoundException;
import com.mapr.db.impl.BaseJsonTable;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.DBDocumentStream;
import com.mapr.db.impl.IdCodec;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.impl.MultiGet;
import com.mapr.db.impl.OjaiQueryProperties;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.ojai.store.impl.AppsUserProfiles;
import com.mapr.ojai.store.impl.CollectingDocumentListener;
import com.mapr.ojai.store.impl.OjaiConnection;
import com.mapr.ojai.store.impl.OjaiDocumentStore;
import com.mapr.ojai.store.impl.OjaiQuery;
import com.mapr.ojai.store.impl.OjaiTest;
import com.mapr.ojai.store.impl.SharedTestTable;
import com.mapr.ojai.store.impl.StringGenerator;
import com.mapr.ojai.store.impl.UnionDocumentStream;
import com.mapr.tests.annotations.ClusterTest;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.Path;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.DocumentBuilder;
import org.ojai.DocumentConstants;
import org.ojai.DocumentListener;
import org.ojai.DocumentReader;
import org.ojai.DocumentStream;
import org.ojai.FieldPath;
import org.ojai.Value;
import org.ojai.store.Connection;
import org.ojai.store.DocumentMutation;
import org.ojai.store.DocumentStore;
import org.ojai.store.Query;
import org.ojai.store.QueryCondition;
import org.ojai.store.SortOrder;
import org.ojai.types.ODate;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;
import org.ojai.util.Documents;

@Category(value={ClusterTest.class})
public class TestOjaiDocumentStore
extends OjaiTest {
    private static final int TIMEOUT_SECONDS = 5;
    private static final String TABLE_NAME = "user_profiles_doc_store";
    private static final String SIZEOF_TABLE = "sizeof_t";
    private static final String TYPEOF_TABLE = "typeof_t";
    private static final String MATCHES_TABLE = "matches_t";
    private static final String EQUALS_TABLE = "equals_t";
    private static final SharedTestTable sharedTable28535 = new SharedTestTable("bug28535"){

        @Override
        protected String initialize(Connection connection, String rawTableName) throws Exception {
            String tableName = DBTests.getFullPath((String)rawTableName);
            Table table = DBTests.createOrGetTable((String)rawTableName);
            Throwable throwable = null;
            if (table != null) {
                if (throwable != null) {
                    try {
                        table.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    table.close();
                }
            }
            return tableName;
        }

        @Override
        public long getNumRows() {
            return 0L;
        }
    };
    private static final Class<?>[] bug27711Case = new Class[]{Bug27711Float.class, Bug27711Int.class, Bug27711String.class};
    private static final SharedTable27809 sharedTable27809 = new SharedTable27809();
    private static SharedTable27024 sharedTable27024 = new SharedTable27024();
    private static final SharedTestTable sharedTable27954 = new SharedTestTable("bug27954"){

        @Override
        protected String initialize(Connection connection, String rawTableName) throws Exception {
            String tableName = DBTests.getFullPath((String)rawTableName);
            try (Table table = DBTests.createOrGetTable((String)rawTableName);){
                Document doc1 = connection.newDocument();
                doc1.setId("1");
                doc1.set("a", 1L);
                doc1.set("b", "anisha");
                table.insert(doc1);
                Document doc2 = connection.newDocument();
                doc2.setId("2");
                doc2.set("a", 2L);
                doc2.set("b", "zara");
                table.insert(doc2);
                Document doc3 = connection.newDocument();
                doc3.setId("3");
                doc3.set("a", 3L);
                doc3.set("c", "pk");
                table.insert(doc3);
            }
            return tableName;
        }

        @Override
        public long getNumRows() {
            return 3L;
        }
    };
    private static final String MULTIGET_TABLE = "multiget";

    @BeforeClass
    public static void setupTest() throws Exception {
        TestOjaiDocumentStore.cleanupTest();
        AppsUserProfiles.getPopulatedTable(TABLE_NAME);
    }

    @AfterClass
    public static void cleanupTest() throws IOException {
        DBTests.deleteTables((String[])new String[]{TABLE_NAME});
        DBTests.deleteTables((String[])new String[]{SIZEOF_TABLE});
        DBTests.deleteTables((String[])new String[]{TYPEOF_TABLE});
    }

    @Test
    public void testFind() throws Exception {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            DocumentStore docStore = connection.getStore(DBTests.getFullPath((String)TABLE_NAME));
            Assert.assertNotNull((Object)docStore);
            Query query = connection.newQuery().select(new String[]{"last_name"}).build();
            List<Document> docList = OjaiTest.collectStreamingFind(docStore, query, 5, null);
            Assert.assertEquals((long)4L, (long)docList.size());
        }
    }

    @Test
    public void testFindById() {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            DocumentStore docStore = connection.getStore(DBTests.getFullPath((String)TABLE_NAME));
            Assert.assertNotNull((Object)docStore);
            List<Document> zoolanderList = TestOjaiDocumentStore.findByStringId((Connection)connection, docStore, "Zoolander");
            Assert.assertEquals((long)0L, (long)zoolanderList.size());
            List<Document> smithList = TestOjaiDocumentStore.findByStringId((Connection)connection, docStore, "dsimon");
            Assert.assertEquals((long)1L, (long)smithList.size());
        }
    }

    @Test
    public void testFindByIdBatch() {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
             DocumentStore docStore = connection.getStore(DBTests.getFullPath((String)TABLE_NAME));){
            Assert.assertNotNull((Object)docStore);
            OjaiDocumentStore ojaiDocStore = (OjaiDocumentStore)docStore;
            BaseJsonTable table = ojaiDocStore.getTable();
            Assert.assertNotNull((Object)table);
            BaseJsonTable jsonTable = table;
            ByteBuffer[] ids = new ByteBuffer[]{IdCodec.encode((String)"dsimon"), IdCodec.encode((String)"mdupont")};
            MultiGet multiGet = new MultiGet(jsonTable, null, jsonTable.isExcludeId(), (String[])null);
            List docList = multiGet.doGet(ids);
            Assert.assertEquals((long)2L, (long)docList.size());
        }
    }

    @Test
    public void testFindByIdBatchUnsorted() {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
             DocumentStore docStore = connection.getStore(DBTests.getFullPath((String)TABLE_NAME));){
            Assert.assertNotNull((Object)docStore);
            OjaiDocumentStore ojaiDocStore = (OjaiDocumentStore)docStore;
            BaseJsonTable table = ojaiDocStore.getTable();
            Assert.assertNotNull((Object)table);
            BaseJsonTable jsonTable = table;
            ByteBuffer[] ids = new ByteBuffer[]{IdCodec.encode((String)"mdupont"), IdCodec.encode((String)"dsimon")};
            MultiGet multiGet = new MultiGet(jsonTable, null, jsonTable.isExcludeId(), (String[])null);
            List docList = multiGet.doGet(ids);
            Assert.assertEquals((long)2L, (long)docList.size());
            Assert.assertEquals((Object)((Document)docList.get(0)).getString("first_name"), (Object)"Maxime");
            Assert.assertEquals((Object)((Document)docList.get(1)).getString("last_name"), (Object)"Simon");
        }
    }

    @Test
    public void testFindByIdBatchNonExistentID() {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
             DocumentStore docStore = connection.getStore(DBTests.getFullPath((String)TABLE_NAME));){
            Assert.assertNotNull((Object)docStore);
            OjaiDocumentStore ojaiDocStore = (OjaiDocumentStore)docStore;
            BaseJsonTable table = ojaiDocStore.getTable();
            Assert.assertNotNull((Object)table);
            BaseJsonTable jsonTable = table;
            ByteBuffer[] ids = new ByteBuffer[]{IdCodec.encode((String)"Zoolander"), IdCodec.encode((String)"dsimon")};
            MultiGet multiGet = new MultiGet(jsonTable, null, jsonTable.isExcludeId(), (String[])null);
            List docList = multiGet.doGet(ids);
            Assert.assertEquals((long)1L, (long)docList.size());
            Assert.assertEquals((Object)((Document)docList.get(0)).getString("last_name"), (Object)"Simon");
        }
    }

    private static void testIdInDoQuery(DocumentStore docStore, Query query, List<String> idList, boolean expectId) {
        query.build();
        Assert.assertEquals((Object)expectId, (Object)((OjaiQuery)query).includeId());
        try (DocumentStream docStream = docStore.findQuery(query);){
            int docCount = 0;
            for (Document doc : docStream) {
                String id = doc.getIdString();
                Assert.assertNotNull((Object)id);
                Assert.assertTrue((boolean)idList.contains(id));
                String lastName = doc.getString("last_name");
                Assert.assertNotNull((Object)lastName);
                String firstName = doc.getString("first_name");
                Assert.assertNotNull((Object)firstName);
                String docString = doc.toString();
                Assert.assertEquals((Object)expectId, (Object)docString.contains("\"_id\":"));
                ++docCount;
            }
            Assert.assertEquals((long)2L, (long)docCount);
            Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)OjaiTest.getQueryPath(docStream));
        }
    }

    @Test
    public void testIdIn() {
        ImmutableList idList = ImmutableList.of((Object)"dsimon", (Object)"mdupont");
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
             DocumentStore docStore = connection.getStore(DBTests.getFullPath((String)TABLE_NAME));){
            Assert.assertNotNull((Object)docStore);
            QueryCondition condition = connection.newCondition().in(DocumentConstants.ID_FIELD, (List)idList).build();
            Query query = connection.newQuery().where(condition);
            TestOjaiDocumentStore.testIdInDoQuery(docStore, query, (List<String>)idList, true);
            Query queryStar = connection.newQuery().select(new String[]{"*"}).where(condition);
            TestOjaiDocumentStore.testIdInDoQuery(docStore, queryStar, (List<String>)idList, true);
            Query queryFields = connection.newQuery().select(new String[]{"last_name", "first_name"}).where(condition);
            TestOjaiDocumentStore.testIdInDoQuery(docStore, queryFields, (List<String>)idList, false);
            Query queryFieldsId = connection.newQuery().select(new String[]{"last_name", "first_name", "_id"}).where(condition);
            TestOjaiDocumentStore.testIdInDoQuery(docStore, queryFieldsId, (List<String>)idList, true);
        }
    }

    @Test
    public void testDirectQueries() throws Exception {
        String tablePath = DBTests.getFullPath((String)TABLE_NAME);
        try (Table table = DBTests.getTable((String)TABLE_NAME);){
            DBTests.createIndex((Table)table, (String)"last_name_idx", (boolean)false, (int)0, (String[])new String[]{"last_name"}, null, (String[])new String[]{"first_name"});
        }
        String LAST_NAME = "Simon";
        String FIRST_NAME = "David";
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            DocumentStore docStore = connection.getStore(tablePath);
            Assert.assertNotNull((Object)docStore);
            Query coverQuery = connection.newQuery().select(new String[]{"last_name", "first_name"}).where(connection.newCondition().is("last_name", QueryCondition.Op.EQUAL, "Simon").build()).build();
            DocumentStream coverStream = docStore.findQuery(coverQuery);
            Document coverDocument = DBTests.getSingleDocument((DocumentStream)coverStream);
            Assert.assertNotNull((Object)coverDocument);
            Assert.assertEquals((Object)"Simon", (Object)coverDocument.getString("last_name"));
            Assert.assertEquals((Object)"David", (Object)coverDocument.getString("first_name"));
            Assert.assertNull((Object)coverDocument.getDate("dob"));
            Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)OjaiTest.getQueryPath(coverStream));
            Assert.assertTrue((boolean)(coverStream instanceof DBDocumentStream));
            Query nonCoverQuery = connection.newQuery().select(new String[]{"last_name", "dob"}).where(connection.newCondition().is("last_name", QueryCondition.Op.EQUAL, "Simon").build()).build();
            DocumentStream nonCoverStream = docStore.findQuery(nonCoverQuery);
            Document nonCoverDocument = DBTests.getSingleDocument((DocumentStream)nonCoverStream);
            Assert.assertNotNull((Object)nonCoverDocument);
            Assert.assertEquals((Object)"Simon", (Object)nonCoverDocument.getString("last_name"));
            Assert.assertNull((Object)nonCoverDocument.getString("first_name"));
            Assert.assertNotNull((Object)nonCoverDocument.getDate("dob"));
            Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)OjaiTest.getQueryPath(nonCoverStream));
        }
    }

    @Test
    public void testDirectQueries_id_range() throws IOException {
        String tablePath = DBTests.getFullPath((String)TABLE_NAME);
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
             DocumentStore docStore = connection.getStore(tablePath);){
            Assert.assertNotNull((Object)docStore);
            String lowerBound = "dt";
            String upperBound = "rr";
            Query coverQuery = connection.newQuery().select(new String[]{"_id", "last_name", "first_name"}).where(connection.newCondition().and().is("_id", QueryCondition.Op.GREATER, "dt").is("_id", QueryCondition.Op.LESS, "rr").close().build()).build();
            DocumentStream docStream = docStore.findQuery(coverQuery);
            int docCount = 0;
            for (Document doc : docStream) {
                ++docCount;
                String id = doc.getIdString();
                Assert.assertTrue((id.compareTo("dt") > 0 ? 1 : 0) != 0);
                Assert.assertTrue((id.compareTo("rr") < 0 ? 1 : 0) != 0);
            }
            Assert.assertEquals((long)2L, (long)docCount);
            Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)OjaiTest.getQueryPath(docStream));
        }
    }

    private void testQuery_offset_limit(OjaiQueryProperties.QueryPath queryPath) throws Exception {
        String tablePath = DBTests.getFullPath((String)TABLE_NAME);
        FieldPath lastPath = FieldPath.parseFrom((String)"last_name");
        FieldPath firstPath = FieldPath.parseFrom((String)"first_name");
        FieldPath[] fieldPaths = new FieldPath[]{lastPath, firstPath};
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            DocumentStore docStore = connection.getStore(tablePath);
            Assert.assertNotNull((Object)docStore);
            Query query = connection.newQuery().select(fieldPaths).orderBy(fieldPaths).limit(1L).offset(2L);
            if (queryPath == OjaiQueryProperties.QueryPath.DRILL) {
                query.setOption("ojai.mapr.query.force-drill", (Object)true);
            }
            query.build();
            OjaiTest.DocumentStreamRef docRef = new OjaiTest.DocumentStreamRef();
            List<Document> streamedResult = OjaiTest.collectStreamingFind(docStore, query, 5, docRef);
            Assert.assertEquals((long)1L, (long)streamedResult.size());
            Document streamedDoc = streamedResult.get(0);
            Assert.assertEquals((Object)"Simon", (Object)streamedDoc.getString("last_name"));
            Assert.assertEquals((Object)"David", (Object)streamedDoc.getString("first_name"));
            TestOjaiDocumentStore.assertQueryPath(docRef.docStream, queryPath);
            LinkedList<Document> iteratedResult = new LinkedList<Document>();
            DocumentStream iteratedStream = docStore.findQuery(query);
            for (Document doc : iteratedStream) {
                iteratedResult.add(doc);
            }
            Assert.assertEquals((long)1L, (long)iteratedResult.size());
            Document iteratedDoc = (Document)iteratedResult.get(0);
            Assert.assertEquals((Object)"Simon", (Object)iteratedDoc.getString("last_name"));
            TestOjaiDocumentStore.assertQueryPath(iteratedStream, queryPath);
            iteratedStream.close();
            LinkedList<Document> readerResult = new LinkedList<Document>();
            DocumentStream readerStream = docStore.findQuery(query);
            Iterable readerIterable = readerStream.documentReaders();
            for (DocumentReader docReader : readerIterable) {
                DocumentBuilder docBuilder = TestOjaiDocumentStore.getDriver().newDocumentBuilder();
                Documents.writeReaderToBuilder((DocumentReader)docReader, (DocumentBuilder)docBuilder);
                Document doc = docBuilder.getDocument();
                readerResult.add(doc);
            }
            Assert.assertEquals((long)1L, (long)readerResult.size());
            Document readerDoc = (Document)readerResult.get(0);
            Assert.assertEquals((Object)"Simon", (Object)readerDoc.getString("last_name"));
            TestOjaiDocumentStore.assertQueryPath(iteratedStream, queryPath);
            Assert.assertEquals((Object)streamedDoc, (Object)iteratedDoc);
            Assert.assertEquals((Object)iteratedDoc, (Object)readerDoc);
        }
    }

    @Test
    public void testQuery_offset_limit() throws Exception {
        this.testQuery_offset_limit(OjaiQueryProperties.QueryPath.DRILL);
        try (Table table = DBTests.getTable((String)TABLE_NAME);){
            DBTests.createIndex((Table)table, (String)"lnfn_idx", (boolean)false, (int)0, (String[])new String[]{"last_name", "first_name"}, null, null);
        }
        DBTests.waitForIndexFlush((String)TABLE_NAME);
        this.testQuery_offset_limit(OjaiQueryProperties.QueryPath.DIRECT);
    }

    private static List<Document> findByStringField(Connection connection, DocumentStore docStore, FieldPath fieldPath, String id, OjaiQueryProperties.QueryPath expectedPath) {
        Query query = connection.newQuery().where(connection.newCondition().is(fieldPath, QueryCondition.Op.EQUAL, id).build()).build();
        LinkedList<Document> docList = new LinkedList<Document>();
        Semaphore doneSem = new Semaphore(0);
        DocumentStream docStream = docStore.findQuery(query);
        Assert.assertEquals((Object)expectedPath, (Object)((OjaiQueryProperties)docStream).getQueryPath());
        docStream.streamTo((DocumentListener)new CollectingDocumentListener(docList, doneSem));
        try {
            doneSem.tryAcquire(1, 5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException("timed out waiting for result", ex);
        }
        return docList;
    }

    private static List<Document> findByStringId(Connection connection, DocumentStore docStore, String id) {
        Preconditions.checkNotNull((Object)connection);
        Preconditions.checkNotNull((Object)docStore);
        Preconditions.checkNotNull((Object)id);
        OjaiDocumentStore ojaiStore = (OjaiDocumentStore)docStore;
        Assert.assertNotNull((Object)ojaiStore);
        List<Document> docList = TestOjaiDocumentStore.findByStringField(connection, docStore, DocumentConstants.ID_FIELD, id, OjaiQueryProperties.QueryPath.DIRECT);
        return docList;
    }

    @Test
    public void testDeleteById() {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            DocumentStore docStore = connection.getStore(DBTests.getFullPath((String)TABLE_NAME));
            Assert.assertNotNull((Object)docStore);
            List<Document> listBefore = TestOjaiDocumentStore.findByStringId((Connection)connection, docStore, "jdoe");
            Assert.assertEquals((long)1L, (long)listBefore.size());
            Document idDoc = connection.newDocument();
            idDoc.set(DocumentConstants.ID_FIELD, "jdoe");
            docStore.delete(idDoc);
            docStore.flush();
            List<Document> listAfter = TestOjaiDocumentStore.findByStringId((Connection)connection, docStore, "jdoe");
            Assert.assertEquals((long)0L, (long)listAfter.size());
        }
    }

    @Test
    @Category(value={ClusterTest.class})
    public void testFindByOtherField() {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            DocumentStore docStore = connection.getStore(DBTests.getFullPath((String)TABLE_NAME));
            Assert.assertNotNull((Object)docStore);
            OjaiDocumentStore ojaiStore = (OjaiDocumentStore)docStore;
            Assert.assertNotNull((Object)ojaiStore);
            List<Document> docList = TestOjaiDocumentStore.findByStringField((Connection)connection, docStore, AppsUserProfiles.FIRST_NAME_FIELD, "David", OjaiQueryProperties.QueryPath.DIRECT);
            Assert.assertEquals((long)1L, (long)docList.size());
            Document doc = docList.remove(0);
            Assert.assertNotNull((Object)doc);
            String lastName = doc.getString(AppsUserProfiles.LAST_NAME_FIELD);
            Assert.assertEquals((Object)"Simon", (Object)lastName);
        }
    }

    private static Document insertAbs(Connection connection, Table table, String id, String a, String b, String s) {
        Document document = connection.newDocument();
        document.set("_id", id);
        document.set("a", a);
        document.set("b", b);
        document.set("s", s);
        table.insert(document);
        return document;
    }

    @Test
    public void testBug28386() throws IOException {
        String TEST_TABLE_NAME = "testBug28386_t";
        String tablePath = DBTests.getFullPath((String)"testBug28386_t");
        Table table = DBTests.createOrGetTable((String)"testBug28386_t");
        Throwable throwable = null;
        if (table != null) {
            if (throwable != null) {
                try {
                    table.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                table.close();
            }
        }
        throwable = null;
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
             DocumentStore docStore = connection.getStore(tablePath);){
            Assert.assertNotNull((Object)docStore);
            OjaiDocumentStore ojaiDocStore = (OjaiDocumentStore)docStore;
            BaseJsonTable table2 = ojaiDocStore.getTable();
            Assert.assertNotNull((Object)table2);
            table2.insert(connection.newDocument().set("_id", "1").setArray("a", new int[]{1, 2, 3, 4}));
            table2.flush();
            DBTests.waitForRowCount((String)table2.getName(), (long)1L);
            boolean[] forceDrill = new boolean[]{true, false};
            for (int i = 0; i < 2; ++i) {
                Query query1 = connection.newQuery().setOption("ojai.mapr.query.force-drill", (Object)forceDrill[i]).select(new String[]{"a[1]"}).select(new String[]{"a[3]"}).orderBy(new String[]{"a[2]"}).build();
                Iterable readerStream = ojaiDocStore.findQuery(query1).documentReaders();
                int docCount = 0;
                for (DocumentReader reader : readerStream) {
                    Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)reader.next());
                    Assert.assertEquals((Object)DocumentReader.EventType.START_ARRAY, (Object)reader.next());
                    Assert.assertEquals((Object)DocumentReader.EventType.INT, (Object)reader.next());
                    Assert.assertEquals((long)1L, (long)reader.getArrayIndex());
                    Assert.assertEquals((Object)DocumentReader.EventType.INT, (Object)reader.next());
                    Assert.assertEquals((long)3L, (long)reader.getArrayIndex());
                    Assert.assertEquals((Object)DocumentReader.EventType.END_ARRAY, (Object)reader.next());
                    Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)reader.next());
                    Assert.assertNull((Object)reader.next());
                    ++docCount;
                }
                Assert.assertEquals((long)1L, (long)docCount);
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
    }

    @Test
    public void testFind_sizeOf() throws IOException {
        String tablePath = DBTests.getFullPath((String)SIZEOF_TABLE);
        Table table = DBTests.createOrGetTable((String)SIZEOF_TABLE);
        Throwable throwable = null;
        if (table != null) {
            if (throwable != null) {
                try {
                    table.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                table.close();
            }
        }
        throwable = null;
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
             DocumentStore docStore = connection.getStore(tablePath);){
            Assert.assertNotNull((Object)docStore);
            OjaiDocumentStore ojaiDocStore = (OjaiDocumentStore)docStore;
            BaseJsonTable table2 = ojaiDocStore.getTable();
            Assert.assertNotNull((Object)table2);
            TestOjaiDocumentStore.insertAbs((Connection)connection, (Table)table2, "1", "a1", "b1", "s2");
            TestOjaiDocumentStore.insertAbs((Connection)connection, (Table)table2, "2", "a2", "b2", "s33");
            TestOjaiDocumentStore.insertAbs((Connection)connection, (Table)table2, "3", "a3", "b3", "s444");
            TestOjaiDocumentStore.insertAbs((Connection)connection, (Table)table2, "4", "a4", "b4", "s");
            DBTests.waitForRowCount((String)table2.getName(), (long)4L);
            QueryCondition queryCondSizeOf = connection.newCondition().sizeOf("s", QueryCondition.Op.GREATER_OR_EQUAL, 3L).build();
            DocumentStream tableStream = table2.find(queryCondSizeOf, new String[]{"a", "b", "s"});
            int docCount = 0;
            for (Document doc : tableStream) {
                String s = doc.getString("s");
                Assert.assertTrue((s.length() >= 3 ? 1 : 0) != 0);
                ++docCount;
            }
            Assert.assertEquals((long)2L, (long)docCount);
            Query querySortedSizeOf = connection.newQuery().select(new String[]{"a", "b", "s"}).where(connection.newCondition().sizeOf("s", QueryCondition.Op.LESS_OR_EQUAL, 2L).build()).orderBy(new String[]{"b"}).build();
            DocumentStream drillStream = docStore.findQuery(querySortedSizeOf);
            docCount = 0;
            String lastB = "";
            for (Document doc : drillStream) {
                String s = doc.getString("s");
                Assert.assertTrue((s.length() <= 2 ? 1 : 0) != 0);
                String b = doc.getString("b");
                Assert.assertTrue((b.compareTo(lastB) > 0 ? 1 : 0) != 0);
                lastB = b;
                ++docCount;
            }
            Assert.assertEquals((long)2L, (long)docCount);
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
    }

    private static Document insertVts(Connection connection, Table table, String id, Object v, String t) {
        Document document = connection.newDocument();
        document.set("_id", id);
        document.set("t", t);
        if (v instanceof String) {
            document.set("v", (String)v);
        } else if (v instanceof Integer) {
            document.set("v", ((Integer)v).intValue());
        } else {
            throw new IllegalArgumentException("no case for v of type " + v.getClass());
        }
        table.insert(document);
        return document;
    }

    @Test
    public void testFind_typeOf() throws IOException {
        String tablePath = DBTests.getFullPath((String)TYPEOF_TABLE);
        Table table = DBTests.createOrGetTable((String)TYPEOF_TABLE);
        Throwable throwable = null;
        if (table != null) {
            if (throwable != null) {
                try {
                    table.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                table.close();
            }
        }
        throwable = null;
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
             DocumentStore docStore = connection.getStore(tablePath);){
            Assert.assertNotNull((Object)docStore);
            OjaiDocumentStore ojaiDocStore = (OjaiDocumentStore)docStore;
            BaseJsonTable table2 = ojaiDocStore.getTable();
            Assert.assertNotNull((Object)table2);
            TestOjaiDocumentStore.insertVts((Connection)connection, (Table)table2, "1", "foo", "STRING");
            TestOjaiDocumentStore.insertVts((Connection)connection, (Table)table2, "2", 17, "INT");
            DBTests.waitForRowCount((String)table2.getName(), (long)2L);
            Query queryTypeOf = connection.newQuery().where(connection.newCondition().typeOf("v", Value.Type.STRING).build()).build();
            DocumentStream typeOfDrillStream = docStore.findQuery(queryTypeOf);
            int docCount = 0;
            for (Document doc : typeOfDrillStream) {
                String id = doc.getIdString();
                Assert.assertEquals((Object)"1", (Object)id);
                ++docCount;
            }
            Assert.assertEquals((long)1L, (long)docCount);
            Query queryNotTypeOf = connection.newQuery().where(connection.newCondition().notTypeOf("v", Value.Type.STRING).build()).build();
            DocumentStream notTypeOfDrillStream = docStore.findQuery(queryNotTypeOf);
            docCount = 0;
            for (Document doc : notTypeOfDrillStream) {
                String id = doc.getIdString();
                Assert.assertEquals((Object)"2", (Object)id);
                ++docCount;
            }
            Assert.assertEquals((long)1L, (long)docCount);
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
    }

    private static Document insertS(Connection connection, Table table, String id, String s) {
        Document document = connection.newDocument();
        document.set("_id", id);
        document.set("s", s);
        table.insert(document);
        return document;
    }

    @Test
    public void testFind_matches() throws IOException {
        String tablePath = DBTests.getFullPath((String)MATCHES_TABLE);
        Table table = DBTests.createOrGetTable((String)MATCHES_TABLE);
        Throwable throwable = null;
        if (table != null) {
            if (throwable != null) {
                try {
                    table.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                table.close();
            }
        }
        throwable = null;
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
             DocumentStore docStore = connection.getStore(tablePath);){
            Assert.assertNotNull((Object)docStore);
            OjaiDocumentStore ojaiDocStore = (OjaiDocumentStore)docStore;
            BaseJsonTable table2 = ojaiDocStore.getTable();
            Assert.assertNotNull((Object)table2);
            TestOjaiDocumentStore.insertS((Connection)connection, (Table)table2, "1", "foo");
            TestOjaiDocumentStore.insertS((Connection)connection, (Table)table2, "2", "42");
            DBTests.waitForRowCount((String)table2.getName(), (long)2L);
            String regex = "[0-9]+";
            Query queryMatches = connection.newQuery().where(connection.newCondition().matches("s", "[0-9]+").build()).build();
            DocumentStream matchesDrillStream = docStore.findQuery(queryMatches);
            int docCount = 0;
            for (Document doc : matchesDrillStream) {
                String id = doc.getIdString();
                Assert.assertEquals((Object)"2", (Object)id);
                ++docCount;
            }
            Assert.assertEquals((long)1L, (long)docCount);
            Query queryNotMatches = connection.newQuery().where(connection.newCondition().notMatches("s", "[0-9]+").build()).build();
            DocumentStream notMatchesDrillStream = docStore.findQuery(queryNotMatches);
            docCount = 0;
            for (Document doc : notMatchesDrillStream) {
                String id = doc.getIdString();
                Assert.assertEquals((Object)"1", (Object)id);
                ++docCount;
            }
            Assert.assertEquals((long)1L, (long)docCount);
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
    }

    private static List<Object> makeList(Object ... items) {
        LinkedList<Object> list = new LinkedList<Object>();
        for (Object o : items) {
            list.add(o);
        }
        return list;
    }

    private static Document insertL(Connection connection, Table table, String id, Object ... items) {
        Document document = connection.newDocument();
        document.set("_id", id);
        document.set("list", TestOjaiDocumentStore.makeList(items));
        table.insert(document);
        return document;
    }

    @Test
    public void testFind_equals() throws IOException {
        String tablePath = DBTests.getFullPath((String)EQUALS_TABLE);
        Table table = DBTests.createOrGetTable((String)EQUALS_TABLE);
        Throwable throwable = null;
        if (table != null) {
            if (throwable != null) {
                try {
                    table.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                table.close();
            }
        }
        throwable = null;
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
             DocumentStore docStore = connection.getStore(tablePath);){
            Assert.assertNotNull((Object)docStore);
            OjaiDocumentStore ojaiDocStore = (OjaiDocumentStore)docStore;
            BaseJsonTable table2 = ojaiDocStore.getTable();
            Assert.assertNotNull((Object)table2);
            TestOjaiDocumentStore.insertL((Connection)connection, (Table)table2, "1", "foo", "Bar", "Baz");
            TestOjaiDocumentStore.insertL((Connection)connection, (Table)table2, "2", 42, 17);
            DBTests.waitForRowCount((String)table2.getName(), (long)2L);
            Query equalsQuery = connection.newQuery().where(connection.newCondition().equals("list", TestOjaiDocumentStore.makeList(42, 17)).build()).build();
            DocumentStream equalsStream = docStore.findQuery(equalsQuery);
            int docCount = 0;
            for (Document doc : equalsStream) {
                String id = doc.getIdString();
                Assert.assertEquals((Object)"2", (Object)id);
                ++docCount;
            }
            Assert.assertEquals((long)1L, (long)docCount);
            TestOjaiDocumentStore.assertQueryPath(equalsStream, OjaiQueryProperties.QueryPath.DIRECT);
            Query notEqualsQuery = connection.newQuery().where(connection.newCondition().notEquals("list", TestOjaiDocumentStore.makeList(42, 17)).build()).build();
            DocumentStream notEqualsDrillStream = docStore.findQuery(notEqualsQuery);
            docCount = 0;
            for (Document doc : notEqualsDrillStream) {
                String id = doc.getIdString();
                Assert.assertEquals((Object)"1", (Object)id);
                ++docCount;
            }
            Assert.assertEquals((long)1L, (long)docCount);
            TestOjaiDocumentStore.assertQueryPath(notEqualsDrillStream, OjaiQueryProperties.QueryPath.DIRECT);
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
    }

    private static void insertFoo(Connection connection, DocumentStore docStore, String id, int foo) {
        Document doc = connection.newDocument();
        doc.setId(id);
        doc.set("foo", foo);
        docStore.insert(doc);
    }

    @Test(expected=IllegalArgumentException.class)
    @Category(value={ClusterTest.class})
    public void testWaitForCommitInvalid1() throws IOException {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            String tableName = sharedTable28535.prepare((Connection)connection);
            try (DocumentStore docStore = connection.getStore(tableName);){
                docStore.beginTrackingWrites(new String("invalid"));
                Assert.assertTrue((boolean)false);
            }
        }
    }

    @Test(expected=IllegalStateException.class)
    @Category(value={ClusterTest.class})
    public void testWaitForCommitInvalid2() throws IOException {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            String tableName = sharedTable28535.prepare((Connection)connection);
            try (DocumentStore docStore = connection.getStore(tableName);){
                docStore.beginTrackingWrites();
                docStore.beginTrackingWrites();
                Assert.assertTrue((boolean)false);
            }
        }
    }

    @Test(expected=IllegalStateException.class)
    @Category(value={ClusterTest.class})
    public void testWaitForCommitInvalid3() throws IOException {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            String tableName = sharedTable28535.prepare((Connection)connection);
            try (DocumentStore docStore = connection.getStore(tableName);){
                docStore.beginTrackingWrites();
                String ctx = docStore.endTrackingWrites();
                docStore.beginTrackingWrites();
                docStore.beginTrackingWrites(ctx);
                Assert.assertTrue((boolean)false);
            }
        }
    }

    @Test
    @Category(value={ClusterTest.class})
    public void testWaitForCommit() throws IOException {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            String rawTableName = "wait_one";
            this.addCleanupTable("wait_one");
            Table table = DBTests.createOrGetTable((String)"wait_one");
            Throwable throwable = null;
            if (table != null) {
                if (throwable != null) {
                    try {
                        table.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    table.close();
                }
            }
            String tableName = DBTests.getFullPath((String)"wait_one");
            this.addCleanupTable(tableName);
            try (DocumentStore docStore = connection.getStore(tableName);){
                docStore.beginTrackingWrites();
                TestOjaiDocumentStore.insertFoo((Connection)connection, docStore, "1", 7);
                TestOjaiDocumentStore.insertFoo((Connection)connection, docStore, "2", 16);
                TestOjaiDocumentStore.insertFoo((Connection)connection, docStore, "3", 23);
                String commitContext = docStore.endTrackingWrites();
                Query query = connection.newQuery().waitForTrackedWrites(commitContext).select(new String[]{"foo"}).where(connection.newCondition().is("foo", QueryCondition.Op.GREATER_OR_EQUAL, 17).build()).build();
                try (DocumentStream docStream = docStore.findQuery(query);){
                    int docCount = 0;
                    for (Document doc : docStream) {
                        int foo = doc.getInt("foo");
                        Assert.assertTrue((foo >= 17 ? 1 : 0) != 0);
                        ++docCount;
                    }
                    Assert.assertEquals((long)1L, (long)docCount);
                }
            }
        }
    }

    @Test
    public void testQuery_bug27718() throws Exception {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            String tableName;
            String rawTableName = "bug27718";
            this.addCleanupTable("bug27718");
            int nRows = 300;
            int matchCount = 0;
            try (Table table = DBTests.createOrGetTable((String)"bug27718");){
                Path tablePath = table.getPath();
                tableName = tablePath.toString();
                DBTests.createIndex((Table)table, (String)"bug27718_idx", (boolean)false, (int)0, (String[])new String[]{"v1"}, (SortOrder[])new SortOrder[]{SortOrder.DESC}, null);
                Random random = new Random(27718L);
                for (int i = 1; i <= 300; ++i) {
                    Document doc = connection.newDocument();
                    String id = Integer.toString(i);
                    doc.setId(id);
                    int v1 = 200 - random.nextInt(400);
                    doc.set("v1", v1);
                    table.insert(doc);
                    if (v1 <= -100 || v1 > 100) continue;
                    ++matchCount;
                }
            }
            Assert.assertTrue((matchCount > 0 ? 1 : 0) != 0);
            DBTests.waitForIndexFlush((String)"bug27718");
            DBTests.waitForRowCount((String)"bug27718", (long)300L);
            Query query = connection.newQuery().select(new String[]{"v1", "_id"}).where(connection.newCondition().and().is("v1", QueryCondition.Op.GREATER, -100).is("v1", QueryCondition.Op.LESS_OR_EQUAL, 100).close().build()).build();
            try (DocumentStore docStore = connection.getStore(tableName);
                 DocumentStream docStream = docStore.findQuery(query);){
                int docCount = 0;
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertTrue((Integer.parseInt(id) > 0 ? 1 : 0) != 0);
                    int v1 = doc.getInt("v1");
                    Assert.assertTrue((v1 > -100 ? 1 : 0) != 0);
                    Assert.assertTrue((v1 <= 100 ? 1 : 0) != 0);
                    ++docCount;
                }
                Assert.assertEquals((long)matchCount, (long)docCount);
            }
        }
    }

    @Test
    public void testQuery_bug29191_project_hashedIndex() throws Exception {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            String tableName;
            String rawTableName = "bug29191";
            this.addCleanupTable("bug29191");
            int nRows = 300;
            int matchCount = 0;
            String indexName = "bug29191_idx";
            try (Table table = DBTests.createOrGetTable((String)"bug29191");){
                Path tablePath = table.getPath();
                tableName = tablePath.toString();
                DBTests.createIndex((String)table.getPath().toString(), (String)"bug29191_idx", (String[])new String[]{"v1"}, null, (boolean)true, (int)10);
                Random random = new Random(29191L);
                for (int i = 1; i <= 300; ++i) {
                    Document doc = connection.newDocument();
                    String id = Integer.toString(i);
                    doc.setId(id);
                    int v1 = 200 - random.nextInt(400);
                    doc.set("v1", v1);
                    table.insert(doc);
                    if (v1 <= -100 || v1 > 100) continue;
                    ++matchCount;
                }
            }
            Assert.assertTrue((matchCount > 0 ? 1 : 0) != 0);
            DBTests.waitForIndexFlush((String)"bug29191");
            DBTests.waitForRowCount((String)"bug29191", (long)300L);
            Query query = connection.newQuery().setOption("ojai.mapr.query.use-index", (Object)"bug29191_idx").select(new String[]{"v1", "_id"}).where(connection.newCondition().and().is("v1", QueryCondition.Op.GREATER, -100).is("v1", QueryCondition.Op.LESS_OR_EQUAL, 100).close().build()).build();
            try (DocumentStore docStore = connection.getStore(tableName);
                 DocumentStream docStream = docStore.findQuery(query);){
                int docCount = 0;
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertTrue((Integer.parseInt(id) > 0 ? 1 : 0) != 0);
                    int v1 = doc.getInt("v1");
                    Assert.assertTrue((v1 > -100 ? 1 : 0) != 0);
                    Assert.assertTrue((v1 <= 100 ? 1 : 0) != 0);
                    ++docCount;
                }
                Assert.assertEquals((long)matchCount, (long)docCount);
            }
        }
    }

    @Test
    public void testQuery_bug27711() throws Exception {
        StringGenerator fieldGenerator = new StringGenerator(5, 27711L);
        for (Class<?> klass : bug27711Case) {
            Bug27711 test = (Bug27711)klass.getConstructor(null).newInstance(null);
            String rawTableName = test.getRawTableName();
            String fieldName = fieldGenerator.nextUniqueString();
            try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
                 Table table = DBTests.createOrGetTable((String)rawTableName);){
                this.addCleanupTable(rawTableName);
                Path tablePath = table.getPath();
                String tableName = tablePath.toString();
                DBTests.createIndex((Table)table, (String)(rawTableName + Bug27711.Direction.ASC.getSuffix() + "_idx"), (boolean)false, (int)0, (String[])new String[]{fieldName + Bug27711.Direction.ASC.getSuffix()}, null, null);
                DBTests.createIndex((Table)table, (String)(rawTableName + Bug27711.Direction.DESC.getSuffix() + "_idx"), (boolean)false, (int)0, (String[])new String[]{fieldName + Bug27711.Direction.DESC.getSuffix()}, (SortOrder[])new SortOrder[]{SortOrder.DESC}, null);
                for (int i = 1; i <= 83; ++i) {
                    Document doc = connection.newDocument();
                    doc.setId(Integer.toString(i));
                    test.setDocFields(doc, fieldName);
                    table.insert(doc);
                }
                test.doneInserting();
                DBTests.waitForRowCount((String)rawTableName, (long)83L);
                DBTests.waitForIndexFlush((String)rawTableName);
                try (DocumentStore docStore = connection.getStore(tableName);){
                    test.testQueries((Connection)connection, rawTableName, fieldName, Bug27711.Direction.ASC, docStore);
                    test.testQueries((Connection)connection, rawTableName, fieldName, Bug27711.Direction.DESC, docStore);
                }
            }
        }
    }

    @Test
    public void testQuery_bug27809() throws Exception {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            String tableName = sharedTable27809.prepare((Connection)connection);
            Query query = connection.newQuery().select(new String[]{"s1"}).build();
            try (DocumentStore docStore = connection.getStore(tableName);
                 DocumentStream docStream = docStore.findQuery(query);){
                int docCount = 0;
                for (Document doc : docStream) {
                    String s1 = doc.getString("s1");
                    Assert.assertNotNull((Object)s1);
                    ++docCount;
                }
                Assert.assertEquals((long)sharedTable27809.getNumRows(), (long)docCount);
                Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)TestOjaiDocumentStore.getQueryPath(docStream));
                Assert.assertEquals((Object)sharedTable27809.getIndexName(), (Object)TestOjaiDocumentStore.getIndexUsed(docStream));
            }
        }
    }

    private static void bug27024_querySExists(Connection connection, String tableName, Query query, int nonNullStrings, String indexName) {
        try (DocumentStore docStore = connection.getStore(tableName);
             DocumentStream docStream = docStore.findQuery(query);){
            int docCount = 0;
            for (Document doc : docStream) {
                String id = doc.getIdString();
                Assert.assertTrue((Integer.valueOf(id) > 0 ? 1 : 0) != 0);
                String s = doc.getString("s");
                Assert.assertNotNull((Object)s);
                ++docCount;
            }
            Assert.assertEquals((long)nonNullStrings, (long)docCount);
            Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)OjaiTest.getQueryPath(docStream));
            Assert.assertEquals((Object)indexName, (Object)OjaiTest.getIndexUsed(docStream));
        }
    }

    @Test
    public void testQuery_bug27024() throws Exception {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            String tableName = sharedTable27024.prepare((Connection)connection);
            String rawTableName = sharedTable27024.getRawTableName();
            int nonNullStrings = sharedTable27024.getNonNullStrings();
            int nRows = (int)sharedTable27024.getNumRows();
            String indexName = sharedTable27024.getIndexName();
            Assert.assertTrue((nonNullStrings > 0 ? 1 : 0) != 0);
            Assert.assertNotEquals((long)nRows, (long)nonNullStrings);
            Query querySExists = connection.newQuery().select(new String[]{"s"}).where(connection.newCondition().exists("s").build()).build();
            TestOjaiDocumentStore.bug27024_querySExists((Connection)connection, tableName, querySExists, nonNullStrings, rawTableName);
            Query querySExistsId = connection.newQuery().select(new String[]{"s", "_id"}).where(connection.newCondition().exists("s").build()).build();
            TestOjaiDocumentStore.bug27024_querySExists((Connection)connection, tableName, querySExistsId, nonNullStrings, rawTableName);
            Query querySNotExists = connection.newQuery().select(new String[]{"s"}).where(connection.newCondition().notExists("s").build()).build();
            try (DocumentStore docStore = connection.getStore(tableName);
                 DocumentStream docStream = docStore.findQuery(querySNotExists);){
                int docCount = 0;
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertTrue((Integer.valueOf(id) > 0 ? 1 : 0) != 0);
                    String s = doc.getString("s");
                    Assert.assertNull((Object)s);
                    ++docCount;
                }
                Assert.assertEquals((long)(nRows - nonNullStrings), (long)docCount);
                Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)OjaiTest.getQueryPath(docStream));
            }
            Query querySNotExistsId = connection.newQuery().select(new String[]{"s", "_id"}).where(connection.newCondition().notExists("s").build()).build();
            try (DocumentStore docStore = connection.getStore(tableName);
                 DocumentStream docStream = docStore.findQuery(querySNotExistsId);){
                int docCount = 0;
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertTrue((Integer.valueOf(id) > 0 ? 1 : 0) != 0);
                    String s = doc.getString("s");
                    Assert.assertNull((Object)s);
                    ++docCount;
                }
                Assert.assertEquals((long)(nRows - nonNullStrings), (long)docCount);
                Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)OjaiTest.getQueryPath(docStream));
            }
        }
    }

    @Test
    @Category(value={ClusterTest.class})
    public void test_bug27560() throws Exception {
        String rawTableName = "equals_not_all";
        this.addCleanupTable("equals_not_all");
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
             Table table = DBTests.createOrGetTable((String)"equals_not_all");){
            DBTests.createIndex((Table)table, (String)"equals_not_all_idx", (boolean)false, (int)0, (String[])new String[]{"i.a.b"}, null, null);
            String tableName = DBTests.getFullPath((String)"equals_not_all");
            this.addCleanupTable(tableName);
            try (DocumentStore docStore = connection.getStore(tableName);){
                int nGroup = 286;
                int[] iValue = new int[]{-97, -101, -201, -301, -401};
                int waitFor = 0;
                for (int i = 1; i <= 286; ++i) {
                    for (int j = 0; j < iValue.length; ++j) {
                        Document doc = connection.newDocument();
                        doc.setId("record" + j + (i - 1) * iValue.length);
                        Document aDoc = connection.newDocument();
                        aDoc.set("b", iValue[j]);
                        aDoc.set("k", "foo");
                        Document iDoc = connection.newDocument();
                        iDoc.set("a", aDoc);
                        doc.set("i", iDoc);
                        doc.set("j", j);
                        docStore.insert(doc);
                        ++waitFor;
                    }
                }
                DBTests.waitForIndexFlush((String)"equals_not_all");
                DBTests.waitForRowCount((String)"equals_not_all", (long)waitFor);
                Query query = connection.newQuery().select(new String[]{"i.a.b", "_id"}).where(connection.newCondition().and().is("i.a.b", QueryCondition.Op.EQUAL, iValue[0]).is("i.a.b", QueryCondition.Op.GREATER_OR_EQUAL, -100).close().build()).build();
                try (DocumentStream docStream = docStore.findQuery(query);){
                    int docCount = 0;
                    for (Document doc : docStream) {
                        int i = doc.getInt("i.a.b");
                        Assert.assertEquals((long)iValue[0], (long)i);
                        ++docCount;
                    }
                    Assert.assertEquals((long)286L, (long)docCount);
                }
            }
        }
    }

    @Test
    @Category(value={ClusterTest.class})
    public void testDrill_bug27566() throws IOException {
        String rawTableName = "bug27566";
        try (Table table = DBTests.createOrGetTable((String)"bug27566");){
            String tableName = DBTests.getFullPath((String)"bug27566");
            this.addCleanupTable(tableName);
            try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
                 DocumentStore docStore = connection.getStore(tableName);){
                int nRows = 17;
                OTime theTime = new OTime(1, 20, 42, 879);
                for (int i = 1; i <= 17; ++i) {
                    Document doc = connection.newDocument();
                    doc.setId(Integer.toString(i));
                    OTime t = new OTime(theTime.getHour(), theTime.getMinute() - 8 + i, theTime.getSecond(), theTime.getMilliSecond());
                    doc.set("t", t);
                    docStore.insert(doc);
                }
                DBTests.waitForRowCount((String)"bug27566", (long)17L);
                Query query = connection.newQuery().setOption("ojai.mapr.query.force-drill", (Object)true).select(new String[]{"t", "_id"}).where(connection.newCondition().is("t", QueryCondition.Op.EQUAL, theTime).build()).build();
                try (DocumentStream docStream = docStore.findQuery(query);){
                    int docCount = 0;
                    for (Document doc : docStream) {
                        String id = doc.getIdString();
                        Assert.assertTrue((Integer.valueOf(id) > 0 ? 1 : 0) != 0);
                        OTime t = doc.getTime("t");
                        Assert.assertEquals((Object)theTime, (Object)t);
                        ++docCount;
                    }
                    Assert.assertEquals((long)1L, (long)docCount);
                    Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DRILL, (Object)TestOjaiDocumentStore.getQueryPath(docStream));
                }
            }
        }
    }

    @Test
    public void testStore_bug27054() throws Exception {
        String rawTableName = "bug27054_t";
        String tablePath = DBTests.getFullPath((String)"bug27054_t");
        try (Table table = DBTests.createOrGetTable((String)"bug27054_t");){
            DBTests.createIndex((Table)table, (String)"bug27054_t_idx", (boolean)false, (int)0, (String[])new String[]{"s"}, null, null);
        }
        var4_4 = null;
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
             DocumentStore docStore = connection.getStore(tablePath);){
            Object s;
            Assert.assertNotNull((Object)docStore);
            OjaiDocumentStore ojaiDocStore = (OjaiDocumentStore)docStore;
            BaseJsonTable table = ojaiDocStore.getTable();
            Assert.assertNotNull((Object)table);
            String regex = "^[a-zA-Z0-9]+.*$";
            Pattern pattern = Pattern.compile("^[a-zA-Z0-9]+.*$");
            StringGenerator valueGenerator = new StringGenerator(32, 27054L);
            int nRows = 100;
            int matchingDocs = 0;
            for (int i = 1; i <= 100; ++i) {
                Matcher matcher;
                Document doc = connection.newDocument();
                String id = Integer.toString(i);
                doc.setId(id);
                s = valueGenerator.nextUniqueString();
                if (i % 2 == 0) {
                    s = "^" + (String)s;
                }
                if ((matcher = pattern.matcher((CharSequence)s)).matches()) {
                    ++matchingDocs;
                }
                System.out.println("s = " + (String)s);
                doc.set("s", (String)s);
                table.insert(doc);
            }
            DBTests.waitForIndexFlush((String)"bug27054_t");
            DBTests.waitForRowCount((String)"bug27054_t", (long)100L);
            int docCount = 0;
            Query queryMatches = connection.newQuery().select(new String[]{"s", "_id"}).where(connection.newCondition().matches("s", "^[a-zA-Z0-9]+.*$").build()).build();
            DocumentStream matchesStream = docStore.findQuery(queryMatches);
            s = null;
            try {
                docCount = 0;
                for (Document doc : matchesStream) {
                    String id = doc.getIdString();
                    Assert.assertNotNull((Object)id);
                    Assert.assertTrue((0 < Integer.valueOf(id) ? 1 : 0) != 0);
                    String s2 = doc.getString("s");
                    Assert.assertNotNull((Object)s2);
                    Matcher matcher = pattern.matcher(s2);
                    Assert.assertTrue((boolean)matcher.matches());
                    ++docCount;
                }
                System.out.println("testStore_bug27054 documents matched " + docCount);
                Assert.assertEquals((long)matchingDocs, (long)docCount);
            }
            catch (Throwable throwable) {
                s = throwable;
                throw throwable;
            }
            finally {
                if (matchesStream != null) {
                    if (s != null) {
                        try {
                            matchesStream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)s).addSuppressed(throwable);
                        }
                    } else {
                        matchesStream.close();
                    }
                }
            }
            Query queryNotMatches = connection.newQuery().select(new String[]{"s", "_id"}).where(connection.newCondition().notMatches("s", "^[a-zA-Z0-9]+.*$").build()).build();
            DocumentStream matchesStream2 = docStore.findQuery(queryNotMatches);
            Object object = null;
            try {
                docCount = 0;
                for (Document doc : matchesStream2) {
                    String id = doc.getIdString();
                    Assert.assertNotNull((Object)id);
                    Assert.assertTrue((0 < Integer.valueOf(id) ? 1 : 0) != 0);
                    String s3 = doc.getString("s");
                    Assert.assertNotNull((Object)s3);
                    Matcher matcher = pattern.matcher(s3);
                    Assert.assertTrue((!matcher.matches() ? 1 : 0) != 0);
                    ++docCount;
                }
                System.out.println("testStore_bug27054 documents notMatched " + docCount);
                Assert.assertEquals((long)(100 - matchingDocs), (long)docCount);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (matchesStream2 != null) {
                    if (object != null) {
                        try {
                            matchesStream2.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        matchesStream2.close();
                    }
                }
            }
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testPrefixMatch() throws Exception {
        String rawTableName = "priTab";
        String tablePath = DBTests.getFullPath((String)"priTab");
        try (Table table = DBTests.createOrGetTable((String)"priTab");){
            DBTests.createIndex((Table)table, (String)"priTab_idx", (boolean)false, (int)0, (String[])new String[]{"s"}, null, null);
        }
        var4_4 = null;
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
             DocumentStore docStore = connection.getStore(tablePath);){
            Object s;
            Assert.assertNotNull((Object)docStore);
            OjaiDocumentStore ojaiDocStore = (OjaiDocumentStore)docStore;
            BaseJsonTable table = ojaiDocStore.getTable();
            Assert.assertNotNull((Object)table);
            String regex = "abc[0-9]";
            Pattern pattern = Pattern.compile("abc[0-9]");
            StringGenerator valueGenerator = new StringGenerator(32, 27054L);
            int nRows = 100;
            int matchingDocs = 0;
            for (int i = 1; i <= 100; ++i) {
                Document doc = connection.newDocument();
                String id = Integer.toString(i);
                doc.setId(id);
                s = valueGenerator.nextUniqueString();
                if (i % 2 == 0) {
                    Random generator = new Random();
                    s = "abc" + generator.nextInt(10);
                } else {
                    s = "^" + (String)s;
                }
                Matcher matcher = pattern.matcher((CharSequence)s);
                if (matcher.matches()) {
                    ++matchingDocs;
                }
                System.out.println("s = " + (String)s);
                doc.set("s", (String)s);
                table.insert(doc);
            }
            DBTests.waitForIndexFlush((String)"priTab");
            DBTests.waitForRowCount((String)"priTab", (long)100L);
            int docCount = 0;
            Query queryMatches = connection.newQuery().select(new String[]{"s", "_id"}).where(connection.newCondition().matches("s", "abc[0-9]").build()).build();
            DocumentStream matchesStream = docStore.findQuery(queryMatches);
            s = null;
            try {
                docCount = 0;
                for (Document doc : matchesStream) {
                    String id = doc.getIdString();
                    Assert.assertNotNull((Object)id);
                    Assert.assertTrue((0 < Integer.valueOf(id) ? 1 : 0) != 0);
                    String s2 = doc.getString("s");
                    Assert.assertNotNull((Object)s2);
                    Matcher matcher = pattern.matcher(s2);
                    Assert.assertTrue((boolean)matcher.matches());
                    ++docCount;
                }
                System.out.println("testStore_bug27054 documents matched " + docCount);
                Assert.assertEquals((long)matchingDocs, (long)docCount);
            }
            catch (Throwable throwable) {
                s = throwable;
                throw throwable;
            }
            finally {
                if (matchesStream != null) {
                    if (s != null) {
                        try {
                            matchesStream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)s).addSuppressed(throwable);
                        }
                    } else {
                        matchesStream.close();
                    }
                }
            }
            Query queryNotMatches = connection.newQuery().select(new String[]{"s", "_id"}).where(connection.newCondition().notMatches("s", "abc[0-9]").build()).build();
            DocumentStream matchesStream2 = docStore.findQuery(queryNotMatches);
            Object object = null;
            try {
                docCount = 0;
                for (Document doc : matchesStream2) {
                    String id = doc.getIdString();
                    Assert.assertNotNull((Object)id);
                    Assert.assertTrue((0 < Integer.valueOf(id) ? 1 : 0) != 0);
                    String s3 = doc.getString("s");
                    Assert.assertNotNull((Object)s3);
                    Matcher matcher = pattern.matcher(s3);
                    Assert.assertTrue((!matcher.matches() ? 1 : 0) != 0);
                    ++docCount;
                }
                System.out.println("testStore_bug27054 documents notMatched " + docCount);
                Assert.assertEquals((long)(100 - matchingDocs), (long)docCount);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (matchesStream2 != null) {
                    if (object != null) {
                        try {
                            matchesStream2.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        matchesStream2.close();
                    }
                }
            }
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
    }

    @Test
    @Category(value={ClusterTest.class})
    public void testDrill_bug27567() throws IOException {
        String tableName;
        String rawTableName = "bug27567";
        this.addCleanupTable("bug27567");
        try (Table table = DBTests.createOrGetTable((String)"bug27567");){
            tableName = DBTests.getFullPath((String)"bug27567");
            this.addCleanupTable(tableName);
        }
        var4_3 = null;
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
             DocumentStore docStore = connection.getStore(tableName);){
            int nRows = 19;
            OTimestamp theTimestamp = new OTimestamp(2756709L);
            for (int i = 1; i <= 19; ++i) {
                Document doc = connection.newDocument();
                doc.setId(Integer.toString(i));
                OTimestamp t = new OTimestamp((long)(2756691 + i));
                doc.set("t", t);
                docStore.insert(doc);
            }
            DBTests.waitForRowCount((String)"bug27567", (long)19L);
            Query query = connection.newQuery().setOption("ojai.mapr.query.force-drill", (Object)true).select(new String[]{"t", "_id"}).where(connection.newCondition().is("t", QueryCondition.Op.EQUAL, theTimestamp).build()).build();
            try (DocumentStream docStream = docStore.findQuery(query);){
                int docCount = 0;
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertTrue((Integer.valueOf(id) > 0 ? 1 : 0) != 0);
                    OTimestamp t = doc.getTimestamp("t");
                    Assert.assertEquals((Object)theTimestamp, (Object)t);
                    ++docCount;
                }
                Assert.assertEquals((long)1L, (long)docCount);
                Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DRILL, (Object)TestOjaiDocumentStore.getQueryPath(docStream));
            }
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
    }

    @Test
    @Category(value={ClusterTest.class})
    public void testDrill_bug27467() throws Exception {
        String rawTableName = "bug27467";
        this.addCleanupTable("bug27467");
        try (Table table = DBTests.createOrGetTable((String)"bug27467");){
            String tableName = DBTests.getFullPath((String)"bug27467");
            this.addCleanupTable(tableName);
            try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
                 DocumentStore docStore = connection.getStore(tableName);){
                boolean[] useDrillOptions;
                Document doc = connection.newDocument(" {\"_id\":\"record0\",\"sl1\":{\"l1_a60_array\":[false,1.1862953200067821E38,1289709519,1.5671444844984837E308,\"qlaa|qxu|irpbkzh\",385279837858599013,\"2874730-03-17\",null,125,11641,\"06:41:47.109\",\"269616082-11-09T20:12:38.373Z\",\"/v8AdwBlAGoAaA==\",{\"key0\":false,\"key1\":3.516588262442531E37,\"key10\":\"23:50:33.829\",\"key11\":\"135990985-09-30T17:49:14.725Z\",\"key12\":\"/v8AZwBhAHsAeQ==\",\"key13\":\"/v8AZgB0AGkAdw==\",\"key2\":762072476,\"key3\":1.4561384399789896E308,\"key4\":\"gm{~nv|nwsh}nsjg\",\"key5\":2144246572548827237,\"key6\":\"3492035-04-17\",\"key7\":null,\"key8\":120,\"key9\":5716},[false,3.116079632963063E37,841854436,9.036146914887033E307,\"soamzfti~sbydo~h\",5013954358349961317,\"1422655-06-20\",null,101,15936,\"02:40:27.749\",\"275951436-08-31T15:14:54.693Z\",\"/v8AaABhAHAAYg==\",\"97855806-09-18T08:28:23.013Z\"],null]}}");
                table.insert(doc);
                DBTests.waitForRowCount((String)"bug27467", (long)1L);
                for (boolean useDrill : useDrillOptions = new boolean[]{true, false}) {
                    Query query = connection.newQuery().setOption("ojai.mapr.query.force-drill", (Object)useDrill).select(new String[]{"_id", "sl1.l1_a60_array[14][4]"}).build();
                    OjaiTest.DocumentStreamRef streamRef = new OjaiTest.DocumentStreamRef();
                    List<Document> docList = OjaiTest.collectStreamingFind(docStore, query, 5, streamRef);
                    Assert.assertEquals((long)1L, (long)docList.size());
                    Assert.assertEquals((Object)(useDrill ? OjaiQueryProperties.QueryPath.DRILL : OjaiQueryProperties.QueryPath.DIRECT), (Object)TestOjaiDocumentStore.getQueryPath(streamRef.docStream));
                    Document doc2 = docList.get(0);
                    String id = doc2.getIdString();
                    Assert.assertEquals((Object)"record0", (Object)id);
                    List a_list = doc2.getList("sl1.l1_a60_array");
                    Assert.assertNotNull((Object)a_list);
                    Assert.assertEquals((long)15L, (long)a_list.size());
                    for (int i = 0; i < 14; ++i) {
                        Assert.assertNull(a_list.get(i));
                    }
                    Assert.assertNotNull(a_list.get(14));
                    List subList = doc2.getList("sl1.l1_a60_array[14]");
                    Assert.assertNotNull((Object)subList);
                    Assert.assertEquals((long)5L, (long)subList.size());
                    for (int i = 0; i < 4; ++i) {
                        Assert.assertNull(subList.get(i));
                    }
                    Assert.assertNotNull(subList.get(4));
                    Assert.assertEquals((Object)"soamzfti~sbydo~h", (Object)doc2.getString("sl1.l1_a60_array[14][4]"));
                }
            }
        }
    }

    private static void bug28005QueryValue(DocumentStore docStore, String theId, Value id, QueryCondition cond) {
        Document doc = docStore.findById(id);
        OjaiTest.assertIdString(doc, theId, true);
        doc = docStore.findById(id, new String[]{"a"});
        OjaiTest.assertIdString(doc, theId, false);
        doc = docStore.findById(id, new String[]{"_id"});
        OjaiTest.assertIdString(doc, theId, true);
        doc = docStore.findById(id, cond);
        OjaiTest.assertIdString(doc, theId, true);
        doc = docStore.findById(id, cond, new String[]{"a"});
        OjaiTest.assertIdString(doc, theId, false);
        doc = docStore.findById(id, cond, new String[]{"a", "_id"});
        OjaiTest.assertIdString(doc, theId, true);
    }

    @Test
    @Category(value={ClusterTest.class})
    public void testQuery_bug28005() throws IOException {
        String rawTableName = "bug28005";
        this.addCleanupTable("bug28005");
        try (Table table = DBTests.createOrGetTable((String)"bug28005");){
            String tableName = DBTests.getFullPath((String)"bug28005");
            this.addCleanupTable(tableName);
            String theId = "1";
            try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
                 DocumentStore docStore = connection.getStore(tableName);){
                Document doc = connection.newDocument();
                doc.setId("1");
                doc.set("a", 1);
                table.insert(doc);
                DBTests.waitForRowCount((String)"bug28005", (long)1L);
                QueryCondition cond = connection.newCondition().is("a", QueryCondition.Op.EQUAL, 1).build();
                Document doc2 = docStore.findById("1");
                OjaiTest.assertIdString(doc2, "1", true);
                doc2 = docStore.findById("1", new String[]{"a"});
                OjaiTest.assertIdString(doc2, "1", false);
                doc2 = docStore.findById("1", new String[]{"_id"});
                OjaiTest.assertIdString(doc2, "1", true);
                doc2 = docStore.findById("1", cond);
                OjaiTest.assertIdString(doc2, "1", true);
                doc2 = docStore.findById("1", cond, new String[]{"a"});
                OjaiTest.assertIdString(doc2, "1", false);
                doc2 = docStore.findById("1", cond, new String[]{"a", "_id"});
                OjaiTest.assertIdString(doc2, "1", true);
                Value idStringValue = TestOjaiDocumentStore.getDriver().getValueBuilder().newValue("1");
                TestOjaiDocumentStore.bug28005QueryValue(docStore, "1", idStringValue, cond);
            }
        }
    }

    @Test
    @Category(value={ClusterTest.class})
    public void testQuery_bug27954() throws IOException {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            String tableName = sharedTable27954.prepare((Connection)connection);
            try (DocumentStore docStore = connection.getStore(tableName);){
                Query queryExists = connection.newQuery().setOption("ojai.mapr.query.force-drill", (Object)true).select(new String[]{"*"}).where(connection.newCondition().exists("a").build()).build();
                int docCount = 0;
                try (DocumentStream docStream = docStore.findQuery(queryExists);){
                    for (Document doc : docStream) {
                        String id = doc.getIdString();
                        int idInt = Integer.parseInt(id);
                        Assert.assertTrue((idInt > 0 ? 1 : 0) != 0);
                        long a = doc.getLong("a");
                        Assert.assertEquals((long)idInt, (long)a);
                        ++docCount;
                    }
                    Assert.assertEquals((long)3L, (long)docCount);
                    Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DRILL, (Object)TestOjaiDocumentStore.getQueryPath(docStream));
                }
                Query queryNotExists = connection.newQuery().setOption("ojai.mapr.query.force-drill", (Object)true).select(new String[]{"*"}).where(connection.newCondition().notExists("c").build()).build();
                docCount = 0;
                DocumentStream docStream = docStore.findQuery(queryNotExists);
                Object object = null;
                try {
                    for (Document doc : docStream) {
                        String id = doc.getIdString();
                        int idInt = Integer.parseInt(id);
                        Assert.assertTrue((idInt > 0 ? 1 : 0) != 0);
                        long a = doc.getLong("a");
                        Assert.assertEquals((long)idInt, (long)a);
                        String c = doc.getString("c");
                        Assert.assertNull((Object)c);
                        ++docCount;
                    }
                    Assert.assertEquals((long)2L, (long)docCount);
                    Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DRILL, (Object)TestOjaiDocumentStore.getQueryPath(docStream));
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (docStream != null) {
                        if (object != null) {
                            try {
                                docStream.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            docStream.close();
                        }
                    }
                }
            }
        }
    }

    @Test
    @Category(value={ClusterTest.class})
    public void testQuery_bug27259() throws Exception {
        String rawTableName = "bug27259";
        this.addCleanupTable("bug27259");
        try (Table table = DBTests.createOrGetTable((String)"bug27259");){
            String tableName = DBTests.getFullPath((String)"bug27259");
            this.addCleanupTable(tableName);
            String indexName = "bug27259_idx";
            DBTests.createIndex((Table)table, (String)"bug27259_idx", (boolean)false, (int)0, (String[])new String[]{"d"}, null, null);
            try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
                 DocumentStore docStore = connection.getStore(tableName);){
                int nRows = 61;
                ODate midDate = new ODate(2017, 6, 15);
                int nGreater = 0;
                Random random = new Random(27259L);
                for (int i = 1; i <= 61; ++i) {
                    Document doc = connection.newDocument();
                    doc.setId(Integer.toString(i));
                    ODate date = new ODate(2017, 1 + random.nextInt(12), 1 + random.nextInt(28));
                    doc.set("d", date);
                    if (date.compareTo(midDate) > 0) {
                        ++nGreater;
                    }
                    table.insert(doc);
                }
                DBTests.waitForIndexFlush((String)"bug27259");
                DBTests.waitForRowCount((String)"bug27259", (long)61L);
                Query query = connection.newQuery().select(new String[]{"d"}).where(connection.newCondition().is("d", QueryCondition.Op.GREATER, midDate).build()).build();
                try (DocumentStream docStream = docStore.findQuery(query);){
                    int docCount = 0;
                    for (Document doc : docStream) {
                        String id = doc.getIdString();
                        Assert.assertTrue((Integer.parseInt(id) > 0 ? 1 : 0) != 0);
                        ODate date = doc.getDate("d");
                        Assert.assertTrue((date.compareTo(midDate) > 0 ? 1 : 0) != 0);
                        ++docCount;
                    }
                    Assert.assertEquals((long)nGreater, (long)docCount);
                    Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)TestOjaiDocumentStore.getQueryPath(docStream));
                    Assert.assertEquals((Object)"bug27259_idx", (Object)TestOjaiDocumentStore.getIndexUsed(docStream));
                }
            }
        }
    }

    private static boolean bug27697GetDoc(Iterator<Document> docIter) {
        if (!docIter.hasNext()) {
            return false;
        }
        Document doc = docIter.next();
        String id = doc.getIdString();
        Assert.assertNotNull((Object)id);
        int i = Integer.parseInt(id);
        Assert.assertTrue((i > 0 ? 1 : 0) != 0);
        int a = doc.getInt("a");
        Assert.assertEquals((long)i, (long)a);
        return true;
    }

    private static void bug27697DoQueries(String tableName, Connection connection, OjaiQueryProperties.QueryPath queryPath) {
        int i;
        boolean gotRows;
        int limit = 2;
        Query query = connection.newQuery().setOption("ojai.mapr.query.force-drill", (Object)(queryPath == OjaiQueryProperties.QueryPath.DRILL ? 1 : 0)).limit(2L).build();
        int nIters = 5;
        DocumentStore[] docStore = new DocumentStore[5];
        DocumentStream[] docStream = new DocumentStream[5];
        ArrayList<Iterator> docIter = new ArrayList<Iterator>(5);
        int[] iterCount = new int[5];
        for (int i2 = 0; i2 < 5; ++i2) {
            docStore[i2] = connection.getStore(tableName);
            docStream[i2] = docStore[i2].findQuery(query);
            docIter.add(i2, docStream[i2].iterator());
        }
        do {
            gotRows = false;
            for (i = 0; i < 5; ++i) {
                if (!TestOjaiDocumentStore.bug27697GetDoc((Iterator)docIter.get(i))) continue;
                int n = i;
                iterCount[n] = iterCount[n] + 1;
                gotRows |= true;
            }
        } while (gotRows);
        for (i = 0; i < 5; ++i) {
            docStream[i].close();
            docStore[i].close();
            Assert.assertEquals((long)2L, (long)iterCount[i]);
        }
    }

    @Test
    @Category(value={ClusterTest.class})
    public void testQuery_bug27697() throws Exception {
        String rawTableName = "bug27697";
        this.addCleanupTable("bug27697");
        try (Table table = DBTests.createOrGetTable((String)"bug27697");){
            String tableName = DBTests.getFullPath((String)"bug27697");
            this.addCleanupTable(tableName);
            int nRows = 3;
            for (int i = 1; i <= 3; ++i) {
                Document doc = TestOjaiDocumentStore.getDriver().newDocument();
                doc.setId(Integer.toString(i));
                doc.set("a", i);
                doc.set("b", 3 - i);
                table.insert(doc);
            }
            DBTests.waitForRowCount((String)"bug27697", (long)3L);
            Timer timer = new Timer();
            TimerTask timeoutTask = new TimerTask(){

                @Override
                public void run() {
                    throw new RuntimeException("Queries took too long");
                }
            };
            timer.schedule(timeoutTask, 60000L);
            try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
                TestOjaiDocumentStore.bug27697DoQueries(tableName, (Connection)connection, OjaiQueryProperties.QueryPath.DIRECT);
                TestOjaiDocumentStore.bug27697DoQueries(tableName, (Connection)connection, OjaiQueryProperties.QueryPath.DRILL);
            }
        }
    }

    private static void bug27937Query(DocumentStore docStore, Query query, boolean expectId) {
        query.build();
        try (DocumentStream docStream = docStore.findQuery(query);){
            int docCount = 0;
            for (Document doc : docStream) {
                OjaiTest.assertIdString(doc, null, expectId);
                ++docCount;
            }
            Assert.assertEquals((long)2L, (long)docCount);
            Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)OjaiTest.getQueryPath(docStream));
        }
    }

    @Test
    public void testQuery_bug27937() throws Exception {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            String tableName = sharedTable27954.prepare((Connection)connection);
            ImmutableList idList = ImmutableList.of((Object)"1", (Object)"2");
            QueryCondition condition = connection.newCondition().in("_id", (List)idList).build();
            try (DocumentStore docStore = connection.getStore(tableName);){
                Query queryPlain = connection.newQuery().where(condition);
                TestOjaiDocumentStore.bug27937Query(docStore, queryPlain, true);
                Query queryStar = connection.newQuery().where(condition).select(new String[]{"*"});
                TestOjaiDocumentStore.bug27937Query(docStore, queryStar, true);
                Query queryStarId = connection.newQuery().where(condition).select(new String[]{"*", "_id"});
                TestOjaiDocumentStore.bug27937Query(docStore, queryStarId, true);
                Query queryField = connection.newQuery().where(condition).select(new String[]{"b"});
                TestOjaiDocumentStore.bug27937Query(docStore, queryField, false);
                Query queryId = connection.newQuery().where(condition).select(new String[]{"_id"});
                TestOjaiDocumentStore.bug27937Query(docStore, queryId, true);
                Query queryFieldId = connection.newQuery().where(condition).select(new String[]{"b", "_id"});
                TestOjaiDocumentStore.bug27937Query(docStore, queryFieldId, true);
            }
        }
    }

    @Test
    public void testQuery_bug27654() throws Exception {
        String rawTableName = "bug27654";
        this.addCleanupTable("bug27654");
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
             Table table = DBTests.createOrGetTable((String)"bug27654");){
            Path tablePath = table.getPath();
            String tableName = tablePath.toString();
            int nRows = 17;
            int evenRows = 0;
            for (int i = 1; i <= 17; ++i) {
                Document doc = connection.newDocument();
                doc.setId(Integer.toString(i));
                doc.set("a", i);
                boolean isEven = i % 2 == 0;
                doc.set("isEven", isEven);
                if (isEven) {
                    ++evenRows;
                }
                table.insert(doc);
            }
            DBTests.waitForRowCount((String)"bug27654", (long)17L);
            Assert.assertTrue((evenRows > 0 ? 1 : 0) != 0);
            Query query = connection.newQuery().where(connection.newCondition().is("isEven", QueryCondition.Op.EQUAL, true).build()).build();
            int docCount = 0;
            try (DocumentStore docStore = connection.getStore(tableName);
                 DocumentStream docStream = docStore.findQuery(query);){
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertNotNull((Object)id);
                    Assert.assertTrue((Integer.parseInt(id) > 0 ? 1 : 0) != 0);
                    boolean isEven = doc.getBoolean("isEven");
                    Assert.assertTrue((boolean)isEven);
                    ++docCount;
                }
                Assert.assertEquals((long)evenRows, (long)docCount);
                OjaiTest.assertQueryPath(docStream, OjaiQueryProperties.QueryPath.DIRECT);
                Assert.assertEquals((Object)"bug27654", (Object)OjaiTest.getIndexUsed(docStream));
            }
        }
    }

    private static void bug28274_general_query(DocumentStore docStore, Query query, int theValue, long nRows, String indexName) {
        try (DocumentStream docStream = docStore.findQuery(query);){
            int docCount = 0;
            for (Document doc : docStream) {
                String id = doc.getIdString();
                Assert.assertTrue((Integer.parseInt(id) > 0 ? 1 : 0) != 0);
                int a = doc.getInt("a");
                int b = doc.getInt("b");
                Assert.assertEquals((long)theValue, (long)a);
                Assert.assertEquals((long)(nRows - (long)theValue), (long)b);
                String c = doc.getString("c");
                Assert.assertNotNull((Object)c);
                ++docCount;
            }
            Assert.assertEquals((long)1L, (long)docCount);
            Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)TestOjaiDocumentStore.getQueryPath(docStream));
            Assert.assertEquals((Object)indexName, (Object)TestOjaiDocumentStore.getIndexUsed(docStream));
        }
    }

    @Test
    @Category(value={ClusterTest.class})
    public void testQuery_bug28274_general() throws Exception {
        String rawTableName = "bug28274_general";
        this.addCleanupTable("bug28274_general");
        try (Table table = DBTests.createOrGetTable((String)"bug28274_general");){
            String tableName = DBTests.getFullPath((String)"bug28274_general");
            this.addCleanupTable(tableName);
            String indexName = "bug28274_general_idx";
            DBTests.createIndex((Table)table, (String)"bug28274_general_idx", (boolean)false, (int)0, (String[])new String[]{"a"}, null, null);
            try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
                 DocumentStore docStore = connection.getStore(tableName);){
                int nRows = 61;
                Random random = new Random(28274L);
                for (int i = 1; i <= 61; ++i) {
                    Document doc = connection.newDocument();
                    doc.setId(Integer.toString(i));
                    doc.set("a", i);
                    doc.set("b", 61 - i);
                    doc.set("c", Integer.toString(random.nextInt()));
                    table.insert(doc);
                }
                DBTests.waitForIndexFlush((String)"bug28274_general");
                DBTests.waitForRowCount((String)"bug28274_general", (long)61L);
                int theValue = 17;
                Query query = connection.newQuery().where(connection.newCondition().and().is("a", QueryCondition.Op.EQUAL, 17).is("b", QueryCondition.Op.EQUAL, 44).close().build()).build();
                TestOjaiDocumentStore.bug28274_general_query(docStore, query, 17, 61L, "bug28274_general");
                Query queryIndex = connection.newQuery().setOption("ojai.mapr.query.use-index", (Object)"bug28274_general_idx").where(connection.newCondition().and().is("a", QueryCondition.Op.EQUAL, 17).is("b", QueryCondition.Op.EQUAL, 44).close().build()).build();
                TestOjaiDocumentStore.bug28274_general_query(docStore, queryIndex, 17, 61L, "bug28274_general_idx");
            }
        }
    }

    @Test
    @Category(value={ClusterTest.class})
    public void testQuery_bug28274_matches_id() throws Exception {
        String rawTableName = "bug28274_matches_id";
        this.addCleanupTable("bug28274_matches_id");
        try (Table table = DBTests.createOrGetTable((String)"bug28274_matches_id");){
            String tableName = DBTests.getFullPath((String)"bug28274_matches_id");
            this.addCleanupTable(tableName);
            String indexName = "bug28274_matches_id_idx";
            DBTests.createIndex((Table)table, (String)"bug28274_matches_id_idx", (boolean)false, (int)0, (String[])new String[]{"a"}, null, null);
            try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
                 DocumentStore docStore = connection.getStore(tableName);){
                int nRows = 61;
                StringGenerator stringGenerator = new StringGenerator(64, 28274L);
                boolean makeMatch = true;
                int matchCount = 0;
                for (int i = 1; i <= 61; ++i) {
                    if (makeMatch) {
                        makeMatch = false;
                    } else {
                        ++matchCount;
                        makeMatch = true;
                    }
                    Document doc = connection.newDocument();
                    String id = (makeMatch ? "xyz" : "") + stringGenerator.nextUniqueString();
                    doc.setId(id);
                    String a = (makeMatch ? "xyz" : "") + stringGenerator.nextUniqueString();
                    doc.set("a", a);
                    table.insert(doc);
                }
                Assert.assertTrue((matchCount > 0 ? 1 : 0) != 0);
                DBTests.waitForIndexFlush((String)"bug28274_matches_id");
                DBTests.waitForRowCount((String)"bug28274_matches_id", (long)61L);
                String thePattern = "^xyz.*";
                Query query = connection.newQuery().where(connection.newCondition().and().matches("_id", "^xyz.*").matches("a", "^xyz.*").close().build()).build();
                Pattern pattern = Pattern.compile("^xyz.*");
                try (DocumentStream docStream = docStore.findQuery(query);){
                    int docCount = 0;
                    for (Document doc : docStream) {
                        String id = doc.getIdString();
                        Matcher idMatcher = pattern.matcher(id);
                        Assert.assertTrue((boolean)idMatcher.matches());
                        String a = doc.getString("a");
                        Matcher aMatcher = pattern.matcher(a);
                        Assert.assertTrue((boolean)aMatcher.matches());
                        ++docCount;
                    }
                    Assert.assertEquals((long)matchCount, (long)docCount);
                    Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)TestOjaiDocumentStore.getQueryPath(docStream));
                }
            }
        }
    }

    private static void bug28274_project_indexed_query(DocumentStore docStore, Query query, int theValue, String indexName) {
        try (DocumentStream docStream = docStore.findQuery(query);){
            int docCount = 0;
            for (Document doc : docStream) {
                String id = doc.getIdString();
                int idInt = Integer.parseInt(id);
                Assert.assertTrue((idInt > 0 ? 1 : 0) != 0);
                int a = doc.getInt("a");
                Assert.assertEquals((long)idInt, (long)a);
                Assert.assertEquals((long)theValue, (long)a);
                String aText = doc.getString("aText");
                Assert.assertNull((Object)aText);
                ++docCount;
            }
            Assert.assertEquals((long)1L, (long)docCount);
            Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)TestOjaiDocumentStore.getQueryPath(docStream));
            Assert.assertEquals((Object)indexName, (Object)TestOjaiDocumentStore.getIndexUsed(docStream));
        }
    }

    @Test
    @Category(value={ClusterTest.class})
    public void testQuery_bug28274_project_indexed() throws Exception {
        String rawTableName = "bug28274_concrete";
        this.addCleanupTable("bug28274_concrete");
        try (Table table = DBTests.createOrGetTable((String)"bug28274_concrete");){
            String tableName = DBTests.getFullPath((String)"bug28274_concrete");
            this.addCleanupTable(tableName);
            String indexName = "bug28274_concrete_idx";
            DBTests.createIndex((Table)table, (String)"bug28274_concrete_idx", (boolean)false, (int)0, (String[])new String[]{"a"}, null, null);
            try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
                 DocumentStore docStore = connection.getStore(tableName);){
                int nRows = 6;
                for (int i = 1; i <= 6; ++i) {
                    Document doc = connection.newDocument();
                    doc.setId(Integer.toString(i));
                    doc.set("a", i);
                    doc.set("aText", "sometext" + i);
                    table.insert(doc);
                }
                DBTests.waitForIndexFlush((String)"bug28274_concrete");
                DBTests.waitForRowCount((String)"bug28274_concrete", (long)6L);
                int theValue = 3;
                Query query = connection.newQuery().select(new String[]{"a"}).where(connection.newCondition().and().is("a", QueryCondition.Op.EQUAL, 3).is("aText", QueryCondition.Op.EQUAL, "sometext3").close().build()).build();
                TestOjaiDocumentStore.bug28274_project_indexed_query(docStore, query, 3, "bug28274_concrete");
                Query queryRaw = connection.newQuery().setOption("ojai.mapr.query.use-index", (Object)"bug28274_concrete_idx").select(new String[]{"a"}).where(connection.newCondition().and().is("a", QueryCondition.Op.EQUAL, 3).is("aText", QueryCondition.Op.EQUAL, "sometext3").close().build()).build();
                TestOjaiDocumentStore.bug28274_project_indexed_query(docStore, queryRaw, 3, "bug28274_concrete_idx");
            }
        }
    }

    @Test
    public void testQuery_bug28439() throws Exception {
        String rawTableName = "bug28439";
        this.addCleanupTable("bug28439");
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
             Table table = DBTests.createOrGetTable((String)"bug28439");){
            String id;
            Path tablePath = table.getPath();
            String tableName = tablePath.toString();
            int nRows = 2;
            for (int i = 1; i <= 2; ++i) {
                Document doc = connection.newDocument();
                String id2 = Integer.toString(i);
                doc.setId(id2);
                doc.set("a", "a" + id2);
                table.insert(doc);
            }
            DBTests.waitForRowCount((String)"bug28439", (long)2L);
            Query query = connection.newQuery().select(new String[]{"a"}).build();
            DocumentStore docStore = connection.getStore(tableName);
            DocumentStream docStream = docStore.findQuery(query);
            Document doc1 = docStore.findById("1");
            Assert.assertNotNull((Object)doc1);
            int docCount = 0;
            for (Document doc : docStream) {
                id = doc.getIdString();
                Assert.assertNotNull((Object)id);
                ++docCount;
            }
            Assert.assertEquals((long)2L, (long)docCount);
            TestOjaiDocumentStore.assertQueryPath(docStream, OjaiQueryProperties.QueryPath.DIRECT);
            docStream.close();
            docStore.close();
            docStore = connection.getStore(tableName);
            docStream = docStore.findQuery(query);
            docCount = 0;
            for (Document doc : docStream) {
                id = doc.getIdString();
                Assert.assertNotNull((Object)id);
                ++docCount;
            }
            Assert.assertEquals((long)2L, (long)docCount);
            TestOjaiDocumentStore.assertQueryPath(docStream, OjaiQueryProperties.QueryPath.DIRECT);
            DocumentMutation mutation = connection.newMutation().append("b", "_append");
            docStore.update("1", mutation);
            docStream.close();
            docStore.close();
        }
    }

    @Test(expected=TableNotFoundException.class)
    public void testStore_bug27658() throws Exception {
        String rawTableName = "bug27658";
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            DocumentStore documentStore = connection.getStore("bug27658");
            Assert.assertNotNull((Object)documentStore);
        }
    }

    @Test
    public void testStore_bug28161() throws Exception {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            Document ex4;
            String tableName = sharedTable27809.prepare((Connection)connection);
            Query query = connection.newQuery().select(new String[]{"s1"}).offset(2L).limit(2L).build();
            DocumentStore docStore = connection.getStore(tableName);
            try (DocumentStream docStream = docStore.findQuery(query);){
                int docCount = 0;
                for (Document doc : docStream) {
                    String s1 = doc.getString("s1");
                    Assert.assertNotNull((Object)s1);
                    ++docCount;
                }
                Assert.assertEquals((long)2L, (long)docCount);
                Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)TestOjaiDocumentStore.getQueryPath(docStream));
            }
            docStore.close();
            boolean caughtEx = false;
            try {
                var7_10 = docStore.findQuery(query);
            }
            catch (TableClosedException ex2) {
                caughtEx = true;
            }
            Assert.assertTrue((boolean)caughtEx);
            caughtEx = false;
            try {
                Document ex2 = docStore.findById("1");
            }
            catch (TableClosedException ex3) {
                caughtEx = true;
            }
            Assert.assertTrue((boolean)caughtEx);
            QueryCondition condition = connection.newCondition().is("s1", QueryCondition.Op.EQUAL, "foo").build();
            caughtEx = false;
            try {
                Document docCount = docStore.findById("1", condition);
            }
            catch (TableClosedException ex4) {
                caughtEx = true;
            }
            Assert.assertTrue((boolean)caughtEx);
            caughtEx = false;
            try {
                ex4 = docStore.findById("1", new String[]{"s1"});
            }
            catch (TableClosedException ex5) {
                caughtEx = true;
            }
            Assert.assertTrue((boolean)caughtEx);
            caughtEx = false;
            try {
                ex4 = docStore.findById("1", condition, new String[]{"s1"});
            }
            catch (TableClosedException ex6) {
                caughtEx = true;
            }
            Assert.assertTrue((boolean)caughtEx);
        }
    }

    @Test
    public void testStore_bug28384() throws Exception {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            String tableName = sharedTable27809.prepare((Connection)connection);
            QueryCondition condition = connection.newCondition().typeOf("s1", Value.Type.STRING).build();
            try (DocumentStore docStore = connection.getStore(tableName);){
                Document docAll = docStore.findById("3");
                Assert.assertNotNull((Object)docAll);
                Document doc = docStore.findById("3", (String[])null);
                Assert.assertNotNull((Object)doc);
                doc = docStore.findById("3", condition);
                Assert.assertNotNull((Object)doc);
                doc = docStore.findById("3", condition, (String[])null);
                Assert.assertNotNull((Object)doc);
            }
        }
    }

    @Test(expected=NullPointerException.class)
    public void testStore_bug28217_begin() throws Exception {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            String tableName = sharedTable27809.prepare((Connection)connection);
            try (DocumentStore docStore = connection.getStore(tableName);){
                docStore.beginTrackingWrites(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDocumentStore_buffered_writes() throws Exception {
        String test_buffered_write_table = "test_buffered_write_table";
        String test_buffered_write_table_path = DBTests.getFullPath((String)"test_buffered_write_table");
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
             Table table = DBTests.createOrReplaceTable((String)"test_buffered_write_table");
             DocumentStore buffered_store = connection.getStore(test_buffered_write_table_path);){
            buffered_store.insertOrReplace(MapRDBImpl.newDocument((String)"{\"_id\":\"1500a821-f9d3-46de-a603-e6e6b0db5822\",\"data\":{\"firstName\":\"first\",\"lastName\":null}}"));
            DocumentStream streamWithoutFlush = table.find();
            List docs = DBTests.getAllDocumentsAndCloseStream((DocumentStream)streamWithoutFlush);
            Assert.assertEquals((long)0L, (long)docs.size());
        }
        catch (Throwable throwable) {
            DBTests.deleteTables((String[])new String[]{"test_buffered_write_table"});
            throw throwable;
        }
        DBTests.deleteTables((String[])new String[]{"test_buffered_write_table"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDocumentStore_non_buffered_writes() throws Exception {
        String test_non_buffered_write_table = "test_non_buffered_write_table";
        String test_non_buffered_write_table_path = DBTests.getFullPath((String)"test_non_buffered_write_table");
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
             Table table = DBTests.createOrReplaceTable((String)"test_non_buffered_write_table");
             DocumentStore non_buffered_store = connection.getStore(test_non_buffered_write_table_path, connection.newDocument().set("ojai.mapr.documentstore.buffer-writes", false));){
            non_buffered_store.insertOrReplace(MapRDBImpl.newDocument((String)"{\"_id\":\"1500a821-f9d3-46de-a603-e6e6b0db5822\",\"data\":{\"firstName\":\"first\",\"lastName\":null}}"));
            DocumentStream streamWithoutFlush = table.find();
            List docs = DBTests.getAllDocumentsAndCloseStream((DocumentStream)streamWithoutFlush);
            Assert.assertEquals((long)1L, (long)docs.size());
        }
        catch (Throwable throwable) {
            DBTests.deleteTables((String[])new String[]{"test_non_buffered_write_table"});
            throw throwable;
        }
        DBTests.deleteTables((String[])new String[]{"test_non_buffered_write_table"});
    }

    @Test
    @Category(value={ClusterTest.class})
    public void testQuery_bug28195() throws IOException {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            String tableName = sharedTable27954.prepare((Connection)connection);
            try (DocumentStore docStore = connection.getStore(tableName);){
                Query query = connection.newQuery().select(new String[]{"*"}).where(connection.newCondition().is("_id", QueryCondition.Op.GREATER_OR_EQUAL, "1").build()).orderBy("b", SortOrder.DESC).build();
                String lastB = null;
                int docCount = 0;
                try (DocumentStream docStream = docStore.findQuery(query);){
                    for (Document doc : docStream) {
                        String id = doc.getIdString();
                        int idInt = Integer.parseInt(id);
                        Assert.assertTrue((idInt > 0 ? 1 : 0) != 0);
                        long a = doc.getLong("a");
                        Assert.assertEquals((long)idInt, (long)a);
                        String b = doc.getString("b");
                        Assert.assertTrue((OjaiTest.STRING_CMP_W_NULL.compare(b, lastB) <= 0 ? 1 : 0) != 0);
                        lastB = b;
                        ++docCount;
                    }
                    Assert.assertEquals((long)3L, (long)docCount);
                    Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DRILL, (Object)TestOjaiDocumentStore.getQueryPath(docStream));
                }
            }
        }
    }

    @Test
    public void testQuery_bug28013() throws Exception {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            String tableName = sharedTable27024.prepare((Connection)connection);
            String rawTableName = sharedTable27024.getRawTableName();
            long nRows = sharedTable27024.getNumRows();
            int nonNullStrings = sharedTable27024.getNonNullStrings();
            int length2Strings = sharedTable27024.getLength2Strings();
            Query querySExists = connection.newQuery().where(connection.newCondition().typeOf("s", Value.Type.STRING).build()).build();
            try (DocumentStore docStore = connection.getStore(tableName);
                 DocumentStream docStream = docStore.findQuery(querySExists);){
                int docCount = 0;
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertTrue((Integer.valueOf(id) > 0 ? 1 : 0) != 0);
                    String s = doc.getString("s");
                    Assert.assertNotNull((Object)s);
                    ++docCount;
                }
                Assert.assertEquals((long)nonNullStrings, (long)docCount);
                Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)OjaiTest.getQueryPath(docStream));
                Assert.assertEquals((Object)rawTableName, (Object)OjaiTest.getIndexUsed(docStream));
            }
            Query querySLength2 = connection.newQuery().where(connection.newCondition().sizeOf("s", QueryCondition.Op.EQUAL, 2L).build()).build();
            try (DocumentStore docStore = connection.getStore(tableName);
                 DocumentStream docStream = docStore.findQuery(querySLength2);){
                int docCount = 0;
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertTrue((Integer.valueOf(id) > 0 ? 1 : 0) != 0);
                    String s = doc.getString("s");
                    Assert.assertEquals((long)2L, (long)s.length());
                    ++docCount;
                }
                Assert.assertEquals((long)length2Strings, (long)docCount);
                Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)OjaiTest.getQueryPath(docStream));
                Assert.assertEquals((Object)rawTableName, (Object)OjaiTest.getIndexUsed(docStream));
            }
        }
    }

    private static void bug28361_query(Connection connection, String tableName, Query querySLength2And, String lastSizeOf2String, String indexName) {
        try (DocumentStore docStore = connection.getStore(tableName);
             DocumentStream docStream = docStore.findQuery(querySLength2And);){
            int docCount = 0;
            for (Document doc : docStream) {
                String id = doc.getIdString();
                Assert.assertTrue((Integer.valueOf(id) > 0 ? 1 : 0) != 0);
                String s = doc.getString("s");
                Assert.assertEquals((long)2L, (long)s.length());
                Assert.assertEquals((Object)lastSizeOf2String, (Object)s);
                ++docCount;
            }
            Assert.assertEquals((long)1L, (long)docCount);
            Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)OjaiTest.getQueryPath(docStream));
            Assert.assertEquals((Object)indexName, (Object)OjaiTest.getIndexUsed(docStream));
        }
    }

    @Test
    public void testQuery_bug28361() throws Exception {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            String tableName = sharedTable27024.prepare((Connection)connection);
            String rawTableName = sharedTable27024.getRawTableName();
            String indexName = sharedTable27024.getIndexName();
            String lastSizeOf2String = sharedTable27024.getLastSizeOf2String();
            Query querySLength2And = connection.newQuery().where(connection.newCondition().and().sizeOf("s", QueryCondition.Op.EQUAL, 2L).is("s", QueryCondition.Op.EQUAL, lastSizeOf2String).close().build()).build();
            TestOjaiDocumentStore.bug28361_query((Connection)connection, tableName, querySLength2And, lastSizeOf2String, rawTableName);
            Query querySLength2AndIndex = connection.newQuery().setOption("ojai.mapr.query.use-index", (Object)indexName).where(connection.newCondition().and().sizeOf("s", QueryCondition.Op.EQUAL, 2L).is("s", QueryCondition.Op.EQUAL, lastSizeOf2String).close().build()).build();
            TestOjaiDocumentStore.bug28361_query((Connection)connection, tableName, querySLength2AndIndex, lastSizeOf2String, indexName);
        }
    }

    @Test
    public void testQuery_bug28715() throws Exception {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            String tableName = sharedTable27024.prepare((Connection)connection);
            int length2Strings = sharedTable27024.getLength2Strings();
            int nonNullStrings = sharedTable27024.getNonNullStrings();
            String rawTableName = sharedTable27024.getRawTableName();
            Query querySLengthNot2 = connection.newQuery().where(connection.newCondition().sizeOf("s", QueryCondition.Op.NOT_EQUAL, 2L).build()).build();
            try (DocumentStore docStore = connection.getStore(tableName);
                 DocumentStream docStream = docStore.findQuery(querySLengthNot2);){
                int docCount = 0;
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertTrue((Integer.valueOf(id) > 0 ? 1 : 0) != 0);
                    String s = doc.getString("s");
                    Assert.assertNotEquals((long)2L, (long)s.length());
                    ++docCount;
                }
                Assert.assertEquals((long)(nonNullStrings - length2Strings), (long)docCount);
                Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)OjaiTest.getQueryPath(docStream));
                Assert.assertEquals((Object)rawTableName, (Object)OjaiTest.getIndexUsed(docStream));
            }
        }
    }

    @Test
    public void testQuery_bug28350() throws Exception {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            String tableName = sharedTable27954.prepare((Connection)connection);
            String rawTableName = sharedTable27954.getRawTableName();
            Query query = connection.newQuery().select(new String[]{"*"}).where(connection.newCondition().typeOf("asdf", Value.Type.STRING).build()).build();
            try (DocumentStore docStore = connection.getStore(tableName);
                 DocumentStream docStream = docStore.findQuery(query);){
                int docCount = 0;
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertTrue((Integer.valueOf(id) > 0 ? 1 : 0) != 0);
                    ++docCount;
                }
                Assert.assertEquals((long)0L, (long)docCount);
                Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)OjaiTest.getQueryPath(docStream));
                Assert.assertEquals((Object)rawTableName, (Object)OjaiTest.getIndexUsed(docStream));
            }
        }
    }

    @Test
    public void testOmniTypeNotEquals() throws IOException, Exception {
        String testTable = "testtable-testOmniTableNotEquals";
        OjaiConnection connection = TestOjaiDocumentStore.getConnection();
        try (Table table = DBTests.createOrReplaceTable((String)"testtable-testOmniTableNotEquals");){
            DBTests.createIndex((String)"testtable-testOmniTableNotEquals", (String)"a_idx", (String[])new String[]{"a"});
        }
        var4_4 = null;
        try (DocumentStore store = connection.getStore(DBTests.getFullPath((String)"testtable-testOmniTableNotEquals"));){
            store.insertOrReplace(connection.newDocument("{\"_id\":\"1\",\"a\":1}"));
            store.insertOrReplace(connection.newDocument("{\"_id\":\"2\",\"a\":2.04}"));
            store.insertOrReplace(connection.newDocument("{\"_id\":\"3\",\"a\":\"three\"}"));
            store.insertOrReplace(connection.newDocument("{\"_id\":\"4\",\"a\":false}"));
            store.insertOrReplace(connection.newDocument("{\"_id\":\"5\",\"b\":true}"));
            store.insertOrReplace(connection.newDocument("{\"_id\":\"6\",\"c\":true}"));
            store.flush();
            DBTests.waitForIndexFlush((String)"testtable-testOmniTableNotEquals");
            Query q = connection.newQuery().where(connection.newCondition().is("a", QueryCondition.Op.NOT_EQUAL, 1).build()).build();
            try (DocumentStream stream = store.findQuery(q);){
                int count = 0;
                for (Document d : stream) {
                    Assert.assertNotNull((Object)d.getIdString());
                    ++count;
                }
                Assert.assertEquals((long)5L, (long)count);
            }
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
    }

    @Ignore(value="http://10.250.1.25/show_bug.cgi?id=27686")
    @Test
    public void testQuery_bug28190() throws Exception {
        String rawTableName = "bug28190";
        OjaiTest.createTableAndLoad("bug28190");
        this.addCleanupTable("bug28190");
        String indexName = "bug28190_idx";
        DBTests.createIndex((String)"bug28190", (String)"bug28190_idx", (String[])new String[]{"a", "b"}, (String[])new String[]{"c"});
        DBTests.waitForRowCount((String)"bug28190", (long)16L);
        DBTests.waitForIndexFlush((String)"bug28190");
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            Query query = connection.newQuery().select(new String[]{"a"}).where(connection.newCondition().and().is("a", QueryCondition.Op.EQUAL, 1).is("_id", QueryCondition.Op.NOT_EQUAL, "001").close().build()).build();
            try (Table table = DBTests.createOrGetTable((String)"bug28190");){
                Path tablePath = table.getPath();
                String tableName = tablePath.toString();
                try (DocumentStore docStore = connection.getStore(tableName);
                     DocumentStream docStream = docStore.findQuery(query);){
                    int docCount = 0;
                    for (Document doc : docStream) {
                        String id = doc.getIdString();
                        Assert.assertTrue((Integer.parseInt(id) > 0 ? 1 : 0) != 0);
                        int a = doc.getInt("a");
                        Assert.assertEquals((long)1L, (long)a);
                        ++docCount;
                    }
                    Assert.assertEquals((long)5L, (long)docCount);
                    Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)TestOjaiDocumentStore.getQueryPath(docStream));
                    Assert.assertEquals((Object)"bug28190_idx", (Object)OjaiTest.getIndexUsed(docStream));
                }
            }
        }
    }

    @Test
    public void testQuery_bug28384() throws Exception {
        String theId = "1";
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            String tableName = sharedTable27809.prepare((Connection)connection);
            try (DocumentStore docStore = connection.getStore(tableName);){
                Document doc = docStore.findById("1", (String[])null);
                Assert.assertNotNull((Object)doc);
                String id = doc.getIdString();
                Assert.assertEquals((Object)"1", (Object)id);
                String idGet = doc.getString("_id");
                Assert.assertEquals((Object)"1", (Object)idGet);
                String docString = doc.toString();
                Assert.assertTrue((boolean)docString.contains("_id"));
            }
        }
    }

    @Test
    public void testQuery_bug28534() throws Exception {
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            String tableName = sharedTable27809.prepare((Connection)connection);
            long rowCount = sharedTable27809.getNumRows();
            try (DocumentStore docStore = connection.getStore(tableName);){
                Query queryNotExists = connection.newQuery().where(connection.newCondition().notExists(DocumentConstants.ID_FIELD).build()).build();
                try (DocumentStream docStream = docStore.findQuery(queryNotExists);){
                    int docCount = 0;
                    for (Document doc : docStream) {
                        String id = doc.getIdString();
                        Assert.assertNotNull((Object)id);
                        ++docCount;
                    }
                    Assert.assertEquals((long)0L, (long)docCount);
                }
                Query queryExists = connection.newQuery().where(connection.newCondition().exists(DocumentConstants.ID_FIELD).build()).build();
                try (DocumentStream docStream = docStore.findQuery(queryExists);){
                    int docCount = 0;
                    for (Document doc : docStream) {
                        String id = doc.getIdString();
                        Assert.assertNotNull((Object)id);
                        ++docCount;
                    }
                    Assert.assertEquals((long)rowCount, (long)docCount);
                }
            }
        }
    }

    public void testQuery_bug28953() throws Exception {
        String rawTableName = "bug28953";
        int numZeros = 0;
        this.addCleanupTable("bug28953");
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();){
            String indexName;
            String tableName;
            int nPartition = 32;
            int theMultiple = 2;
            int nRows = 64;
            try (Table table = DBTests.createOrGetTable((String)"bug28953");){
                Path tablePath = table.getPath();
                tableName = tablePath.toString();
                for (int i = 1; i <= 64; ++i) {
                    Document doc = connection.newDocument();
                    String id = Integer.toString(i);
                    doc.setId(id);
                    doc.set("a", "a" + id);
                    doc.set("b", 64 - i);
                    int c = i % 2;
                    doc.set("c", c);
                    if (c == 0) {
                        ++numZeros;
                    }
                    table.insert(doc);
                }
                indexName = "bug28953_c_hidx";
                DBTests.createIndex((Table)table, (String)indexName, (boolean)true, (int)32, (String[])new String[]{"c"}, null, (String[])new String[]{"b"});
            }
            DBTests.waitForRowCount((String)"bug28953", (long)64L);
            DBTests.waitForIndexFlush((String)"bug28953");
            Query query = connection.newQuery().select(new String[]{"b"}).where(connection.newCondition().is("c", QueryCondition.Op.EQUAL, 0).build()).build();
            try (DocumentStore docStore = connection.getStore(tableName);
                 DocumentStream docStream = docStore.findQuery(query);){
                int docCount = 0;
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertTrue((Integer.parseInt(id) > 0 ? 1 : 0) != 0);
                    int b = doc.getInt("b");
                    Assert.assertTrue((b <= 64 ? 1 : 0) != 0);
                    ++docCount;
                }
                Assert.assertEquals((long)numZeros, (long)docCount);
                Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)TestOjaiDocumentStore.getQueryPath(docStream));
                Assert.assertEquals((Object)indexName, (Object)OjaiTest.getIndexUsed(docStream));
                String queryPlanString = OjaiDocumentStore.queryPlanToString(OjaiTest.getQueryPlan(docStream));
                Assert.assertTrue((String)queryPlanString, (boolean)queryPlanString.contains(UnionDocumentStream.class.getSimpleName()));
            }
        }
    }

    @Test
    public void testMultiGet() throws IOException {
        String tablePath = DBTests.getFullPath((String)MULTIGET_TABLE);
        Table table = DBTests.createOrGetTable((String)MULTIGET_TABLE);
        Throwable throwable = null;
        if (table != null) {
            if (throwable != null) {
                try {
                    table.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                table.close();
            }
        }
        throwable = null;
        try (OjaiConnection connection = TestOjaiDocumentStore.getConnection();
             DocumentStore docStore = connection.getStore(tablePath);){
            Assert.assertNotNull((Object)docStore);
            OjaiDocumentStore ojaiDocStore = (OjaiDocumentStore)docStore;
            BaseJsonTable table2 = ojaiDocStore.getTable();
            Assert.assertNotNull((Object)table2);
            BaseJsonTable jsonTable = table2;
            int numDocuments = 30000;
            for (int i = 0; i < numDocuments; ++i) {
                Document document = connection.newDocument();
                document.set("_id", "key" + i).set("a", "a" + i).set("b", i).set("c", "c" + i);
                table2.insert(document);
            }
            table2.flush();
            ByteBuffer[] ids = new ByteBuffer[numDocuments];
            for (int i = 0; i < numDocuments; ++i) {
                ids[i] = IdCodec.encode((String)("key" + i));
            }
            MultiGet multiGet = new MultiGet(jsonTable, null, jsonTable.isExcludeId(), (String[])null);
            List docList = multiGet.doGet(ids);
            Assert.assertEquals((long)numDocuments, (long)docList.size());
            for (int i = 0; i < numDocuments; ++i) {
                Assert.assertEquals((Object)("a" + i), (Object)((Document)docList.get(i)).getString("a"));
            }
            ConditionImpl condition = MapRDBImpl.newCondition().is("b", QueryCondition.Op.LESS, 100L).build();
            multiGet = new MultiGet(jsonTable, (QueryCondition)condition, jsonTable.isExcludeId(), new String[]{"c"});
            docList = multiGet.doGet(ids);
            Assert.assertEquals((long)100L, (long)docList.size());
            for (int i = 0; i < 100; ++i) {
                Assert.assertEquals(null, (Object)((Document)docList.get(i)).getString("a"));
                Assert.assertEquals(null, (Object)((Document)docList.get(i)).getString("b"));
                Assert.assertEquals((Object)("c" + i), (Object)((Document)docList.get(i)).getString("c"));
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
    }

    private static class SharedTable27024
    extends SharedTestTable {
        private final int nRows = 17;
        private int nonNullStrings;
        private String indexName = null;
        private int length2Strings;
        private String lastSizeOf2String;

        public SharedTable27024() {
            super("bug27024");
        }

        @Override
        protected String initialize(Connection connection, String rawTableName) throws Exception {
            try (Table table = DBTests.createOrGetTable((String)rawTableName);){
                Path tablePath = table.getPath();
                String tableName = tablePath.toString();
                this.indexName = rawTableName + "_idx";
                DBTests.createIndex((Table)table, (String)this.indexName, (boolean)false, (int)0, (String[])new String[]{"s"}, null, null);
                this.nonNullStrings = 0;
                this.length2Strings = 0;
                this.lastSizeOf2String = null;
                StringGenerator stringGenerator = new StringGenerator(32, 27024L);
                for (int i = 1; i <= 17; ++i) {
                    Document doc = connection.newDocument();
                    String id = Integer.toString(i);
                    doc.setId(id);
                    doc.set("i", i);
                    if (i % 2 == 0) {
                        ++this.nonNullStrings;
                        String s = stringGenerator.nextUniqueString();
                        if (this.lastSizeOf2String == null) {
                            s = s.substring(0, 2);
                        }
                        if (s.length() == 2) {
                            ++this.length2Strings;
                            this.lastSizeOf2String = s;
                        }
                        doc.set("s", s);
                    }
                    table.insert(doc);
                }
                String string = tableName;
                return string;
            }
        }

        @Override
        public long getNumRows() {
            return 17L;
        }

        public int getNonNullStrings() {
            return this.nonNullStrings;
        }

        public int getLength2Strings() {
            return this.length2Strings;
        }

        public String getLastSizeOf2String() {
            return this.lastSizeOf2String;
        }

        public String getIndexName() {
            return this.indexName;
        }
    }

    private static class SharedTable27809
    extends SharedTestTable {
        private String indexName;

        public SharedTable27809() {
            super("bug27809");
        }

        @Override
        protected String initialize(Connection connection, String rawTableName) throws Exception {
            try (Table table = DBTests.createOrGetTable((String)rawTableName);){
                Path tablePath = table.getPath();
                String tableName = tablePath.toString();
                this.indexName = rawTableName + "_idx";
                DBTests.createIndex((Table)table, (String)(rawTableName + "_idx"), (boolean)false, (int)0, (String[])new String[]{"s1"}, null, null);
                StringGenerator stringGenerator = new StringGenerator(32, 27809L);
                int nRows = (int)this.getNumRows();
                for (int i = 1; i <= nRows; ++i) {
                    Document doc = connection.newDocument();
                    doc.setId(Integer.toString(i));
                    String s1 = stringGenerator.nextUniqueString();
                    doc.set("s1", s1);
                    table.insert(doc);
                }
                String string = tableName;
                return string;
            }
        }

        @Override
        public long getNumRows() {
            return 17L;
        }

        public String getIndexName() {
            return this.indexName;
        }
    }

    private static class Bug27711String
    extends Bug27711 {
        private static final String[][] value = new String[2][83];
        private final String[] mid = new String[2];
        private final StringGenerator stringGenerator = new StringGenerator(32, 27711L);

        @Override
        public void setDocFields(Document doc, String fieldName) {
            String v1;
            String v0;
            Bug27711String.value[Bug27711.Direction.ASC.getIndex()][this.rowCount] = v0 = this.stringGenerator.nextUniqueString();
            doc.set(fieldName + Bug27711.Direction.ASC.getSuffix(), v0);
            Bug27711String.value[Bug27711.Direction.DESC.getIndex()][this.rowCount] = v1 = this.stringGenerator.nextUniqueString();
            doc.set(fieldName + Bug27711.Direction.DESC.getSuffix(), v1);
            ++this.rowCount;
        }

        @Override
        public void doneInserting() {
            for (int i = 0; i < 2; ++i) {
                Arrays.sort(value[i]);
                this.mid[i] = value[i][this.rowCount / 2];
            }
        }

        @Override
        public void setCondition(String fieldName, QueryCondition cond, QueryCondition.Op op, Bug27711.Direction dir) {
            cond.is(fieldName + dir.getSuffix(), op, this.mid[dir.getIndex()]);
        }

        @Override
        public void assertCmp(Document doc, String fieldName, QueryCondition.Op op, Bug27711.Direction dir) {
            String v = doc.getString(fieldName + dir.getSuffix());
            switch (op) {
                case GREATER: {
                    Assert.assertTrue((v.compareTo(this.mid[dir.getIndex()]) > 0 ? 1 : 0) != 0);
                    break;
                }
                case LESS: {
                    Assert.assertTrue((v.compareTo(this.mid[dir.getIndex()]) < 0 ? 1 : 0) != 0);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("no case for " + op);
                }
            }
        }
    }

    private static class Bug27711Int
    extends Bug27711 {
        private static final int[][] value = new int[2][83];
        private final int[] mid = new int[2];

        @Override
        public void setDocFields(Document doc, String fieldName) {
            int v1;
            int v0;
            Bug27711Int.value[Bug27711.Direction.ASC.getIndex()][this.rowCount] = v0 = 100 - this.random.nextInt(200);
            doc.set(fieldName + Bug27711.Direction.ASC.getSuffix(), v0);
            Bug27711Int.value[Bug27711.Direction.DESC.getIndex()][this.rowCount] = v1 = 100 - this.random.nextInt(200);
            doc.set(fieldName + Bug27711.Direction.DESC.getSuffix(), v1);
            ++this.rowCount;
        }

        @Override
        public void doneInserting() {
            for (int i = 0; i < 2; ++i) {
                Arrays.sort(value[i]);
                this.mid[i] = value[i][this.rowCount / 2];
            }
        }

        @Override
        public void setCondition(String fieldName, QueryCondition cond, QueryCondition.Op op, Bug27711.Direction dir) {
            cond.is(fieldName + dir.getSuffix(), op, this.mid[dir.getIndex()]);
        }

        @Override
        public void assertCmp(Document doc, String fieldName, QueryCondition.Op op, Bug27711.Direction dir) {
            int v = doc.getInt(fieldName + dir.getSuffix());
            switch (op) {
                case GREATER: {
                    Assert.assertTrue((v > this.mid[dir.getIndex()] ? 1 : 0) != 0);
                    break;
                }
                case LESS: {
                    Assert.assertTrue((v < this.mid[dir.getIndex()] ? 1 : 0) != 0);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("no case for " + op);
                }
            }
        }
    }

    private static class Bug27711Float
    extends Bug27711 {
        private static final float[][] value = new float[2][83];
        private final float[] mid = new float[2];

        @Override
        public void setDocFields(Document doc, String fieldName) {
            float v1;
            float v0;
            Bug27711Float.value[Bug27711.Direction.ASC.getIndex()][this.rowCount] = v0 = 100.0f * this.random.nextFloat();
            doc.set(fieldName + Bug27711.Direction.ASC.getSuffix(), v0);
            Bug27711Float.value[Bug27711.Direction.DESC.getIndex()][this.rowCount] = v1 = 100.0f * this.random.nextFloat();
            doc.set(fieldName + Bug27711.Direction.DESC.getSuffix(), v1);
            ++this.rowCount;
        }

        @Override
        public void doneInserting() {
            for (int i = 0; i < 2; ++i) {
                Arrays.sort(value[i]);
                this.mid[i] = value[i][this.rowCount / 2];
            }
        }

        @Override
        public void setCondition(String fieldName, QueryCondition cond, QueryCondition.Op op, Bug27711.Direction dir) {
            cond.is(fieldName + dir.getSuffix(), op, this.mid[dir.getIndex()]);
        }

        @Override
        public void assertCmp(Document doc, String fieldName, QueryCondition.Op op, Bug27711.Direction dir) {
            float v = doc.getFloat(fieldName + dir.getSuffix());
            switch (op) {
                case GREATER: {
                    Assert.assertTrue((v > this.mid[dir.getIndex()] ? 1 : 0) != 0);
                    break;
                }
                case LESS: {
                    Assert.assertTrue((v < this.mid[dir.getIndex()] ? 1 : 0) != 0);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("no case for " + op);
                }
            }
        }
    }

    public static abstract class Bug27711 {
        public static final int NROWS = 83;
        protected static final int BOUND = 100;
        protected int rowCount = 0;
        protected final Random random = new Random(27711L);

        public String getRawTableName() {
            String className = this.getClass().getName();
            return className.substring(className.lastIndexOf(36) + 1) + "_t";
        }

        private void testQuery(Connection connection, String rawTableName, String fieldName, QueryCondition.Op op, Direction dir, DocumentStore docStore) {
            QueryCondition condGt = connection.newCondition();
            this.setCondition(fieldName, condGt, op, dir);
            Query queryGt = connection.newQuery().select(new String[]{fieldName + dir.getSuffix(), "_id"}).where(condGt.build()).build();
            try (DocumentStream docStream = docStore.findQuery(queryGt);){
                int docCount = 0;
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertTrue((Integer.parseInt(id) > 0 ? 1 : 0) != 0);
                    this.assertCmp(doc, fieldName, op, dir);
                    ++docCount;
                }
                Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)OjaiTest.getQueryPath(docStream));
                Assert.assertEquals((long)41L, (long)docCount);
                String indexName = rawTableName + dir.getSuffix() + "_idx";
                Assert.assertEquals((Object)indexName, (Object)OjaiTest.getIndexUsed(docStream));
            }
        }

        public void testQueries(Connection connection, String rawTableName, String fieldName, Direction dir, DocumentStore docStore) {
            this.testQuery(connection, rawTableName, fieldName, QueryCondition.Op.GREATER, dir, docStore);
            this.testQuery(connection, rawTableName, fieldName, QueryCondition.Op.LESS, dir, docStore);
        }

        public abstract void setDocFields(Document var1, String var2);

        public abstract void doneInserting();

        public abstract void setCondition(String var1, QueryCondition var2, QueryCondition.Op var3, Direction var4);

        public abstract void assertCmp(Document var1, String var2, QueryCondition.Op var3, Direction var4);

        public static enum Direction {
            ASC(0, "_asc"),
            DESC(1, "_desc");

            private final int v;
            private final String suffix;

            private Direction(int v, String suffix) {
                this.v = v;
                this.suffix = suffix;
            }

            public int getIndex() {
                return this.v;
            }

            public String getSuffix() {
                return this.suffix;
            }
        }
    }
}

