/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.google.common.base.Preconditions;
import com.mapr.db.Admin;
import com.mapr.db.exceptions.DBException;
import com.mapr.db.exceptions.ExceptionHandler;
import com.mapr.db.impl.AdminImpl;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.fs.MapRFileSystem;
import com.mapr.ojai.store.impl.DrillNotInClasspathDrillClient;
import com.mapr.ojai.store.impl.LazyClient;
import com.mapr.ojai.store.impl.OjaiDocumentStore;
import com.mapr.ojai.store.impl.OjaiDrillClient;
import com.mapr.ojai.store.impl.OjaiDriver;
import com.mapr.ojai.store.impl.bean.DrillConnectionParams;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.drill.exec.rpc.user.clusterclient.DrillSession;
import org.apache.hadoop.conf.Configuration;
import org.ojai.Document;
import org.ojai.DocumentBuilder;
import org.ojai.exceptions.DecodingException;
import org.ojai.store.Connection;
import org.ojai.store.DocumentMutation;
import org.ojai.store.DocumentStore;
import org.ojai.store.Driver;
import org.ojai.store.Query;
import org.ojai.store.QueryCondition;
import org.ojai.store.ValueBuilder;

public class OjaiConnection
implements Connection {
    private static final Document emptyStoreOptions = MapRDBImpl.newDocument();
    private final OjaiDriver ojaiDriver;
    private final OjaiDrillClient drillClient;
    private final Admin admin;
    private boolean isClosed;
    private MapRFileSystem fileSystem;

    OjaiConnection(OjaiDriver ojaiDriver) {
        this.ojaiDriver = ojaiDriver;
        this.drillClient = OjaiDriver.isDrillInClasspath() ? new LazyClient(this) : new DrillNotInClasspathDrillClient();
        this.admin = new AdminImpl(this.getFileSystem());
        this.isClosed = false;
    }

    synchronized MapRFileSystem getFileSystem() throws DBException {
        if (this.fileSystem == null) {
            MapRFileSystem fs;
            try {
                fs = new MapRFileSystem();
                Configuration conf = new Configuration();
                fs.initialize(MapRFileSystem.MAPRFS_BASE_URI, conf);
            }
            catch (IOException e) {
                throw ExceptionHandler.handle((IOException)e, (String)"");
            }
            this.fileSystem = fs;
        }
        return this.fileSystem;
    }

    public ExecutorService getExecutorService() {
        return this.ojaiDriver.getExecutorService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (this.isClosed) {
            return;
        }
        OjaiDrillClient ojaiDrillClient = this.drillClient;
        synchronized (ojaiDrillClient) {
            this.drillClient.close();
        }
    }

    public Driver getDriver() {
        return this.ojaiDriver;
    }

    public DocumentStore getStore(String storePath) throws DBException {
        return this.getStore(storePath, emptyStoreOptions);
    }

    public DocumentStore getStore(String storePath, Document options) throws DBException {
        if (this.drillClient.isClosed()) {
            throw new DBException("This connection has been closed");
        }
        return new OjaiDocumentStore(this, storePath, options);
    }

    public ValueBuilder getValueBuilder() {
        return this.ojaiDriver.getValueBuilder();
    }

    public QueryCondition newCondition() {
        return this.ojaiDriver.newCondition();
    }

    public Document newDocument() {
        return this.ojaiDriver.newDocument();
    }

    public Document newDocument(String documentJson) throws DecodingException {
        return this.ojaiDriver.newDocument(documentJson);
    }

    public Document newDocument(Map<String, Object> document) throws DecodingException {
        return this.ojaiDriver.newDocument(document);
    }

    public Document newDocument(Object document) throws DecodingException {
        return this.ojaiDriver.newDocument(document);
    }

    public DocumentBuilder newDocumentBuilder() {
        return this.ojaiDriver.newDocumentBuilder();
    }

    public DocumentMutation newMutation() {
        return this.ojaiDriver.newMutation();
    }

    public Query newQuery() {
        return this.ojaiDriver.newQuery();
    }

    public Query newQuery(String queryJson) {
        return this.ojaiDriver.newQuery(queryJson);
    }

    OjaiDrillClient getDrillClient() {
        return this.drillClient;
    }

    DrillConnectionParams getQueryServiceParam(String clusterName) {
        Preconditions.checkNotNull((Object)clusterName);
        return this.drillClient.getQueryServiceParam(clusterName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DrillSession getDrillSession(String clusterName) {
        Preconditions.checkNotNull((Object)clusterName);
        OjaiDrillClient ojaiDrillClient = this.drillClient;
        synchronized (ojaiDrillClient) {
            return this.drillClient.getDrillSession(clusterName);
        }
    }

    Admin getAdmin() {
        return this.admin;
    }

    String getDefaultClusterName() {
        return this.getFileSystem().getDefaultClusterName();
    }
}

