/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.google.common.collect.ImmutableList;
import com.mapr.ojai.store.impl.Expression;
import com.mapr.ojai.store.impl.ExpressionVisitor;
import com.mapr.ojai.store.impl.FieldExpression;
import com.mapr.ojai.store.impl.LiteralExpression;
import com.mapr.ojai.store.impl.NaryOperator;
import com.mapr.ojai.store.impl.RelationalOperator;
import com.mapr.ojai.store.impl.UnaryOperator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.ojai.FieldPath;

public class ExpressionPruner
extends ExpressionVisitor {
    private final Set<FieldPath> fieldSet;
    private Expression resultExpr;

    public ExpressionPruner(Set<FieldPath> fieldSet) {
        this.fieldSet = Collections.unmodifiableSet(fieldSet);
    }

    public Expression getPrunedExpression() {
        return this.resultExpr;
    }

    @Override
    public void visitField(FieldExpression fieldExpr) {
        FieldPath fieldPath = fieldExpr.getFieldPath();
        this.resultExpr = this.fieldSet.contains(fieldPath) ? fieldExpr : null;
    }

    @Override
    public void visitLiteral(LiteralExpression literalExpr) {
        this.resultExpr = literalExpr;
    }

    @Override
    public void visitNary(NaryOperator naryOp) {
        int nonNull = 0;
        int nonLiterals = 0;
        Expression[] args = new Expression[naryOp.arg.length];
        for (int i = 0; i < args.length; ++i) {
            naryOp.arg[i].visit(this);
            if (this.resultExpr == null) continue;
            ++nonNull;
            args[i] = this.resultExpr;
            if (this.resultExpr instanceof LiteralExpression) continue;
            ++nonLiterals;
        }
        if (nonNull > 0 && nonLiterals > 0) {
            ArrayList<Expression> newArgs = new ArrayList<Expression>(nonNull);
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null) continue;
                newArgs.add(args[i]);
            }
            if (newArgs.size() == 1 && RelationalOperator.isLogicalOperator(naryOp.opName)) {
                this.resultExpr = newArgs.get(0);
                return;
            }
            NaryOperator newOp = new NaryOperator(naryOp.opName, newArgs);
            this.resultExpr = newOp;
            return;
        }
        this.resultExpr = null;
    }

    @Override
    public void visitRelational(RelationalOperator relOp) {
        Expression leftArg = relOp.arg[0];
        leftArg.visit(this);
        if (this.resultExpr != null) {
            this.resultExpr = new RelationalOperator(relOp.opName, (List<Expression>)ImmutableList.of((Object)leftArg, (Object)relOp.getRightLiteral()));
        }
    }

    @Override
    public void visitUnary(UnaryOperator unaryOp) {
        Expression operand = unaryOp.getOperand();
        operand.visit(this);
        if (this.resultExpr != null) {
            this.resultExpr = unaryOp;
        }
    }
}

