/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import java.util.Iterator;
import org.ojai.Document;
import org.ojai.DocumentListener;
import org.ojai.DocumentReader;
import org.ojai.DocumentStream;
import org.ojai.exceptions.OjaiException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDocumentStream
implements DocumentStream {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDocumentStream.class);
    protected boolean isUsed;
    private boolean isClosed;
    private boolean isCanceled;

    private void checkOpen() {
        if (this.isClosed) {
            throw new IllegalStateException("DocumentStream is already closed");
        }
    }

    protected void checkState() {
        this.checkOpen();
        if (this.isUsed) {
            throw new IllegalStateException("DocumentStream has already been used once");
        }
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    protected void cancelQuery() {
        this.isCanceled = true;
    }

    protected void closeDerived() throws OjaiException {
    }

    public final synchronized void close() throws OjaiException {
        if (this.isClosed) {
            return;
        }
        logger.debug("close()");
        if (!this.isCanceled) {
            this.cancelQuery();
        }
        this.closeDerived();
        this.isCanceled = true;
        this.isClosed = true;
    }

    public Iterable<DocumentReader> documentReaders() {
        return new ReaderIterable(this.iterator());
    }

    public void streamTo(DocumentListener docListener) {
        this.checkState();
        try {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Document doc = (Document)iterator.next();
                docListener.documentArrived(doc);
            }
            docListener.eos();
        }
        catch (Exception ex) {
            docListener.failed(ex);
        }
    }

    private class ReaderIterable
    implements Iterable<DocumentReader> {
        private final Iterator<Document> docIter;

        public ReaderIterable(Iterator<Document> docIter) {
            this.docIter = docIter;
        }

        @Override
        public Iterator<DocumentReader> iterator() {
            return new ReaderIterator(this.docIter);
        }
    }

    private static class ReaderIterator
    implements Iterator<DocumentReader> {
        private final Iterator<Document> docIter;

        public ReaderIterator(Iterator<Document> docIter) {
            this.docIter = docIter;
        }

        @Override
        public boolean hasNext() {
            return this.docIter.hasNext();
        }

        @Override
        public DocumentReader next() {
            Document doc = this.docIter.next();
            return doc.asReader();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

