/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.google.common.collect.ImmutableList;
import com.mapr.db.Table;
import com.mapr.db.impl.OjaiQueryProperties;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.ojai.store.impl.AppsUserProfiles;
import com.mapr.ojai.store.impl.CollectingDocumentListener;
import com.mapr.ojai.store.impl.DrillDocumentStream;
import com.mapr.ojai.store.impl.OjaiConnection;
import com.mapr.ojai.store.impl.OjaiQuery;
import com.mapr.ojai.store.impl.OjaiTest;
import com.mapr.ojai.store.impl.QueryContext;
import com.mapr.ojai.store.impl.SharedTestTable;
import com.mapr.ojai.store.impl.StringGenerator;
import com.mapr.tests.annotations.ClusterTest;
import com.mapr.tests.annotations.StressTest;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.Path;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.DocumentConstants;
import org.ojai.DocumentListener;
import org.ojai.DocumentStream;
import org.ojai.FieldPath;
import org.ojai.exceptions.OjaiException;
import org.ojai.store.Connection;
import org.ojai.store.DocumentStore;
import org.ojai.store.Query;
import org.ojai.store.QueryCondition;
import org.ojai.store.SortOrder;

@Category(value={ClusterTest.class})
public class TestDrillDocumentStream
extends OjaiTest {
    private static final int TIMEOUT_SECONDS = 5;
    private static String TABLE_NAME = "user_profiles_doc_stream";
    private static SharedTestTable sharedTable28014fc = new SharedTestTable("bug28014fc"){

        @Override
        protected String initialize(Connection connection, String rawTableName) throws Exception {
            try (Table table = DBTests.createOrGetTable((String)rawTableName);){
                Path tablePath = table.getPath();
                String tableName = tablePath.toString();
                Document doc1 = connection.newDocument();
                doc1.setId("1");
                doc1.set("a", 1L);
                doc1.set("b", "anisha");
                Document doc1Map = connection.newDocument();
                doc1Map.set("A", "A VALUE");
                doc1Map.set("B", "B VALUE");
                doc1.set("map", doc1Map);
                table.insert(doc1);
                Document doc2 = connection.newDocument();
                doc2.setId("2");
                doc2.set("a", "A");
                doc2.set("b", "zara");
                table.insert(doc2);
                Document doc3 = connection.newDocument();
                doc3.setId("3");
                doc3.set("a", 2L);
                ArrayList<String> doc3b = new ArrayList<String>(2);
                doc3b.add("a");
                doc3b.add("b");
                doc3.set("b", doc3b);
                table.insert(doc3);
                table.flush();
                String string = tableName;
                return string;
            }
        }

        @Override
        public long getNumRows() {
            return 3L;
        }
    };
    private static final SharedTable29462 sharedTable29462 = new SharedTable29462();

    @Test
    public void testStreamOne() {
        String sql = "select count(*) theCount from sys.drillbits";
        TestStreamToFromSql tester = new TestStreamToFromSql("select count(*) theCount from sys.drillbits"){

            @Override
            public void verify(LinkedList<Document> docList) {
                Assert.assertEquals((long)1L, (long)docList.size());
                Document doc1 = docList.removeFirst();
                Assert.assertEquals((long)1L, (long)doc1.size());
                Assert.assertEquals((long)1L, (long)doc1.getLong("theCount"));
            }
        };
        tester.runTestBoth();
    }

    @Test
    public void testStreamEmpty() throws IOException {
        DBTests.createOrGetTable((String)"user_profiles_empty");
        String tableName = DBTests.getTablePath((String)"user_profiles_empty").toString();
        String sql = "select * from dfs.`" + tableName + '`';
        TestStreamToFromSql tester = new TestStreamToFromSql(sql){

            @Override
            public void verify(LinkedList<Document> docList) {
                Assert.assertEquals((long)0L, (long)docList.size());
            }
        };
        tester.runTestBoth();
    }

    private static String getScanTableSql(String tableName) {
        String tablePath = DBTests.getTablePath((String)tableName).toString();
        String sql = "select * from dfs.`" + tablePath + '`';
        return sql;
    }

    @BeforeClass
    public static void setup() throws IOException {
        TestDrillDocumentStream.cleanup();
    }

    @AfterClass
    public static void cleanup() throws IOException {
        AppsUserProfiles.deleteAllTables();
    }

    @Test
    public void testStreamMultiple() throws IOException {
        AppsUserProfiles.getPopulatedTable(TABLE_NAME);
        final Map<String, Document> docMap = AppsUserProfiles.getDocMap(TABLE_NAME);
        TestStreamToFromSql tester = new TestStreamToFromSql(TestDrillDocumentStream.getScanTableSql(TABLE_NAME)){

            @Override
            public void verify(LinkedList<Document> docList) {
                Assert.assertEquals((String)"Did not get back all the Documents inserted", (long)docMap.size(), (long)docList.size());
                for (Document doc : docList) {
                    String lastName = doc.getString("last_name");
                    Assert.assertNotNull((Object)lastName);
                    Document origDoc = (Document)docMap.get(lastName);
                    Assert.assertNotNull((Object)origDoc);
                    Assert.assertTrue((boolean)OjaiTest.isNearlyEqual(doc, origDoc));
                }
            }
        };
        tester.runTestBoth();
    }

    @Test
    public void testStreamToStop() throws IOException {
        AppsUserProfiles.getPopulatedTable(TABLE_NAME);
        TestStreamToFromSql tester = new TestStreamToFromSql(TestDrillDocumentStream.getScanTableSql(TABLE_NAME)){
            private int docCount;
            {
                this.docCount = 0;
            }

            @Override
            protected DocumentListener newDocumentListener(DocumentStream docStream, List<Document> docList, Semaphore doneSem) {
                return new TestCollectingDocumentListener(docList, doneSem){

                    public boolean documentArrived(Document document) {
                        boolean rv = super.documentArrived(document);
                        ++docCount;
                        if (docCount > 0) {
                            return false;
                        }
                        return rv;
                    }
                };
            }

            @Override
            public void verify(LinkedList<Document> docList) {
                Assert.assertTrue((docList.size() >= 1 ? 1 : 0) != 0);
            }
        };
        tester.runTestStreaming();
    }

    @Test
    public void testStreamToCloseToCancel() throws IOException {
        AppsUserProfiles.getPopulatedTable(TABLE_NAME);
        TestStreamToFromSql tester = new TestStreamToFromSql(TestDrillDocumentStream.getScanTableSql(TABLE_NAME)){

            @Override
            protected DocumentListener newDocumentListener(DocumentStream docStream, List<Document> docList, Semaphore doneSem) {
                return new ClosableCollectingDocumentListener(docStream, docList, doneSem);
            }

            @Override
            public void verify(LinkedList<Document> docList) {
                Assert.assertTrue((docList.size() >= 1 ? 1 : 0) != 0);
            }
        };
        tester.runTestStreaming();
    }

    @Test
    public void testIterateCloseToCancel() throws IOException {
        AppsUserProfiles.getPopulatedTable(TABLE_NAME);
        TestStreamToFromSql tester = new TestStreamToFromSql(TestDrillDocumentStream.getScanTableSql(TABLE_NAME)){
            int nDocsSeen;

            @Override
            protected void addDocToList(Document doc, DocumentStream docStream) {
                super.addDocToList(doc, docStream);
                ++this.nDocsSeen;
                if (this.nDocsSeen >= 1) {
                    docStream.close();
                }
            }

            @Override
            public void verify(LinkedList<Document> docList) {
                Assert.assertTrue((docList.size() >= 1 ? 1 : 0) != 0);
            }
        };
        tester.runTestIterating();
    }

    @Test
    public void testDrillSessionOptions() throws Exception {
        AppsUserProfiles.getPopulatedTable(TABLE_NAME);
        Table table = DBTests.getTable((String)TABLE_NAME);
        String tablePath = table.getPath().toString();
        DBTests.createIndex((Table)table, (String)"last_name_idx", (boolean)false, (int)0, (String[])new String[]{"last_name"}, null, null);
        try (OjaiConnection connection = TestDrillDocumentStream.getConnection();
             DocumentStore docStore = connection.getStore(tablePath);){
            Assert.assertNotNull((Object)docStore);
            Query coverQuery = connection.newQuery().orderBy(new String[]{"last_name"}).setOption("ojai.mapr.query.force-noncovering-sort", (Object)true).build();
            try (DocumentStream docStream = docStore.findQuery(coverQuery);){
                String previousName = "";
                int docCount = 0;
                for (Document doc : docStream) {
                    String lastName = doc.getString("last_name");
                    Assert.assertTrue((lastName.compareTo(previousName) >= 0 ? 1 : 0) != 0);
                    previousName = lastName;
                    ++docCount;
                }
                Assert.assertTrue((docCount > 1 ? 1 : 0) != 0);
                Assert.assertNull((Object)OjaiTest.getIndexUsed(docStream));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQuery_bug27584() throws Exception {
        String[] dbField = new String[]{"a", "b", "c", "d", "e", "f", "g"};
        try (OjaiConnection connection = TestDrillDocumentStream.getConnection();){
            String rawTableName = "bug27584_t";
            this.addCleanupTable("bug27584_t");
            Table table = DBTests.createOrGetTable((String)"bug27584_t");
            table.flush();
            Path tablePath = table.getPath();
            String tableName = tablePath.toString();
            int nRows = 123;
            int fieldRange = 13759;
            Random valueGenerator = new Random(27584L);
            for (int i = 1; i <= 123; ++i) {
                Document doc = connection.newDocument();
                String id = Integer.toString(i);
                doc.setId(id);
                for (String fieldName : dbField) {
                    doc.set(fieldName, valueGenerator.nextInt(13759));
                }
                table.insert(doc);
            }
            DBTests.waitForRowCount((String)"bug27584_t", (long)123L);
            Query[] fieldQuery = new Query[dbField.length];
            for (int i = 0; i < dbField.length; ++i) {
                int selectId = i % 2;
                FieldPath[] fieldPath = new FieldPath[1 + selectId];
                fieldPath[0] = FieldPath.parseFrom((String)dbField[i]);
                if (selectId != 0) {
                    fieldPath[1] = DocumentConstants.ID_FIELD;
                }
                fieldQuery[i] = connection.newQuery().select(fieldPath).orderBy(new String[]{dbField[i]}).build();
            }
            int nConcurrent = 19;
            ExecutorService executorService = Executors.newFixedThreadPool(19);
            int nQueries = 237;
            CountDownLatch countDownLatch = new CountDownLatch(237);
            for (int i = 0; i < 237; ++i) {
                int fieldIndex = i % dbField.length;
                executorService.execute(new Runnable((Connection)connection, tableName, fieldQuery, fieldIndex, dbField, countDownLatch){
                    final /* synthetic */ Connection val$connection;
                    final /* synthetic */ String val$tableName;
                    final /* synthetic */ Query[] val$fieldQuery;
                    final /* synthetic */ int val$fieldIndex;
                    final /* synthetic */ String[] val$dbField;
                    final /* synthetic */ CountDownLatch val$countDownLatch;
                    {
                        this.val$connection = connection;
                        this.val$tableName = string;
                        this.val$fieldQuery = queryArray;
                        this.val$fieldIndex = n;
                        this.val$dbField = stringArray;
                        this.val$countDownLatch = countDownLatch;
                    }

                    @Override
                    public void run() {
                        try (DocumentStore docStore = this.val$connection.getStore(this.val$tableName);
                             DocumentStream docStream = docStore.findQuery(this.val$fieldQuery[this.val$fieldIndex]);){
                            int docCount = 0;
                            int lastIntValue = Integer.MIN_VALUE;
                            for (Document doc : docStream) {
                                String id = doc.getIdString();
                                Assert.assertTrue((Integer.valueOf(id) > 0 ? 1 : 0) != 0);
                                int intValue = doc.getInt(this.val$dbField[this.val$fieldIndex]);
                                Assert.assertTrue((intValue >= lastIntValue ? 1 : 0) != 0);
                                lastIntValue = intValue;
                                ++docCount;
                            }
                            Assert.assertEquals((long)123L, (long)docCount);
                            this.val$countDownLatch.countDown();
                        }
                    }
                });
            }
            long startMs = System.currentTimeMillis();
            try {
                countDownLatch.await(237L, TimeUnit.SECONDS);
                long endMs = System.currentTimeMillis();
                long elapsedMs = endMs - startMs;
                System.out.println("237 queries took " + elapsedMs + "ms to execute");
            }
            catch (InterruptedException ie) {
                Assert.fail();
            }
            finally {
                executorService.shutdownNow();
            }
        }
    }

    private static void bug27164Query(DocumentStore docStore, Query query, boolean expectId) {
        query.setOption("ojai.mapr.query.force-drill", (Object)true).build();
        try (DocumentStream docStream = docStore.findQuery(query);){
            int docCount = 0;
            for (Document doc : docStream) {
                OjaiTest.assertIdString(doc, null, expectId);
                ++docCount;
            }
            Assert.assertEquals((long)1L, (long)docCount);
            Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DRILL, (Object)OjaiTest.getQueryPath(docStream));
        }
    }

    @Test
    public void testQuery_bug27164() throws Exception {
        try (OjaiConnection connection = TestDrillDocumentStream.getConnection();){
            String rawTableName = "bug27164";
            this.addCleanupTable("bug27164");
            Table table = DBTests.createOrGetTable((String)"bug27164");
            table.flush();
            Path tablePath = table.getPath();
            String tableName = tablePath.toString();
            Document doc = connection.newDocument();
            doc.setId("theId");
            doc.set("a", 1);
            doc.set("b", "foo");
            table.insert(doc);
            table.flush();
            DBTests.waitForRowCount((String)"bug27164", (long)1L);
            try (DocumentStore docStore = connection.getStore(tableName);){
                Query queryPlain = connection.newQuery();
                TestDrillDocumentStream.bug27164Query(docStore, queryPlain, true);
                Query queryStar = connection.newQuery().select(new String[]{"*"});
                TestDrillDocumentStream.bug27164Query(docStore, queryStar, true);
                Query queryStarId = connection.newQuery().select(new String[]{"*", "_id"});
                TestDrillDocumentStream.bug27164Query(docStore, queryStarId, true);
                Query queryField = connection.newQuery().select(new String[]{"b"});
                TestDrillDocumentStream.bug27164Query(docStore, queryField, false);
                Query queryId = connection.newQuery().select(new String[]{"_id"});
                TestDrillDocumentStream.bug27164Query(docStore, queryId, true);
                Query queryFieldId = connection.newQuery().select(new String[]{"b", "_id"});
                TestDrillDocumentStream.bug27164Query(docStore, queryFieldId, true);
            }
        }
    }

    @Test
    public void testDrill_bug28014_general() throws IOException {
        String rawTableName = "bug28014_general";
        this.addCleanupTable("bug28014_general");
        try (Table table = DBTests.createOrGetTable((String)"bug28014_general");){
            table.flush();
        }
        String tableName = DBTests.getFullPath((String)"bug28014_general");
        this.addCleanupTable(tableName);
        StringGenerator stringGenerator = new StringGenerator(64, 28014L);
        int matchingDocs = 0;
        try (OjaiConnection connection = TestDrillDocumentStream.getConnection();
             DocumentStore docStore = connection.getStore(tableName);){
            int nRows = 17;
            for (int i = 1; i <= 17; ++i) {
                Document doc = connection.newDocument();
                doc.setId(Integer.toString(i));
                doc.set("i", i);
                String s = stringGenerator.nextUniqueString();
                doc.set("s", s);
                if (i >= 4 && s.length() >= 4) {
                    ++matchingDocs;
                }
                docStore.insert(doc);
            }
            DBTests.waitForRowCount((String)"bug28014_general", (long)17L);
            Query query = connection.newQuery().setOption("ojai.mapr.query.force-drill", (Object)true).select(new String[]{"i", "s"}).where(connection.newCondition().and().sizeOf("s", QueryCondition.Op.GREATER_OR_EQUAL, 4L).is("i", QueryCondition.Op.GREATER_OR_EQUAL, 4).close().build()).build();
            try (DocumentStream docStream = docStore.findQuery(query);){
                int docCount = 0;
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertTrue((Integer.valueOf(id) > 0 ? 1 : 0) != 0);
                    int i = doc.getInt("i");
                    Assert.assertTrue((i >= 4 ? 1 : 0) != 0);
                    String s = doc.getString("s");
                    Assert.assertTrue((s.length() >= 4 ? 1 : 0) != 0);
                    ++docCount;
                }
                Assert.assertEquals((long)matchingDocs, (long)docCount);
                Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DRILL, (Object)TestDrillDocumentStream.getQueryPath(docStream));
            }
        }
    }

    @Test
    public void testDrill_bug28014_first_comment() throws IOException {
        try (OjaiConnection connection = TestDrillDocumentStream.getConnection();){
            String tableName = sharedTable28014fc.prepare((Connection)connection);
            Query query = connection.newQuery().setOption("ojai.mapr.query.force-drill", (Object)true).where(connection.newCondition().and().sizeOf("map.A", QueryCondition.Op.LESS, 100L).exists("a").close().build()).build();
            try (DocumentStore docStore = connection.getStore(tableName);
                 DocumentStream docStream = docStore.findQuery(query);){
                int docId = 0;
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertEquals((long)(++docId), (long)Integer.parseInt(id));
                }
                OjaiTest.assertQueryPath(docStream, OjaiQueryProperties.QueryPath.DRILL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQuery_bug28121() throws Exception {
        String rawTableName = "bug28121";
        this.addCleanupTable("bug28121");
        try (Table table = DBTests.createOrGetTable((String)"bug28121");){
            table.flush();
            String tableName = DBTests.getFullPath((String)"bug28121");
            this.addCleanupTable(tableName);
            int nRows = 3;
            for (int i = 1; i <= 3; ++i) {
                Document doc = TestDrillDocumentStream.getDriver().newDocument();
                doc.setId(Integer.toString(i));
                doc.set("a", i);
                doc.set("b", 3 - i);
                table.insert(doc);
            }
            table.flush();
            DBTests.waitForRowCount((String)"bug28121", (long)3L);
            LinkedList failures = new LinkedList();
            int nThreads = 17;
            long testTimeMs = 60000L;
            final CountDownLatch startLatch = new CountDownLatch(1);
            CountDownLatch continueLatch = new CountDownLatch(17);
            try (OjaiConnection connection = TestDrillDocumentStream.getConnection();){
                Query query = connection.newQuery().setOption("ojai.mapr.query.force-drill", (Object)true).build();
                ExecutorService executorService = connection.getExecutorService();
                int i = 0;
                while (i < 17) {
                    int threadId = i++;
                    executorService.execute(new Runnable((Connection)connection, tableName, query, threadId, failures, continueLatch){
                        final /* synthetic */ Connection val$connection;
                        final /* synthetic */ String val$tableName;
                        final /* synthetic */ Query val$query;
                        final /* synthetic */ int val$threadId;
                        final /* synthetic */ List val$failures;
                        final /* synthetic */ CountDownLatch val$continueLatch;
                        {
                            this.val$connection = connection;
                            this.val$tableName = string;
                            this.val$query = query;
                            this.val$threadId = n;
                            this.val$failures = list;
                            this.val$continueLatch = countDownLatch2;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                startLatch.await(60L, TimeUnit.SECONDS);
                            }
                            catch (InterruptedException ex) {
                                Assert.fail((String)"time out before thread started");
                            }
                            long startTime = System.currentTimeMillis();
                            int repetition = 0;
                            try {
                                long nowTime;
                                do {
                                    try (DocumentStore docStore = this.val$connection.getStore(this.val$tableName);
                                         DocumentStream docStream = docStore.findQuery(this.val$query);){
                                        int docCount = 0;
                                        for (Document doc : docStream) {
                                            String id = doc.getIdString();
                                            Assert.assertTrue((Integer.parseInt(id) > 0 ? 1 : 0) != 0);
                                            ++docCount;
                                        }
                                        Assert.assertEquals((long)3L, (long)docCount);
                                        Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DRILL, (Object)OjaiTest.getQueryPath(docStream));
                                    }
                                } while (startTime + 60000L > (nowTime = System.currentTimeMillis()));
                            }
                            catch (Exception ex) {
                                Bug28121Failure failure = new Bug28121Failure(this.val$threadId, repetition, ex);
                                List list = this.val$failures;
                                synchronized (list) {
                                    this.val$failures.add(failure);
                                }
                            }
                            this.val$continueLatch.countDown();
                        }
                    });
                }
                startLatch.countDown();
                boolean timedOut = false;
                try {
                    if (!continueLatch.await(3L, TimeUnit.MINUTES)) {
                        throw new InterruptedException("latch timed out");
                    }
                }
                catch (InterruptedException ex) {
                    timedOut = true;
                }
                LinkedList linkedList = failures;
                synchronized (linkedList) {
                    for (Bug28121Failure failure : failures) {
                        System.err.println(failure);
                    }
                    Assert.assertEquals((long)0L, (long)failures.size());
                }
                Assert.assertFalse((boolean)timedOut);
            }
        }
    }

    private static void bug28376createDrillFailure(final Connection connection) {
        OjaiConnection ojaiConnection = (OjaiConnection)connection;
        String badSql = "select nothing from";
        final QueryContext queryContext = QueryContext.newBuilder((String)"select nothing from").build();
        ExecutorService executorService = ojaiConnection.getExecutorService();
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try (DrillDocumentStream drillStream = new DrillDocumentStream((OjaiConnection)connection, queryContext);){
                    for (Document doc : drillStream) {
                        Assert.assertNotNull((Object)doc.getIdString());
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Category(value={StressTest.class})
    public void testQuery_bug28376() throws Exception {
        String rawTableName = "bug28376";
        this.addCleanupTable("bug28376");
        try (Table table = DBTests.createOrGetTable((String)"bug28376");){
            table.flush();
            String tableName = DBTests.getFullPath((String)"bug28376");
            this.addCleanupTable(tableName);
            boolean nRows = true;
            for (int i = 1; i <= 1; ++i) {
                Document doc = TestDrillDocumentStream.getDriver().newDocument();
                doc.setId(Integer.toString(i));
                doc.set("a", i);
                doc.set("b", 1 - i);
                table.insert(doc);
            }
            table.flush();
            DBTests.waitForRowCount((String)"bug28376", (long)1L);
            int nThreads = 23;
            int testTimeMinutes = 3;
            long testTimeMs = 180000L;
            final CountDownLatch startLatch = new CountDownLatch(1);
            CountDownLatch testCompletionLatch = new CountDownLatch(23);
            CountDownLatch activityLatch = new CountDownLatch(23);
            final int[] queriesCompleted = new int[23];
            try (OjaiConnection connection = TestDrillDocumentStream.getConnection();){
                Query query = connection.newQuery().setOption("ojai.mapr.query.force-drill", (Object)true).build();
                ExecutorService executorService = connection.getExecutorService();
                int i = 0;
                while (i < 23) {
                    final int theThreadId = i++;
                    executorService.execute(new Runnable((Connection)connection, tableName, query, queriesCompleted, activityLatch, testCompletionLatch){
                        private final int threadId;
                        final /* synthetic */ Connection val$connection;
                        final /* synthetic */ String val$tableName;
                        final /* synthetic */ Query val$query;
                        final /* synthetic */ int[] val$queriesCompleted;
                        final /* synthetic */ CountDownLatch val$activityLatch;
                        final /* synthetic */ CountDownLatch val$testCompletionLatch;
                        {
                            this.val$connection = connection;
                            this.val$tableName = string;
                            this.val$query = query;
                            this.val$queriesCompleted = nArray;
                            this.val$activityLatch = countDownLatch2;
                            this.val$testCompletionLatch = countDownLatch3;
                            this.threadId = theThreadId;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         * Converted monitor instructions to comments
                         * Lifted jumps to return sites
                         */
                        @Override
                        public void run() {
                            long nowTime;
                            try {
                                startLatch.await(60L, TimeUnit.SECONDS);
                            }
                            catch (InterruptedException ex) {
                                Assert.fail((String)"time out before thread started");
                            }
                            long startTime = System.currentTimeMillis();
                            do {
                                try (DocumentStore docStore = this.val$connection.getStore(this.val$tableName);
                                     DocumentStream docStream = docStore.findQuery(this.val$query);){
                                    int docCount = 0;
                                    for (Document doc : docStream) {
                                        String id = doc.getIdString();
                                        Assert.assertTrue((Integer.parseInt(id) > 0 ? 1 : 0) != 0);
                                        ++docCount;
                                    }
                                    Assert.assertEquals((long)1L, (long)docCount);
                                    Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DRILL, (Object)OjaiTest.getQueryPath(docStream));
                                }
                                int[] nArray = this.val$queriesCompleted;
                                // MONITORENTER : this.val$queriesCompleted
                                int n = this.threadId;
                                this.val$queriesCompleted[n] = this.val$queriesCompleted[n] + 1;
                                // MONITOREXIT : nArray
                                this.val$activityLatch.countDown();
                            } while (startTime + 180000L > (nowTime = System.currentTimeMillis()));
                            this.val$testCompletionLatch.countDown();
                        }
                    });
                }
                Timer timer = new Timer("TestDrillDocumentStream.testQuery_bug28376", true);
                long watchdogPeriodMs = 20000L;
                TimerTask progressTask = new TimerTask(){
                    int[] queriesCompletedCopy;
                    {
                        this.queriesCompletedCopy = new int[queriesCompleted.length];
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        int[] nArray = queriesCompleted;
                        synchronized (queriesCompleted) {
                            int[] qc = Arrays.copyOf(queriesCompleted, queriesCompleted.length);
                            // ** MonitorExit[var2_1] (shouldn't be in output)
                            for (int threadId = 0; threadId < qc.length; ++threadId) {
                                if (qc[threadId] != this.queriesCompletedCopy[threadId]) continue;
                                System.err.println("thread " + threadId + " is not making progress");
                            }
                            this.queriesCompletedCopy = qc;
                            return;
                        }
                    }
                };
                timer.scheduleAtFixedRate(progressTask, 20000L, 20000L);
                long failurePeriodMs = 15000L;
                TimerTask failureTask = new TimerTask((Connection)connection){
                    final /* synthetic */ Connection val$connection;
                    {
                        this.val$connection = connection;
                    }

                    @Override
                    public void run() {
                        TestDrillDocumentStream.bug28376createDrillFailure(this.val$connection);
                    }
                };
                timer.scheduleAtFixedRate(failureTask, 15000L, 15000L);
                startLatch.countDown();
                long waitTimeMinutes = 4L;
                boolean timedOut = false;
                try {
                    if (!testCompletionLatch.await(4L, TimeUnit.MINUTES)) {
                        throw new InterruptedException("testCompletionlatch timed out");
                    }
                }
                catch (InterruptedException ex) {
                    timedOut = true;
                }
                finally {
                    failureTask.cancel();
                    progressTask.cancel();
                }
                Assert.assertFalse((boolean)timedOut);
            }
        }
    }

    @Test
    public void testDrill_bug28627() throws IOException {
        try (OjaiConnection connection = TestDrillDocumentStream.getConnection();){
            String tableName = sharedTable28014fc.prepare((Connection)connection);
            ImmutableList emptyList = ImmutableList.of();
            Query query = connection.newQuery().setOption("ojai.mapr.query.force-drill", (Object)true).where(connection.newCondition().in("a", (List)emptyList).build()).build();
            try (DocumentStore docStore = connection.getStore(tableName);
                 DocumentStream docStream = docStore.findQuery(query);){
                int docCount = 0;
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertNotNull((Object)id);
                    ++docCount;
                }
                Assert.assertEquals((long)0L, (long)docCount);
            }
        }
    }

    @Test
    public void testQuery_bug28995() throws Exception {
        try (OjaiConnection connection = TestDrillDocumentStream.getConnection();){
            String rawTableName = "bug28995";
            this.addCleanupTable("bug28995");
            try (Table table = DBTests.createOrGetTable((String)"bug28995");){
                table.flush();
                Path tablePath = table.getPath();
                String tableName = tablePath.toString();
                String indexName = tableName + "_idx";
                DBTests.createIndex((Table)table, (String)indexName, (boolean)false, (int)0, (String[])new String[]{"map1.d1"}, null, (String[])new String[]{"map1.map2.d2"});
                int nRows = 2000;
                Random random = new Random(28995L);
                double d1 = random.nextDouble();
                double d2 = random.nextDouble();
                for (int i = 1; i <= 2000; ++i) {
                    Document doc = connection.newDocument();
                    String id = String.format("%04d", i);
                    doc.setId(id);
                    HashMap<String, Serializable> map1 = new HashMap<String, Serializable>();
                    HashMap<String, Object> map2 = new HashMap<String, Object>();
                    if (i % 97 == 0) {
                        map1.put("d1", Double.valueOf(d1));
                        map2.put("d2", d2);
                    } else {
                        map1.put("d1", Double.valueOf(random.nextDouble()));
                        map2.put("d2", random.nextDouble());
                    }
                    map1.put("i1", Integer.valueOf(42));
                    map2.put("s1", "foo");
                    doc.set("d3", random.nextDouble());
                    map2.put("d4", random.nextDouble());
                    map1.put("map2", map2);
                    doc.set("map1", map1);
                    table.insert(doc);
                }
                table.flush();
                DBTests.waitForRowCount((String)"bug28995", (long)1L);
                DBTests.waitForIndexFlush((String)"bug28995");
                OjaiQuery baseQuery = (OjaiQuery)connection.newQuery().setOption("ojai.mapr.query.force-drill", (Object)true).select(new String[]{"map1.map2.d4", "_id"}).where(connection.newCondition().and().is("map1.d1", QueryCondition.Op.EQUAL, d1).is("map1.map2.d2", QueryCondition.Op.EQUAL, d2).close().build());
                try (DocumentStore docStore = connection.getStore(tableName);){
                    OjaiQuery firstQuery = new OjaiQuery((Query)baseQuery).orderBy(new String[]{"map1.map2.d2"}).build();
                    try (DocumentStream docStream = docStore.findQuery((Query)firstQuery);){
                        int docCount = 0;
                        for (Document doc : docStream) {
                            String id = doc.getIdString();
                            Assert.assertNotNull((Object)id);
                            double d4 = doc.getDouble("map1.map2.d4");
                            ++docCount;
                        }
                        Assert.assertTrue((docCount > 0 ? 1 : 0) != 0);
                    }
                }
            }
        }
    }

    @Test
    public void testQuery_bug29462() throws IOException {
        try (OjaiConnection connection = TestDrillDocumentStream.getConnection();){
            String tableName = sharedTable29462.prepare((Connection)connection);
            Query query = connection.newQuery().setOption("ojai.mapr.query.force-drill", (Object)true).where(connection.newCondition().is("i10", QueryCondition.Op.GREATER_OR_EQUAL, 5).build()).build();
            try (DocumentStore docStore = connection.getStore(tableName);
                 DocumentStream docStream = docStore.findQuery(query);){
                int docCount = 0;
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertNotNull((Object)id);
                    ++docCount;
                }
                Assert.assertEquals((long)sharedTable29462.geti10gte5(), (long)docCount);
                Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DRILL, (Object)TestDrillDocumentStream.getQueryPath(docStream));
            }
        }
    }

    @Test(expected=OjaiException.class)
    public void testDrill_bug28072() {
        try (OjaiConnection connection = TestDrillDocumentStream.getConnection();){
            String tableName = sharedTable28014fc.prepare((Connection)connection);
            Query query = connection.newQuery().setOption("ojai.mapr.query.force-drill", (Object)true).setOption("ojai.mapr.drill.planner.disable_full_table_scan", (Object)true).select(new String[]{"*"}).orderBy("_id", SortOrder.DESC).build();
            try (DocumentStore docStore = connection.getStore(tableName);
                 DocumentStream docStream = docStore.findQuery(query);){
                int lastId = Integer.MAX_VALUE;
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    int intId = Integer.parseInt(id);
                    Assert.assertTrue((String)("intId = " + intId + " lastId " + lastId), (intId < lastId ? 1 : 0) != 0);
                }
                OjaiTest.assertQueryPath(docStream, OjaiQueryProperties.QueryPath.DRILL);
            }
        }
    }

    private static class SharedTable29462
    extends SharedTestTable {
        private static final String[] SPLIT_KEYS = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
        private static final long numRows = 2349L;
        private int i10gte5;

        public SharedTable29462() {
            super("bug29462");
        }

        @Override
        protected String initialize(Connection connection, String rawTableName) throws Exception {
            try (Table table = DBTests.createOrReplaceTable((String)rawTableName, (String[])SPLIT_KEYS);){
                Path tablePath = table.getPath();
                String tableName = tablePath.toString();
                this.i10gte5 = 0;
                Random random = new Random(29462L);
                StringGenerator stringGenerator = new StringGenerator(128, random);
                int i = 1;
                while ((long)i <= 2349L) {
                    Document doc = connection.newDocument();
                    String id = stringGenerator.nextUniqueString();
                    doc.setId(id);
                    doc.set("s1", stringGenerator.nextUniqueString());
                    int i10 = random.nextInt(10);
                    if (i10 >= 5) {
                        ++this.i10gte5;
                    }
                    doc.set("i10", i10);
                    doc.set("i100", random.nextInt(100));
                    table.insert(doc);
                    ++i;
                }
                table.flush();
                String string = tableName;
                return string;
            }
        }

        @Override
        public long getNumRows() {
            return 2349L;
        }

        public int geti10gte5() {
            return this.i10gte5;
        }
    }

    private static class Bug28121Failure {
        final int threadId;
        final int repetition;
        final Exception ex;

        public Bug28121Failure(int threadId, int repetition, Exception ex) {
            this.threadId = threadId;
            this.repetition = repetition;
            this.ex = ex;
        }

        public String toString() {
            return "thread " + this.threadId + " repetition " + this.repetition + " ex " + this.ex + '\n';
        }
    }

    private static class ClosableCollectingDocumentListener
    extends CollectingDocumentListener {
        private final DocumentStream docStream;
        private int docCount = 0;

        public ClosableCollectingDocumentListener(DocumentStream docStream, List<Document> docList, Semaphore doneSem) {
            super(docList, doneSem);
            this.docStream = docStream;
        }

        public boolean documentArrived(Document document) {
            boolean rv = super.documentArrived(document);
            ++this.docCount;
            if (this.docCount > 0) {
                this.docStream.close();
            }
            return rv;
        }
    }

    public abstract class TestStreamToFromSql {
        private final String sql;
        private final LinkedList<Document> docList = new LinkedList();
        private final Semaphore doneSem = new Semaphore(0);

        public TestStreamToFromSql(String sql) {
            this.sql = sql;
        }

        public void runTestBoth() {
            this.runTestStreaming();
            this.runTestIterating();
        }

        public void runTestStreaming() {
            this.docList.clear();
            QueryContext queryContext = QueryContext.newBuilder((String)this.sql).build();
            try (OjaiConnection ojaiConnection = OjaiTest.getConnection();
                 DrillDocumentStream ods = new DrillDocumentStream(ojaiConnection, queryContext);){
                ods.streamTo(this.newDocumentListener((DocumentStream)ods, this.docList, this.doneSem));
                try {
                    this.doneSem.tryAcquire(1, 5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException ex) {
                    Assert.fail((String)("interrupted " + ex.toString()));
                }
                this.verify(this.docList);
            }
        }

        public void runTestIterating() {
            this.docList.clear();
            QueryContext queryContext = QueryContext.newBuilder((String)this.sql).build();
            try (OjaiConnection ojaiConnection = OjaiTest.getConnection();
                 DrillDocumentStream ods = new DrillDocumentStream(ojaiConnection, queryContext);){
                for (Document doc : ods) {
                    this.addDocToList(doc, (DocumentStream)ods);
                }
                this.verify(this.docList);
            }
        }

        protected void addDocToList(Document doc, DocumentStream docStream) {
            this.docList.add(doc);
        }

        protected DocumentListener newDocumentListener(DocumentStream docStream, List<Document> docList, Semaphore doneSem) {
            return new TestCollectingDocumentListener(docList, doneSem);
        }

        public abstract void verify(LinkedList<Document> var1);
    }

    private static class TestCollectingDocumentListener
    extends CollectingDocumentListener {
        public TestCollectingDocumentListener(List<Document> docList, Semaphore doneSem) {
            super(docList, doneSem);
        }

        public void failed(Exception ex) {
            Assert.fail((String)("Caught exception " + ex));
            super.failed(ex);
        }
    }
}

