/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.mapr.db.Table;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.ojai.store.impl.SharedTestTable;
import com.mapr.ojai.store.impl.StringGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import org.apache.hadoop.fs.Path;
import org.ojai.Document;
import org.ojai.store.Connection;

class SharedTable29281
extends SharedTestTable {
    protected String cityStateReviewsIndexName;
    private String lastBusinessName;
    private int rcOver50;
    public static final String[] CITY = new String[]{"Atlantis", "Kaldor City", "Mos Eisley", "New New York", "Pacifica"};
    public static final String[] STATE = new String[]{"AH", "BF", "CX", "MQ", "ZP"};

    public SharedTable29281() {
        this("bug29281");
    }

    protected SharedTable29281(String bugTableName) {
        super(bugTableName);
    }

    protected void createIndexes(String rawTableName, Table table) throws Exception {
        this.cityStateReviewsIndexName = rawTableName + "_csr_idx";
        DBTests.createIndex((Table)table, (String)this.cityStateReviewsIndexName, (boolean)false, (int)0, (String[])new String[]{"city", "state", "review_count"}, null, (String[])new String[]{"name"});
    }

    @Override
    protected String initialize(Connection connection, String rawTableName) throws Exception {
        this.rcOver50 = 0;
        try (Table table = DBTests.createOrGetTable((String)rawTableName);){
            Path tablePath = table.getPath();
            String tableName = tablePath.toString();
            this.createIndexes(rawTableName, table);
            long nRows = this.getNumRows();
            Random random = new Random(29281L);
            StringGenerator nameGenerator = new StringGenerator(256, random);
            int i = 1;
            while ((long)i <= nRows) {
                Document doc = connection.newDocument();
                String id = String.format("%04d", i);
                doc.setId(id);
                String name = nameGenerator.nextUniqueString();
                String city = CITY[random.nextInt(CITY.length)];
                String state = STATE[random.nextInt(STATE.length)];
                int reviewCount = random.nextInt(100);
                int stars = 1 + random.nextInt(5);
                this.lastBusinessName = name;
                if (city == CITY[0] && state == STATE[0] && reviewCount > 50) {
                    ++this.rcOver50;
                }
                doc.set("name", name);
                doc.set("city", city);
                doc.set("state", state);
                doc.set("review_count", reviewCount);
                doc.set("nc_review_count", reviewCount);
                doc.set("stars", stars);
                HashMap aMap = new HashMap();
                ArrayList<Integer> anArray = new ArrayList<Integer>(2);
                anArray.add(0);
                anArray.add(stars);
                aMap.put("star_array", anArray);
                doc.set("aMap", aMap);
                table.insert(doc);
                ++i;
            }
            String string = tableName;
            return string;
        }
    }

    @Override
    public long getNumRows() {
        return 2000L;
    }

    public String getCityStateReviewsIndexName() {
        return this.cityStateReviewsIndexName;
    }

    public String getLastBusinessName() {
        return this.lastBusinessName;
    }

    public int getRcOver50() {
        return this.rcOver50;
    }
}

