/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.mapr.db.Table;
import com.mapr.db.impl.OjaiQueryProperties;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.ojai.store.impl.CollectingDocumentListener;
import com.mapr.ojai.store.impl.OjaiConnection;
import com.mapr.ojai.store.impl.OjaiDocumentStore;
import com.mapr.ojai.store.impl.OjaiDriver;
import com.mapr.ojai.store.impl.TestProjectionPassthrough;
import com.mapr.tests.BaseTest;
import java.io.IOException;
import java.io.InputStream;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.drill.exec.util.EncodedSchemaPathSet;
import org.junit.AfterClass;
import org.junit.Assert;
import org.ojai.Document;
import org.ojai.DocumentListener;
import org.ojai.DocumentStream;
import org.ojai.json.Json;
import org.ojai.store.Connection;
import org.ojai.store.DocumentStore;
import org.ojai.store.DriverManager;
import org.ojai.store.Query;

public class OjaiTest
extends BaseTest {
    private static final OjaiDriver OJAI_DRIVER = (OjaiDriver)DriverManager.getDriver((String)"ojai:mapr:");
    private static final Pattern ENCODED_FIELD_MATCHER = Pattern.compile("^select ((\\,?t\\.`\\$\\$[a-zA-Z0-9]+`)+) from");
    private static final String BASE_RESOURCE_PATH = "/com/mapr/ojai/driver/test/";
    private static final Map<String, Table> tables_ = Maps.newHashMap();
    private static final Map<String, String> tablesPath_ = Maps.newHashMap();
    private static final List<String> cleanupTables = new LinkedList<String>();
    public static final Comparator<String> STRING_CMP_W_NULL = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            return o1.compareTo(o2);
        }
    };

    public static OjaiDriver getDriver() {
        return OJAI_DRIVER;
    }

    public static OjaiConnection getConnection() {
        Document connectionOptions = OjaiTest.getDriver().newDocument();
        String maprHome = System.getenv("MAPR_HOME");
        if (maprHome == null) {
            maprHome = "/opt/mapr";
        }
        connectionOptions.set("mapr.client.conf_file", maprHome + "/conf/mapr-clusters.conf");
        Connection connection = OjaiTest.getDriver().connect("ojai:mapr:", connectionOptions);
        assert (connection instanceof OjaiConnection);
        return (OjaiConnection)connection;
    }

    public static List<Document> collectStreamingFind(DocumentStore docStore, Query query, int timeoutSeconds, DocumentStreamRef docStreamRef) throws Exception {
        LinkedList<Document> docList = new LinkedList<Document>();
        Semaphore doneSem = new Semaphore(0);
        CollectingDocumentListener cdl = new CollectingDocumentListener(docList, doneSem);
        try (DocumentStream docStream = docStore.findQuery(query);){
            if (docStreamRef != null) {
                docStreamRef.docStream = docStream;
            }
            docStream.streamTo((DocumentListener)cdl);
            try {
                doneSem.tryAcquire(1, timeoutSeconds, TimeUnit.SECONDS);
            }
            catch (InterruptedException ex) {
                System.out.println("timeout (" + timeoutSeconds + ") exceeded, cancelling");
                docStream.close();
            }
        }
        Exception ex = cdl.getException();
        if (ex != null) {
            throw ex;
        }
        return docList;
    }

    public static OjaiQueryProperties getQueryProperties(DocumentStream docStream) {
        if (docStream instanceof OjaiQueryProperties) {
            return (OjaiQueryProperties)docStream;
        }
        return null;
    }

    public static List<Map<String, Object>> getQueryPlan(DocumentStream docStream) {
        Preconditions.checkArgument((boolean)(docStream instanceof OjaiQueryProperties));
        OjaiQueryProperties queryProperties = (OjaiQueryProperties)docStream;
        LinkedList<Map<String, Object>> planList = new LinkedList<Map<String, Object>>();
        queryProperties.getQueryPlan(planList);
        return planList;
    }

    public static String getQueryPlanString(DocumentStream docStream) {
        List<Map<String, Object>> queryPlan = OjaiTest.getQueryPlan(docStream);
        String planString = OjaiDocumentStore.queryPlanToString(queryPlan);
        return planString;
    }

    public static OjaiQueryProperties.QueryPath getQueryPath(DocumentStream docStream) {
        OjaiQueryProperties queryProperties = OjaiTest.getQueryProperties(docStream);
        if (queryProperties != null) {
            return queryProperties.getQueryPath();
        }
        return null;
    }

    public static String getIndexUsed(DocumentStream docStream) {
        OjaiQueryProperties queryProperties = OjaiTest.getQueryProperties(docStream);
        if (queryProperties != null) {
            return queryProperties.getIndexUsed();
        }
        return null;
    }

    public static boolean isNearlyEqual(Document fetchedDoc, Document originalDoc) {
        Map originalMap = originalDoc.asMap();
        Map fetchedMap = fetchedDoc.asMap();
        return OjaiTest.isNearlyEqual(fetchedMap, originalMap);
    }

    public static boolean isNearlyEqual(Map<String, Object> fetchedMap, Map<String, Object> originalMap) {
        HashSet<String> originalFields = new HashSet<String>();
        Set<Map.Entry<String, Object>> originalSet = originalMap.entrySet();
        for (Map.Entry<String, Object> originalEntry : originalSet) {
            String fieldName = originalEntry.getKey();
            Object originalObject = originalEntry.getValue();
            Object fetchedObject = fetchedMap.get(fieldName);
            if (fetchedObject == null) {
                return false;
            }
            if (originalObject instanceof Document) {
                if (!OjaiTest.isNearlyEqual((Document)originalObject, (Document)fetchedObject)) {
                    return false;
                }
            } else if (originalObject instanceof Map) {
                if (!OjaiTest.isNearlyEqual((Map)fetchedObject, (Map)originalObject)) {
                    return false;
                }
            } else if (!fetchedObject.equals(originalObject)) {
                System.out.println("isNearlyEqual false for fetchedObject " + fetchedObject + " originalObject " + originalObject + " type " + fetchedObject.getClass().getName());
                return false;
            }
            originalFields.add(fieldName);
        }
        Set<Map.Entry<String, Object>> fetchedSet = fetchedMap.entrySet();
        for (Map.Entry<String, Object> fetchedEntry : fetchedSet) {
            Object v;
            String fieldName = fetchedEntry.getKey();
            if (originalFields.contains(fieldName) || fieldName.equals("_id") || (v = fetchedEntry.getValue()) == null || !(v instanceof List ? ((List)v).size() != 0 : v instanceof Map && ((Map)v).size() != 0)) continue;
            return false;
        }
        return true;
    }

    public static void assertEncodedFields(String sql, String ... fields) {
        String[] encodedMatches;
        Matcher matcher = ENCODED_FIELD_MATCHER.matcher(sql);
        Assert.assertTrue((boolean)matcher.find());
        HashSet<String> fieldSet = new HashSet<String>(fields.length);
        for (String string : fields) {
            fieldSet.add(string);
        }
        LinkedList<String> encodedPathList = new LinkedList<String>();
        String encodedGroup = matcher.group(1);
        Assert.assertNotNull((Object)encodedGroup);
        for (String encodedMatch : encodedMatches = encodedGroup.split(",")) {
            String string = encodedMatch.substring(encodedMatch.indexOf(46) + 2, encodedMatch.length() - 1);
            encodedPathList.add(string);
        }
        Assert.assertTrue((boolean)encodedPathList.remove("$$document"));
        String[] stringArray = new String[encodedPathList.size()];
        encodedPathList.toArray(stringArray);
        String[] decodedPaths = EncodedSchemaPathSet.decode((String[])stringArray);
        HashSet<String> projectionSet = new HashSet<String>(decodedPaths.length);
        for (String decodedPath : decodedPaths) {
            projectionSet.add(decodedPath);
        }
        for (String string : fieldSet) {
            Assert.assertTrue((String)("SQL string is missing " + string), (boolean)projectionSet.contains(string));
        }
        for (String string : projectionSet) {
            Assert.assertTrue((String)("SQL string has extra field " + string), (boolean)fieldSet.contains(string));
        }
    }

    public static void assertIdString(Document doc, String theId, boolean expectId) {
        Assert.assertNotNull((Object)doc);
        if (theId == null) {
            Assert.assertNotNull((Object)doc.getId());
        } else {
            String id = doc.getIdString();
            Assert.assertEquals((Object)theId, (Object)id);
        }
        String docString = doc.toString();
        Assert.assertEquals((Object)expectId, (Object)docString.contains("\"_id\":"));
    }

    protected static String getTablePath(String tableName) {
        return tablesPath_.get(tableName);
    }

    protected static void createTableAndLoad(String tableName) throws IOException {
        OjaiTest.createTableAndLoad(tableName, null);
    }

    protected static void createTableAndLoad(String tableName, Map<String, String> cfPath) throws IOException {
        Preconditions.checkState((!tables_.containsKey(tableName) ? 1 : 0) != 0, (Object)String.format("A table by name %s is already created by another test.", tableName));
        Table table = cfPath == null ? DBTests.createOrReplaceTable((String)tableName) : DBTests.createOrReplaceTable((String)tableName, cfPath);
        tables_.put(tableName, table);
        String tablePath = DBTests.getTablePath((String)tableName).toString();
        tablesPath_.put(tableName, tablePath);
        String jsonFileURL = BASE_RESOURCE_PATH + tableName + ".json";
        try (InputStream in = TestProjectionPassthrough.class.getResourceAsStream(jsonFileURL);
             DocumentStream stream = Json.newDocumentStream((InputStream)in);){
            table.insertOrReplace(stream);
            table.flush();
        }
    }

    protected static void closeAndDeleteTable(String tableName) throws IOException {
        Table table = tables_.get(tableName);
        if (table != null) {
            tables_.remove(tableName).close();
            DBTests.deleteTables((String[])new String[]{tableName});
        }
    }

    public static void assertQueryPath(DocumentStream docStream, OjaiQueryProperties.QueryPath queryPath) {
        Assert.assertTrue((boolean)(docStream instanceof OjaiQueryProperties));
        OjaiQueryProperties oqp = (OjaiQueryProperties)docStream;
        Assert.assertEquals((Object)queryPath, (Object)oqp.getQueryPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addCleanupTable(String tableName) {
        List<String> list = cleanupTables;
        synchronized (list) {
            cleanupTables.add(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterClass
    public static void cleanup() throws IOException {
        List<String> list = cleanupTables;
        synchronized (list) {
            for (String tableName : cleanupTables) {
                DBTests.deleteTables((String[])new String[]{tableName});
            }
            cleanupTables.clear();
        }
    }

    public static class DocumentStreamRef {
        public DocumentStream docStream;
    }
}

