/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.mapr.ojai.store.impl.AsynchronousStreamTo;
import com.mapr.ojai.store.impl.DocumentStreamFactory;
import com.mapr.ojai.store.impl.QueryDocumentStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.ojai.Document;
import org.ojai.DocumentListener;
import org.ojai.DocumentStream;

public class UnionDocumentStream
extends QueryDocumentStream {
    private DocumentStream currentStream;
    private DocumentListener userListener;
    private final ExecutorService executorService;
    private final DocumentStreamFactory streamFactory;
    private final UnionListener unionListener = new UnionListener();

    public UnionDocumentStream(ExecutorService executorService, DocumentStreamFactory streamFactory) {
        this.executorService = executorService;
        this.streamFactory = streamFactory;
    }

    private void nextStream() {
        this.currentStream = this.streamFactory.create();
        if (this.currentStream == null) {
            this.userListener.eos();
            return;
        }
        this.executorService.execute(new AsynchronousStreamTo(this.unionListener, this.currentStream));
    }

    @Override
    protected void submitQuery(DocumentListener docListener) {
        this.userListener = docListener;
        this.nextStream();
    }

    @Override
    protected void cancelQuery() {
        if (this.currentStream != null) {
            this.currentStream.close();
        }
    }

    @Override
    public String getIndexUsed() {
        return null;
    }

    @Override
    public void getQueryPlan(List<Map<String, Object>> planList) {
        HashMap<String, Object> myMap = new HashMap<String, Object>();
        myMap.put("streamName", this.getClass().getSimpleName());
        HashMap valueMap = new HashMap();
        myMap.put("parameters", valueMap);
        planList.add(myMap);
    }

    private class UnionListener
    implements DocumentListener {
        private UnionListener() {
        }

        public boolean documentArrived(Document doc) {
            return UnionDocumentStream.this.userListener.documentArrived(doc);
        }

        public void eos() {
            UnionDocumentStream.this.currentStream.close();
            UnionDocumentStream.this.nextStream();
        }

        public void failed(Exception ex) {
            UnionDocumentStream.this.userListener.failed(ex);
        }
    }
}

