/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.google.common.base.Preconditions;
import com.mapr.db.impl.OjaiQueryProperties;
import com.mapr.ojai.store.impl.AbstractDocumentFilter;
import com.mapr.ojai.store.impl.DocumentListenerToIterator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import org.ojai.Document;
import org.ojai.DocumentListener;
import org.ojai.DocumentStream;
import org.ojai.exceptions.QueryTimeoutException;

public class TimeoutDocumentFilter
extends AbstractDocumentFilter {
    private static final Timer timer = new Timer("TimeoutDocumentFilter", true);
    private final DocumentStream upstreamStream;
    private final long timeoutMs;
    private volatile TimeoutTask timeoutTask;
    private volatile DocumentListener docListener;
    private static final NullListener NULL_LISTENER = new NullListener();

    public TimeoutDocumentFilter(DocumentStream upstreamStream, ExecutorService executorService, long timeoutMs) {
        super(upstreamStream, executorService);
        this.upstreamStream = upstreamStream;
        this.timeoutMs = timeoutMs;
    }

    void cancelTimer() {
        this.timeoutTask.cancel();
    }

    void startTimer() {
        this.timeoutTask = new TimeoutTask();
        timer.schedule((TimerTask)this.timeoutTask, this.timeoutMs);
    }

    private void streamTo(DocumentListener wrapperListener, DocumentListener userListener) {
        Preconditions.checkArgument((userListener != null ? 1 : 0) != 0);
        Preconditions.checkState((this.timeoutTask == null ? 1 : 0) != 0);
        Preconditions.checkState((this.docListener == null ? 1 : 0) != 0);
        this.docListener = userListener;
        this.timeoutTask = new TimeoutTask();
        timer.schedule((TimerTask)this.timeoutTask, this.timeoutMs);
        super.streamTo(wrapperListener);
    }

    @Override
    public void streamTo(DocumentListener docListener) {
        this.streamTo(new TimedWrapper(), docListener);
    }

    @Override
    public Iterator<Document> iterator() {
        this.checkState();
        this.dlti = new DocumentListenerToIterator(this);
        this.streamTo(new PassthroughWrapper(), this.dlti);
        return this.dlti;
    }

    public void getQueryPlan(List<Map<String, Object>> planList) {
        if (this.upstreamStream == null) {
            return;
        }
        ((OjaiQueryProperties)this.upstreamStream).getQueryPlan(planList);
        HashMap<String, Object> myMap = new HashMap<String, Object>();
        myMap.put("streamName", this.getClass().getSimpleName());
        HashMap<String, Long> valueMap = new HashMap<String, Long>();
        valueMap.put("timeoutMs", this.timeoutMs);
        myMap.put("parameters", valueMap);
        planList.add(myMap);
    }

    private class PassthroughWrapper
    implements DocumentListener {
        private PassthroughWrapper() {
        }

        public boolean documentArrived(Document doc) {
            return TimeoutDocumentFilter.this.docListener.documentArrived(doc);
        }

        public void eos() {
            TimeoutDocumentFilter.this.docListener.eos();
        }

        public void failed(Exception ex) {
            TimeoutDocumentFilter.this.docListener.failed(ex);
        }
    }

    private class TimedWrapper
    implements DocumentListener {
        private TimedWrapper() {
        }

        public boolean documentArrived(Document doc) {
            TimeoutDocumentFilter.this.cancelTimer();
            boolean rv = TimeoutDocumentFilter.this.docListener.documentArrived(doc);
            TimeoutDocumentFilter.this.startTimer();
            return rv;
        }

        public void eos() {
            TimeoutDocumentFilter.this.timeoutTask.cancel();
            TimeoutDocumentFilter.this.docListener.eos();
        }

        public void failed(Exception ex) {
            TimeoutDocumentFilter.this.timeoutTask.cancel();
            TimeoutDocumentFilter.this.docListener.failed(ex);
        }
    }

    private class TimeoutTask
    extends TimerTask {
        private TimeoutTask() {
        }

        @Override
        public void run() {
            DocumentListener userListener = TimeoutDocumentFilter.this.docListener;
            TimeoutDocumentFilter.this.docListener = NULL_LISTENER;
            TimeoutDocumentFilter.this.executorService.execute(new UpstreamCloser());
            userListener.failed((Exception)new QueryTimeoutException("Query exceeded timeout (" + TimeoutDocumentFilter.this.timeoutMs + ")"));
        }
    }

    private class UpstreamCloser
    implements Runnable {
        private UpstreamCloser() {
        }

        @Override
        public void run() {
            TimeoutDocumentFilter.this.upstreamStream.close();
        }
    }

    private static class NullListener
    implements DocumentListener {
        private NullListener() {
        }

        public boolean documentArrived(Document doc) {
            return false;
        }

        public void eos() {
        }

        public void failed(Exception ex) {
        }
    }
}

