/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.mapr.db.impl.BaseJsonTable;
import com.mapr.fs.proto.Dbserver;
import com.mapr.ojai.store.impl.SharedResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedTable
extends SharedResource<BaseJsonTable> {
    private static final Logger logger = LoggerFactory.getLogger(SharedTable.class);

    public SharedTable(BaseJsonTable jsonTable) {
        super(jsonTable);
        if (!jsonTable.isIndex()) {
            logger.debug("shareTable " + jsonTable.getName() + " fid " + jsonTable.getFidStr());
        } else {
            Dbserver.SIndexInfo indexInfo = jsonTable.getIndexInfo();
            logger.debug("shareIndex " + indexInfo.getIndexName() + " fid " + jsonTable.getFidStr() + " table " + jsonTable.getName());
        }
    }

    @Override
    protected void preCloseAction(BaseJsonTable jsonTable) {
        if (!jsonTable.isIndex()) {
            logger.debug("closeTable " + jsonTable.getName() + " fid " + jsonTable.getFidStr());
        } else {
            Dbserver.SIndexInfo indexInfo = jsonTable.getIndexInfo();
            logger.debug("closeIndex " + indexInfo.getIndexName() + " fid " + jsonTable.getFidStr() + " table " + jsonTable.getName());
        }
    }
}

