/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.mapr.db.impl.BaseJsonTable;
import com.mapr.db.impl.IdCodec;
import com.mapr.db.impl.MultiGet;
import com.mapr.db.impl.OjaiQueryProperties;
import com.mapr.ojai.store.impl.AbstractDocumentFilter;
import com.mapr.ojai.store.impl.SharedTable;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.FieldPath;
import org.ojai.Value;
import org.ojai.store.QueryCondition;

public class RowkeyLookup
extends AbstractDocumentFilter {
    private final MultiGet multiGet;
    private static final int BATCH_SIZE = 50;
    private final ByteBuffer[] batchId = new ByteBuffer[50];
    private int batchIdx = 0;
    private boolean keepListening = true;
    private final SharedTable sharedTable;
    private final String priTablePath;
    private final QueryCondition condition;
    private final FieldPath[] projList;

    public RowkeyLookup(DocumentStream upstreamStream, ExecutorService executorService, SharedTable sharedTable, QueryCondition queryCond, FieldPath ... fieldPaths) {
        super(upstreamStream, executorService);
        String[] fieldStrings;
        this.sharedTable = sharedTable;
        sharedTable.addRef();
        if (fieldPaths == null) {
            fieldStrings = null;
        } else {
            fieldStrings = new String[fieldPaths.length];
            int nextIdx = 0;
            for (FieldPath fieldPath : fieldPaths) {
                fieldStrings[nextIdx] = fieldPath.toString();
                ++nextIdx;
            }
        }
        BaseJsonTable jsonTable = (BaseJsonTable)sharedTable.get();
        this.priTablePath = jsonTable.getPath().toString();
        this.condition = queryCond;
        this.projList = fieldPaths;
        this.multiGet = new MultiGet(jsonTable, queryCond, jsonTable.isExcludeId(), fieldStrings);
    }

    private boolean processBatch() {
        List docList = this.multiGet.doGet(this.batchId, this.batchIdx);
        this.batchIdx = 0;
        for (Document doc : docList) {
            if (super.documentArrived(doc)) continue;
            this.keepListening = false;
            break;
        }
        return this.keepListening;
    }

    private boolean idArrived(Value idValue) {
        ByteBuffer idBuffer;
        Value.Type idType = idValue.getType();
        if (idType == Value.Type.BINARY) {
            idBuffer = idValue.getBinary();
        } else if (idType == Value.Type.STRING) {
            String idString = idValue.getString();
            idBuffer = IdCodec.encode((String)idString);
        } else {
            throw new IllegalArgumentException("_id values can only be BINARY or STRING");
        }
        return this.idArrived(idBuffer);
    }

    public boolean idArrived(ByteBuffer idBuffer) {
        if (!this.keepListening) {
            return false;
        }
        this.batchId[this.batchIdx] = idBuffer;
        ++this.batchIdx;
        if (this.batchIdx == 50) {
            this.keepListening = this.processBatch();
        }
        return this.keepListening;
    }

    @Override
    public boolean documentArrived(Document doc) {
        Value idValue = doc.getId();
        return this.idArrived(idValue);
    }

    @Override
    public void eos() {
        this.processBatch();
        super.eos();
    }

    @Override
    protected void closeDerived() {
        this.sharedTable.release();
        super.closeDerived();
    }

    public void getQueryPlan(List<Map<String, Object>> planList) {
        if (this.upstreamStream == null) {
            return;
        }
        ((OjaiQueryProperties)this.upstreamStream).getQueryPlan(planList);
        HashMap<String, Object> myMap = new HashMap<String, Object>();
        myMap.put("streamName", this.getClass().getSimpleName());
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        valueMap.put("primaryTable", this.priTablePath);
        valueMap.put("queryCondition", this.condition);
        valueMap.put("projection", this.projList);
        myMap.put("parameters", valueMap);
        planList.add(myMap);
    }
}

