/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.google.common.collect.ImmutableMap;
import com.mapr.ojai.store.impl.Expression;
import com.mapr.ojai.store.impl.ExpressionVisitor;
import com.mapr.ojai.store.impl.FieldExpression;
import com.mapr.ojai.store.impl.LiteralExpression;
import com.mapr.ojai.store.impl.NaryOperator;
import com.mapr.ojai.store.impl.UnaryOperator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ojai.FieldPath;
import org.ojai.store.QueryCondition;

public class RelationalOperator
extends NaryOperator {
    private static final ImmutableMap<String, QueryCondition.Op> QUERY_CONDITIONS;
    private static final ImmutableMap<String, String> UNOP_TO_SQL;

    public RelationalOperator(String opName, List<Expression> arg) {
        super(opName, arg);
    }

    @Override
    public void gatherExpressions(int depth, Map<FieldPath, List<NaryOperator>> topRelations, Set<Expression> otherPredicates) {
        if (depth == 0) {
            this.addTopRelation(topRelations, this.getLeftField(), this);
        } else {
            otherPredicates.add(this);
        }
    }

    @Override
    public void emitSql(StringBuilder sb, String tableAlias) {
        if (!(this.arg[0] instanceof UnaryOperator)) {
            super.emitSql(sb, tableAlias);
            return;
        }
        UnaryOperator unOp = (UnaryOperator)this.arg[0];
        String sqlOp = (String)UNOP_TO_SQL.get((Object)unOp.opName);
        if (sqlOp == null) {
            super.emitSql(sb, tableAlias);
            return;
        }
        if (sqlOp.equals("ojai_sizeof")) {
            sb.append("ojai_sizeof(");
            unOp.getOperand().emitSql(sb, tableAlias);
            sb.append(",'");
            sb.append(this.opName);
            sb.append('\'');
        } else {
            if (sqlOp.equals("ojai_typeof") && this.opName.equals("<>")) {
                sb.append("ojai_nottypeof");
            } else {
                sb.append(sqlOp);
            }
            sb.append('(');
            unOp.getOperand().emitSql(sb, tableAlias);
        }
        sb.append(",");
        this.getRightLiteral().emitSql(sb, tableAlias);
        sb.append(')');
    }

    public FieldPath getLeftField() {
        Expression expr = this.arg[0];
        if (expr instanceof UnaryOperator) {
            return ((FieldExpression)((UnaryOperator)expr).getOperand()).getFieldPath();
        }
        return ((FieldExpression)expr).getFieldPath();
    }

    public LiteralExpression getRightLiteral() {
        return (LiteralExpression)this.arg[1];
    }

    @Override
    public void visit(ExpressionVisitor ev) {
        ev.visitRelational(this);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        QUERY_CONDITIONS = builder.put((Object)"=", (Object)QueryCondition.Op.EQUAL).put((Object)"<>", (Object)QueryCondition.Op.NOT_EQUAL).put((Object)"<", (Object)QueryCondition.Op.LESS).put((Object)"<=", (Object)QueryCondition.Op.LESS_OR_EQUAL).put((Object)">", (Object)QueryCondition.Op.GREATER).put((Object)">=", (Object)QueryCondition.Op.GREATER_OR_EQUAL).build();
        builder = ImmutableMap.builder();
        UNOP_TO_SQL = builder.put((Object)"sizeOf", (Object)"ojai_sizeof").put((Object)"typeOf", (Object)"ojai_typeof").build();
    }
}

