/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mapr.db.util.ConditionParser;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.ojai.exceptions.DecodingException;
import org.ojai.store.DriverManager;
import org.ojai.store.Query;
import org.ojai.store.SortOrder;

public class QueryParser {
    private Query query = DriverManager.getDriver((String)"ojai:mapr:").newQuery();
    boolean isWhere;
    boolean isSelect;

    public Query parseQuery(String jsonQuery) {
        this.isWhere = false;
        this.isSelect = false;
        Map queryMap = null;
        try {
            queryMap = (Map)new ObjectMapper().readValue(jsonQuery, (TypeReference)new TypeReference<Map<String, JsonNode>>(){});
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Iterator iterator = queryMap.keySet().iterator();
        while (iterator.hasNext()) {
            String op;
            switch (op = (String)iterator.next()) {
                case "$where": {
                    if (this.isWhere) {
                        throw new IllegalArgumentException("$where already given");
                    }
                    this.isWhere = true;
                    ConditionParser cp = new ConditionParser();
                    this.query.where(cp.parseCondition(((JsonNode)queryMap.get(op)).toString()));
                    break;
                }
                case "$select": {
                    if (this.isSelect) {
                        throw new IllegalArgumentException("$select already given");
                    }
                    this.isSelect = true;
                    String proj = ((JsonNode)queryMap.get(op)).toString();
                    if (proj.startsWith("[") && proj.endsWith("]")) {
                        String[] projList = proj.substring(1, proj.length() - 1).split(",");
                        for (int i = 0; i < projList.length; ++i) {
                            projList[i] = projList[i].substring(1, projList[i].length() - 1);
                        }
                        this.query.select(projList);
                        break;
                    }
                    this.query.select(new String[]{proj.substring(1, proj.length() - 1)});
                    break;
                }
                case "$orderby": {
                    String orders = ((JsonNode)queryMap.get(op)).toString();
                    if (orders.startsWith("[") && orders.endsWith("]")) {
                        String[] orderList = orders.substring(1, orders.length() - 1).split(",");
                        for (int i = 0; i < orderList.length; ++i) {
                            orderList[i] = orderList[i].substring(1, orderList[i].length() - 1);
                        }
                        if (orderList.length == 1) {
                            this.query.orderBy(new String[]{orderList[0]});
                            break;
                        }
                        if (orderList[orderList.length - 1].startsWith("$")) {
                            if (orderList[orderList.length - 1].substring(1).equals("ASC")) {
                                this.query.orderBy(orderList[0], SortOrder.ASC);
                                break;
                            }
                            if (orderList[orderList.length - 1].substring(1).equals("DESC")) {
                                this.query.orderBy(orderList[0], SortOrder.DESC);
                                break;
                            }
                            throw new IllegalArgumentException("wrong orderby sort order format");
                        }
                        this.query.orderBy(orderList);
                        break;
                    }
                    this.query.orderBy(new String[]{orders.substring(1, orders.length() - 1)});
                    break;
                }
                case "$offset": {
                    this.query.offset((long)Integer.parseInt(((JsonNode)queryMap.get(op)).toString()));
                    break;
                }
                case "$limit": {
                    this.query.limit((long)Integer.parseInt(((JsonNode)queryMap.get(op)).toString()));
                    break;
                }
                default: {
                    throw new DecodingException("Invalid Query Parameter");
                }
            }
        }
        return this.query.build();
    }
}

