/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.mapr.db.impl.ConditionVisitor;
import com.mapr.ojai.store.impl.OjaiQuery;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.drill.common.JSONOptions;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.expression.FunctionCallFactory;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.NullExpression;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.expression.ValueExpressions;
import org.apache.drill.common.logical.LogicalPlan;
import org.apache.drill.common.logical.LogicalPlanBuilder;
import org.apache.drill.common.logical.data.Filter;
import org.apache.drill.common.logical.data.LogicalOperator;
import org.apache.drill.common.logical.data.NamedExpression;
import org.apache.drill.common.logical.data.Project;
import org.apache.drill.common.logical.data.Scan;
import org.ojai.FieldPath;
import org.ojai.FieldSegment;
import org.ojai.store.QueryCondition;
import org.ojai.types.ODate;
import org.ojai.types.OInterval;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;

class PlanBuilder
implements ConditionVisitor {
    private final LinkedList<LogicalExpression> exprStack = new LinkedList();

    PlanBuilder() {
    }

    public LogicalPlan build(Set<FieldPath> projectedFieldSet) {
        if (this.exprStack.size() > 1) {
            throw new IllegalStateException("Attempt to build plan when number of expressions > 1");
        }
        LogicalPlanBuilder logicalPlanBuilder = new LogicalPlanBuilder();
        Scan scan = new Scan("maprdb", new JSONOptions(null));
        if (projectedFieldSet.size() == 0) {
            throw new RuntimeException("unimplemented");
        }
        LinkedList<NamedExpression> namedExprList = new LinkedList<NamedExpression>();
        for (FieldPath fieldPath : projectedFieldSet) {
            int nSegments = 0;
            for (FieldSegment fieldSegment : fieldPath) {
                ++nSegments;
            }
            String[] segment = new String[nSegments];
            int iSegment = 0;
            for (FieldSegment fieldSegment : fieldPath) {
                segment[iSegment++] = fieldSegment.asPathString(false);
            }
            SchemaPath schemaPath = SchemaPath.getCompoundPath((String[])segment);
            NamedExpression namedExpression = new NamedExpression((LogicalExpression)new FieldReference(schemaPath), null);
            namedExprList.add(namedExpression);
        }
        Project project = new Project(namedExprList);
        logicalPlanBuilder.addLogicalOperator((LogicalOperator)project);
        if (this.exprStack.size() == 1) {
            Filter filter = new Filter(this.exprStack.peek());
            logicalPlanBuilder.addLogicalOperator((LogicalOperator)filter);
        }
        logicalPlanBuilder.addLogicalOperator((LogicalOperator)scan);
        LogicalPlan logicalPlan = logicalPlanBuilder.build();
        return logicalPlan;
    }

    public void operator(QueryCondition.Op op, int nOperands) {
        this.operator((String)OjaiQuery.OP_TO_NAME.get((Object)op), nOperands);
    }

    public void operator(String name, int nOperands) {
        if (nOperands < this.exprStack.size()) {
            throw new IllegalStateException("Attempt to pop more operands than are on the stack");
        }
        LinkedList<LogicalExpression> operandList = new LinkedList<LogicalExpression>();
        for (int i = 0; i < nOperands; ++i) {
            operandList.addFirst(this.exprStack.pop());
        }
        LogicalExpression logicalExpression = FunctionCallFactory.createExpression((String)name, operandList);
        this.exprStack.push(logicalExpression);
    }

    public void field(FieldPath fieldPath) {
        this.exprStack.push((LogicalExpression)new FieldReference((CharSequence)fieldPath.asPathString()));
    }

    public void binaryLiteral(ByteBuffer value) {
        throw new RuntimeException("unimplemented");
    }

    public void booleanLiteral(boolean value) {
        this.exprStack.push(ValueExpressions.getBit((boolean)value));
    }

    public void byteLiteral(byte value) {
        this.exprStack.push(ValueExpressions.getInt((int)value));
    }

    public void dateLiteral(ODate value) {
        this.exprStack.push(ValueExpressions.getDate((GregorianCalendar)new GregorianCalendar(value.getYear(), value.getMonth(), value.getDayOfMonth())));
    }

    public void decimalLiteral(BigDecimal value) {
        throw new RuntimeException("unimplemented");
    }

    public void doubleLiteral(double value) {
        this.exprStack.push(ValueExpressions.getFloat8((double)value));
    }

    public void floatLiteral(float value) {
        this.exprStack.push(ValueExpressions.getFloat4((float)value));
    }

    public void intLiteral(int value) {
        this.exprStack.push(ValueExpressions.getInt((int)value));
    }

    public void intervalLiteral(OInterval value) {
        this.exprStack.push(ValueExpressions.getIntervalDay((long)value.getTimeInMillis()));
    }

    public void longLiteral(long value) {
        this.exprStack.push(ValueExpressions.getBigInt((long)value));
    }

    public void mapLiteral(Map<String, Object> value) {
        throw new RuntimeException("unimplemented");
    }

    public void nullLiteral() {
        this.exprStack.push((LogicalExpression)new NullExpression());
    }

    public void shortLiteral(short value) {
        this.exprStack.push(ValueExpressions.getInt((int)value));
    }

    public void stringLiteral(String value) {
        this.exprStack.push(ValueExpressions.getChar((String)value));
    }

    public void timeLiteral(OTime value) {
        this.exprStack.push((LogicalExpression)new ValueExpressions.TimeExpression(value.toTimeInMillis()));
    }

    public void timestampLiteral(OTimestamp value) {
        this.exprStack.push(ValueExpressions.getTimeStamp((GregorianCalendar)new GregorianCalendar(value.getYear(), value.getMonth(), value.getDayOfMonth(), value.getHour(), value.getMinute(), value.getSecond())));
    }
}

