/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.mapr.db.Admin;
import com.mapr.db.impl.BaseJsonTable;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.ConditionVisitor;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.impl.index.IndexFieldDescImpl;
import com.mapr.db.index.IndexDesc;
import com.mapr.db.index.IndexFieldDesc;
import com.mapr.db.rowcol.DBValueBuilderImpl;
import com.mapr.db.util.ConditionParser;
import com.mapr.ojai.store.impl.AbstractDocumentStream;
import com.mapr.ojai.store.impl.CommitWaitStream;
import com.mapr.ojai.store.impl.DrillDocumentStream;
import com.mapr.ojai.store.impl.DrillPostludeFilter;
import com.mapr.ojai.store.impl.DrillPreludeFilter;
import com.mapr.ojai.store.impl.EligibleIndex;
import com.mapr.ojai.store.impl.Expression;
import com.mapr.ojai.store.impl.ExpressionToCondition;
import com.mapr.ojai.store.impl.ExpressionVisitor;
import com.mapr.ojai.store.impl.FieldExpression;
import com.mapr.ojai.store.impl.LimitStream;
import com.mapr.ojai.store.impl.LiteralExpression;
import com.mapr.ojai.store.impl.NaryOperator;
import com.mapr.ojai.store.impl.OffsetStream;
import com.mapr.ojai.store.impl.OjaiConnection;
import com.mapr.ojai.store.impl.OjaiDocumentStore;
import com.mapr.ojai.store.impl.PlanBuilder;
import com.mapr.ojai.store.impl.QueryAnalyzer;
import com.mapr.ojai.store.impl.QueryContext;
import com.mapr.ojai.store.impl.QueryEquivalence;
import com.mapr.ojai.store.impl.SharedDrillSession;
import com.mapr.ojai.store.impl.SharedResource;
import com.mapr.ojai.store.impl.SharedTable;
import com.mapr.ojai.store.impl.SortKey;
import com.mapr.ojai.store.impl.TimeoutDocumentFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.drill.common.logical.LogicalPlan;
import org.apache.hadoop.fs.Path;
import org.ojai.Document;
import org.ojai.DocumentConstants;
import org.ojai.DocumentStream;
import org.ojai.FieldPath;
import org.ojai.FieldSegment;
import org.ojai.Value;
import org.ojai.exceptions.OjaiException;
import org.ojai.store.Query;
import org.ojai.store.QueryCondition;
import org.ojai.store.SortOrder;
import org.ojai.util.Fields;

public class OjaiQuery
implements Query {
    public static final String OPTION_FORCE_SORT = "ojai.mapr.query.force-noncovering-sort";
    public static final String OPTION_FORCE_DRILL = "ojai.mapr.force-drill";
    private Document options;
    private boolean possiblyNeedProjection = false;
    private boolean hasProjectionWithArrayIndex = false;
    private boolean isStarQuery = false;
    private final HashSet<FieldPath> projectedFieldSet = new HashSet();
    private boolean includeId = false;
    private ConditionImpl condition = MapRDBImpl.newCondition();
    public static final long LIMIT_NONE = -1L;
    private long limit = -1L;
    public static final long OFFSET_NONE = 0L;
    private long offset = 0L;
    private String commitContext;
    private static final FieldPath[] EMPTY_FIELD_PATH_ARRAY = new FieldPath[0];
    private List<SortKey> sortKeys;
    static final ImmutableMap<QueryCondition.Op, String> OP_TO_NAME;
    private QueryAnalyzer queryAnalyzer;
    public static final Equivalence<OjaiQuery> EQUIVALENCE;
    private static final int HASH_ROTATION = 5;
    private static final long INTEGER_MASK = 0xFFFFFFFFL;
    private static final int HASH_SEED = -256961641;
    private static final String DRILL_FORCE_SORT_NONCOVERING = "planner.index_force_sort_noncovering";
    private static final String FORCE_SORT_SQL = "alter session set `planner.index_force_sort_noncovering` = true";
    private static final String RESET_SORT_SQL = "alter session reset `planner.index_force_sort_noncovering`";
    private static final long TIMEOUT_NONE = -1L;
    private long timeout = -1L;
    private boolean built;

    public long getLimit() {
        return this.limit;
    }

    public long getOffset() {
        return this.offset;
    }

    public boolean hasCondition() {
        return !this.condition.isEmpty();
    }

    public ConditionImpl getCondition() {
        return this.condition;
    }

    public FieldPath[] getSelectListAsArray() {
        if (this.projectedFieldSet.size() == 0 || this.isStarQuery) {
            return null;
        }
        return this.projectedFieldSet.toArray(EMPTY_FIELD_PATH_ARRAY);
    }

    public OjaiQuery setOption(String optionName, Object value) throws IllegalArgumentException {
        this.checkNotBuilt();
        if (this.options == null) {
            this.options = MapRDBImpl.newDocument();
        }
        this.options.set(optionName, (Value)DBValueBuilderImpl.KeyValueBuilder.initFromObject(value));
        return this;
    }

    public Object getOption(String optionName) {
        return this.options == null ? null : this.options.getValue(optionName).getObject();
    }

    public OjaiQuery setOptions(Document options) throws IllegalArgumentException {
        this.checkNotBuilt();
        this.options = options;
        return this;
    }

    public Document getOptions() {
        return this.options;
    }

    public OjaiQuery select(String ... fieldPaths) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)fieldPaths);
        this.checkNotBuilt();
        this.select(Fields.toFieldPathArray((String[])fieldPaths));
        return this;
    }

    public OjaiQuery select(FieldPath ... fieldPaths) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)fieldPaths);
        this.checkNotBuilt();
        for (FieldPath fieldPath : fieldPaths) {
            if ("*".equals(fieldPath.getRootSegment().getNameSegment().getName())) {
                this.isStarQuery = true;
            } else if (!this.hasProjectionWithArrayIndex) {
                FieldSegment seg = fieldPath.getRootSegment();
                while ((seg = seg.getChild()) != null) {
                    if (!seg.isIndexed()) continue;
                    this.possiblyNeedProjection = true;
                    this.hasProjectionWithArrayIndex = true;
                    break;
                }
            }
            this.projectedFieldSet.add(fieldPath);
        }
        return this;
    }

    public OjaiQuery where(String conditionJson) throws OjaiException, IllegalArgumentException {
        this.checkNotBuilt();
        ConditionParser conditionParser = new ConditionParser();
        return this.where(conditionParser.parseCondition(conditionJson));
    }

    public OjaiQuery where(QueryCondition queryCond) throws OjaiException, IllegalArgumentException {
        this.checkNotBuilt();
        if (!queryCond.isEmpty()) {
            this.possiblyNeedProjection = true;
            if (this.condition.isEmpty()) {
                this.condition.condition(queryCond);
            } else {
                ConditionImpl previousCondition = this.condition;
                if (!previousCondition.isBuilt()) {
                    previousCondition.build();
                }
                this.condition = MapRDBImpl.newCondition().and().condition((QueryCondition)previousCondition).condition(queryCond).close();
            }
        }
        return this;
    }

    public OjaiQuery orderBy(String ... stringPaths) throws IllegalArgumentException {
        this.checkNotBuilt();
        Preconditions.checkArgument((stringPaths != null && stringPaths.length > 0 ? 1 : 0) != 0, (Object)"no sort keys specified");
        this.orderBy(Fields.toFieldPathArray((String[])stringPaths));
        return this;
    }

    public OjaiQuery orderBy(FieldPath ... fieldPaths) throws IllegalArgumentException {
        this.checkNotBuilt();
        Preconditions.checkArgument((fieldPaths != null && fieldPaths.length > 0 ? 1 : 0) != 0, (Object)"no sort keys specified");
        for (FieldPath fieldPath : fieldPaths) {
            this.orderBy(fieldPath, SortOrder.ASC);
        }
        return this;
    }

    public OjaiQuery orderBy(String field, String order) throws IllegalArgumentException {
        return this.orderBy(FieldPath.parseFrom((String)field), SortOrder.valueOf((String)order));
    }

    public OjaiQuery orderBy(String field, SortOrder order) throws IllegalArgumentException {
        return this.orderBy(FieldPath.parseFrom((String)field), order);
    }

    public OjaiQuery orderBy(FieldPath fieldPath, SortOrder sortOrder) throws IllegalArgumentException {
        this.checkNotBuilt();
        Preconditions.checkArgument((fieldPath != null ? 1 : 0) != 0, (Object)"fieldPath must be non-null");
        Preconditions.checkArgument((sortOrder != null ? 1 : 0) != 0, (Object)"sortOrder must be non-null");
        if (this.sortKeys == null) {
            this.sortKeys = new LinkedList<SortKey>();
        }
        this.possiblyNeedProjection = true;
        this.sortKeys.add(new SortKey(fieldPath, sortOrder));
        return this;
    }

    public OjaiQuery offset(long offset) throws IllegalArgumentException {
        this.checkNotBuilt();
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (Object)"offset must be non-negative");
        this.offset = offset;
        return this;
    }

    public OjaiQuery limit(long limit) throws IllegalArgumentException {
        this.checkNotBuilt();
        Preconditions.checkArgument((limit >= 0L ? 1 : 0) != 0, (Object)"limit must be non-negative");
        this.limit = limit;
        return this;
    }

    QueryAnalyzer getQueryAnalyzer() {
        if (this.queryAnalyzer == null) {
            this.queryAnalyzer = new QueryAnalyzer();
            this.condition.visit((ConditionVisitor)this.queryAnalyzer);
        }
        return this.queryAnalyzer;
    }

    public String buildSqlString(String engineName, String tableName) {
        QueryAnalyzer queryAnalyzer = this.getQueryAnalyzer();
        return queryAnalyzer.buildSql(this.projectedFieldSet, engineName, tableName, this.sortKeys, this.offset, this.limit);
    }

    public boolean isIdIn() {
        QueryAnalyzer queryAnalyzer = this.getQueryAnalyzer();
        if (!queryAnalyzer.isUnion()) {
            return false;
        }
        Set<Expression> otherPredicates = queryAnalyzer.getOtherPredicates();
        if (otherPredicates.size() > 0) {
            return false;
        }
        Map<FieldPath, List<NaryOperator>> topRelations = queryAnalyzer.getTopRelations();
        if (topRelations.size() != 1) {
            return false;
        }
        List<NaryOperator> relOps = topRelations.get(DocumentConstants.ID_FIELD);
        if (relOps == null) {
            return false;
        }
        int notEquality = 0;
        for (NaryOperator relOp : relOps) {
            String opName = relOp.opName;
            if (opName.equals("=") || opName.equals("in")) continue;
            ++notEquality;
        }
        return notEquality <= 0;
    }

    public LogicalPlan buildLogicalPlan() {
        PlanBuilder planBuilder = new PlanBuilder();
        this.condition.visit((ConditionVisitor)planBuilder);
        return planBuilder.build(this.projectedFieldSet);
    }

    public boolean structuralEquals(OjaiQuery otherQuery) {
        if (this.limit == -1L != (otherQuery.limit == -1L)) {
            return false;
        }
        if (this.offset == 0L != (otherQuery.offset == 0L)) {
            return false;
        }
        if (this.projectedFieldSet.size() != otherQuery.projectedFieldSet.size()) {
            return false;
        }
        Iterator<FieldPath> otherIter = otherQuery.projectedFieldSet.iterator();
        for (FieldPath fieldPath : this.projectedFieldSet) {
            FieldPath otherFieldPath;
            if (fieldPath.equals((Object)(otherFieldPath = otherIter.next()))) continue;
            return false;
        }
        if (this.options == null) {
            if (otherQuery.options != null) {
                return false;
            }
        } else {
            if (otherQuery.options == null) {
                return false;
            }
            if (!this.options.equals(otherQuery.options)) {
                return false;
            }
        }
        if (!this.getQueryAnalyzer().structuralEquals(otherQuery.getQueryAnalyzer())) {
            return false;
        }
        if (this.sortKeys == null && otherQuery.sortKeys != null && otherQuery.sortKeys.size() != 0) {
            return false;
        }
        if (this.sortKeys != null) {
            if (otherQuery.sortKeys == null || otherQuery.sortKeys.size() == 0) {
                return false;
            }
            if (this.sortKeys.size() != otherQuery.sortKeys.size()) {
                return false;
            }
            Iterator<SortKey> otherSortIter = otherQuery.sortKeys.iterator();
            for (SortKey sortKey : this.sortKeys) {
                SortKey otherKey = otherSortIter.next();
                if (!sortKey.fieldPath.equals((Object)otherKey.fieldPath)) {
                    return false;
                }
                if (sortKey.sortOrder == otherKey.sortOrder) continue;
                return false;
            }
        }
        return true;
    }

    private static int blendHash(int hash, int toBlend) {
        int rotatedHash = hash << 5 | hash >> 27;
        return rotatedHash ^ toBlend;
    }

    private static int blendHash(int hash, long toBlend) {
        int highBits = (int)(toBlend >> 32);
        hash = OjaiQuery.blendHash(hash, highBits);
        int lowBits = (int)(toBlend & 0xFFFFFFFFL);
        hash = OjaiQuery.blendHash(hash, lowBits);
        return hash;
    }

    public int structuralHashCode() {
        int hash = -256961641;
        hash = OjaiQuery.blendHash(hash, this.limit != -1L ? 7L : -1L);
        hash = OjaiQuery.blendHash(hash, this.offset != 0L ? 11L : 0L);
        for (FieldPath fieldPath : this.projectedFieldSet) {
            hash = OjaiQuery.blendHash(hash, fieldPath.hashCode());
        }
        if (this.options != null) {
            hash = OjaiQuery.blendHash(hash, this.options.hashCode());
        }
        hash = OjaiQuery.blendHash(hash, this.getQueryAnalyzer().structuralHashCode());
        if (this.sortKeys != null) {
            for (SortKey sortKey : this.sortKeys) {
                hash = OjaiQuery.blendHash(hash, sortKey.fieldPath.hashCode());
                hash = OjaiQuery.blendHash(hash, sortKey.sortOrder.hashCode());
            }
        }
        return hash;
    }

    private boolean isCoveringIndex(QueryAnalyzer queryAnalyzer, IndexDesc indexDesc) {
        if (this.projectedFieldSet == null || this.projectedFieldSet.size() == 0) {
            return false;
        }
        List indexedFields = indexDesc.getIndexedFields();
        Collection coveredFields = indexDesc.getCoveredFields();
        final HashMap<String, IndexFieldDesc> coveredMap = new HashMap<String, IndexFieldDesc>(indexedFields.size() + coveredFields.size());
        for (IndexFieldDesc ifd : indexedFields) {
            coveredMap.put(((IndexFieldDescImpl)ifd).getFieldPathStr(), ifd);
        }
        for (IndexFieldDesc ifd : coveredFields) {
            coveredMap.put(((IndexFieldDescImpl)ifd).getFieldPathStr(), ifd);
        }
        for (FieldPath fieldPath : this.projectedFieldSet) {
            String fieldPathString = fieldPath.asPathString();
            if (coveredMap.get(fieldPathString) != null || fieldPathString.equals("_id")) continue;
            return false;
        }
        final MutableBoolean isCovering = new MutableBoolean(true);
        queryAnalyzer.visit(new ExpressionVisitor(){

            @Override
            public void visitField(FieldExpression fieldExpression) {
                FieldPath fieldPath = fieldExpression.getFieldPath();
                if (!coveredMap.containsKey(fieldPath.asPathString())) {
                    isCovering.value = false;
                }
            }
        });
        return isCovering.value;
    }

    private boolean isSortKeyIndexEqualitySuffix(List<IndexFieldDesc> fieldDescriptors, Map<FieldPath, List<NaryOperator>> topFieldRelations) {
        IndexFieldDesc fieldDesc;
        Iterator<SortKey> sortKeyIter = this.sortKeys.iterator();
        SortKey sortKey = sortKeyIter.next();
        int equalityKeys = 0;
        Iterator<IndexFieldDesc> fieldDescIter = fieldDescriptors.iterator();
        while (fieldDescIter.hasNext()) {
            fieldDesc = fieldDescIter.next();
            FieldPath fieldPath = fieldDesc.getFieldPath();
            if (sortKey.fieldPath.equals((Object)fieldPath) && !fieldDesc.isFunctional()) {
                if (sortKey.order == fieldDesc.getSortOrder()) break;
                return false;
            }
            List<NaryOperator> relOps = topFieldRelations.get(fieldPath);
            if (relOps == null) {
                return false;
            }
            for (NaryOperator relOp : relOps) {
                if (relOp.opName.equals("=")) continue;
                return false;
            }
            ++equalityKeys;
        }
        if (this.sortKeys.size() > fieldDescriptors.size() - equalityKeys) {
            return false;
        }
        while (sortKeyIter.hasNext()) {
            sortKey = sortKeyIter.next();
            fieldDesc = fieldDescIter.next();
            if (sortKey.order == fieldDesc.getSortOrder() && sortKey.fieldPath.equals((Object)fieldDesc.getFieldPath())) continue;
            return false;
        }
        return true;
    }

    private static boolean cantUseIndex(List<NaryOperator> relOps) {
        block9: for (NaryOperator nOp : relOps) {
            String opName;
            switch (opName = nOp.opName) {
                case "notMatches": 
                case "ojai_condition": {
                    return true;
                }
                case "=": {
                    if (!(nOp.arg[1] instanceof LiteralExpression)) break;
                    LiteralExpression litExpr = (LiteralExpression)nOp.arg[1];
                    if (litExpr.getType() != Value.Type.NULL) continue block9;
                    return true;
                }
            }
        }
        return false;
    }

    public List<EligibleIndex> analyzeQuery(Admin admin, Path tablePath) throws IOException {
        Collection indexes = admin.getTableIndexes(tablePath);
        LinkedList<EligibleIndex> eligibleIndexes = new LinkedList<EligibleIndex>();
        QueryAnalyzer queryAnalyzer = this.getQueryAnalyzer();
        queryAnalyzer.gatherExpressions();
        Map<FieldPath, List<NaryOperator>> topFieldRelations = queryAnalyzer.getTopRelations();
        block0: for (IndexDesc indexDesc : indexes) {
            if (indexDesc.isDisabled()) continue;
            List fieldDescriptors = indexDesc.getIndexedFields();
            boolean canUseIndexForSort = false;
            if (this.sortKeys != null && this.sortKeys.size() > 0) {
                if (indexDesc.isHashed() || this.sortKeys.size() > fieldDescriptors.size() || !this.isSortKeyIndexEqualitySuffix(fieldDescriptors, topFieldRelations)) continue;
                canUseIndexForSort = true;
            }
            int scanFields = 0;
            if (topFieldRelations.size() > 0) {
                int fieldPos = 0;
                for (IndexFieldDesc fieldDesc : fieldDescriptors) {
                    FieldPath fieldPath = fieldDesc.getFieldPath();
                    List<NaryOperator> relOps = topFieldRelations.get(fieldPath);
                    if (!fieldDesc.isFunctional() && relOps != null && !OjaiQuery.cantUseIndex(relOps)) {
                        ++scanFields;
                    }
                    if (fieldPos == 0 && scanFields == 0) continue block0;
                    if (scanFields <= fieldPos) break;
                    ++fieldPos;
                }
            }
            if (scanFields <= 0 && !canUseIndexForSort) continue;
            boolean isCovering = this.isCoveringIndex(queryAnalyzer, indexDesc);
            EligibleIndex ei = new EligibleIndex(indexDesc, scanFields, isCovering);
            eligibleIndexes.add(ei);
        }
        return eligibleIndexes;
    }

    public QueryCondition getScanCondition(OjaiConnection ojaiConnection, EligibleIndex eligibleIndex) {
        QueryAnalyzer queryAnalyzer = this.getQueryAnalyzer();
        Map<FieldPath, List<NaryOperator>> topRelations = queryAnalyzer.getTopRelations();
        IndexDesc indexDesc = eligibleIndex.indexDesc;
        List fieldDescs = indexDesc.getIndexedFields();
        QueryCondition queryCondition = null;
        int fieldIdx = 0;
        for (IndexFieldDesc fieldDesc : fieldDescs) {
            if (fieldIdx >= eligibleIndex.scanFields) break;
            List<NaryOperator> relOps = topRelations.get(fieldDesc.getFieldPath());
            for (NaryOperator relOp : relOps) {
                QueryCondition newCond = ExpressionToCondition.convert(relOp, ojaiConnection);
                if (queryCondition == null) {
                    queryCondition = newCond;
                    continue;
                }
                queryCondition = ojaiConnection.newCondition().and().condition(queryCondition).condition(newCond).close().build();
            }
            ++fieldIdx;
        }
        return queryCondition;
    }

    public Set<FieldPath> getProjectedFieldSet() {
        return new HashSet<FieldPath>(this.projectedFieldSet);
    }

    public boolean isStarQuery() {
        return this.isStarQuery || this.projectedFieldSet.isEmpty();
    }

    public boolean isPossiblyNeedProjection() {
        return this.possiblyNeedProjection;
    }

    public OjaiQuery waitForTrackedWrites(String writesContext) throws IllegalArgumentException {
        this.checkNotBuilt();
        this.commitContext = writesContext;
        return this;
    }

    public DocumentStream decorateStream(DocumentStream docStream, OjaiConnection ojaiConnection, SharedResource<BaseJsonTable> sharedTable) {
        ExecutorService executorService = ojaiConnection.getExecutorService();
        DocumentStream resultStream = docStream;
        if (this.offset > 0L) {
            resultStream = new OffsetStream(resultStream, executorService, this.offset);
        }
        if (this.limit != -1L) {
            resultStream = new LimitStream(resultStream, executorService, this.limit);
        }
        if (this.commitContext != null) {
            resultStream = this.waitForSync(resultStream, ojaiConnection, sharedTable);
        }
        resultStream = this.addTimeout(resultStream, ojaiConnection);
        OjaiDocumentStore.logQueryPlan(resultStream);
        return resultStream;
    }

    private DocumentStream waitForSync(DocumentStream docStream, OjaiConnection ojaiConnection, SharedResource<BaseJsonTable> sharedTable) {
        DocumentStream resultStream = docStream;
        if (this.commitContext != null) {
            ExecutorService executorService = ojaiConnection.getExecutorService();
            resultStream = new CommitWaitStream(resultStream, executorService, sharedTable, this.commitContext);
        }
        return resultStream;
    }

    private DocumentStream addTimeout(DocumentStream docStream, OjaiConnection ojaiConnection) {
        DocumentStream resultStream = docStream;
        long timeoutMs = this.getTimeout();
        if (timeoutMs != -1L) {
            ExecutorService executorService = ojaiConnection.getExecutorService();
            resultStream = new TimeoutDocumentFilter(resultStream, executorService, timeoutMs);
        }
        return resultStream;
    }

    public DocumentStream createDrillStream(OjaiConnection ojaiConnection, SharedTable sharedTable, QueryContext queryContext) {
        SharedDrillSession sharedDrillSession = new SharedDrillSession(ojaiConnection, queryContext.getClusterName());
        AbstractDocumentStream drillStream = new DrillDocumentStream(ojaiConnection, queryContext, sharedDrillSession);
        drillStream = this.waitForSync(drillStream, ojaiConnection, sharedTable);
        if (this.getForceNonCoveringSort()) {
            drillStream = new DrillPreludeFilter(drillStream, ojaiConnection, sharedDrillSession, FORCE_SORT_SQL);
            drillStream = new DrillPostludeFilter(drillStream, ojaiConnection, sharedDrillSession, RESET_SORT_SQL);
        }
        drillStream = this.addTimeout(drillStream, ojaiConnection);
        return drillStream;
    }

    public boolean getForceNonCoveringSort() {
        if (this.options == null) {
            return false;
        }
        Boolean optionBoolean = this.options.getBooleanObj(OPTION_FORCE_SORT);
        if (optionBoolean == null) {
            return false;
        }
        return optionBoolean;
    }

    public boolean getForceDrill() {
        if (this.options == null) {
            return false;
        }
        Boolean optionBoolean = this.options.getBooleanObj(OPTION_FORCE_DRILL);
        if (optionBoolean == null) {
            return false;
        }
        return optionBoolean;
    }

    long getTimeout() {
        return this.timeout;
    }

    public OjaiQuery setTimeout(long timeoutInMilliseconds) throws IllegalArgumentException {
        this.checkNotBuilt();
        Preconditions.checkArgument((timeoutInMilliseconds > 0L ? 1 : 0) != 0, (Object)"timeout must not be negative");
        this.timeout = timeoutInMilliseconds;
        return this;
    }

    boolean isBuilt() {
        return this.built;
    }

    public OjaiQuery build() {
        this.checkNotBuilt();
        this.condition.build();
        QueryAnalyzer queryAnalyzer = this.getQueryAnalyzer();
        queryAnalyzer.build();
        this.includeId = this.isStarQuery || this.projectedFieldSet.size() == 0 || this.projectedFieldSet.contains(DocumentConstants.ID_FIELD);
        this.built = true;
        return this;
    }

    private void checkNotBuilt() {
        Preconditions.checkState((!this.built ? 1 : 0) != 0, (Object)"The OJAI Query is already built!");
    }

    public boolean includeId() {
        return this.includeId;
    }

    public boolean hasOrderBy() {
        return this.sortKeys != null && this.sortKeys.size() > 0;
    }

    public Set<FieldPath> getOrderByFields() {
        HashSet fields = Sets.newHashSet();
        if (this.hasOrderBy()) {
            for (SortKey sortKey : this.sortKeys) {
                fields.add(sortKey.fieldPath);
            }
        }
        return fields;
    }

    public boolean hasProjectionWithArrayIndex() {
        return this.hasProjectionWithArrayIndex;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        OP_TO_NAME = builder.put((Object)QueryCondition.Op.EQUAL, (Object)"=").put((Object)QueryCondition.Op.GREATER, (Object)">").put((Object)QueryCondition.Op.GREATER_OR_EQUAL, (Object)">=").put((Object)QueryCondition.Op.LESS, (Object)"<").put((Object)QueryCondition.Op.LESS_OR_EQUAL, (Object)"<=").put((Object)QueryCondition.Op.NOT_EQUAL, (Object)"<>").build();
        EQUIVALENCE = new QueryEquivalence();
    }

    private static class MutableBoolean {
        boolean value;

        public MutableBoolean(boolean value) {
            this.value = value;
        }
    }
}

