/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.mapr.db.MetaTable;
import com.mapr.db.Table;
import com.mapr.db.exceptions.DBException;
import com.mapr.db.exceptions.ExceptionHandler;
import com.mapr.db.impl.BaseJsonTable;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.impl.OjaiQueryProperties;
import com.mapr.db.impl.scan.ScanStatsImpl;
import com.mapr.db.index.IndexDesc;
import com.mapr.db.index.IndexFieldDesc;
import com.mapr.db.rowcol.DBValueBuilderImpl;
import com.mapr.db.scan.ScanRange;
import com.mapr.db.scan.ScanStats;
import com.mapr.db.util.ConditionParser;
import com.mapr.ojai.store.impl.DocumentStreamFactory;
import com.mapr.ojai.store.impl.EligibleIndex;
import com.mapr.ojai.store.impl.EmptyQueryStream;
import com.mapr.ojai.store.impl.Expression;
import com.mapr.ojai.store.impl.ExpressionToCondition;
import com.mapr.ojai.store.impl.IdDocumentStream;
import com.mapr.ojai.store.impl.IndexScanStats;
import com.mapr.ojai.store.impl.MaterializedDocumentStream;
import com.mapr.ojai.store.impl.NaryOperator;
import com.mapr.ojai.store.impl.OjaiConnection;
import com.mapr.ojai.store.impl.OjaiQuery;
import com.mapr.ojai.store.impl.QueryAnalyzer;
import com.mapr.ojai.store.impl.QueryContext;
import com.mapr.ojai.store.impl.RowkeyLookup;
import com.mapr.ojai.store.impl.SharedReleaser;
import com.mapr.ojai.store.impl.SharedResource;
import com.mapr.ojai.store.impl.SharedTable;
import com.mapr.ojai.store.impl.UnionDocumentStream;
import com.mapr.ojai.store.impl.bean.DrillConnectionParams;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.fs.Path;
import org.ojai.Document;
import org.ojai.DocumentConstants;
import org.ojai.DocumentStream;
import org.ojai.FieldPath;
import org.ojai.Value;
import org.ojai.annotation.API;
import org.ojai.exceptions.OjaiException;
import org.ojai.store.DocumentMutation;
import org.ojai.store.DocumentStore;
import org.ojai.store.Query;
import org.ojai.store.QueryCondition;
import org.ojai.store.exceptions.MultiOpException;
import org.ojai.store.exceptions.StoreException;
import org.ojai.util.Fields;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API.NotThreadSafe
public class OjaiDocumentStore
implements DocumentStore {
    private static final Logger logger = LoggerFactory.getLogger(OjaiDocumentStore.class);
    private static final int TABLET_LIMIT = 2;
    private final OjaiConnection ojaiConnection;
    private final String tableName;
    private final Path tablePath;
    private final Document options;
    private final String clusterName;
    private String engineName;
    private boolean isClosed = false;
    private static final ObjectMapper objectMapper = logger.isTraceEnabled() ? new ObjectMapper() : null;
    private SharedTable sharedTable;
    private static final FieldPath[] SELECT_ROWKEY = new FieldPath[]{DocumentConstants.ID_FIELD};

    public OjaiDocumentStore(OjaiConnection ojaiConnection, String tableName, Document options) {
        this.ojaiConnection = ojaiConnection;
        this.tableName = tableName;
        this.options = (Document)DBValueBuilderImpl.KeyValueBuilder.initFrom(options);
        this.tablePath = new Path(tableName);
        try {
            this.clusterName = ojaiConnection.getFileSystem().getClusterName(this.tablePath.toUri());
        }
        catch (IOException e) {
            throw ExceptionHandler.handle((IOException)e, (String)"OjaiDocumentStore.<init>()");
        }
    }

    @VisibleForTesting
    public BaseJsonTable getTable() {
        if (this.sharedTable == null) {
            BaseJsonTable jsonTable = (BaseJsonTable)MapRDBImpl.getTable((String)this.tableName);
            this.sharedTable = new SharedTable(jsonTable);
            logger.debug("getTable " + this.tableName + " fid " + jsonTable.getFidStr());
        }
        return (BaseJsonTable)this.sharedTable.get();
    }

    public static void logQueryPlan(DocumentStream ds) {
        if (!logger.isTraceEnabled()) {
            return;
        }
        if (!(ds instanceof OjaiQueryProperties)) {
            logger.trace("OjaiQueryProperties is not implemented in '{}',", (Object)ds.getClass().getSimpleName());
            return;
        }
        ArrayList planList = new ArrayList();
        ((OjaiQueryProperties)ds).getQueryPlan(planList);
        String queryPlanJson = null;
        try {
            queryPlanJson = objectMapper.writeValueAsString(planList);
        }
        catch (IOException ioe) {
            throw new StoreException((Throwable)ioe);
        }
        logger.trace("Ojai Query Plan: '{}'", (Object)queryPlanJson);
    }

    private static Table getIndex(IndexDesc indexDesc) {
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)indexDesc);
        logger.debug("getIndex " + indexDesc.getIndexName() + " fid " + indexDesc.getIndexFid() + " table " + indexDesc.getPrimaryTablePath());
        return indexTable;
    }

    private static SharedReleaser<BaseJsonTable> getSharedIndex(IndexDesc indexDesc) {
        Table indexTable = MapRDBImpl.getIndexTable((IndexDesc)indexDesc);
        SharedTable sharedIndex = new SharedTable((BaseJsonTable)indexTable);
        SharedReleaser<BaseJsonTable> sharedReleaser = new SharedReleaser<BaseJsonTable>(sharedIndex);
        return sharedReleaser;
    }

    private String getEngineName() {
        if (this.engineName == null) {
            DrillConnectionParams connectParam = this.ojaiConnection.getQueryServiceParam(this.clusterName);
            if (!connectParam.isEnabled()) {
                throw new DBException("MapR-DB Query Service is not enabled for cluster: " + this.clusterName);
            }
            this.engineName = connectParam.getStoragePlugin();
        }
        return this.engineName;
    }

    public boolean checkAndDelete(String _id, QueryCondition condition) throws StoreException {
        BaseJsonTable table = this.getTable();
        return table.checkAndDelete(_id, condition);
    }

    public boolean checkAndDelete(Value _id, QueryCondition condition) throws StoreException {
        BaseJsonTable table = this.getTable();
        return table.checkAndDelete(_id, condition);
    }

    public boolean checkAndMutate(String _id, QueryCondition condition, DocumentMutation mutation) throws StoreException {
        BaseJsonTable table = this.getTable();
        return table.checkAndMutate(_id, condition, mutation);
    }

    public boolean checkAndMutate(Value _id, QueryCondition condition, DocumentMutation mutation) throws StoreException {
        BaseJsonTable table = this.getTable();
        return table.checkAndMutate(_id, condition, mutation);
    }

    public boolean checkAndReplace(String _id, QueryCondition condition, Document document) throws StoreException {
        BaseJsonTable table = this.getTable();
        return table.checkAndReplace(_id, condition, document);
    }

    public boolean checkAndReplace(Value _id, QueryCondition condition, Document document) throws StoreException {
        BaseJsonTable table = this.getTable();
        return table.checkAndReplace(_id, condition, document);
    }

    public void close() throws StoreException {
        if (this.isClosed) {
            return;
        }
        if (this.sharedTable != null) {
            this.sharedTable.release();
            this.sharedTable = null;
            this.isClosed = true;
        }
    }

    public void delete(String _id) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.delete(_id);
    }

    public void delete(Value _id) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.delete(_id);
    }

    public void delete(Document document) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.delete(document);
    }

    public void delete(DocumentStream stream) throws MultiOpException {
        BaseJsonTable table = this.getTable();
        table.delete(stream);
    }

    public void delete(Document document, FieldPath fieldPath) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.delete(document, fieldPath);
    }

    public void delete(Document document, String fieldAsKey) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.delete(document, fieldAsKey);
    }

    public void delete(DocumentStream stream, FieldPath fieldPath) throws MultiOpException {
        BaseJsonTable table = this.getTable();
        table.delete(stream, fieldPath);
    }

    public void delete(DocumentStream stream, String fieldAsKey) throws MultiOpException {
        BaseJsonTable table = this.getTable();
        table.delete(stream, fieldAsKey);
    }

    public DocumentStream find() throws StoreException {
        OjaiQuery query = new OjaiQuery().build();
        return this.findQuery(query);
    }

    public DocumentStream find(String ... paths) throws StoreException {
        OjaiQuery query = new OjaiQuery().select(paths).build();
        return this.findQuery(query);
    }

    public DocumentStream find(FieldPath ... fieldPaths) throws StoreException {
        OjaiQuery query = new OjaiQuery().select(fieldPaths).build();
        return this.findQuery(query);
    }

    public DocumentStream findQuery(String jsonQuery) throws StoreException {
        ConditionParser conditionParser = new ConditionParser();
        return this.find(conditionParser.parseCondition(jsonQuery));
    }

    @VisibleForTesting
    public EligibleIndex getSmallestScan(OjaiQuery ojaiQuery, List<EligibleIndex> eligibleIndexes) {
        IndexScanStats bestIndex = null;
        for (EligibleIndex eligibleIndex : eligibleIndexes) {
            IndexDesc indexDesc = eligibleIndex.indexDesc;
            try {
                Table indexTable = OjaiDocumentStore.getIndex(indexDesc);
                Throwable throwable = null;
                try {
                    MetaTable metaTable = indexTable.getMetaTable();
                    Throwable throwable2 = null;
                    try {
                        QueryCondition queryCondition = ojaiQuery.getScanCondition(this.ojaiConnection, eligibleIndex);
                        ScanStats scanStats = metaTable.getScanStats(queryCondition);
                        int nTablets = ((ScanStatsImpl)scanStats).getTabletCount();
                        if (nTablets > 2) continue;
                        IndexScanStats newCandidate = new IndexScanStats(eligibleIndex, scanStats);
                        if (bestIndex == null || nTablets < bestIndex.tabletCount()) {
                            bestIndex = newCandidate;
                            continue;
                        }
                        if (nTablets != bestIndex.tabletCount() || newCandidate.dataSize() >= bestIndex.dataSize() && (newCandidate.dataSize() != bestIndex.dataSize() || newCandidate.nDocuments() >= bestIndex.nDocuments())) continue;
                        bestIndex = newCandidate;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (metaTable == null) continue;
                        if (throwable2 != null) {
                            try {
                                metaTable.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        metaTable.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (indexTable == null) continue;
                    if (throwable != null) {
                        try {
                            indexTable.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    indexTable.close();
                }
            }
            catch (IOException ex) {
                throw new OjaiException((Throwable)ex);
            }
        }
        if (bestIndex == null) {
            return null;
        }
        return bestIndex.eligibleIndex;
    }

    private static List<EligibleIndex> favorCoveringIndexes(List<EligibleIndex> eligibleIndexes) {
        ArrayList<EligibleIndex> coveringIndexes = null;
        for (EligibleIndex eligibleIndex : eligibleIndexes) {
            if (!eligibleIndex.isCovering) continue;
            if (coveringIndexes == null) {
                coveringIndexes = new ArrayList<EligibleIndex>(eligibleIndexes.size());
            }
            coveringIndexes.add(eligibleIndex);
        }
        return coveringIndexes == null ? eligibleIndexes : coveringIndexes;
    }

    private static QueryCondition getCompleteScanCondition(QueryCondition userCond, ScanRange scanRange) {
        QueryCondition rangeCondition = scanRange.getCondition();
        if (userCond == null || userCond.isEmpty()) {
            return rangeCondition;
        }
        if (rangeCondition.isEmpty()) {
            return userCond;
        }
        ConditionImpl scanCondition = MapRDBImpl.newCondition().and().condition(scanRange.getCondition()).condition(userCond).close().build();
        return scanCondition;
    }

    private static DocumentStream createDocumentStream(final SharedResource<BaseJsonTable> sharedTable, final FieldPath[] fieldPaths, final QueryCondition cond, ExecutorService executorService) {
        List scanRanges;
        final Table table = (Table)sharedTable.get();
        try (MetaTable metaTable = table.getMetaTable();){
            scanRanges = metaTable.getScanRanges(cond);
        }
        catch (IOException ex) {
            throw new OjaiException((Throwable)ex);
        }
        int nRanges = scanRanges.size();
        if (nRanges == 0) {
            return new EmptyQueryStream();
        }
        if (nRanges == 1) {
            QueryCondition scanCondition = OjaiDocumentStore.getCompleteScanCondition(cond, (ScanRange)scanRanges.get(0));
            DocumentStream docStream = fieldPaths == null ? table.find(scanCondition) : table.find(scanCondition, fieldPaths);
            return docStream;
        }
        sharedTable.addRef();
        final Iterator rangeIter = scanRanges.iterator();
        return new UnionDocumentStream(executorService, new DocumentStreamFactory(){

            @Override
            public DocumentStream create() {
                if (!rangeIter.hasNext()) {
                    return null;
                }
                ScanRange scanRange = (ScanRange)rangeIter.next();
                QueryCondition scanCondition = OjaiDocumentStore.getCompleteScanCondition(cond, scanRange);
                DocumentStream docStream = fieldPaths == null ? table.find(scanCondition) : table.find(scanCondition, fieldPaths);
                return docStream;
            }
        }){

            @Override
            protected void closeDerived() {
                sharedTable.release();
                super.closeDerived();
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DocumentStream findQuery(Query query) throws StoreException {
        Throwable indexDesc;
        Preconditions.checkNotNull((Object)query, (Object)"Query must be non-null");
        Preconditions.checkArgument((boolean)(query instanceof OjaiQuery), (Object)"Query argument is not a MapR OJAI query");
        OjaiQuery ojaiQuery = (OjaiQuery)query;
        Preconditions.checkArgument((boolean)ojaiQuery.isBuilt(), (Object)"Query is not built");
        QueryAnalyzer queryAnalyzer = ojaiQuery.getQueryAnalyzer();
        Map<FieldPath, List<NaryOperator>> topRelations = queryAnalyzer.getTopRelations();
        if (topRelations.get(DocumentConstants.ID_FIELD) != null) {
            Set<Expression> otherPredicates = queryAnalyzer.getOtherPredicates();
            FieldPath[] fieldPaths = ojaiQuery.getSelectListAsArray();
            if (otherPredicates.size() == 0) {
                DocumentStream docStream;
                if (queryAnalyzer.isIdEquals()) {
                    return this._findById(queryAnalyzer.getIdForLookup(), ojaiQuery.includeId(), fieldPaths);
                }
                BaseJsonTable table2 = this.getTable();
                OjaiDocumentStore.setIdReturn((Table)table2, ojaiQuery.includeId());
                if (ojaiQuery.isIdIn()) {
                    IdDocumentStream idDocStream = new IdDocumentStream(this.ojaiConnection, queryAnalyzer.getFieldInBundle());
                    RowkeyLookup rowkeyLookup = new RowkeyLookup(idDocStream, this.ojaiConnection.getExecutorService(), this.sharedTable, (QueryCondition)ojaiQuery.getCondition(), fieldPaths);
                    OjaiDocumentStore.logQueryPlan(rowkeyLookup);
                    return rowkeyLookup;
                }
                ConditionImpl condition = ojaiQuery.getCondition();
                if (fieldPaths != null) {
                    docStream = table2.find((QueryCondition)condition, fieldPaths);
                    return ojaiQuery.decorateStream(docStream, this.ojaiConnection, this.sharedTable);
                }
                docStream = table2.find((QueryCondition)condition);
                return ojaiQuery.decorateStream(docStream, this.ojaiConnection, this.sharedTable);
            }
        }
        if (!queryAnalyzer.isUnion() && !ojaiQuery.getForceDrill()) {
            List<EligibleIndex> eligibleIndexes;
            try {
                eligibleIndexes = ojaiQuery.analyzeQuery(this.ojaiConnection.getAdmin(), this.tablePath);
            }
            catch (IOException ioe) {
                throw new StoreException((Throwable)ioe);
            }
            List<EligibleIndex> bestIndexes = OjaiDocumentStore.favorCoveringIndexes(eligibleIndexes);
            EligibleIndex bestIndex = this.getSmallestScan(ojaiQuery, bestIndexes);
            if (bestIndex != null) {
                indexDesc = bestIndex.indexDesc;
                try (SharedReleaser<BaseJsonTable> autoReleasedIndex = OjaiDocumentStore.getSharedIndex((IndexDesc)indexDesc);){
                    SharedResource<BaseJsonTable> sharedIndex = autoReleasedIndex.getSharedResource();
                    FieldPath[] fieldPaths = ojaiQuery.getSelectListAsArray();
                    if (bestIndex.isCovering) {
                        ConditionImpl queryCondition = ojaiQuery.getCondition();
                        DocumentStream docStream = OjaiDocumentStore.createDocumentStream(sharedIndex, fieldPaths, (QueryCondition)queryCondition, this.ojaiConnection.getExecutorService());
                        DocumentStream documentStream2 = ojaiQuery.decorateStream(docStream, this.ojaiConnection, sharedIndex);
                        return documentStream2;
                    }
                    if (!ojaiQuery.getForceNonCoveringSort()) {
                        HashSet<FieldPath> indexedFields = new HashSet<FieldPath>();
                        Iterator docStream = indexDesc.getIndexedFields().iterator();
                        while (true) {
                            if (!docStream.hasNext()) {
                                Expression prunedExpr = queryAnalyzer.getPrunedExpression(indexedFields);
                                QueryCondition prunedCond = ExpressionToCondition.convert(prunedExpr, this.ojaiConnection);
                                DocumentStream indexStream = OjaiDocumentStore.createDocumentStream(sharedIndex, SELECT_ROWKEY, prunedCond, this.ojaiConnection.getExecutorService());
                                BaseJsonTable table3 = this.getTable();
                                OjaiDocumentStore.setIdReturn((Table)table3, ojaiQuery.includeId());
                                RowkeyLookup rowkeyLookup = new RowkeyLookup(indexStream, this.ojaiConnection.getExecutorService(), this.sharedTable, (QueryCondition)ojaiQuery.getCondition(), ojaiQuery.getSelectListAsArray());
                                DocumentStream documentStream3 = ojaiQuery.decorateStream(rowkeyLookup, this.ojaiConnection, this.sharedTable);
                                return documentStream3;
                            }
                            IndexFieldDesc ifd = (IndexFieldDesc)docStream.next();
                            indexedFields.add(ifd.getFieldPath());
                        }
                    }
                }
            }
        }
        BaseJsonTable table = this.getTable();
        if (!ojaiQuery.getForceDrill() && !ojaiQuery.hasOrderBy()) {
            ConditionImpl queryCondition = ojaiQuery.getCondition();
            try {
                indexDesc = null;
                try (MetaTable primaryMetaTable = table.getMetaTable();){
                    ScanStats scanStats = primaryMetaTable.getScanStats((QueryCondition)queryCondition);
                    int nTablets = ((ScanStatsImpl)scanStats).getTabletCount();
                    if (nTablets <= 2) {
                        FieldPath[] fieldPaths = ojaiQuery.getSelectListAsArray();
                        OjaiDocumentStore.setIdReturn((Table)table, ojaiQuery.includeId());
                        DocumentStream docStream = OjaiDocumentStore.createDocumentStream(this.sharedTable, fieldPaths, (QueryCondition)queryCondition, this.ojaiConnection.getExecutorService());
                        DocumentStream documentStream = ojaiQuery.decorateStream(docStream, this.ojaiConnection, this.sharedTable);
                        return documentStream;
                    }
                }
                catch (Throwable throwable) {
                    indexDesc = throwable;
                    throw throwable;
                }
            }
            catch (IOException ex) {
                throw new StoreException((Throwable)ex);
            }
        }
        String sql = ojaiQuery.buildSqlString(this.getEngineName(), this.tableName);
        QueryContext queryContext = QueryContext.newBuilder(sql).clusterName(this.clusterName).familyIdToFieldPathMap(table.idToCFNameMap()).fieldPathToFamilyIdMap(table.sortedByPath()).query(ojaiQuery).build();
        DocumentStream drillStream = ojaiQuery.createDrillStream(this.ojaiConnection, this.sharedTable, queryContext);
        OjaiDocumentStore.logQueryPlan(drillStream);
        return drillStream;
    }

    private static void setIdReturn(Table table, boolean includeId) {
        table.setOption(Table.TableOption.EXCLUDEID, !includeId);
    }

    private DocumentStream _findById(String idValue, boolean includeId, FieldPath ... fieldPath) {
        BaseJsonTable table = this.getTable();
        OjaiDocumentStore.setIdReturn((Table)table, includeId);
        Document doc = fieldPath == null || fieldPath.length == 0 ? table.findById(idValue) : table.findById(idValue, fieldPath);
        MaterializedDocumentStream mds = new MaterializedDocumentStream(doc, OjaiQueryProperties.QueryPath.DIRECT, table.getName(), new FieldPath[0]);
        OjaiDocumentStore.logQueryPlan(mds);
        return mds;
    }

    public DocumentStream find(QueryCondition condition) throws StoreException {
        OjaiQuery ojaiQuery = new OjaiQuery().where(condition).build();
        return this.findQuery(ojaiQuery);
    }

    public DocumentStream find(QueryCondition condition, String ... field) throws StoreException {
        OjaiQuery ojaiQuery = new OjaiQuery().select(field).where(condition).build();
        return this.findQuery(ojaiQuery);
    }

    public DocumentStream find(QueryCondition condition, FieldPath ... fieldPath) throws StoreException {
        OjaiQuery ojaiQuery = new OjaiQuery().select(fieldPath).where(condition).build();
        return this.findQuery(ojaiQuery);
    }

    public void flush() throws StoreException {
        BaseJsonTable table = this.getTable();
        table.flush();
    }

    public void increment(String _id, String field, byte inc) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.increment(_id, field, inc);
    }

    public void increment(String _id, String field, short inc) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.increment(_id, field, inc);
    }

    public void increment(String _id, String field, int inc) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.increment(_id, field, inc);
    }

    public void increment(String _id, String field, long inc) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.increment(_id, field, inc);
    }

    public void increment(String _id, String field, float inc) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.increment(_id, field, inc);
    }

    public void increment(String _id, String field, double inc) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.increment(_id, field, inc);
    }

    public void increment(String _id, String field, BigDecimal inc) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.increment(_id, field, inc);
    }

    public void increment(Value value, String field, byte v) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.increment(value, field, v);
    }

    public void increment(Value value, String field, short v) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.increment(value, field, v);
    }

    public void increment(Value value, String field, int v) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.increment(value, field, v);
    }

    public void increment(Value value, String field, long v) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.increment(value, field, v);
    }

    public void increment(Value value, String field, float v) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.increment(value, field, v);
    }

    public void increment(Value value, String field, double v) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.increment(value, field, v);
    }

    public void increment(Value value, String field, BigDecimal v) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.increment(value, field, v);
    }

    public void insert(Document document) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.insert(document);
    }

    public void insert(DocumentStream stream) throws MultiOpException {
        BaseJsonTable table = this.getTable();
        table.insert(stream);
    }

    public void insert(String _id, Document document) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.insert(_id, document);
    }

    public void insert(Value value, Document document) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.insert(value, document);
    }

    public void insert(Document document, FieldPath fieldPath) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.insert(document, fieldPath);
    }

    public void insert(Document document, String fieldAsKey) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.insert(document, fieldAsKey);
    }

    public void insert(DocumentStream stream, FieldPath fieldPath) throws MultiOpException {
        BaseJsonTable table = this.getTable();
        table.insert(stream, fieldPath);
    }

    public void insert(DocumentStream stream, String fieldAsKey) throws MultiOpException {
        BaseJsonTable table = this.getTable();
        table.insert(stream, fieldAsKey);
    }

    public void insertOrReplace(Document document) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.insertOrReplace(document);
    }

    public void insertOrReplace(DocumentStream stream) throws MultiOpException {
        BaseJsonTable table = this.getTable();
        table.insertOrReplace(stream);
    }

    public void insertOrReplace(String _id, Document document) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.insertOrReplace(_id, document);
    }

    public void insertOrReplace(Value _id, Document document) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.insertOrReplace(_id, document);
    }

    public void insertOrReplace(Document document, FieldPath fieldPath) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.insertOrReplace(document, fieldPath);
    }

    public void insertOrReplace(Document document, String fieldAsKey) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.insertOrReplace(document, fieldAsKey);
    }

    public void insertOrReplace(DocumentStream stream, FieldPath fieldPath) throws MultiOpException {
        BaseJsonTable table = this.getTable();
        table.insertOrReplace(stream, fieldPath);
    }

    public void insertOrReplace(DocumentStream stream, String fieldAsKey) throws MultiOpException {
        BaseJsonTable table = this.getTable();
        table.insertOrReplace(stream, fieldAsKey);
    }

    public boolean isReadOnly() {
        BaseJsonTable table = this.getTable();
        return table.isReadOnly();
    }

    public void replace(Document document) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.replace(document);
    }

    public void replace(DocumentStream stream) throws MultiOpException {
        BaseJsonTable table = this.getTable();
        table.replace(stream);
    }

    public void replace(String _id, Document document) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.replace(_id, document);
    }

    public void replace(Value value, Document document) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.replace(value, document);
    }

    public void replace(Document document, FieldPath fieldPath) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.replace(document, fieldPath);
    }

    public void replace(Document document, String fieldAsKey) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.replace(document, fieldAsKey);
    }

    public void replace(DocumentStream stream, FieldPath fieldPath) throws MultiOpException {
        BaseJsonTable table = this.getTable();
        table.replace(stream, fieldPath);
    }

    public void replace(DocumentStream stream, String fieldAsKey) throws MultiOpException {
        BaseJsonTable table = this.getTable();
        table.replace(stream, fieldAsKey);
    }

    public void update(String _id, DocumentMutation mutation) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.update(_id, mutation);
    }

    public void update(Value value, DocumentMutation mutation) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.update(value, mutation);
    }

    public String endTrackingWrites() throws StoreException {
        BaseJsonTable table = this.getTable();
        return table.endTrackingWrites();
    }

    public void beginTrackingWrites() throws StoreException {
        BaseJsonTable table = this.getTable();
        table.beginTrackingWrites();
    }

    public void beginTrackingWrites(String previousWritesContext) throws StoreException {
        BaseJsonTable table = this.getTable();
        table.beginTrackingWrites(previousWritesContext);
    }

    public void clearTrackedWrites() throws StoreException {
        BaseJsonTable table = this.getTable();
        table.clearTrackedWrites();
    }

    public Document getStoreOptions() {
        return this.options;
    }

    public Document findById(String _id) throws StoreException {
        Preconditions.checkNotNull((Object)_id);
        BaseJsonTable table = this.getTable();
        OjaiDocumentStore.setIdReturn((Table)table, true);
        return table.findById(_id);
    }

    public Document findById(Value _id) throws StoreException {
        Preconditions.checkNotNull((Object)_id);
        BaseJsonTable table = this.getTable();
        OjaiDocumentStore.setIdReturn((Table)table, true);
        return table.findById(_id);
    }

    private static boolean hasId(FieldPath[] fieldPaths) {
        for (FieldPath fieldPath : fieldPaths) {
            if (!fieldPath.equals((Object)DocumentConstants.ID_FIELD)) continue;
            return true;
        }
        return false;
    }

    public Document findById(String _id, FieldPath ... fieldPaths) throws StoreException {
        Preconditions.checkNotNull((Object)_id);
        Preconditions.checkNotNull((Object)fieldPaths);
        BaseJsonTable table = this.getTable();
        OjaiDocumentStore.setIdReturn((Table)table, OjaiDocumentStore.hasId(fieldPaths));
        return table.findById(_id, fieldPaths);
    }

    public Document findById(String _id, String ... fieldPaths) throws StoreException {
        return this.findById(_id, Fields.toFieldPathArray((String[])fieldPaths));
    }

    public Document findById(Value _id, String ... fieldPaths) throws StoreException {
        return this.findById(_id, Fields.toFieldPathArray((String[])fieldPaths));
    }

    public Document findById(Value _id, FieldPath ... fieldPaths) throws StoreException {
        Preconditions.checkNotNull((Object)_id);
        BaseJsonTable table = this.getTable();
        OjaiDocumentStore.setIdReturn((Table)table, OjaiDocumentStore.hasId(fieldPaths));
        return table.findById(_id, fieldPaths);
    }

    public Document findById(String _id, QueryCondition condition) throws StoreException {
        Preconditions.checkNotNull((Object)_id);
        Preconditions.checkNotNull((Object)condition);
        BaseJsonTable table = this.getTable();
        OjaiDocumentStore.setIdReturn((Table)table, true);
        return table.findById(_id, condition);
    }

    public Document findById(Value _id, QueryCondition condition) throws StoreException {
        Preconditions.checkNotNull((Object)_id);
        Preconditions.checkNotNull((Object)condition);
        BaseJsonTable table = this.getTable();
        OjaiDocumentStore.setIdReturn((Table)table, true);
        return table.findById(_id, condition);
    }

    public Document findById(String _id, QueryCondition condition, String ... fieldPaths) throws StoreException {
        return this.findById(_id, condition, Fields.toFieldPathArray((String[])fieldPaths));
    }

    public Document findById(String _id, QueryCondition condition, FieldPath ... fieldPaths) throws StoreException {
        Preconditions.checkNotNull((Object)_id);
        Preconditions.checkNotNull((Object)condition);
        Preconditions.checkNotNull((Object)fieldPaths);
        BaseJsonTable table = this.getTable();
        OjaiDocumentStore.setIdReturn((Table)table, OjaiDocumentStore.hasId(fieldPaths));
        return table.findById(_id, condition, fieldPaths);
    }

    public Document findById(Value _id, QueryCondition condition, String ... fieldPaths) throws StoreException {
        return this.findById(_id, condition, Fields.toFieldPathArray((String[])fieldPaths));
    }

    public Document findById(Value _id, QueryCondition condition, FieldPath ... fieldPaths) throws StoreException {
        Preconditions.checkNotNull((Object)_id);
        Preconditions.checkNotNull((Object)condition);
        Preconditions.checkNotNull((Object)fieldPaths);
        BaseJsonTable table = this.getTable();
        OjaiDocumentStore.setIdReturn((Table)table, OjaiDocumentStore.hasId(fieldPaths));
        return table.findById(_id, condition, fieldPaths);
    }
}

