/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.mapr.db.impl.OjaiQueryProperties;
import com.mapr.ojai.store.impl.AbstractDocumentFilter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.ojai.Document;
import org.ojai.DocumentStream;

public class OffsetStream
extends AbstractDocumentFilter {
    private final long offset;
    private long docCount;

    public OffsetStream(DocumentStream upstreamStream, ExecutorService executorService, long offset) {
        super(upstreamStream, executorService);
        this.offset = offset;
    }

    @Override
    public boolean documentArrived(Document doc) {
        if (this.docCount++ >= this.offset) {
            return super.documentArrived(doc);
        }
        return true;
    }

    public void getQueryPlan(List<Map<String, Object>> planList) {
        if (this.upstreamStream == null) {
            return;
        }
        ((OjaiQueryProperties)this.upstreamStream).getQueryPlan(planList);
        HashMap<String, Object> myMap = new HashMap<String, Object>();
        myMap.put("streamName", this.getClass().getSimpleName());
        HashMap<String, Long> valueMap = new HashMap<String, Long>();
        valueMap.put("offset", this.offset);
        myMap.put("parameters", valueMap);
        planList.add(myMap);
    }
}

